/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import mikera.tyrant.AI;
import mikera.tyrant.Coin;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Monster;
import mikera.tyrant.Personality;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Skill;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class Person {
    public static void init() {
        Thing thing = Lib.extend("base person", "base being");
        thing.set("LevelMin", 1);
        thing.set("IsPerson", 1);
        thing.set("IsHostile", 0);
        thing.set("IsIntelligent", 1);
        thing.set("IsInhabitant", 1);
        thing.set("IsGiftReceiver", 1);
        thing.set("Frequency", 0);
        Lib.add(thing);
        Person.initRaces();
        Person.initTownies();
        Person.initWoodFolk();
        Person.initNPCs();
        Person.initWanderers();
        Person.initUniversityStaff();
        Person.initDwarves();
    }

    private static Script teachSkillScript(String string, int n) {
        TeachSkillScript teachSkillScript = new TeachSkillScript();
        teachSkillScript.set("SkillName", string);
        teachSkillScript.set("Price", n);
        return teachSkillScript;
    }

    public static void initRaces() {
        Thing thing = Lib.extend("human", "base person");
        Monster.stats(thing, 7, 7, 7, 7, 7, 7, 7, 7);
        thing.set("Race", thing.name());
        thing.set("Image", 101);
        thing.set("RaceDescription", "Adaptable and inventive, humans are the most common race on the surface of the world. They live in communities ranging in size from small villages to great fortified cities.");
        thing.incStat("SkillPoints", 1);
        Lib.add(thing);
        thing = Lib.extend("dwarf", "base person");
        Monster.stats(thing, 6, 7, 2, 11, 5, 8, 4, 10);
        thing.set("Race", thing.name());
        thing.set("Image", 83);
        thing.incStat("MoveSpeed", -10);
        thing.multiplyStat("RechargeRate", 0.3);
        thing.incStat("Magic Resistance", 1);
        thing.incStat("Smithing", RPG.r(2));
        thing.incStat("Mining", RPG.r(3));
        thing.set("RaceDescription", "Delving in the deep underworld or in the high mountains, dwarves are hardy folk with a fierce tradition of pride and loyalty. Above all, they prize gold, gems and precious metals which they accumulate in their cavernous underground halls. Suspicious of other races in genral, dwarves prefer to keep to themselves, although they have forged trading links with humans. They have a particular dislike for elves, since they have still not forgotten ancient conflicts that once brought the two races to war.");
        Lib.add(thing);
        thing = Lib.extend("hobbit", "base person");
        Monster.stats(thing, 8, 4, 6, 3, 6, 12, 9, 7);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.incStat("Farming", 1);
        thing.incStat("Herb Lore", RPG.r(3));
        thing.incStat("Cooking", 1);
        thing.incStat("Storytelling", RPG.r(2));
        thing.set("RaceDescription", "Hobbits are a diminutive folk, half the height of the average man, with large hairy feet. What they lack in strength and stamina they make up for in skill, cunning and a good-natured charm. Typically farmers and herb-gardeners, they generally shun adventuring ways - the peaceful, carefree hobbit likes nothing better than relaxing after a hearty meal, with a puff of pipeweed and a good story told among friends. Occasionally however, a hobbit succumbs to wanderlust, the lure of gold, or simply becomes involved in events beyond his control...");
        Lib.add(thing);
        thing = Lib.extend("base elf", "base person");
        Monster.stats(thing, 8, 5, 8, 4, 7, 6, 6, 5);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.multiplyStat("RechargeRate", 1.3);
        thing.incStat("Speed", 10);
        thing.incStat("Literacy", 1);
        Lib.add(thing);
        thing = Lib.extend("high elf", "base elf");
        Monster.stats(thing, 8, 5, 7, 4, 10, 7, 12, 9);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.set("RaceDescription", "The high elves are the most ancient of all races, and enjoy enormously long lives which they dedicate by and large to noble pastimes such as dancing, writing, art and music. Their finely developed culture and traditions remains impenetrable to most other races, who often regard them as aloof and arrogant. High elves ally most frequenctly with man, who they seem to regard affectionately as unruly younger siblings in need of guidance. The dark elves are their bitterest foes, separated. In battle, high elves tend to rely on speed, agility and magic rather than brute force.");
        thing.incStat("Literacy", 1);
        thing.incStat("Perception", 1);
        Lib.add(thing);
        thing = Lib.extend("dark elf", "base elf");
        Monster.stats(thing, 9, 6, 7, 6, 8, 7, 5, 5);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.set("RaceDescription", "The typical Dark Elf has fine white hair like spider silk, lustrous skin like graphite and glossy black eyes like obsidian. Although the High and Dark Elves deny they are related to one another, the truth is that the Dark Elves were born of a schism from the original Elven race millennia ago. The exact nature of the split is uncertain since neither race will admit it ever happened; whatever it was, the Dark Elves left their forest homes in Uendil and made their way underground, forming their own empire beneath the mountains of Azak-Hal; since then they have spread to other regions. Like high elves, they are skilled and agile. The harsh environment has made the Dark Elves more well-rounded; they are stronger in body and will, although less intelligent and crafty. They are ferocious in combat and adept in the use of throwing weapons.");
        thing.incStat("Throwing", 1);
        thing.incStat("Ferocity", 1);
        Lib.add(thing);
        thing = Lib.extend("wood elf", "base elf");
        Monster.stats(thing, 10, 4, 12, 4, 8, 6, 8, 8);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.set("RaceDescription", "Wood elves live in harmony with nature, and in general shun the company of other races. They thrive on songs and storytelling, their ancient culture having grown in woodland relams for thousands of years. They are more light hearted and mischeivous than the austere High Elves, but their common ancestry makes them frequent allies.");
        thing.incStat("Archery", 1);
        Lib.add(thing);
        thing = Lib.extend("gnome", "base person");
        Monster.stats(thing, 6, 3, 4, 3, 8, 9, 8, 12);
        thing.set("Race", thing.name());
        thing.set("Image", 10);
        thing.incStat("VisionRange", -1);
        thing.incStat("Trading", RPG.d(2));
        thing.incStat("Item Lore", RPG.d(2));
        thing.set("RaceDescription", "Gnomes are the smallest of all the humanoid races, with adults rarely exceeding two feet in height. Forced to live by their wits rather than their strength, Gnomes have found their talent in tinkering and trade. More traditional gnomes live in well-hidden and defended gnomish towns in the forests or hills, but others have settled along humans and dwarves where their crafting skills and ingenuity enable them to earn a good living whilst also enjoying the protection of their larger cousins. Some gnomish businessmen have become so successful their their fortunes rival those of human princes, and they are thus able to wield considerable political power.");
        thing.incStat("MoveSpeed", -20);
        thing.incStat("AttackSpeed", -10);
        thing.incStat("Luck", 7);
        Lib.add(thing);
        thing = Lib.extend("half orc", "base person");
        Monster.stats(thing, 7, 11, 8, 8, 5, 7, 3, 4);
        thing.set("DeathDecoration", "slime pool");
        thing.set("Race", thing.name());
        thing.set("Image", 244);
        thing.set("IsGoblinoid", 1);
        thing.incStat("SkillPoints", -1);
        thing.incStat("Ferocity", 1);
        thing.incStat("Unarmed Combat", 1);
        thing.incStat("Bravery", 1);
        thing.set("RaceDescription", "A fearsome and tragic half-breed between man and orc, half orcs usually find themselves shunned by both races. Bitter and angry, many take to banditry or hired work as mercenaries, where their agressive tendencies coupled with smarter wits than any orc make them formidable fighters.");
        Lib.add(thing);
        thing = Lib.extend("half troll", "base person");
        Monster.stats(thing, 6, 16, 4, 11, 1, 8, 2, 2);
        thing.set("DeathDecoration", "slime pool");
        thing.set("Race", thing.name());
        thing.set("Image", 244);
        thing.set("IsGoblinoid", 1);
        thing.incStat("SkillPoints", -1);
        thing.incStat("Unarmed Combat", 1);
        thing.incStat("Survival", 1);
        thing.multiplyStat("RegenerationRate", 3.0);
        thing.set("RaceDescription", "Half trolls are a mutant breed related to trolls and goblins. With limited intelligence, they often live in the wild as hunters and scavengers. They are freqently also found among orcs and goblins, where their great muscle is highly valued by the contantly feuding factions.");
        Lib.add(thing);
        thing = Lib.extend("argonian", "base person");
        Monster.stats(thing, 5, 4, 9, 12, 10, 8, 2, 7);
        thing.set("DeathDecoration", "slime pool");
        thing.set("Race", thing.name());
        thing.set("Image", 423);
        thing.set("RaceDescription", "Argonians are the offspring of the unholy union of humans and snakes. Their skin has a greenish hue and a scaly toughness. They are invulnerable to poison but are extra sensitive to cold, greatly prefering warm climates. They are very tough. Shunned by most of society they tend to prefer solitary professions.");
        thing.incStat("Swimming", 2);
        thing.incStat("ARM", 3);
        thing.set("RES:poison", 1000);
        thing.set("RES:ice", -10);
        thing.set("RES:fire", 10);
        thing.multiplyStat("RegenerationRate", 2.0);
        Lib.add(thing);
        thing = Lib.extend("hawken", "base person");
        Monster.stats(thing, 8, 4, 15, 5, 8, 7, 5, 5);
        thing.set("DeathDecoration", "blood pool");
        thing.set("Race", thing.name());
        thing.set("Image", 420);
        thing.incStat("VisionRange", 4);
        thing.set("RaceDescription", "The race of hawken decended from couplings between men and harpies. Birdmen have sharp hawklike features and soft downy skin. The have phenomenal eyesight and perception. They are preternaturally quick.");
        thing.incStat("Athletics", RPG.d(3));
        thing.incStat("Perception", RPG.r(3));
        thing.incStat("Alertness", RPG.d(3));
        thing.set("RES:piercing", -5);
        thing.set("RES:impact", -5);
        Lib.add(thing);
        thing = Lib.extend("pensadorian", "base person");
        Monster.stats(thing, 5, 3, 5, 3, 15, 9, 5, 10);
        thing.set("DeathDecoration", "blood pool");
        thing.set("Race", thing.name());
        thing.set("Image", 101);
        thing.incStat("VisionRange", -2);
        thing.set("RaceDescription", "The pensadorians' ancestors were human, but centuries of selective breeding in a society that valued nothing but intelligence has caused them to slowly evolve into a different race.  They have inherently brilliant minds but barely have the muscularity to hold their heads up.");
        thing.incStat("Literacy", RPG.d(2));
        thing.incStat("Item Lore", RPG.r(2));
        thing.incStat("Rune Lore", RPG.r(2));
        thing.set("RES:poison", -5);
        thing.set("RES:ice", -5);
        thing.set("RES:fire", -5);
        thing.set("RES:shock", -5);
        thing.set("RES:acid", -5);
        thing.set("RES:piercing", -5);
        thing.set("RES:impact", -5);
        Lib.add(thing);
    }

    public static void initWanderers() {
        Thing thing = Lib.extend("merchant", "human");
        Monster.strengthen(thing, 8.0);
        thing.set("IsWanderer", 1);
        thing.set("Image", 36);
        thing.set("LevelMin", 5);
        thing.set("Frequency", 50);
        Lib.add(thing);
        thing = Lib.extend("wandering teacher", "schoolmaster");
        thing.set("IsWanderer", 1);
        thing.set("LevelMin", 10);
        thing.set("Frequency", 50);
        Lib.add(thing);
    }

    public static void initUniversityStaff() {
        Thing thing = Lib.extend("base university person", "human");
        Monster.stats(thing, 12, 14, 12, 28, 27, 37, 14, 22);
        thing.set("IsUniversityStaff", 1);
        thing.set("ARM", 2);
        thing.set("Level", 9);
        thing.set("Luck", 50);
        Lib.add(thing);
        thing = Lib.extend("professor", "base university person");
        thing.set("Spellcasting", 5);
        thing.set("Image", 142);
        Lib.add(thing);
        thing = Lib.extend("advisor", "base university person");
        thing.set("Spellcasting", 3);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("dean of admissions", "base university person");
        thing.set("Spellcasting", 7);
        thing.set("Image", 141);
        RiddleScript riddleScript = new RiddleScript();
        thing.set("OnChat", riddleScript);
        Lib.add(thing);
        thing = Lib.extend("dean of thaumaturgy", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("dean of alchemy", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("dean of herbology", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("dean of theology", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("dean of symbolism", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("bursar", "base university person");
        thing.set("Image", 143);
        thing.set("Spellcasting", 3);
        Lib.add(thing);
        thing = Lib.extend("student", "base university person");
        thing.set("Spellcasting", 1);
        thing.set("Image", 148);
        Lib.add(thing);
        thing = Lib.extend("gardner", "base university person");
        thing.set("Image", 146);
        Lib.add(thing);
        thing = Lib.extend("janitor", "base university person");
        thing.set("Image", 147);
        Lib.add(thing);
        thing = Lib.extend("clerk", "base university person");
        thing.set("Image", 150);
        Lib.add(thing);
        thing = Lib.extend("campus policeman", "base university person");
        Monster.stats(thing, 12, 35, 35, 28, 27, 37, 14, 22);
        thing.set("Image", 81);
        Lib.add(thing);
        thing = Lib.extend("provost", "base university person");
        thing.set("Spellcasting", 11);
        thing.set("Image", 125);
        Lib.add(thing);
        thing = Lib.extend("university president", "base university person");
        thing.set("Spellcasting", 15);
        thing.set("Image", 149);
        Lib.add(thing);
    }

    public static void initDwarves() {
        Thing thing = Lib.extend("dwarf clansman", "dwarf");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("dwarf guard", "dwarf clansman");
        Monster.strengthen(thing, 2.0);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour],[IsCoin]");
        thing.set("LevelMin", 7);
        Lib.add(thing);
    }

    public static void initWoodFolk() {
        Thing thing = Lib.extend("woodsman", "human");
        thing.set("Image", 114);
        Monster.stats(thing, 8, 16, 10, 18, 7, 17, 8, 12);
        thing.set("Level", 3);
        thing.set("ARM", 2);
        Lib.add(thing);
        thing = Lib.extend("wood temple guard", "human");
        thing.set("Image", 115);
        Monster.stats(thing, 18, 18, 13, 28, 9, 27, 12, 14);
        thing.set("ARM", 4);
        thing.set("Level", 8);
        thing.set("DefaultThings", "[IsBow], 20 [IsArrow],[IsWeapon]");
        Lib.add(thing);
        thing = Lib.extend("wood temple archer", "human");
        thing.set("Image", 128);
        Monster.stats(thing, 38, 18, 33, 28, 19, 37, 16, 24);
        thing.set("ARM", 5);
        thing.set("Level", 13);
        thing.set("DefaultThings", "[IsBow], 20 [IsArrow],[IsWeapon]");
        TeachSkillScript teachSkillScript = new TeachSkillScript();
        teachSkillScript.set("SkillName", "Archery");
        teachSkillScript.set("Price", 2000);
        thing.set("OnChat", teachSkillScript);
        Lib.add(thing);
        thing = Lib.extend("wood priest", "human");
        thing.set("Image", 125);
        Monster.stats(thing, 12, 14, 12, 28, 27, 37, 14, 22);
        thing.set("ARM", 2);
        thing.set("Level", 9);
        thing.set("DefaultThings", "[IsBow], 20 [IsArrow], Poison Cloud, Fireball");
        thing.set("Spellcasting", 3);
        thing.set("Luck", 50);
        thing.set("RES:poison", 50);
        thing.set("OnGift", SwapScript.create("IsCoin", RPG.d(2) == 1 ? "IsScroll" : "IsIdentifyScroll", 6));
        Lib.add(thing);
        thing = Lib.extend("wood priestess", "wood priest");
        thing.set("Image", 126);
        Monster.strengthen(thing, 2.0);
        thing.set("Level", 14);
        thing.set("Luck", 100);
        thing.set("ARM", 12);
        Lib.add(thing);
    }

    public static void initTownies() {
        Thing thing = Lib.extend("base townie", "human");
        thing.set("DefaultThings", "[IsItem]");
        Lib.add(thing);
        thing = Lib.extend("village girl", "base townie");
        thing.setPersonality(new Personality(1, 3));
        thing.set("OnGift", SwapScript.create("IsRing", "IsPotion", 12));
        thing.set("Image", 106);
        Lib.add(thing);
        thing = Lib.extend("farmer", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 101);
        Lib.add(thing);
        thing = Lib.extend("villager", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 100);
        Lib.add(thing);
        thing = Lib.extend("village woman", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 103);
        thing.set("OnGift", SwapScript.create("IsCoin", "IsFood", 20));
        Lib.add(thing);
        thing = Lib.extend("townswoman", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 103);
        Lib.add(thing);
        thing = Lib.extend("townie", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 100);
        thing.set("DefaultThings", "[IsWeapon]");
        Lib.add(thing);
        thing = Lib.extend("boy", "base townie");
        thing.setPersonality(new Personality(1, 0));
        thing.set("Image", 31);
        thing.set("DefaultThings", "[IsFood]");
        Lib.add(thing);
        thing = Lib.extend("ranger", "base townie");
        thing.setPersonality(new Personality(1, 3));
        Monster.strengthen(thing, 3.0);
        thing.set("ARM", 5);
        thing.set("Image", 128);
        thing.incStat("Archery", 3);
        thing.set("DefaultThings", "[IsWeapon],[IsBow],[IsArrow],[IsArrow]");
        thing.set("Level", 10);
        thing.set("OnGift", SwapScript.create("IsCoin", "IsArrow", 6));
        Lib.add(thing);
        thing = Lib.extend("guard", "base townie");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 3);
        thing.set("Level", 7);
        thing.set("Unarmed Combat", 2);
        thing.set("Defence", 2);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Monster.strengthen(thing, 3.0);
        Lib.add(thing);
        thing = Lib.extend("priest", "base townie");
        thing.setPersonality(new Personality(1, 4));
        Monster.strengthen(thing, 4.0);
        thing.set("Defence", 2);
        thing.set("Image", 124);
        thing.set("DeathDecoration", "holy ghost");
        Lib.add(thing);
        thing = Lib.extend("wizard", "base townie");
        thing.setPersonality(new Personality(1, 2));
        Monster.strengthen(thing, 4.0);
        thing.set("Image", 121);
        thing.set("Spellcasting", 3);
        thing.set("ARM", 4);
        thing.set("OnGift", SwapScript.create("IsCoin", "IsWand", 16));
        thing.set("DefaultThings", "[IsSpellBook],Magic Missile,Fireball");
        Lib.add(thing);
        thing = Lib.extend("teacher", "base townie");
        thing.set("Image", 122);
        thing.setPersonality(new Personality(2, 0));
        thing.set("OnChat", new TeachingScript());
        Lib.add(thing);
        thing = Lib.extend("schoolmaster", "base townie");
        thing.set("Image", 122);
        thing.setPersonality(new Personality(2, 0));
        thing.set("OnChat", Person.teachSkillScript("Literacy", 5000));
        Lib.add(thing);
        thing = Lib.extend("young soldier", "base townie");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 1);
        thing.set("Level", 1);
        thing.set("Unarmed Combat", 1);
        thing.set("Defence", 1);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("seasoned soldier", "base townie");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 3);
        thing.set("Level", 3);
        thing.set("Unarmed Combat", 2);
        thing.set("Defence", 2);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Lib.add(thing);
        thing = Lib.extend("border legionnaire", "base townie");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 3);
        thing.set("Level", 5);
        thing.set("Unarmed Combat", 2);
        thing.set("Defence", 2);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Monster.strengthen(thing, 2.0);
        Lib.add(thing);
        thing = Lib.extend("garrison commander", "base townie");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 3);
        thing.set("Level", 10);
        thing.set("Unarmed Combat", 3);
        thing.set("Defence", 3);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Monster.strengthen(thing, 3.0);
        Lib.add(thing);
        thing = Lib.extend("elven ranger", "high elf");
        thing.setPersonality(new Personality(1, 1));
        thing.set("Image", 111);
        thing.set("ARM", 3);
        thing.set("Level", 8);
        thing.set("Unarmed Combat", 2);
        thing.set("Defence", 2);
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Monster.strengthen(thing, 3.0);
        Lib.add(thing);
        thing = Lib.extend("blacksmith", "human");
        thing.setPersonality(new Personality(3, 0));
        TeachSkillScript teachSkillScript = new TeachSkillScript();
        teachSkillScript.set("SkillName", "Weapon Lore");
        teachSkillScript.set("Price", 3000);
        thing.set("OnChat", teachSkillScript);
        thing.set("OnGift", new RepairScript());
        thing.set("Image", 109);
        thing.set("Level", 10);
        thing.set("Attack", 3);
        thing.set("Defence", 2);
        thing.set("DefaultThings", "steel battle axe,[IsArmour]");
        Monster.strengthen(thing, 6.0);
        Lib.add(thing);
        thing = Lib.extend("shopkeeper", "human");
        thing.set("Image", 108);
        thing.set("IsShopkeeper", 1);
        thing.set("IsDisplaceable", 0);
        thing.set("Level", 15);
        thing.set("OnGift", new SellingScript());
        thing.set("OnChat", new ListSellingScript());
        thing.set("DefaultThings", "[IsWeapon],[IsArmour],[IsOffensiveSpell],[IsSummonSpell]");
        thing.set("Attack", 3);
        thing.set("Defence", 3);
        thing.set("Spellcasting", 3);
        Monster.strengthen(thing, 6.0);
        Lib.add(thing);
        thing = Lib.extend("trader", "human");
        thing.set("Image", 108);
        thing.set("Level", 15);
        thing.set("OnChat", new ListSellingScript());
        thing.set("DefaultThings", "[IsWeapon],[IsArmour]");
        Monster.strengthen(thing, 4.0);
        Lib.add(thing);
        thing = Lib.extend("healer", "human");
        thing.setPersonality(new Personality(1, 8));
        Monster.strengthen(thing, 4.0);
        thing.set("Level", 18);
        thing.set("Image", 124);
        thing.set("OnGift", new SellingScript());
        thing.set("DefaultThings", "[IsPotion]");
        thing.set("DeathDecoration", "holy ghost");
        Lib.add(thing);
        thing = Lib.extend("learned sage", "human");
        thing.setPersonality(new Personality(1, 8));
        Monster.strengthen(thing, 2.0);
        thing.set("Level", 12);
        thing.set("Image", 125);
        teachSkillScript = new TeachSkillScript();
        teachSkillScript.set("SkillName", "Literacy");
        teachSkillScript.set("Price", 5000);
        thing.set("OnChat", teachSkillScript);
        thing.set("DefaultThings", "[IsPotion]");
        thing.set("DeathDecoration", "holy ghost");
        Lib.add(thing);
        thing = Lib.extend("goblin shopkeeper", "goblin shaman");
        thing.set("IsHostile", 0);
        thing.set("IsInhabitant", 1);
        thing.set("IsDisplaceable", 0);
        thing.set("IsShopkeeper", 1);
        thing.set("IsPerson", 1);
        thing.setPersonality(new Personality(1, 6));
        Lib.add(thing);
    }

    public static void initNPCs() {
        Thing thing = Lib.extend("Jolly Old Nyck", "human");
        AI.name(thing, "Jolly Old Nyck");
        thing.set("Image", 112);
        thing.set("OnChat", new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                Game.message("\"Yo Ho Ho!\"");
                Game.message("\"'Tis the season to be jolly\"");
                Game.message("\"Here's a present for ye!\"");
                Thing thing3 = Lib.createArtifact(50);
                Game.message(thing.getName() + " gives you " + thing3.getAName());
                thing2.addThing(thing3);
                Game.message(thing.getName() + " suddenly dissapears!");
                thing.remove();
                return true;
            }
        });
        Lib.add(thing);
    }

    private static class RiddleScript
    extends Script {
        private static final long serialVersionUID = 2254796328898345150L;
        private static ArrayList riddles = null;
        private static ArrayList answers = null;

        private RiddleScript() {
        }

        private static void setupRiddles() {
            riddles = new ArrayList();
            answers = new ArrayList();
            riddles.add("What walks on four legs in the morning, two in the afternoon and three in the evening?");
            answers.add("man");
            riddles.add("What starts with 'e', ends with 'e' and contains one letter?");
            answers.add("envelope");
            riddles.add("What has eyes but cannot see?");
            answers.add("potato");
            riddles.add("Born at the same time as the world, destined to live as long as the world, and yet never five weeks old.  What is it?");
            answers.add("moon");
            riddles.add("It wasn't my sister, nor my brother, but still was the child of my father and mother.  Who was it?");
            answers.add("you");
            riddles.add("What can be measured, but has no length, width or height?");
            answers.add("temperature");
            riddles.add("What do all living things do at the same time?");
            answers.add("age");
            riddles.add("What do you break with just one word?");
            answers.add("silence");
            riddles.add("What can't you see that is always before you?");
            answers.add("future");
            riddles.add("Which room has no door, no windows, no floor and no roof?");
            answers.add("mushroom");
            riddles.add("What is always coming, but never arrives?");
            answers.add("tomorrow");
            riddles.add("What is often returned but never borrowed?");
            answers.add("thanks");
            riddles.add("What is bought by the yard and worn by the foot?");
            answers.add("carpeting");
            riddles.add("What is full of holes and yet holds water?");
            answers.add("sponge");
            riddles.add("What lives on its own substance and dies when it devours itself?");
            answers.add("candle");
            riddles.add("What 5 letter word can have its last 4 letters removed and still sound the same?");
            answers.add("queue");
            riddles.add("What gets harder to catch the faster you run?");
            answers.add("breath");
            riddles.add("What doesn't exist, but has a name?");
            answers.add("nothing");
            riddles.add("The more there is of this, the less you see of it. What is it?");
            answers.add("darkness");
            riddles.add("What is black when you buy it, red as you use it, and grey when you throw it out?");
            answers.add("coal");
            riddles.add("The more you take, the more you leave behind. What are they?");
            answers.add("footsteps");
            riddles.add("What occurs once in a minute, twice in a moment, but never in an hour?");
            answers.add("m");
            riddles.add("What grows bigger the more you take from it?");
            answers.add("hole");
            riddles.add("What five-letter word becomes shorter when you add two letters to it?");
            answers.add("short");
            riddles.add("What do you lose every time you stand up?");
            answers.add("lap");
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            String string = Text.camelizeString(thing.getName()) + "RiddleMissed";
            String string2 = Text.camelizeString(thing.getName()) + "RiddleSolved";
            Game.message("Camel:  " + string2);
            int n = thing2.getStat(string);
            if (n > 2) {
                Game.message(thing.getTheName() + " is no longer willing to talk with you.");
                return true;
            }
            if (n > 0) {
                Game.message(thing.getTheName() + " has another question for you.");
            } else {
                Game.message(thing.getTheName() + " has a question for you.");
            }
            Game.message("Would you like to answer the question? (y/n)");
            char c = Game.getOption("yn");
            if (c == 'y') {
                int n2 = RPG.r(riddles.size());
                String string3 = "\"" + (String)riddles.get(n2) + "\"";
                String string4 = (String)answers.get(n2);
                Game.message(string3);
                String string5 = Game.getLine("Your answer: ");
                if (string5.equalsIgnoreCase(string4)) {
                    Game.message("\"Well done!\"");
                    thing2.incStat(string2, 1);
                    return true;
                }
                Game.message("\"Thinking must not be your strong suit.\"");
                thing2.incStat(string, 1);
                return true;
            }
            thing2.message("Come back when you want to test your knowledge!");
            return true;
        }

        static {
            RiddleScript.setupRiddles();
        }
    }

    private static class RepairScript
    extends Script {
        private static final long serialVersionUID = -6588466277758378986L;

        private RepairScript() {
        }

        public boolean handle(Thing thing, Event event) {
            boolean bl;
            Thing thing2 = event.getThing("Gift");
            Thing thing3 = event.getThing("Giver");
            boolean bl2 = bl = thing2.getStat("HPS") < thing2.getStat("HPSMAX");
            if (thing2 != null && bl) {
                int n;
                int n2 = Item.value(thing2);
                int n3 = thing3.getStat("CH") * thing3.getStat("Trading");
                if ((n2 = (int)(0.3 * ((double)n2 * 0.3 + 0.7 * (double)n2 * (double)(n3 / (n3 + (n = thing.getStat("CH"))))))) > 0) {
                    thing3.message(thing.getTheName() + " asks for " + Coin.valueString(n2) + " to repair your " + thing2.getName(Game.hero()));
                    thing3.message("Do you accept? (y/n)");
                    char c = Game.getOption("ynq");
                    if (c == 'y') {
                        Game.message("You gave " + thing2.getName(Game.hero()) + " and " + Coin.valueString(n2) + " to the smith for repair.");
                        Coin.removeMoney(thing3, n2);
                        thing2.set("HPS", thing2.getStat("HPSMAX"));
                        thing2.getTheName();
                    } else {
                        thing3.message("Don't waste my time then!");
                    }
                } else {
                    thing3.message("What a piece of junk! Don't waste my time!");
                }
            } else {
                thing3.message("What on earth am I meant to do with that!");
            }
            return true;
        }
    }

    private static class TeachingScript
    extends Script {
        private static final long serialVersionUID = 3760564208726914357L;

        private TeachingScript() {
        }

        public boolean handle(Thing thing, Event event) {
            ArrayList arrayList;
            String string;
            String[] stringArray;
            Thing thing2 = event.getThing("Target");
            int n = thing2.getStat("SkillPointsSpent") * 100 * thing2.getLevel();
            n = (int)((double)n / (1.0 + 0.3 * (double)thing2.getStat("Trading")));
            if (thing2.getStat("SkillPoints") <= 0) {
                String[] stringArray2 = new String[]{"You need to gain experience before I can teach you any more!", "Sorry, I can't teach you any more now - you need to gain experience before.", "I can't teach you any more now, sorry - you need to gain experience before.", "Unfortunately, I can't teach you any more now - you need to gain experience before."};
                Game.message("\"" + RPG.pick(stringArray2) + "\"");
                return true;
            }
            if (n > 0) {
                Game.message(thing.getTheName() + " asks for " + Coin.valueString(n) + " for training.");
                if (Coin.getMoney(thing2) < n) {
                    Game.message("You can't afford that!");
                    return true;
                }
                Game.message("Do you agree? (y/n)");
                if (Game.getOption("yn") != 'y') {
                    return true;
                }
            } else {
                stringArray = new String[]{"I like you, my friend; I can give you some free training to improve your skills.", "My friend, I can give you some free training to improve your skills.", "I like you; I can give you some free training to improve your skills.", "I like you; I offer some free training to improve your skills.", "I can give you some free training to improve your skills.", "Well, I can give you some free training to improve your skills."};
                Game.message("You talk to " + thing.getTheName());
                Game.message("\"" + RPG.pick(stringArray) + "\"");
                Game.message("Do you agree? (y/n)");
                if (Game.getOption("yn") != 'y') {
                    String[] stringArray3 = new String[]{"Come back later if you change your mind!", "You can come back later if you change your mind!", "You don't want FREE training? Anyway, come back later if you change your mind.", "You don't want training for FREE? What a guy :-) !"};
                    Game.message("\"" + RPG.pick(stringArray3) + "\"");
                    return true;
                }
            }
            if ((string = Game.selectString("Select a skill to improve:", (ArrayList)(stringArray = Skill.getList(thing2)), arrayList = Skill.getUnmarkedList(thing2))) != null) {
                Skill.train(thing2, string);
                Coin.removeMoney(thing2, n);
            } else {
                String[] stringArray4 = new String[]{"Maybe later then!", "Well, maybe later then.", "Anyway, you can come back later."};
                Game.message("\"" + RPG.pick(stringArray4) + "\"");
            }
            return true;
        }
    }

    private static class SellingScript
    extends Script {
        private static final long serialVersionUID = -6816925315754576522L;

        private SellingScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Gift");
            Thing thing3 = event.getThing("Giver");
            if (thing2 != null) {
                int n = Item.shopValue(thing2, thing3, thing);
                if ((n = Coin.roundMoney(n)) > 0) {
                    thing3.message(thing.getTheName() + " offers you " + Coin.valueString(n) + " for your " + thing2.getName(Game.hero()));
                    thing3.message("Do you accept? (y/n)");
                    char c = Game.getOption("ynq");
                    if (c == 'y') {
                        Game.message("You sell your " + thing2.getName(Game.hero()) + " to " + thing.getTheName());
                        thing2.remove();
                        Coin.addMoney(thing3, n);
                    }
                } else {
                    thing3.message(thing.getTheName() + " doesn't want to buy your " + thing2.getName(Game.hero()));
                }
                return true;
            }
            throw new Error("Giving null gift!");
        }
    }

    private static class ListSellingScript
    extends Script {
        private static final long serialVersionUID = 5075582255481317201L;

        private ListSellingScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            Thing thing3 = Game.selectSaleItem("Select an item to sell:", thing2, thing);
            while (thing3 != null) {
                if (!thing3.getFlag("IsMoney")) {
                    int n = thing3.getStat("Number");
                    int n2 = 1;
                    if (n > 1) {
                        n2 = Game.selectSaleNumber("Sell how many (Enter=All)? ", thing2, thing, n);
                    }
                    int n3 = Item.shopValue(thing3, thing2, thing, n2);
                    if (thing3.y <= 0 || thing2.clearUsage(thing3.y)) {
                        Game.message("You sell your " + thing3.getName(Game.hero(), n2) + " to " + thing.getTheName());
                        if (n2 > 0) {
                            thing3.remove(n2);
                        }
                        Coin.addMoney(thing2, n3);
                    }
                }
                thing3 = Game.selectSaleItem("Select an item to sell:", thing2, thing);
            }
            return true;
        }
    }

    private static class SwapScript
    extends Script {
        private static final long serialVersionUID = -1462156804224496122L;

        private SwapScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Gift");
            Thing thing3 = event.getThing("Giver");
            if (this.getStat("SwapCount") <= 0) {
                thing3.message(thing.getTheName() + " has nothing else to trade");
                return false;
            }
            if (!thing2.getFlag(this.getString("WantedFlag"))) {
                thing3.message(thing.getTheName() + " doesn't want to swap anything for " + thing2.getYourName());
                return false;
            }
            int n = Item.value(thing2);
            for (int i = 0; i < 20; ++i) {
                Thing thing4 = Lib.createType(this.getString("SwapFlag"), this.getStat("SwapLevel"));
                if (thing4 == null || Item.value(thing4) >= n) continue;
                if (this.getFlag("IdentifyFlag")) {
                    Item.identify(thing4);
                }
                thing3.message(thing.getTheName() + " gives you " + thing4.getAName() + " in return");
                thing2.remove();
                thing3.addThingWithStacking(thing4);
                this.incStat("SwapCount", -1);
                return true;
            }
            thing3.message(thing.getTheName() + " hasn't got anything to swap for " + thing2.getYourName());
            return false;
        }

        public static SwapScript create(String string, String string2, int n) {
            SwapScript swapScript = new SwapScript();
            swapScript.set("WantedFlag", string);
            swapScript.set("SwapFlag", string2);
            swapScript.set("SwapLevel", n);
            swapScript.set("SwapCount", RPG.d(6));
            swapScript.set("IdentifyFlag", 1);
            return swapScript;
        }
    }

    private static class TeachSkillScript
    extends Script {
        private static final long serialVersionUID = 6064405547665614436L;

        private TeachSkillScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            String string = this.getString("SkillName");
            int n = this.getStat("Price");
            if (thing2.getStat(string) > 0) {
                Game.message("\"Good day to you!\"");
            } else if (thing2.getStat("SkillPoints") >= 2) {
                if (Coin.getMoney(thing2) < n) {
                    Game.message(thing.getTheName() + " could teach you the " + string + " skill for " + Coin.valueString(n) + "");
                    Game.message("Unfortunately, you do not have enough money to pay for this");
                } else {
                    Game.message(thing.getTheName() + " is willing to help you acquire new knowledge.");
                    Game.message("Would you like to learn the " + string + " skill for " + Coin.valueString(n) + "? (y/n)");
                    char c = Game.getOption("yn");
                    if (c == 'y') {
                        thing2.incStat(string, 1);
                        thing2.incStat("SkillPoints", -2);
                        Coin.removeMoney(thing2, n);
                        Game.message("You learn the " + string + " skill from " + thing.getTheName());
                    } else {
                        Game.message("Good day to you then!");
                    }
                }
            } else {
                Game.message(thing.getTheName() + " can teach the " + string + " skill for " + Coin.valueString(n) + "");
                Game.message("However, you must gain more experience first");
            }
            return false;
        }
    }
}

