/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Comparator;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public final class Modifier
extends BaseObject {
    private static final long serialVersionUID = -3261034883675606102L;
    private Thing source;
    private String reason;
    public static final Comparator sorter = new ModifierSorter();

    private Modifier() {
    }

    private Modifier(Modifier modifier) {
        super(modifier);
    }

    public static Modifier create(Modifier modifier, Thing thing, String string) {
        Modifier modifier2 = new Modifier(modifier);
        modifier2.source = thing;
        modifier2.reason = string;
        return modifier2;
    }

    public String getStat() {
        return this.getString("Stat");
    }

    public String getReason() {
        return this.reason;
    }

    public int getPriority() {
        return this.getStat("Priority");
    }

    public Thing getSource() {
        return this.source;
    }

    public Object calculate(Thing thing, String string, int n) {
        if (this.getFlag("Calculation")) {
            return new Integer(this.calculation(thing, string, n));
        }
        if (this.getFlag("Override")) {
            return this.get("Value");
        }
        if (this.getFlag("AddModifier")) {
            Modifier[] modifierArray = (Modifier[])thing.getModified(string, n);
            Modifier modifier = (Modifier)this.get("Value");
            if (modifierArray == null) {
                return new Modifier[]{modifier};
            }
            Modifier[] modifierArray2 = new Modifier[modifierArray.length + 1];
            System.arraycopy(modifierArray, 0, modifierArray2, 0, modifierArray.length);
            modifierArray2[modifierArray.length] = modifier;
            return modifierArray2;
        }
        if (this.getFlag("AddHandler")) {
            Script script = (Script)thing.getModified(string, n);
            Script script2 = (Script)this.get("Value");
            Script script3 = Scripts.combine(script, script2);
            return script3;
        }
        return thing.getModified(string, n);
    }

    public int calculation(Thing thing, String string, int n) {
        int n2 = this.getStat("Base");
        int n3 = this.getStat("Multiplier");
        int n4 = this.getStat("Bonus");
        Integer n5 = (Integer)thing.getModified(string, n);
        if (n5 == null) {
            if (n2 > 0) {
                return n2 * n3 / 100 + n4;
            }
            return n4;
        }
        return n5 * n3 / 100 + n4;
    }

    public static Modifier bonus(String string, int n) {
        return Modifier.linear(string, 100, n);
    }

    public static Modifier linear(String string, int n, int n2) {
        Modifier modifier = new Modifier();
        modifier.set("Stat", string);
        modifier.set("Calculation", 1);
        modifier.set("Multiplier", n);
        modifier.set("Bonus", n2);
        modifier.set("Priority", 100);
        return modifier;
    }

    public static Modifier percent(String string, int n) {
        Modifier modifier = new Modifier();
        modifier.set("Stat", string);
        modifier.set("Base", 100);
        modifier.set("Calculation", 1);
        modifier.set("Multiplier", n);
        modifier.set("Priority", 100);
        return modifier;
    }

    public static Modifier constant(String string, int n) {
        return Modifier.constant(string, new Integer(n));
    }

    public static Modifier constant(String string, Object object) {
        Modifier modifier = new Modifier();
        modifier.set("Stat", string);
        modifier.set("Override", 1);
        modifier.set("Value", object);
        modifier.set("Priority", 100);
        return modifier;
    }

    public static Modifier addModifier(String string, Object object) {
        Modifier modifier = new Modifier();
        modifier.set("Stat", string);
        modifier.set("AddModifier", 1);
        modifier.set("Value", object);
        modifier.set("Priority", 100);
        return modifier;
    }

    public static Modifier addHandler(String string, Script script) {
        Modifier modifier = new Modifier();
        modifier.set("Stat", string);
        modifier.set("AddHandler", 1);
        modifier.set("Value", script);
        modifier.set("Priority", 100);
        return modifier;
    }

    public String toString() {
        String string = this.getStat();
        if (this.getFlag("Calculation") && this.getStat("Bonus") != 0) {
            string = string + "+" + this.getStat("Bonus");
        }
        return string;
    }

    private static class ModifierSorter
    implements Comparator {
        private ModifierSorter() {
        }

        public int compare(Object object, Object object2) {
            Modifier modifier = (Modifier)object;
            Modifier modifier2 = (Modifier)object2;
            return modifier2.getPriority() - modifier.getPriority();
        }
    }
}

