/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mikera.tyrant.AI;
import mikera.tyrant.Animal;
import mikera.tyrant.Artifact;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Chest;
import mikera.tyrant.Coin;
import mikera.tyrant.Decoration;
import mikera.tyrant.Describer;
import mikera.tyrant.Description;
import mikera.tyrant.Door;
import mikera.tyrant.Effect;
import mikera.tyrant.EndGame;
import mikera.tyrant.Event;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.GoblinVillage;
import mikera.tyrant.Gods;
import mikera.tyrant.Item;
import mikera.tyrant.Missile;
import mikera.tyrant.Monster;
import mikera.tyrant.Person;
import mikera.tyrant.Potion;
import mikera.tyrant.Quest;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Recipe;
import mikera.tyrant.Scenery;
import mikera.tyrant.Skill;
import mikera.tyrant.Special;
import mikera.tyrant.Spell;
import mikera.tyrant.SpellBook;
import mikera.tyrant.Temple;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;
import mikera.tyrant.Trap;
import mikera.tyrant.Tutorial;

public class Lib
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3978145456561862453L;
    private HashMap lib = new HashMap();
    private HashMap lowerCaseNames = new HashMap();
    private List all = new ArrayList();
    private transient Map types;
    private Map createdUniques = new HashMap();
    private List uniques = new ArrayList();
    private static Lib instance;
    private int createCount = 0;
    private static Object libLock;
    private ArrayList tileList = new ArrayList();
    public static final Description DESC_IMPERIALCROWN;
    public static final Description DESC_HAT;
    public static final Description DESC_TROUSERS;
    public static final Description DESC_ROBE;
    public static final Description DESC_MAGICROBE;
    public static final Description DESC_GLOVES;
    public static final Description DESC_TREASURE;
    public static final String[] qualitystrings;
    public static final int[] qualityvalues;

    public Lib() {
        this.clearTypes();
    }

    public void addArtifact(Thing thing) {
        thing.set("IsArtifact", 1);
        thing.set("IsDestructible", 0);
        thing.set("Frequency", 0);
        Lib.add(thing);
    }

    public void clearTypes() {
        this.types = new HashMap();
    }

    public HashMap getLib() {
        return this.lib;
    }

    public List getAll() {
        return this.all;
    }

    public Map getTypes() {
        return this.types;
    }

    public Object intern(Object object) {
        if (object instanceof String) {
            return ((String)object).intern();
        }
        return object;
    }

    private static void initBase() {
        Thing thing = new Thing();
        thing.set("Name", "base thing");
        thing.set("IsThing", 1);
        thing.set("ImageSource", "Items");
        thing.set("Image", 0);
        thing.set("Number", 1);
        Lib.add(thing);
    }

    public static Thing create(String string) {
        return Lib.create(string, Game.level());
    }

    public static Thing createIgnoreCase(String string) {
        if ((string = (String)Lib.instance.lowerCaseNames.get(string.toLowerCase())) == null) {
            return null;
        }
        return Lib.create(string, Game.level());
    }

    public static Thing create(String string, int n) {
        Thing thing;
        int n2 = 0;
        if (Character.isDigit(string.charAt(0))) {
            while (Character.isDigit(string.charAt(0))) {
                n2 = n2 * 10 + Character.getNumericValue(string.charAt(0));
                string = string.substring(1);
            }
            if (string.charAt(0) == '*') {
                n2 = RPG.r(n2) + 1;
                string = string.substring(1);
            } else if (string.charAt(0) == '%') {
                if (RPG.r(100) >= n2) {
                    return null;
                }
                return Lib.create(string.substring(1).trim(), n);
            }
            string = string.trim();
        }
        if (string.charAt(0) == '[') {
            thing = Lib.createType(string.substring(1, string.length() - 1), n);
        } else {
            BaseObject baseObject = Lib.get(string);
            if (baseObject == null) {
                Game.warn("Lib: Can't create " + string);
                return !string.equals("strange rock") ? Lib.create("strange rock") : null;
            }
            thing = Lib.createThing(baseObject);
            if (baseObject.getFlag("IsUnique")) {
                return Lib.getArtifact(baseObject.getString("Name"));
            }
        }
        if (n2 > 0 && thing.getFlag("IsItem")) {
            thing.set("Number", n2);
        }
        return thing;
    }

    public String stats() {
        BaseObject baseObject = new BaseObject();
        for (int i = 0; i < this.all.size(); ++i) {
            Thing thing = new Thing((BaseObject)this.all.get(i));
            if (Lib.isBaseClass(thing)) continue;
            thing.flattenProperties();
            Iterator iterator = thing.getCollapsedMap().keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith("Is") || !thing.getFlag(string)) continue;
                baseObject.set(string, baseObject.getStat(string) + 1);
            }
        }
        return baseObject.report();
    }

    public static Thing createThing(BaseObject baseObject) {
        String string;
        Thing thing;
        if (!baseObject.getFlag("IsOptimized")) {
            baseObject.optimize();
        }
        if ((thing = new Thing(baseObject)).handles("OnCreate")) {
            thing.handle(new Event("Create"));
        }
        if ((string = thing.getString("DefaultThings")) != null) {
            Lib.createDefaultThings(thing, string);
        }
        if (thing.getFlag("IsBeing")) {
            if (RPG.d(100) <= 3) {
                thing.addThing(Lib.createItem(thing.getLevel()));
            }
            Being.utiliseItems(thing);
        }
        ++Lib.instance.createCount;
        return thing;
    }

    public static int getCreateCount() {
        return Lib.instance.createCount;
    }

    private static void createDefaultThings(Thing thing, String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            try {
                Lib.createDefaultThing(thing, stringArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void createDefaultThing(Thing thing, String string) {
        Thing thing2;
        int n = string.indexOf(37);
        if (n > 0) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n).trim());
                if (RPG.r(100) >= n2) {
                    return;
                }
                string = string.substring(n + 1, string.length()).trim();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Game.warn("createDefaultThing parse error: " + string);
                return;
            }
        }
        if (string.charAt(0) == '[') {
            String string2 = string.substring(1, string.length() - 1);
            int n3 = thing.getLevel();
            n3 = n3 + RPG.d(2, 6) - RPG.d(2, 6);
            thing2 = Lib.createType(string2, n3);
        } else {
            thing2 = Lib.create(string);
        }
        thing.addThingWithStacking(thing2);
    }

    public static int currentLevel() {
        return Game.level();
    }

    public static Thing createType(String string) {
        return Lib.createType(string, RPG.d(Lib.currentLevel()));
    }

    private BaseObject getThingFromType(String string, int n) {
        Integer n2;
        List list = this.getTypeArray(string, n);
        int n3 = 1;
        while (list.isEmpty() && n3 < 50) {
            list = this.getTypeArray(string, n + n3);
            n3 = n3 > 0 ? -n3 : -n3 + 1;
        }
        if (list.isEmpty()) {
            throw new Error("Can't create type [" + string + "] at level " + n);
        }
        BaseObject baseObject = null;
        for (int i = 0; i < 100 && (n2 = (Integer)(baseObject = (BaseObject)list.get(RPG.r(list.size()))).get("Frequency")) != null && RPG.r(100) >= n2; ++i) {
        }
        if (baseObject == null) {
            throw new Error("Can't find type [" + string + "] at level " + n);
        }
        return baseObject;
    }

    private void buildTypeArrays() {
        this.clearTypes();
        Iterator iterator = this.all.iterator();
        while (iterator.hasNext()) {
            Thing thing = (Thing)iterator.next();
            this.addThingToTypeArray(thing);
        }
    }

    private void addThingToTypeArray(Thing thing) {
        if (thing.getStat("Frequency") <= 0) {
            return;
        }
        if (((String)thing.get("Name")).indexOf("base ") >= 0) {
            return;
        }
        Integer n = (Integer)thing.get("LevelMin");
        Integer n2 = (Integer)thing.get("LevelMax");
        if (n == null) {
            return;
        }
        int n3 = n2 == null ? 50 : n2;
        String[] stringArray = thing.findAttributesStartingWith("Is");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!thing.getFlag(string)) continue;
            HashMap<Integer, ArrayList<Thing>> hashMap = (HashMap<Integer, ArrayList<Thing>>)this.types.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<Integer, ArrayList<Thing>>();
                this.types.put(string, hashMap);
            }
            for (int j = n.intValue(); j < n3; ++j) {
                Integer n4 = new Integer(j);
                ArrayList<Thing> arrayList = (ArrayList<Thing>)hashMap.get(n4);
                if (arrayList == null) {
                    arrayList = new ArrayList<Thing>();
                    hashMap.put(n4, arrayList);
                }
                arrayList.add(thing);
            }
        }
    }

    public static Thing createType(String string, int n) {
        if (string.equals("IsCoin")) {
            return Coin.createLevelMoney(n);
        }
        if (string.equals("IsRandomArtifact")) {
            return Lib.createArtifact(n);
        }
        BaseObject baseObject = Lib.instance().getThingFromType(string, n);
        Thing thing = Lib.createThing(baseObject);
        if (RPG.d(3) == 1 && thing.getFlag("IsBeing")) {
            Being.gainLevel(thing, RPG.rspread(n, thing.getLevel()));
        }
        return thing;
    }

    public List getTypeArray(String string, int n) {
        Integer n2;
        List list;
        Hashtable hashtable;
        if (n < 1) {
            n = 1;
        }
        if (this.types == null) {
            this.types = new Hashtable();
        }
        if ((hashtable = (Hashtable)this.types.get(string)) == null) {
            hashtable = new Hashtable();
            this.types.put(string, hashtable);
        }
        if ((list = (List)hashtable.get(n2 = new Integer(n))) == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public static void asynchronousCreate() {
        new Thread(new Runnable(){

            public void run() {
                Lib.instance();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lib instance() {
        Object object = libLock;
        synchronized (object) {
            if (instance == null) {
                instance = new Lib();
                Lib.init();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = libLock;
        synchronized (object) {
            instance = null;
        }
    }

    public static BaseObject getThing(String string) {
        return Lib.get(string);
    }

    public static int getDefaultStat(Thing thing, String string) {
        Integer n = (Integer)Lib.getDefault(thing, string);
        return n == null ? 0 : n;
    }

    public static Object getDefault(Thing thing, String string) {
        BaseObject baseObject = Lib.get(thing.getString("Name"));
        if (baseObject == null) {
            return null;
        }
        return baseObject.get(string);
    }

    public static BaseObject get(String string) {
        return (BaseObject)Lib.instance().lib.get(string);
    }

    public Object getObject(String string) {
        return this.lib.get(string);
    }

    public static List getUniques() {
        return Lib.instance().uniques;
    }

    public static Map getCreatedUniques() {
        return Lib.instance().createdUniques;
    }

    public static Thing extend(String string, String string2) {
        BaseObject baseObject = Lib.get(string2);
        if (baseObject == null) {
            throw new Error("Can't find base properties [" + string2 + "]");
        }
        Thing thing = new Thing(baseObject);
        thing.set("Name", string);
        return thing;
    }

    public static Thing extendCopy(String string, String string2) {
        BaseObject baseObject = Lib.get(string2);
        if (baseObject == null) {
            throw new Error("Can't find base properties [" + string2 + "]");
        }
        Thing thing = new Thing(baseObject.getPropertyHashMap(), null);
        thing.set("Name", string);
        return thing;
    }

    public static Thing extendNamed(String string, String string2) {
        Thing thing = Lib.extend("newthing", string2);
        AI.name(thing, string);
        return thing;
    }

    public static void add(Thing thing) {
        Lib lib = Lib.instance();
        if (lib == null) {
            throw new Error("Game.hero.lib not available!");
        }
        String string = (String)thing.get("Name");
        if (string == null) {
            throw new Error("Trying to add unnamed object to Library!");
        }
        Lib.prepareAdd(thing);
        if (lib.lib.get(string) != null) {
            Game.warn("Trying to add duplicate object [" + string + "] to library!");
        }
        lib.lib.put(string, thing);
        lib.lowerCaseNames.put(string.toLowerCase(), string);
        lib.all.add(thing);
        lib.addThingToTypeArray(thing);
        if (thing.getFlag("IsUnique")) {
            lib.uniques.add(thing);
        }
    }

    public static Thing getLibraryInstance(String string) {
        return (Thing)Lib.instance.lib.get(string);
    }

    private static boolean isBaseClass(Thing thing) {
        return thing.getString("Name").indexOf("base ") == 0;
    }

    private static void prepareAdd(Thing thing) {
        String string = thing.getString("Name");
        if (!Lib.isBaseClass(thing) && thing.getStat("LevelMin") <= 0) {
            thing.set("LevelMin", 1);
            Game.warn("Warning: no LevelMin for " + string);
        }
        if (thing.getStat("Level") <= thing.getStat("LevelMin")) {
            thing.set("Level", thing.getStat("LevelMin"));
        }
        if (thing.getFlag("IsDestructible")) {
            int n = thing.getStat("HPS");
            if (n <= 0) {
                if (thing.getFlag("IsBeing")) {
                    n = thing.getStat("TG");
                }
                if (n <= 0) {
                    throw new Error(thing.name() + " has no HPS!");
                }
            }
            if (thing.getFlag("IsBeing")) {
                n = RPG.max(n, thing.getStat("TG"));
            }
            thing.set("HPSMAX", n);
            thing.set("HPS", n);
        }
        if (thing.getFlag("IsBeing")) {
            thing.set("MPSMAX", thing.getStat("WP"));
        }
        if (thing.getFlag("MPSMAX")) {
            thing.set("MPS", thing.getStat("MPSMAX"));
        }
        if (thing.getFlag("IsOpenable") && thing.get("ImageOpen") == null) {
            thing.set("ImageOpen", 1);
        }
        thing.set("Seed", RPG.r(1000000));
    }

    public ArrayList getTiles() {
        return this.tileList;
    }

    public static String wieldDescription(int n) {
        switch (n) {
            case 1: {
                return "Right hand";
            }
            case 2: {
                return "Left hand";
            }
            case 3: {
                return "Both hands";
            }
            case 4: {
                return "Right finger";
            }
            case 5: {
                return "Left finger";
            }
            case 6: {
                return "Neck";
            }
            case 7: {
                return "Worn";
            }
            case 8: {
                return "Feet";
            }
            case 9: {
                return "Body";
            }
            case 10: {
                return "Worn";
            }
            case 11: {
                return "Head";
            }
            case 12: {
                return "Worn";
            }
            case 13: {
                return "Body";
            }
            case 14: {
                return "Worn";
            }
            case 20: {
                return "Ranged weapon";
            }
            case 21: {
                return "Missile";
            }
            case 15: {
                return "Waist";
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                return "Using";
            }
        }
        return null;
    }

    public static int hitLocation() {
        switch (RPG.d(30)) {
            case 1: 
            case 2: {
                return 11;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 6;
            }
            case 6: 
            case 7: {
                return 8;
            }
        }
        switch (RPG.d(5)) {
            case 1: 
            case 2: {
                return 9;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 10;
            }
        }
        throw new Error("Invalid Hit Location");
    }

    public static String damageDescription(int n, int n2) {
        double d;
        if (n <= 0) {
            return "no damage";
        }
        if (n2 <= 0) {
            n2 = 10;
        }
        if ((d = (double)n / (double)n2) < 0.2) {
            return "minor damage";
        }
        if (d < 0.4) {
            return "moderate damage";
        }
        if (d < 0.7) {
            return "serious damage";
        }
        return "critical damage";
    }

    public static Thing createShield(int n) {
        return Lib.createType("IsShield", n);
    }

    public static Thing createFood(int n) {
        return Food.createFood(n);
    }

    public static Thing createWeapon(int n) {
        return Lib.createType("IsWeapon", n);
    }

    public static Thing createSword(int n) {
        return Lib.createType("IsSword", n);
    }

    public static Thing createLightArmour(int n) {
        return Lib.createType("IsArmour", n);
    }

    public static Thing createArmour(int n) {
        return Lib.createType("IsArmour", n);
    }

    public static Thing createArtifact(int n) {
        Thing thing;
        int n2;
        ArrayList<Thing> arrayList = new ArrayList<Thing>();
        List list = Lib.instance().uniques;
        for (n2 = 0; n2 < list.size(); ++n2) {
            thing = (Thing)list.get(n2);
            if (Lib.instance().createdUniques.containsKey(thing.name()) || !thing.getFlag("IsRandomArtifact") || thing.getStat("LevelMin") > n) continue;
            arrayList.add(thing);
        }
        n2 = arrayList.size();
        if (n2 == 0) {
            Game.warn("No artifact at level " + n);
            return null;
        }
        thing = (Thing)arrayList.get(RPG.r(n2));
        return Lib.getArtifact(thing.name());
    }

    public static Thing createItem(int n) {
        switch (RPG.d(15)) {
            case 1: {
                return Lib.createArmour(n);
            }
            case 2: {
                return Lib.createType("IsWeapon", n);
            }
            case 3: {
                return SpellBook.create(n);
            }
            case 4: {
                return Lib.createType("IsWand", n);
            }
            case 5: {
                return Lib.createType("IsRing", n);
            }
            case 6: {
                return Potion.createPotion();
            }
            case 7: 
            case 8: {
                return Lib.createType("IsFood", n);
            }
            case 9: 
            case 10: {
                return Lib.createType("IsScroll", n);
            }
            case 11: {
                return Lib.createArmour(n);
            }
            case 12: {
                return Missile.createMissile(n);
            }
            case 13: {
                return Coin.createMoney(RPG.d(10 + n * 5) * RPG.d(3 + n * 5));
            }
            case 14: {
                return RangedWeapon.createRangedWeapon(n);
            }
            case 15: {
                return Lib.createType("IsSword", n);
            }
        }
        return Food.createFood(n);
    }

    public static Thing addNewArtifact(Thing thing) {
        Lib.add(thing);
        return thing;
    }

    public static Thing getArtifact(String string) {
        Map map = Lib.getCreatedUniques();
        Thing thing = (Thing)map.get(string);
        if (thing == null) {
            thing = Lib.createThing(Lib.get(string));
        }
        map.put(string, thing);
        return thing;
    }

    public static Thing createFoe(int n) {
        return Lib.createType("IsHostile", n);
    }

    public static Thing createMonster(int n) {
        return Lib.createType("IsMonster", n + RPG.r(3));
    }

    public static Thing createCreature(int n) {
        return Lib.createType("IsMonster", n);
    }

    public static Thing createMagicItem(int n) {
        return Lib.createType("IsMagicItem", n);
    }

    private static void init() {
        Lib.initBase();
        Special.init();
        Effect.init();
        Skill.init();
        Spell.init();
        Being.init();
        Special.initClouds();
        Item.init();
        Decoration.init();
        Scenery.init();
        Tile.init();
        Door.init();
        Chest.init();
        Trap.init();
        Gods.init();
        Quest.init();
        AI.init();
        Animal.init();
        Monster.init();
        Person.init();
        Artifact.init();
        EndGame.init();
        Tutorial.init();
        GoblinVillage.init();
        Temple.init();
        Recipe.init();
        Spell.updateIngredients();
        if (Game.isDebug()) {
            System.out.println("Library initialisation complete");
            System.out.println(Lib.instance().stats());
        }
    }

    public Set getAllPropertyNames() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.all.iterator();
        while (iterator.hasNext()) {
            BaseObject baseObject = (BaseObject)iterator.next();
            Map map = baseObject.getCollapsedMap();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(iterator2.next());
            }
        }
        return hashSet;
    }

    public void set(String string, Object object) {
        this.lib.put(string, object);
    }

    public static void setInstance(Lib lib) {
        if (instance != lib) {
            instance = lib;
            lib.buildTypeArrays();
        }
    }

    static {
        libLock = new Object();
        DESC_IMPERIALCROWN = new Describer("The Crown of Daedor", "", "The priceless crown of the Daedorian Empire. This artifact is rumoured to bestow remarkable powers on the wearer.", 1, 0);
        DESC_HAT = new Describer("hat", "A hat of fine quality.");
        DESC_TROUSERS = new Describer("trousers", "pairs of trousers", "A pair of serviceable trousers.", 2, 0);
        DESC_ROBE = new Describer("robe", "A well-made robe.");
        DESC_MAGICROBE = new Describer("robe", "A robe covered with runes and mystic sigils.");
        DESC_GLOVES = new Describer("gloves", "pairs of gloves", "A pair of soft leather gloves.", 2, 0);
        DESC_TREASURE = new Describer("treasure", "treasure", "Valuable treasure.", 2, 0);
        qualitystrings = new String[]{"useless", "pathetic", "very poor", "poor", "mediocre", "average", "fair", "good", "very good", "excellent", "superb", "brilliant", "divine", "perfect"};
        qualityvalues = new int[]{0, 20, 40, 60, 80, 100, 150, 200, 400, 800, 1800, 5000, 20000, 100000};
    }
}

