/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.HashSet;
import mikera.tyrant.Amulet;
import mikera.tyrant.Armour;
import mikera.tyrant.Being;
import mikera.tyrant.Clothing;
import mikera.tyrant.Coin;
import mikera.tyrant.Equipment;
import mikera.tyrant.Event;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.Gods;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Missile;
import mikera.tyrant.Movement;
import mikera.tyrant.Potion;
import mikera.tyrant.RPG;
import mikera.tyrant.RangedWeapon;
import mikera.tyrant.Ring;
import mikera.tyrant.Rune;
import mikera.tyrant.Score;
import mikera.tyrant.Scroll;
import mikera.tyrant.Secret;
import mikera.tyrant.SpellBook;
import mikera.tyrant.Thing;
import mikera.tyrant.Wand;
import mikera.tyrant.Weapon;

public class Item {
    private static final String wpstring = "watery potion";
    public static final double VALUEFACTOR = Math.sqrt(2.0);

    public static boolean isIdentified(Thing thing) {
        HashSet hashSet = (HashSet)Game.hero().get("IdentifiedItems");
        if (hashSet == null) {
            return false;
        }
        return hashSet.contains(thing.name());
    }

    public static boolean repair(Thing thing, boolean bl) {
        if (thing.getStat("HPS") < thing.getStat("HPSMAX")) {
            if (!bl) {
                thing.incStat("HPSMAX", -1);
            }
            thing.set("HPS", thing.getStat("HPSMAX"));
            return true;
        }
        return false;
    }

    public static boolean isDamaged(Thing thing) {
        return thing.getStat("HPS") < thing.getStat("HPSMAX");
    }

    public static boolean isDisguisedName(Thing thing) {
        String string = thing.getString("UName");
        if (string == null) {
            return false;
        }
        return !string.equals(thing.getString("Name"));
    }

    public static void identify(Thing thing) {
        Thing thing2 = Game.hero();
        HashSet<String> hashSet = (HashSet<String>)thing2.get("IdentifiedItems");
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            thing2.set("IdentifiedItems", hashSet);
        }
        if (hashSet.add(thing.name())) {
            Score.scoreIdentify(thing2, thing);
        }
        if (wpstring.equals(thing.getString("UName"))) {
            Lib.get(thing.name()).set("IsStatusKnown", 1);
        }
    }

    public static void fullIdentify(Thing thing) {
        Item.identify(thing);
        thing.set("IsStatusKnown", 1);
    }

    public static boolean isOwned(Thing thing) {
        return thing.getFlag("IsOwned") || thing.getFlag("IsShopOwned");
    }

    public static void clearOwnership(Thing thing) {
        thing.set("IsOwned", 0);
        thing.set("IsShopOwned", 0);
    }

    public static void steal(Thing thing, Thing thing2) {
        thing2.getMap().areaNotify(thing2.getMapX(), thing2.getMapY(), 10, 6, 0, thing);
        if (thing.isHero()) {
            Gods.checkTheft(thing);
        }
    }

    public static boolean pickup(Thing thing, Thing thing2) {
        Thing thing3;
        int n;
        thing2.remove();
        Item.tryIdentify(thing, thing2);
        int n2 = Being.maxCarryingWeight(thing) - thing.getInventoryWeight();
        int n3 = thing2.getWeight();
        if (n3 > 0 && n2 < n3) {
            if (n2 >= thing2.getStat("ItemWeight")) {
                n = n2 / thing2.getStat("ItemWeight");
                thing.message("You are only able to pick up " + n + " of " + thing2.getTheName());
                thing3 = thing2.separate(thing2.getNumber() - n);
                thing.getMap().addThing(thing3, thing.getMapX(), thing.getMapY());
            } else {
                thing.message("You can't handle any more kit!");
                thing.getMap().addThing(thing2, thing.getMapX(), thing.getMapY());
                return false;
            }
        }
        n = 0;
        if (Item.isOwned(thing2)) {
            Item.clearOwnership(thing2);
            n = 1;
        }
        if (n != 0) {
            thing.message("You sneakily grab " + thing2.getTheName(null));
            thing.addThingWithStacking(thing2);
            Item.steal(thing, thing2);
        } else {
            thing.message("You pick up " + thing2.getTheName(null));
            thing.addThingWithStacking(thing2);
        }
        thing3 = thing.getWielded(7);
        Item.touch(thing3 == null ? thing : thing3, thing2);
        return true;
    }

    public static void drop(Thing thing, Thing thing2) {
        Movement.moveTo(thing2, thing.getMap(), thing.x, thing.y);
    }

    public static void touch(Thing thing, Thing thing2) {
        Event event;
        if (thing.handles("OnTouch")) {
            event = new Event("Touch");
            event.set("Target", thing2);
            thing.handle(event);
        }
        if (thing2.handles("OnTouch")) {
            event = new Event("Touch");
            event.set("Target", thing);
            thing2.handle(event);
        }
    }

    public static double identitySeed(Thing thing) {
        return (double)(thing.getStat("Seed") % 123456) / 123456.0;
    }

    public static void tryIdentify(Thing thing, Thing[] thingArray) {
        for (int i = 0; i < thingArray.length; ++i) {
            Item.tryIdentify(thing, thingArray[i]);
        }
    }

    public static boolean tryStatusDetect(Thing thing, Thing thing2) {
        if (thing2.getFlag("IsStatusKnown")) {
            return true;
        }
        int n = RPG.min(thing.getStat("Prayer"), thing.getStat("Holy Magic") * 2);
        if (n >= 2 && thing2.getStat("Level") <= (n - 1) * 6) {
            thing2.set("IsStatusKnown", 1);
            return true;
        }
        return false;
    }

    public static boolean tryIdentify(Thing thing, Thing thing2) {
        if (thing != Game.hero()) {
            return false;
        }
        Item.tryStatusDetect(thing, thing2);
        if (Item.isIdentified(thing2)) {
            return true;
        }
        int n = thing.getStat("Item Lore");
        int n2 = thing.getStat("IN");
        int n3 = n2 * n;
        int n4 = thing2.getLevel();
        double d = Item.identitySeed(thing2);
        double d2 = (double)(10000 * n3) / 1000000.0;
        d2 -= (double)n4 * 0.02;
        if (!Item.isDisguisedName(thing2)) {
            d2 += 1000.0;
        }
        if (d2 <= d) {
            if (thing2.getFlag("IsRune")) {
                d2 += (double)thing.getStat("Rune Lore") * 0.1;
            }
            if (thing2.getFlag("IsWeapon") || thing2.getFlag("IsArmour")) {
                d2 += (double)thing.getStat("Weapon Lore") * 0.2;
                d2 += (double)thing.getStat("Smithing") * 0.1;
            }
            if (thing2.getFlag("IsThrowingWeapon")) {
                d2 += (double)thing.getStat("Throwing") * 0.2;
            }
            if (thing2.getFlag("IsRangedWeapon") || thing2.getFlag("IsMissile")) {
                d2 += (double)thing.getStat("Archery") * 0.2;
            }
            if (thing2.getFlag("IsPotion")) {
                d2 += (double)thing.getStat("Alchemy") * 0.2;
            }
            if (thing2.getFlag("IsHerb")) {
                d2 += (double)thing.getStat("Herb Lore") * 0.3;
            }
            if (thing2.getFlag("IsFood")) {
                d2 += (double)thing.getStat("Cooking") * 0.3;
            }
            if (thing2.getFlag("IsBook") || thing2.getFlag("IsScroll")) {
                d2 += (double)thing.getStat("Literacy") * 0.2;
            }
        }
        if (d2 > d) {
            Item.identify(thing2);
            return true;
        }
        return false;
    }

    public static String inspect(Thing thing) {
        Object object;
        thing = thing.separate(1);
        Thing thing2 = Game.hero();
        String string = "";
        if (thing.getFlag("IsArtifact") && Item.isIdentified(thing)) {
            string = string + "This is the legendary artifact known as \"" + thing.name() + "\"\n";
        } else {
            object = thing.getString("Description");
            if (object == null) {
                object = "This looks like a normal " + thing.getSingularName() + ".";
            }
            object = (String)object + "\n";
            string = string + (String)object;
        }
        if (!Item.isIdentified(thing)) {
            object = "You have not identified it yet.";
            if (Item.isDisguisedName(thing) && thing2.getFlag("Perception")) {
                object = (String)object + " You feel that there may be more to it than meets the eye.\n";
            }
            string = string + (String)object + "\n";
        }
        if (thing2.getFlag("Appraisal")) {
            string = string + "You estimate that it may be worth up to " + Coin.valueString(Item.value(thing)) + "\n";
        }
        if (thing2.getFlag("Spellcasting") && thing.getFlag("IsMagicItem")) {
            string = string + "You sense the presence of magical energies.\n";
        }
        if (!thing2.getFlag("Literacy") || thing.getFlag("IsBook")) {
            // empty if block
        }
        if (thing.getFlag("IsWeapon")) {
            object = "single handed";
            switch (thing.getStat("WieldType")) {
                case 3: {
                    object = "two handed";
                }
            }
            String string2 = "It can be used as a " + (String)object + " weapon, with an attack skill of " + Weapon.getASK(thing, thing2) + " and an attack strength of " + Weapon.getAST(thing, thing2) + ". ";
            string2 = string2 + " It contributes " + Weapon.getDSK(thing, thing2) + " to your defence skill.";
            if (thing2.getFlag("Weapon Lore")) {
                string2 = string2 + " It inflicts " + thing.getString("WeaponDamageType") + " damage. ";
                string2 = string2 + " It has a base attack cost of " + thing.getStat("AttackCost") + ". ";
                int n = Weapon.getExtraAST(thing, thing2);
                if (n > 0) {
                    string2 = string2 + "It inflicts an additional " + n + " points of " + thing.getString("ExtraDamageType") + " damage. ";
                }
            }
            string = string + string2 + "\n";
        }
        if (thing2.getFlag("Rune Lore")) {
            object = thing.getInventory();
            for (int i = 0; i < thing.invCount(); ++i) {
                Thing thing3 = object[i];
                if (!thing3.getFlag("IsRune")) continue;
                string = string + "It is inscribed with " + thing3.getAName() + ".\n";
            }
        } else if (thing.getFlag("IsRunic")) {
            string = string + "It is inscribed with mysterious runes.\n";
        }
        string = string.replaceAll("\n", "\n\n");
        thing.restack();
        return string;
    }

    public static void use(Thing thing, Thing thing2) {
        if (thing2.handles("OnUse")) {
            Event event = new Event("Use");
            event.set("User", thing);
            thing2.handle(event);
        } else {
            thing.message("You don't manage to do anything interesting");
        }
        thing.incStat("APS", -Being.actionCost(thing));
    }

    public static int value(Thing thing) {
        return Item.valueOfOne(thing) * thing.getStat("Number");
    }

    public static double levelValue(int n) {
        return Math.pow(VALUEFACTOR, n - 1);
    }

    public static int valueOfOne(Thing thing) {
        int n = thing.getStat("Value");
        if (n == 0) {
            n = (int)((double)thing.getStat("ValueBase") * Item.levelValue(thing.getLevel()));
        }
        Thing[] thingArray = thing.getInventory();
        for (int i = 0; i < thing.invCount(); ++i) {
            n += Item.value(thingArray[i]);
        }
        return n;
    }

    public static Thing findShopkeeper(Thing thing) {
        Map map = thing.getMap();
        Thing thing2 = null;
        Thing thing3 = map.getFlaggedObject(thing.x, thing.y, "IsStockingPoint");
        if (thing3 != null) {
            thing2 = thing3.getThing("Shopkeeper");
        }
        int n = 100;
        if (thing2 == null) {
            Thing[] thingArray = map.getObjects(thing.x - 8, thing.y - 8, thing.x + 8, thing.y + 8, "IsInhabitant");
            for (int i = 0; i < thingArray.length; ++i) {
                Thing thing4 = thingArray[i];
                if (thing4.getFlag("IsShopkeeper")) {
                    return thing4;
                }
                if (RPG.distSquared(thing4.x, thing4.y, thing.x, thing.y) >= n) continue;
                thing2 = thing4;
            }
        }
        return thing2;
    }

    public static void bless(Thing thing) {
        if (!thing.getFlag("IsItem")) {
            Game.warn("Trying to bless a non-item!");
            return;
        }
        if (thing.getFlag("IsArtifact")) {
            thing.visibleMessage(thing.getYourName() + " " + thing.verb("seem") + " unaffected");
            return;
        }
        thing.visibleMessage(thing.getYourName() + " " + thing.is() + " surrounded by a holy light");
        if (thing.getFlag("IsCursed")) {
            thing.set("IsCursed", 0);
        } else {
            thing.set("IsBlessed", 1);
        }
        thing.set("IsStatusKnown", 1);
        thing.restack();
    }

    public static void curse(Thing thing) {
        Item.curse(thing, true);
    }

    public static void curse(Thing thing, boolean bl) {
        if (!thing.getFlag("IsItem")) {
            Game.warn("Trying to bless a non-item!");
            return;
        }
        if (thing.getFlag("IsArtifact")) {
            if (bl) {
                thing.visibleMessage(thing.getYourName() + " " + thing.verb("seem") + " unaffected");
            }
            return;
        }
        if (bl) {
            thing.visibleMessage(thing.getYourName() + " " + thing.is() + " surrounded by an unholy light");
        }
        if (thing.getFlag("IsBlessed")) {
            thing.set("IsBlessed", 0);
        } else {
            thing.set("IsCursed", 1);
        }
        thing.set("IsStatusKnown", 1);
    }

    public static int shopValue(Thing thing, Thing thing2, Thing thing3) {
        return Item.shopValue(thing, thing2, thing3, thing.getNumber());
    }

    public static int shopValue(Thing thing, Thing thing2, Thing thing3, int n) {
        int n2 = Item.valueOfOne(thing);
        n2 = Coin.roundDownMoney(n2);
        n2 = n * (int)((double)n2 * Item.shopFactor(thing2, thing3));
        return n2;
    }

    private static double shopFactor(Thing thing, Thing thing2) {
        double d = thing.getStat("CH") * thing.getStat("Trading");
        double d2 = thing2.getStat("CH");
        return 0.4 + 0.6 * (d / (d + d2));
    }

    public static int shopPrice(Thing thing, Thing thing2, Thing thing3) {
        int n = Item.value(thing);
        n = (int)((double)n / Math.sqrt(Item.shopFactor(thing2, thing3)));
        return Coin.roundMoney(n);
    }

    public static void init() {
        Thing thing = Lib.extendCopy("base item", "base thing");
        thing.set("IsItem", 1);
        thing.set("IsStoreItem", 1);
        thing.set("IsOwned", 0);
        thing.set("IsShopOwned", 0);
        thing.set("IsDestructible", 1);
        thing.set("IsPhysical", 1);
        thing.set("HPS", 10);
        thing.set("ImageSource", "Items");
        thing.set("Image", 1);
        thing.set("WeaponDamageType", "normal");
        thing.set("RES:poison", 1000);
        thing.set("RES:ice", 13);
        thing.set("RES:chill", 1000);
        thing.set("RES:drain", 25);
        thing.set("NameType", 0);
        thing.set("Z", 20);
        Lib.add(thing);
        Food.init();
        Scroll.init();
        Missile.init();
        RangedWeapon.init();
        Potion.init();
        Wand.init();
        Ring.init();
        Coin.init();
        Armour.init();
        Weapon.init();
        Secret.init();
        SpellBook.init();
        Equipment.init();
        Amulet.init();
        Rune.init();
        Clothing.init();
    }
}

