/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Being;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Hero;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Missile;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Food {
    public static Thing createFood(int n) {
        return Lib.createType("IsFood", n);
    }

    public static boolean isVegetarian(Thing thing) {
        return thing.getFlag("IsVegetarianFood");
    }

    public static void eat(Thing thing, Thing thing2) {
        int n;
        if (!thing2.getFlag("IsEdible")) {
            if (thing.isHero()) {
                Game.message("You can't eat that!");
            }
            return;
        }
        thing2 = thing2.separate(1);
        Thing thing3 = Game.hero();
        if (thing != thing3) {
            return;
        }
        thing3.incStat("APS", -Being.actionCost(thing3));
        boolean bl = false;
        int n2 = thing3.getStat("Hunger");
        int n3 = Food.nutritionValue(thing2, thing3);
        if (n2 - Food.nutritionValue(thing2, thing3) / 2 < -thing3.getStat("HungerThreshold")) {
            if (n2 > 0) {
                bl = true;
                n = Math.min(n2, n3);
                thing2.incStat("FoodValue", -n);
                if (!thing2.getFlag("IsCursed")) {
                    thing3.incStat("Hunger", -n);
                }
            }
            thing3.message("You eat part of " + thing2.getTheName());
        } else {
            thing3.message("You eat " + thing2.getTheName());
        }
        if (thing2.handles("OnEaten")) {
            Event event = new Event("Eaten");
            event.set("Target", thing);
            if (thing2.handle(event)) {
                return;
            }
            thing2.remove("OnEaten");
        }
        n = thing3.getStat("Hunger");
        if (thing2.getFlag("IsCursed")) {
            Game.message("That tasted pretty foul!");
        } else {
            if (!bl) {
                n = RPG.max(-thing3.getStat("HungerThreshold"), n - n3);
                thing2.incStat("FoodValue", -n3);
                thing3.set("Hunger", n);
            }
            Game.message("Yum yum!  You feel " + Hero.hungerString(thing3));
        }
        if (Food.nutritionValue(thing2, thing3) <= 0) {
            thing2 = thing2.remove(1);
        }
    }

    public static int nutritionValue(Thing thing, Thing thing2) {
        int n = thing.getStatIfAbsent("FoodValue", -1);
        if (n == -1) {
            n = Food.pureNutrition(thing, thing2);
            thing.set("FoodValue", n);
        }
        return n;
    }

    private static int pureNutrition(Thing thing, Thing thing2) {
        double d = thing.getStat("ItemWeight") * thing.getStat("Nutrition");
        if (thing.getFlag("IsBlessed")) {
            d *= 2.0;
        }
        return (int)(d *= 1.0 + 0.1 * (double)thing2.getStat("Survival"));
    }

    public static void init() {
        Thing thing = Lib.extend("base food", "base item");
        thing.set("Z", 19);
        thing.set("IsEdible", 1);
        thing.set("Image", 226);
        thing.set("IsFood", 1);
        thing.set("ValueBase", 10);
        thing.set("HPS", 4);
        thing.set("Nutrition", 20);
        thing.set("IsVegetarianFood", 1);
        thing.set("ItemWeight", 1000);
        thing.set("Frequency", 100);
        thing.set("ASCII", "%");
        Lib.add(thing);
        Food.initFood();
        Food.initFruit();
        Food.initBerries();
        Food.initStoneFruit();
        Food.initMeat();
        Food.initPoultry();
        Food.initFish();
        Food.initPies();
        Food.initMushrooms();
        Food.initBread();
        Food.initEggs();
        Food.initVegetables();
        Food.initHerbs();
        Food.initMonsterParts();
        Food.initSkulls();
    }

    private static void addFood(Thing thing) {
        Lib.add(thing);
    }

    private static void initMonsterParts() {
        Thing thing = Lib.extend("base monster part", "base food");
        thing.set("IsMonsterPart", 1);
        thing.set("IsMeat", 1);
        thing.set("Image", 481);
        thing.set("Frequency", 20);
        thing.set("Nutrition", 80);
        thing.set("ItemWeight", 400);
        thing.set("IsBlackIngredient", 1);
        thing.set("IsVegetarianFood", 0);
        thing.set("ValueBase", 50);
        Lib.add(thing);
        thing = Lib.extend("mouse tail", "base monster part");
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 400);
        Lib.add(thing);
        thing = Lib.extend("rat tail", "base monster part");
        thing.set("LevelMin", 2);
        Lib.add(thing);
        thing = Lib.extend("frog leg", "base monster part");
        thing.set("LevelMin", 5);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 10, 50));
        Lib.add(thing);
        thing = Lib.extend("toad leg", "base monster part");
        thing.set("LevelMin", 5);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "WP", 20, 50));
        Lib.add(thing);
        thing = Lib.extend("snake skin", "base monster part");
        thing.set("LevelMin", 3);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "CH", 10, 20));
        Lib.add(thing);
        thing = Lib.extend("cat whisker", "base monster part");
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("red snake skin", "base monster part");
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("scorpion tail", "base monster part");
        thing.set("LevelMin", 9);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "TG", 25, 50));
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("strong poison")));
        Lib.add(thing);
        thing = Lib.extend("base feather", "base monster part");
        Lib.add(thing);
        thing = Lib.extend("kestrel feather", "base feather");
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 10, 30));
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("hawk feather", "base feather");
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 20, 30));
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("vulture feather", "base feather");
        thing.addHandler("OnEaten", Scripts.statGain("Target", "SK", 20, 100));
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("eagle feather", "base feather");
        thing.addHandler("OnEaten", Scripts.statGain("Target", "SK", 30, 100));
        thing.set("LevelMin", 17);
        Lib.add(thing);
        thing = Lib.extend("bear paw", "base feather");
        thing.set("LevelMin", 18);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "ST", 30, 100));
        Lib.add(thing);
        thing = Lib.extend("phoenix feather", "base feather");
        thing.set("LevelMin", 37);
        Lib.add(thing);
        Food.initTeeth();
        Food.initDeadInsects();
    }

    private static void initDeadInsects() {
        Thing thing = Lib.extend("base dead insect", "base monster part");
        thing.set("ValueBase", 0);
        thing.set("IsStoreItem", 0);
        thing.set("IsVegetarianFood", 0);
        thing.set("Nutrition", 20);
        Lib.add(thing);
        thing = Lib.extend("dead bug", "base dead insect");
        thing.set("Nutrition", 10);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("squished bug", "base dead insect");
        thing.set("Nutrition", 3);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("squished roach", "base dead insect");
        thing.set("Nutrition", 3);
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("dead roach", "base dead insect");
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("dead beetle", "base dead insect");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("dead scorpion", "base dead insect");
        thing.set("LevelMin", 9);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("strong poison")));
        Lib.add(thing);
        thing = Lib.extend("dead fly", "base dead insect");
        thing.set("Nutrition", 1);
        thing.set("ItemWeight", 4);
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("dead bee", "base dead insect");
        thing.set("Nutrition", 2);
        thing.set("ItemWeight", 5);
        thing.set("LevelMin", 5);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("poison")));
        Lib.add(thing);
        thing = Lib.extend("dead wasp", "base dead insect");
        thing.set("Nutrition", 1);
        thing.set("ItemWeight", 6);
        thing.set("LevelMin", 7);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("poison")));
        Lib.add(thing);
        thing = Lib.extend("dead hornet", "base dead insect");
        thing.set("Nutrition", 1);
        thing.set("ItemWeight", 7);
        thing.set("LevelMin", 11);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("poison")));
        Lib.add(thing);
        thing = Lib.extend("dead fire wasp", "base dead insect");
        thing.set("Nutrition", 1);
        thing.set("ItemWeight", 5);
        thing.set("LevelMin", 9);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("strong poison")));
        Lib.add(thing);
        thing = Lib.extend("squished spider", "base dead insect");
        thing.set("Nutrition", 2);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("dead spider", "base dead insect");
        thing.set("Nutrition", 5);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("dead wolf spider", "base dead insect");
        thing.set("Nutrition", 5);
        thing.set("LevelMin", 6);
        Lib.add(thing);
        thing = Lib.extend("dead red spider", "base dead insect");
        thing.set("Nutrition", 5);
        thing.set("LevelMin", 8);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("poison")));
        Lib.add(thing);
        thing = Lib.extend("dead black widow", "base dead insect");
        thing.set("Nutrition", 5);
        thing.set("LevelMin", 10);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("strong poison")));
        Lib.add(thing);
        thing = Lib.extend("dead tarantula", "base dead insect");
        thing.set("Nutrition", 25);
        thing.set("LevelMin", 21);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("deadly poison")));
        Lib.add(thing);
    }

    private static void initTeeth() {
        Thing thing = Lib.extend("tooth", "base monster part");
        thing.set("NamePlural", "teeth");
        thing.set("Image", 490);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 10);
        thing.set("IsVegetarianFood", 0);
        thing.set("ValueBase", 30);
        Lib.add(thing);
        thing = Lib.extend("human tooth", "base monster part");
        thing.set("NamePlural", "human teeth");
        thing.set("Image", 490);
        thing.set("LevelMin", 6);
        Lib.add(thing);
        thing = Lib.extend("giant tooth", "base monster part");
        thing.set("NamePlural", "giant teeth");
        thing.set("Image", 490);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 16);
        Lib.add(thing);
        thing = Lib.extend("dragon tooth", "base monster part");
        thing.set("NamePlural", "dragon teeth");
        thing.set("Image", 490);
        thing.set("ItemWeight", 60);
        thing.set("LevelMin", 26);
        Lib.add(thing);
    }

    private static void initSkulls() {
        Thing thing = Lib.extend("base skull", "base monster part");
        thing.set("Image", 301);
        thing.set("ItemWeight", 1000);
        thing.set("Nutrition", 5);
        thing.set("Frequency", 20);
        thing.set("LevelMin", 10);
        thing.set("IsSkull", 1);
        thing.set("IsBlackIngredient", 1);
        thing.set("HPS", 8);
        Lib.add(thing);
        thing = Lib.extend("skull", "base skull");
        thing.set("UName", "skull");
        thing.set("ValueBase", 10);
        Lib.add(thing);
        thing = Lib.extend("human skull", "base skull");
        Lib.add(thing);
        thing = Lib.extend("orc skull", "base skull");
        thing.set("LevelMin", 7);
        Lib.add(thing);
        thing = Lib.extend("haunted skull", "base skull");
        thing.set("Frequency", 2);
        thing.set("DecayRate", 100);
        thing.set("LevelMin", 12);
        thing.set("DecayType", "haunted skeleton");
        thing.set("OnAction", Scripts.decay());
        Lib.add(thing);
        thing = Lib.extend("dragon skull", "base skull");
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("haunted dragon skull", "dragon skull");
        thing.set("Frequency", 2);
        thing.set("LevelMin", 26);
        thing.set("DecayRate", 10);
        thing.set("DecayType", "skeletal dragon");
        thing.set("OnAction", Scripts.decay());
        thing.set("HPS", 800);
        Lib.add(thing);
    }

    private static void initHerbs() {
        Thing thing = Lib.extend("base herb", "base food");
        thing.set("UName", "strange herb");
        thing.set("IsHerb", 1);
        thing.set("Nutrition", 2);
        thing.set("Frequency", 20);
        thing.set("IsAlchemyIngredient", 1);
        thing.set("IsHerbIngredient", 1);
        thing.set("IsVegetarianFood", 1);
        thing.set("Image", 486);
        thing.addHandler("OnTouch", new Script(){
            private static final long serialVersionUID = 1L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                if (RPG.d(5) == 1 && thing2.isHero() && !thing2.getFlag("Herb Lore")) {
                    Item.curse(thing, false);
                }
                return false;
            }
        });
        Food.addFood(thing);
        thing = Lib.extend("wayflower herb", "base herb");
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("dervish flower", "base herb");
        thing.set("LevelMin", 2);
        thing.addHandler("OnEaten", Scripts.addEffect("Target", Lib.create("strong poison")));
        Lib.add(thing);
        thing = Lib.extend("pixiedance flower", "base herb");
        thing.set("LevelMin", 3);
        thing.addHandler("OnEaten", Scripts.spellEffect("Target", "Teleport Self", 10));
        Lib.add(thing);
        thing = Lib.extend("pipeweed leaf", "base herb");
        thing.set("LevelMin", 4);
        thing.addHandler("OnEaten", Scripts.statusSwitch(Scripts.incStat("Target", "MPS", 10, "You feel much more lively"), Scripts.incStat("Target", "MPS", 2, "You feel more lively"), Scripts.incStat("Target", "MPS", -20, "You feel really weak")));
        Lib.add(thing);
        thing = Lib.extend("arwenflower leaf", "base herb");
        thing.set("LevelMin", 5);
        thing.addHandler("OnEaten", Scripts.statusSwitch(Scripts.incStat("Target", "Experience", 100, "You feel like you are learning a lot"), Scripts.incStat("Target", "Experience", 20, "You feel like you are learning something"), Scripts.incStat("Target", "Experience", -100, "You feel forgetful")));
        Lib.add(thing);
        thing = Lib.extend("kingsweed leaf", "base herb");
        thing.set("LevelMin", 6);
        Lib.add(thing);
        thing = Lib.extend("kahnflower", "base herb");
        thing.set("LevelMin", 7);
        thing.addHandler("OnTouch", Scripts.damage("poison", RPG.d(2, 4), "painfully stung by the herb!", 100));
        Lib.add(thing);
        thing = Lib.extend("krom leaf", "base herb");
        thing.set("LevelMin", 8);
        thing.set("OnEaten", Scripts.statusSwitch(Scripts.statGain("Target", "IN", 30, 100), Scripts.statGain("Target", "IN", 15, 100), Scripts.incStat("Target", "IN", -1, "Your head aches badly")));
        Lib.add(thing);
        thing = Lib.extend("fire nettle", "base herb");
        thing.set("LevelMin", 9);
        thing.addHandler("OnTouch", Scripts.damage("poison", RPG.d(4, 4), "painfully stung by the herb!", 100));
        Lib.add(thing);
    }

    private static void initFood() {
        Thing thing = Lib.extend("beefcake", "base food");
        thing.set("Image", 225);
        thing.set("Nutrition", 30);
        thing.set("ItemWeight", 2000);
        thing.set("IsVegetarianFood", 0);
        thing.set("LevelMin", 3);
        Food.addFood(thing);
    }

    private static void initVegetables() {
        Thing thing = Lib.extend("base vegetable", "base food");
        thing.set("IsVegetable", 1);
        thing.set("Nutrition", 10);
        thing.set("Frequency", 30);
        thing.set("IsShopFood", 1);
        thing.set("IsVegetarianFood", 1);
        thing.set("Image", 480);
        Food.addFood(thing);
        thing = Lib.extend("spinach leaf", "base vegetable");
        thing.set("Image", 480);
        thing.set("ItemWeight", 200);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "ST", 15, 15));
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("clover leaf", "base vegetable");
        thing.set("Image", 493);
        thing.set("ItemWeight", 100);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "CH", 40, 40));
        thing.set("LevelMin", 15);
        Food.addFood(thing);
        thing = Lib.extend("carrot", "base vegetable");
        thing.set("Image", 482);
        thing.set("ItemWeight", 500);
        thing.set("Nutrition", 15);
        thing.set("LevelMin", 1);
        Food.addFood(thing);
        thing = Lib.extend("prize carrot", "base vegetable");
        thing.set("Image", 482);
        thing.set("ItemWeight", 500);
        thing.set("Nutrition", 15);
        thing.set("LevelMin", 7);
        thing.set("OnEaten", Scripts.statGain("Target", "SK", 12, 100));
        Food.addFood(thing);
        thing = Lib.extend("parsnip", "base vegetable");
        thing.set("Image", 483);
        thing.set("ItemWeight", 400);
        thing.set("Nutrition", 12);
        thing.set("LevelMin", 4);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "CH", 15, 100));
        Food.addFood(thing);
        thing = Lib.extend("ginger root", "base vegetable");
        thing.set("Image", 485);
        thing.set("ItemWeight", 600);
        thing.set("Nutrition", 10);
        thing.set("LevelMin", 14);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 20, 100));
        Food.addFood(thing);
        thing = Lib.extend("ginseng root", "base vegetable");
        thing.set("Image", 485);
        thing.set("ItemWeight", 800);
        thing.set("Nutrition", 30);
        thing.set("LevelMin", 18);
        thing.addHandler("OnEaten", Scripts.incStat("Target", "APS", 100, "You feel a burst of energy fill your body"));
        Food.addFood(thing);
    }

    private static void initFish() {
        Thing thing = Lib.extend("base fish", "base food");
        thing.set("IsFish", 1);
        thing.set("Nutrition", 100);
        thing.set("Frequency", 30);
        thing.set("IsGoblinIngredient", 1);
        thing.set("IsVegetarianFood", 1);
        thing.set("Image", 236);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "IN", 10, 30));
        Food.addFood(thing);
        thing = Lib.extend("tiny fish", "base fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("LevelMin", 1);
        thing.set("Nutrition", 100);
        thing.set("ItemWeight", 200);
        Food.addFood(thing);
        thing = Lib.extend("small fish", "base fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("LevelMin", 3);
        thing.set("Nutrition", 120);
        thing.set("ItemWeight", 400);
        Food.addFood(thing);
        thing = Lib.extend("fish", "base fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("LevelMin", 6);
        thing.set("Nutrition", 140);
        thing.set("ItemWeight", 800);
        Food.addFood(thing);
        thing = Lib.extend("rotten fish", "fish");
        thing.set("UName", "fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("UNamePlural", thing.getString("UName"));
        thing.set("LevelMin", 5);
        thing.set("Nutrition", 30);
        thing.set("ItemWeight", 760);
        Food.addFood(thing);
        thing = Lib.extend("large fish", "base fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("LevelMin", 9);
        thing.set("Nutrition", 160);
        thing.set("Image", 238);
        thing.set("ItemWeight", 1600);
        Food.addFood(thing);
        thing = Lib.extend("trout", "base fish");
        thing.set("LevelMin", 12);
        thing.set("Nutrition", 170);
        thing.set("ItemWeight", 2000);
        thing.set("Image", 238);
        Food.addFood(thing);
        thing = Lib.extend("salmon", "base fish");
        thing.set("LevelMin", 16);
        thing.set("Nutrition", 200);
        thing.set("ItemWeight", 2500);
        thing.set("Image", 239);
        Food.addFood(thing);
        thing = Lib.extend("large salmon", "base fish");
        thing.set("LevelMin", 16);
        thing.set("Nutrition", 180);
        thing.set("ItemWeight", 4000);
        thing.set("Image", 239);
        Food.addFood(thing);
        thing = Lib.extend("red snapper", "base fish");
        thing.set("NamePlural", thing.getString("Name"));
        thing.set("LevelMin", 7);
        thing.set("Nutrition", 230);
        thing.set("Image", 237);
        thing.set("ItemWeight", 500);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "CR", 25, 25));
        Food.addFood(thing);
    }

    private static void initMeat() {
        Thing thing = Lib.extend("base meat", "base food");
        thing.set("IsMeat", 1);
        thing.set("Nutrition", 60);
        thing.set("Frequency", 20);
        thing.set("IsShopFood", 1);
        thing.set("IsVegetarianFood", 0);
        thing.set("Image", 220);
        Food.addFood(thing);
        thing = Lib.extend("meat ration", "base meat");
        thing.set("Image", 220);
        thing.set("Nutrition", 60);
        thing.set("ItemWeight", 1500);
        thing.set("LevelMin", 6);
        Food.addFood(thing);
        thing = Lib.extend("steak", "base meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 100);
        thing.set("ItemWeight", 2000);
        thing.set("LevelMin", 8);
        Food.addFood(thing);
        thing = Lib.extend("tough steak", "base meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 50);
        thing.set("ItemWeight", 2500);
        thing.set("LevelMin", 4);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "TG", 10, 20));
        Food.addFood(thing);
        thing = Lib.extend("escargot steak", "base meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 180);
        thing.set("ItemWeight", 500);
        thing.set("LevelMin", 10);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "SK", 10, 30));
        Food.addFood(thing);
        thing = Lib.extend("piece of rabbit meat", "base meat");
        thing.set("NamePlural", "pieces of rabbit meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 180);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 7);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 10, 30));
        Food.addFood(thing);
        thing = Lib.extend("piece of hare meat", "base meat");
        thing.set("NamePlural", "pieces of hare meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 120);
        thing.set("ItemWeight", 300);
        thing.set("LevelMin", 12);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "AG", 16, 30));
        Food.addFood(thing);
        thing = Lib.extend("prime steak", "base meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 150);
        thing.set("ItemWeight", 1800);
        thing.set("LevelMin", 13);
        thing.set("OnEaten", Scripts.statGain("Target", "ST", 13, 100));
        Food.addFood(thing);
        thing = Lib.extend("peppered steak", "base meat");
        thing.set("Image", 230);
        thing.set("Nutrition", 160);
        thing.set("ItemWeight", 1600);
        thing.set("LevelMin", 19);
        thing.set("OnEaten", Scripts.statGain("Target", "ST,TG", 18, 100));
        Food.addFood(thing);
        thing = Lib.extend("ham", "base meat");
        thing.set("Image", 220);
        thing.set("Nutrition", 80);
        thing.set("ItemWeight", 2600);
        thing.set("LevelMin", 6);
        Food.addFood(thing);
        thing = Lib.extend("sausage", "base meat");
        thing.set("Image", 231);
        thing.set("Nutrition", 120);
        thing.set("ItemWeight", 1200);
        thing.set("LevelMin", 11);
        Food.addFood(thing);
        thing = Lib.extend("giant sausage", "base meat");
        thing.set("Image", 231);
        thing.set("Nutrition", 125);
        thing.set("ItemWeight", 3000);
        thing.set("LevelMin", 13);
        Food.addFood(thing);
        thing = Lib.extend("spicy sausage", "base meat");
        thing.set("Image", 231);
        thing.set("Nutrition", 180);
        thing.set("ItemWeight", 1800);
        thing.set("LevelMin", 16);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "TG", 25, 100));
        Food.addFood(thing);
        thing = Lib.extend("dwarven sausage", "base meat");
        thing.set("Image", 235);
        thing.set("Nutrition", 240);
        thing.set("ItemWeight", 3000);
        thing.set("LevelMin", 22);
        thing.addHandler("OnEaten", Scripts.statGain("Target", "ST", 30, 100));
        Food.addFood(thing);
    }

    private static void initPoultry() {
        Thing thing = Lib.extend("base poultry", "base food");
        thing.set("IsPoultry", 1);
        thing.set("Nutrition", 60);
        thing.set("Frequency", 20);
        thing.set("IsShopFood", 1);
        thing.set("Image", 220);
        Food.addFood(thing);
        thing = Lib.extend("chicken leg", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 40);
        thing.set("ItemWeight", 500);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("chicken wing", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 25);
        thing.set("ItemWeight", 350);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("chicken breast", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 60);
        thing.set("ItemWeight", 700);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("chicken thigh", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 40);
        thing.set("ItemWeight", 500);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("half a chicken", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 90);
        thing.set("ItemWeight", 1400);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("roast chicken", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 150);
        thing.set("ItemWeight", 2200);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("roast duck", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 120);
        thing.set("ItemWeight", 2000);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("roast goose", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 160);
        thing.set("ItemWeight", 2700);
        thing.set("LevelMin", 4);
        Food.addFood(thing);
        thing = Lib.extend("roast turkey", "base poultry");
        thing.set("Image", 220);
        thing.set("Nutrition", 200);
        thing.set("ItemWeight", 3000);
        thing.set("LevelMin", 5);
        Food.addFood(thing);
    }

    private static void initEggs() {
        Thing thing = Lib.extend("egg", "base food");
        thing.set("Image", 491);
        thing.set("LevelMin", 1);
        thing.set("HPS", 1);
        thing.set("Nutrition", 40);
        thing.set("IsShopFood", 1);
        thing.set("ItemWeight", 40);
        Lib.add(thing);
        thing = Lib.extend("snake egg", "egg");
        thing.set("Frequency", 0);
        thing.set("DeathDecoration", "[IsSnake]");
        thing.set("OnAction", Scripts.decay());
        thing.set("DecayRate", 400);
        Lib.add(thing);
        thing = Lib.extend("bad egg", "egg");
        thing.set("UName", "egg");
        thing.set("LevelMin", 6);
        thing.set("OnEaten", Scripts.addEffect("Target", Lib.create("curse")));
        Lib.add(thing);
    }

    private static void initMushrooms() {
        Thing thing = Lib.extend("mushroom", "base food");
        thing.set("IsMushroom", 1);
        thing.set("Image", 233);
        thing.set("Nutrition", 30);
        thing.set("ItemWeight", 700);
        thing.set("LevelMin", 1);
        thing.set("IsBlackIngredient", 1);
        thing.set("IsHerbIngredient", 1);
        thing.set("OnEaten", Scripts.statGain("Target", "ST,CH", 8, 10));
        Food.addFood(thing);
        thing = Lib.extend("blue mushroom", "mushroom");
        thing.set("Image", 234);
        thing.set("Nutrition", 50);
        thing.set("ItemWeight", 800);
        thing.set("LevelMin", 4);
        thing.set("OnEaten", Scripts.statGain("Target", "ST,CH", 12, 30));
        Food.addFood(thing);
        thing = Lib.extend("magic mushroom", "mushroom");
        thing.set("Image", 229);
        thing.set("IsMagicItem", 1);
        thing.set("Nutrition", 50);
        thing.set("ItemWeight", 800);
        thing.set("LevelMin", 16);
        thing.set("OnEaten", Scripts.statGain("Target", "SK,AG", 16, 30));
        Food.addFood(thing);
        thing = Lib.extend("psilocybin mushroom", "mushroom");
        thing.set("Image", 229);
        thing.set("IsMagicItem", 1);
        thing.set("Nutrition", 50);
        thing.set("ItemWeight", 800);
        thing.set("LevelMin", 16);
        thing.set("OnEaten", Scripts.statGain("Target", "IN,WP", 16, 30));
        Food.addFood(thing);
    }

    private static void initPies() {
        Thing thing = Lib.extend("base pie", "base food");
        thing.set("Image", 225);
        thing.set("Nutrition", 88);
        thing.set("ItemWeight", 2000);
        thing.set("IsShopFood", 1);
        Food.addFood(thing);
        thing = Lib.extend("pork pie", "base pie");
        thing.set("Image", 225);
        thing.set("Nutrition", 95);
        thing.set("ItemWeight", 2500);
        thing.set("IsVegetarianFood", 0);
        thing.set("LevelMin", 5);
        Food.addFood(thing);
        thing = Lib.extend("meat pie", "base pie");
        thing.set("Image", 225);
        thing.set("Nutrition", 125);
        thing.set("ItemWeight", 2200);
        thing.set("IsVegetarianFood", 0);
        thing.set("LevelMin", 7);
        Food.addFood(thing);
        thing = Lib.extend("numble pie", "base pie");
        thing.set("Image", 225);
        thing.set("Description", "This pie was made from animal innards");
        thing.set("Nutrition", 55);
        thing.set("ItemWeight", 2100);
        thing.set("LevelMin", 3);
        Food.addFood(thing);
        thing = Lib.extend("apple pie", "base pie");
        thing.set("Image", 225);
        thing.set("Nutrition", 100);
        thing.set("ItemWeight", 2200);
        thing.set("LevelMin", 1);
        Food.addFood(thing);
    }

    private static void initBread() {
        Thing thing = Lib.extend("loaf of bread", "base food");
        thing.set("NamePlural", "loaves of bread");
        thing.set("Image", 222);
        thing.set("Nutrition", 60);
        thing.set("ItemWeight", 3000);
        thing.set("IsShopFood", 1);
        thing.set("IsBread", 1);
        thing.set("LevelMin", 1);
        Food.addFood(thing);
        thing = Lib.extend("loaf of stale bread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of stale bread");
        thing.set("Nutrition", 35);
        thing.set("LevelMin", 1);
        Food.addFood(thing);
        thing = Lib.extend("loaf of hobbit bread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of hobbit bread");
        thing.set("Nutrition", 125);
        thing.set("ItemWeight", 2000);
        thing.set("LevelMin", 17);
        Food.addFood(thing);
        thing = Lib.extend("loaf of dwarf bread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of dwarf bread");
        thing.set("Nutrition", 100);
        thing.set("LevelMin", 12);
        Food.addFood(thing);
        thing = Lib.extend("loaf of elven bread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of elven bread");
        thing.set("Nutrition", 260);
        thing.set("ItemWeight", 1000);
        thing.set("LevelMin", 22);
        Food.addFood(thing);
        thing = Lib.extend("loaf of spider bread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of spider bread");
        thing.set("Nutrition", 220);
        thing.set("ItemWeight", 1000);
        thing.set("LevelMin", 19);
        Food.addFood(thing);
        thing = Lib.extend("loaf of elven waybread", "loaf of bread");
        thing.set("UName", "loaf of bread");
        thing.set("UNamePlural", "loaves of bread");
        thing.set("NamePlural", "loaves of elven waybread");
        thing.set("Nutrition", 360);
        thing.set("ItemWeight", 500);
        thing.set("LevelMin", 27);
        Food.addFood(thing);
    }

    public static void initFruit() {
        Thing thing = Lib.extend("base fruit", "base food");
        thing.set("IsFruit", 1);
        thing.set("Image", 221);
        thing.set("IsActive", 1);
        thing.set("ValueBase", 5);
        thing.set("DecayRate", 5);
        thing.set("IsShopFood", 1);
        thing.multiplyStat("Frequency", 0.3);
        thing.set("DecayMessage", "rots");
        thing.addHandler("OnAction", Scripts.decay());
        thing.set("LevelMin", 1);
        Food.addFood(thing);
        thing = Lib.extend("apple", "base fruit");
        thing.set("Image", 221);
        thing.set("Nutrition", 45);
        thing.set("ItemWeight", 800);
        thing.set("DecayRate", 2);
        thing.set("DecayMessage", "rots away");
        thing.set("LevelMin", 1);
        Food.addFood(thing);
        thing = Lib.extend("cooking apple", "apple");
        thing.set("Image", 221);
        thing.set("ItemWeight", 1300);
        thing.set("Nutrition", 35);
        Food.addFood(thing);
        thing = Lib.extend("red apple", "apple");
        thing.set("Image", 228);
        thing.set("Nutrition", 70);
        Food.addFood(thing);
        thing = Lib.extend("maggoty apple", "apple");
        thing.set("UName", "red apple");
        thing.set("Image", 228);
        thing.set("LevelMin", 3);
        thing.set("LevelMax", 20);
        thing.set("Nutrition", 25);
        thing.addHandler("OnAction", Scripts.generator("fly swarm", 2));
        Food.addFood(thing);
        thing = Lib.extend("juicy apple", "apple");
        thing.set("Image", 228);
        thing.set("Nutrition", 95);
        thing.addHandler("OnAction", Scripts.generator("wasp swarm", 2));
        Food.addFood(thing);
        thing = Lib.extend("crab apple", "apple");
        thing.set("Image", 221);
        thing.set("Nutrition", 20);
        thing.set("ItemWeight", 300);
        thing.set("IsMissile", 1);
        thing.set("MissileType", "bullet");
        Missile.setStats(thing, 60, 0, 16, 0);
        Food.addFood(thing);
        thing = Lib.extend("base citrus fruit", "base fruit");
        thing.set("Image", 520);
        thing.set("Nutrition", 45);
        thing.set("ItemWeight", 800);
        thing.set("DecayRate", 4);
        thing.set("DecayMessage", "rots away");
        thing.set("LevelMin", 11);
        thing.set("OnEaten", Scripts.cure(5));
        Food.addFood(thing);
        thing = Lib.extend("orange", "base citrus fruit");
        thing.set("Image", 520);
        thing.addHandler("OnEaten", Scripts.heal("Target", 1, 100));
        Food.addFood(thing);
        thing = Lib.extend("large orange", "base citrus fruit");
        thing.set("Image", 520);
        thing.set("Nutrition", 70);
        thing.set("ItemWeight", 1300);
        Food.addFood(thing);
        thing = Lib.extend("tangerine", "base citrus fruit");
        thing.set("Image", 520);
        Food.addFood(thing);
        thing = Lib.extend("grapefruit", "base citrus fruit");
        thing.set("Image", 525);
        thing.set("Nutrition", 70);
        thing.set("ItemWeight", 1600);
        Food.addFood(thing);
        thing = Lib.extend("lemon", "base citrus fruit");
        thing.set("Image", 526);
        thing.set("Nutrition", 35);
        thing.set("ItemWeight", 400);
        Food.addFood(thing);
        thing = Lib.extend("lime", "base citrus fruit");
        thing.set("Image", 527);
        thing.set("Nutrition", 25);
        thing.set("ItemWeight", 300);
        Food.addFood(thing);
        thing = Lib.extend("key lime", "lime");
        thing.set("Frequency", 20);
        thing.set("ItemWeight", 300);
        Food.addFood(thing);
        thing = Lib.extend("bunch of grapes", "base fruit");
        thing.set("NamePlural", "bunches of grapes");
        thing.set("Image", 522);
        thing.set("Nutrition", 140);
        thing.set("ItemWeight", 400);
        thing.set("LevelMin", 13);
        Food.addFood(thing);
    }

    public static void initStoneFruit() {
        Thing thing = Lib.extend("base stone fruit", "base fruit");
        thing.set("Image", 521);
        thing.set("Nutrition", 70);
        thing.set("ItemWeight", 800);
        thing.set("DecayRate", 6);
        thing.set("DecayMessage", "rots away");
        thing.set("LevelMin", 5);
        Food.addFood(thing);
        thing = Lib.extend("peach", "base stone fruit");
        thing.set("Image", 520);
        thing.set("LevelMin", 15);
        Food.addFood(thing);
        thing = Lib.extend("apricot", "base stone fruit");
        thing.set("Image", 520);
        thing.set("ItemWeight", 600);
        thing.set("LevelMin", 17);
        Food.addFood(thing);
        thing = Lib.extend("plum", "base stone fruit");
        thing.set("Image", 521);
        thing.set("ItemWeight", 400);
        thing.set("LevelMin", 6);
        Food.addFood(thing);
        thing = Lib.extend("cherry", "base stone fruit");
        thing.set("Image", 521);
        thing.set("Nutrition", 100);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 9);
        Food.addFood(thing);
        thing = Lib.extend("ranier cherry", "base stone fruit");
        thing.set("Image", 521);
        thing.set("Nutrition", 130);
        thing.set("Frequency", 20);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 13);
        Food.addFood(thing);
    }

    public static void initBerries() {
        Thing thing = Lib.extend("base berry", "base fruit");
        thing.set("Image", 523);
        thing.set("Nutrition", 15);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 8);
        Food.addFood(thing);
        thing = Lib.extend("strawberry", "base berry");
        thing.set("Image", 523);
        thing.set("Nutrition", 15);
        thing.set("ItemWeight", 100);
        Food.addFood(thing);
        thing = Lib.extend("raspberry", "base berry");
        thing.set("Image", 523);
        thing.set("Nutrition", 15);
        thing.set("ItemWeight", 100);
        Food.addFood(thing);
        thing = Lib.extend("blueberry", "base berry");
        thing.set("Image", 524);
        thing.set("Nutrition", 15);
        thing.set("ItemWeight", 50);
        Food.addFood(thing);
    }
}

