/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Iterator;
import mikera.tyrant.Game;
import mikera.tyrant.QuestApp;
import mikera.tyrant.Screen;
import mikera.tyrant.Text;
import mikera.tyrant.TextZone;

public class DetailedListScreen
extends Screen {
    private static final long serialVersionUID = 3257003267744478006L;
    String title = "List";
    String[] strings = null;
    String[] details = null;
    static int page = 0;
    Object result;
    private static int pagesize = 12;
    private static int lineheight = 20;
    private static int leftborder = 20;
    private Color selectionColor = Color.yellow;
    private int currentchoice = 0;
    public String bottomString = "ESC = Cancel";

    public void setSelection(Color color) {
        this.selectionColor = color;
    }

    public Object getObject() {
        boolean bl = false;
        while (!bl) {
            int n;
            KeyEvent keyEvent = Game.getInput();
            if (keyEvent == null) continue;
            if (keyEvent.getKeyCode() == 27) {
                return null;
            }
            if (keyEvent.getKeyCode() == 10) {
                return this.strings[this.currentchoice + page * pagesize];
            }
            char c = Character.toLowerCase(keyEvent.getKeyChar());
            if (c == '8' || keyEvent.getKeyCode() == 38) {
                if (this.currentchoice > 0) {
                    --this.currentchoice;
                    this.repaint();
                }
                return null;
            }
            if (c == '2' || keyEvent.getKeyCode() == 40) {
                ++this.currentchoice;
                if (this.currentchoice + page * pagesize < this.strings.length) {
                    this.repaint();
                } else {
                    --this.currentchoice;
                }
            }
            if ((c == 'p' || c == '-') && page > 0) {
                --page;
                this.repaint();
                this.currentchoice = 0;
            }
            if ((c == 'n' || c == '+' || c == ' ') && (page + 1) * pagesize < this.strings.length) {
                ++page;
                this.repaint();
                this.currentchoice = 0;
            }
            if ((n = c - 97) < 0 || n >= pagesize || (n += page * pagesize) < 0 || n >= this.strings.length) continue;
            return this.strings[n];
        }
        return null;
    }

    public void activate() {
    }

    private static String[] getStringArray(Collection collection) {
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public DetailedListScreen(String string, Collection collection, Collection collection2) {
        this(string, DetailedListScreen.getStringArray(collection), DetailedListScreen.getStringArray(collection2));
    }

    public DetailedListScreen(String string, String[] stringArray, String[] stringArray2) {
        super(Game.getQuestapp());
        this.setLayout(new GridLayout(15, 1));
        this.setFont(QuestApp.mainfont);
        this.addKeyListener(this.questapp.keyadapter);
        this.strings = stringArray;
        this.details = stringArray2;
        if (this.strings == null) {
            this.strings = new String[0];
        }
        this.title = string;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (page * pagesize > this.strings.length) {
            page = 0;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        graphics.drawString(this.title, leftborder, 1 * lineheight);
        for (int i = 0; i < Math.min(this.strings.length - page * pagesize, pagesize); ++i) {
            String string = this.strings[i + page * pagesize];
            String string2 = "[" + (char)(97 + i) + "] " + string;
            graphics.setColor(i == this.currentchoice ? this.selectionColor : QuestApp.INFOTEXTCOLOUR);
            graphics.drawString(string2, 50, lineheight * (i + 2));
        }
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        String[] stringArray = Text.wrapString(this.details[this.currentchoice], TextZone.linelength);
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], leftborder, dimension.height - lineheight * (2 + stringArray.length - i));
        }
        String string = this.bottomString + " ";
        if (page > 0) {
            string = string + " Up = Previous ";
        }
        if ((page + 1) * pagesize < this.strings.length) {
            string = string + " Down = Next ";
        }
        graphics.drawString(string, leftborder, dimension.height - lineheight);
    }
}

