/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Clothing {
    private static Clothing anInstance = new Clothing();
    private static final int WHITE = 1;
    private static final int BLACK = 2;
    private static final int BLUE = 4;
    private static final int GREEN = 8;
    private static final int RED = 16;
    private static final int YELLOW = 32;
    private static final int BROWN = 64;
    private static final int PLAID = 128;
    private static final int PAISLEY = 256;
    private static final int POLKADOT = 512;
    private static final int CHECKERED = 1024;
    private static final int STRIPED = 2048;
    private static final int PURPLE = 4096;
    private static final int ORANGE = 8192;
    private static final int PINK = 16384;
    private static final int CHARCOAL = 32768;
    private static final int TURQUOISE = 65536;
    private static final int TAN = 131072;
    private static final int TEAL = 262144;
    private static final int GRAY = 524288;
    private static final int ALMOND = 0x100000;
    private static final int CREAM = 0x200000;
    private static final int NONE = 0x40000000;
    private static final int NORMAL = 286780;
    private static final int EARTH = 3833923;
    private static final int ROYAL = 69632;
    private static final int PATTERNS = 3968;
    private static final int ALL_COLORS = 0x3FFFFF;
    private static final int FIRE = 1;
    private static final int ICE = 2;
    private static final int WATER = 3;
    private static final int SHOCK = 4;
    private static final int PIERCING = 5;
    private static final int POISON = 6;
    private static final int CHILL = 7;
    private static final int ACID = 8;
    private static final int WEIGHT = 9;
    private static final int IMPACT = 10;
    private static FabricColor[] clothingColors;
    private static final int COTTON = 1;
    private static final int SILK = 2;
    private static final int WOOL = 4;
    private static final int TERRYCLOTH = 8;
    private static final int FLANNEL = 16;
    private static final int CANVAS = 32;
    private static final int SATIN = 64;
    private static final int POLYESTER = 128;
    private static final int DENIM = 256;
    private static final int CORDUROY = 512;
    private static final int CHAMOIS = 1024;
    private static final int FLEECE = 2048;
    private static final int LINEN = 4096;
    private static final int VELVET = 8192;
    private static final int TWILL = 16384;
    private static final int POPLIN = 32768;
    private static final int BROADCLOTH = 65536;
    private static final int VELOUR = 131072;
    private static final int FUR = 262144;
    private static final int FAUX_FUR = 524288;
    private static final int LEATHER = 0x100000;
    private static final int SNAKESKIN = 0x200000;
    private static final int KHAKI = 0x400000;
    private static final int SHARKSKIN = 0x800000;
    private static final int LIZARDSKIN = 0x1000000;
    private static final int DOWN = 0x2000000;
    private static final int SHEEPSKIN = 0x4000000;
    private static final int BASIC = 4101;
    private static final int COMMON = 4195104;
    private static final int SHIRTS = 114816;
    private static final int EXOTIC = 66;
    private static final int COMFY = 3096;
    private static final int ELVIS = 139264;
    private static final int ANIMAL = 96206848;
    private static final int ALL_FABRICS = 0x5FFFFFF;
    private static Fabric[] clothingMaterials;

    public static void init() {
        Thing thing = Lib.extend("base clothing", "base item");
        thing.set("Image", 345);
        thing.set("IsClothing", 1);
        thing.set("IsStoreItem", 0);
        thing.set("WieldType", 9);
        thing.set("HPS", 50);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 200);
        thing.set("ValueBase", 10);
        thing.set("Frequency", 20);
        Lib.add(thing);
        Clothing.initBelts();
        Clothing.initShirts();
        Clothing.initSkirts();
        Clothing.initTrousers();
    }

    private static void initBelts() {
        Thing thing = Lib.extend("base belt", "base clothing");
        thing.set("IsBelt", 1);
        thing.set("WieldType", 15);
        thing.set("LegalFabrics", 96206848);
        thing.set("Image", 358);
        Lib.add(thing);
        thing = Lib.extend("belt", "base belt");
        Clothing.addClothingVariants(thing);
        Clothing.addMagicVariants("IsBelt", 50, Modifier.percent("CarryFactor", 110), "", " of lifting", 5, false);
        Clothing.addMagicVariants("IsBelt", 10, Modifier.percent("CarryFactor", 120), "", " of heavy lifting", 15, false);
        Clothing.addMagicVariants("IsBelt", 20, Modifier.percent("CarryFactor", 60), "", " of lifting ", 5, true);
        Clothing.addMagicVariants("IsBelt", 10, Modifier.bonus("ST", RPG.d(2, 3)), "", " of strength", 8, false);
        Clothing.addMagicVariants("IsBelt", 10, Modifier.bonus("ST", -RPG.d(2, 3)), "", " of strength ", 8, true);
    }

    private static void initTrousers() {
        Thing thing = Lib.extend("base trousers", "base clothing");
        thing.set("IsTrousers", 1);
        thing.set("LegalFabrics", 4199205);
        thing.set("WieldType", 10);
        thing.set("Image", 379);
        Lib.add(thing);
        thing = Lib.extend("trousers", "base trousers");
        Clothing.addClothingVariants(thing);
        Clothing.addMagicVariants("IsTrousers", 10, Modifier.bonus("Seduction", 1), "", " of seduction", 7, false);
        Clothing.addMagicVariants("IsTrousers", 10, Modifier.bonus("Seduction", -1), "", " of seduction ", 7, true);
    }

    private static void initShirts() {
        Thing thing = Lib.extend("base shirt", "base clothing");
        thing.set("IsShirt", 1);
        thing.set("WieldType", 9);
        thing.set("LegalFabrics", 0x5FFFFFF);
        thing.set("Image", 359);
        Lib.add(thing);
        thing = Lib.extend("shirt", "base shirt");
        Clothing.addClothingVariants(thing);
        Clothing.addMagicVariants("IsShirt", 10, Modifier.bonus("Trading", 1), "", " of trading", 8, false);
        Clothing.addMagicVariants("IsShirt", 10, Modifier.bonus("Trading", -1), "", " of trading ", 8, true);
    }

    private static void initSkirts() {
        Thing thing = Lib.extend("base skirt", "base clothing");
        thing.set("IsSkirt", 1);
        thing.set("LegalFabrics", 0x5FFFFFF);
        thing.set("WieldType", 10);
        thing.set("Image", 377);
        thing.multiplyStat("Frequency", 0.25);
        Lib.add(thing);
        thing = Lib.extend("skirt", "base skirt");
        Clothing.addClothingVariants(thing);
        Clothing.addMagicVariants("IsSkirt", 10, Modifier.bonus("Seduction", 1), "", " of seduction", 7, false);
        Clothing.addMagicVariants("IsSkirt", 10, Modifier.bonus("Seduction", -1), "", " of seduction ", 7, true);
    }

    private static void addClothingVariants(Thing thing) {
        Fabric fabric = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < clothingMaterials.length; ++i) {
            if ((Clothing.clothingMaterials[i].mask & thing.getStat("LegalFabrics")) <= 0) continue;
            Thing thing2 = (Thing)thing.clone();
            fabric = clothingMaterials[i];
            for (int j = 0; j < clothingColors.length; ++j) {
                int n;
                if ((fabric.colorMask & Clothing.clothingColors[j].mask) <= 0) continue;
                Thing thing3 = (Thing)thing2.clone();
                string = Clothing.clothingColors[j].name;
                string2 = fabric.name.equals("") ? (string.equals("") ? thing3.name() : string + " " + thing3.name()) : (string.equals("") ? fabric.name + " " + thing3.name() : string + " " + fabric.name + " " + thing3.name());
                if (Clothing.clothingColors[j].charismaBonus != 0) {
                    thing3.add("WieldedModifiers", Modifier.bonus("CH", Clothing.clothingColors[j].charismaBonus));
                    thing3.set("IsMagicItem", 1);
                }
                if (Clothing.clothingColors[j].stealthBonus != 0) {
                    thing3.set("IsMagicItem", 1);
                }
                if ((n = Clothing.clothingColors[j].resistanceBonus) != 0) {
                    if (n == 1) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:fire", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 2) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:ice", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    }
                }
                if ((n = fabric.resistanceBonus) != 0) {
                    if (n == 1) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:fire", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 2) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:ice", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 3) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:water", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 4) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:shock", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 5) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:piercing", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 6) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:poison", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 7) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:chill", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 8) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:acid", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 10) {
                        thing3.add("WieldedModifiers", Modifier.bonus("ARM:impact", RPG.d(2, 3)));
                        thing3.set("IsMagicItem", 1);
                    } else if (n == 9) {
                        thing3.add("WieldedModifiers", Modifier.percent("CarryFactor", 105));
                        thing3.set("IsMagicItem", 1);
                    }
                }
                thing3.set("Name", string2);
                thing3.set("Material", fabric.name);
                thing3.set("Color", string);
                thing3.multiplyStat("Frequency", (double)fabric.frequency / 100.0);
                thing3.multiplyStat("HPS", (double)fabric.sturdiness / 100.0);
                Lib.add(thing3);
            }
        }
    }

    private static void addMagicVariants(String string, int n, Modifier modifier, String string2, String string3, int n2, boolean bl) {
        Thing[] thingArray = Lib.instance().getTypeArray(string, 1).toArray(new Thing[1]);
        Thing thing = null;
        String string4 = null;
        for (int i = 0; i < thingArray.length; ++i) {
            if (RPG.d100() >= n || thingArray[i].getFlag("IsMagicVariant")) continue;
            string4 = thingArray[i].getString("Name");
            thing = (Thing)thingArray[i].clone();
            thing.multiplyStat("Frequency", 0.1);
            thing.add("WieldedModifiers", modifier);
            thing.set("Uname", string4);
            thing.set("Name", string2 + string4 + string3);
            thing.set("IsMagic", 1);
            thing.set("LevelMin", n2);
            thing.set("IsMagicVariant", 1);
            if (bl) {
                thing.set("IsCursed", 1);
            }
            Lib.add(thing);
        }
    }

    public static final void main(String[] stringArray) {
        Clothing.init();
    }

    static {
        FabricColor[] fabricColorArray = new FabricColor[23];
        Clothing clothing = anInstance;
        clothing.getClass();
        fabricColorArray[0] = clothing.new FabricColor("blue", 4, 0, 1, 2);
        Clothing clothing2 = anInstance;
        clothing2.getClass();
        fabricColorArray[1] = clothing2.new FabricColor("white", 1, 0, 0, 0);
        Clothing clothing3 = anInstance;
        clothing3.getClass();
        fabricColorArray[2] = clothing3.new FabricColor("red", 16, 0, -1, 1);
        Clothing clothing4 = anInstance;
        clothing4.getClass();
        fabricColorArray[3] = clothing4.new FabricColor("green", 8, 0, 0, 0);
        Clothing clothing5 = anInstance;
        clothing5.getClass();
        fabricColorArray[4] = clothing5.new FabricColor("yellow", 32, 0, 0, 0);
        Clothing clothing6 = anInstance;
        clothing6.getClass();
        fabricColorArray[5] = clothing6.new FabricColor("black", 2, 0, 1, 0);
        Clothing clothing7 = anInstance;
        clothing7.getClass();
        fabricColorArray[6] = clothing7.new FabricColor("brown", 64, 0, 2, 0);
        Clothing clothing8 = anInstance;
        clothing8.getClass();
        fabricColorArray[7] = clothing8.new FabricColor("plaid", 128, 0, -2, 0);
        Clothing clothing9 = anInstance;
        clothing9.getClass();
        fabricColorArray[8] = clothing9.new FabricColor("paisley", 256, 1, -2, 0);
        Clothing clothing10 = anInstance;
        clothing10.getClass();
        fabricColorArray[9] = clothing10.new FabricColor("polka dot", 512, -1, -3, 0);
        Clothing clothing11 = anInstance;
        clothing11.getClass();
        fabricColorArray[10] = clothing11.new FabricColor("checkered", 1024, 0, -2, 0);
        Clothing clothing12 = anInstance;
        clothing12.getClass();
        fabricColorArray[11] = clothing12.new FabricColor("striped", 2048, 0, -1, 0);
        Clothing clothing13 = anInstance;
        clothing13.getClass();
        fabricColorArray[12] = clothing13.new FabricColor("purple", 4096, 2, 0, 0);
        Clothing clothing14 = anInstance;
        clothing14.getClass();
        fabricColorArray[13] = clothing14.new FabricColor("orange", 8192, 0, 0, 0);
        Clothing clothing15 = anInstance;
        clothing15.getClass();
        fabricColorArray[14] = clothing15.new FabricColor("pink", 16384, 0, 0, 0);
        Clothing clothing16 = anInstance;
        clothing16.getClass();
        fabricColorArray[15] = clothing16.new FabricColor("charcoal", 32768, 0, 3, 0);
        Clothing clothing17 = anInstance;
        clothing17.getClass();
        fabricColorArray[16] = clothing17.new FabricColor("turquoise", 65536, 0, 0, 0);
        Clothing clothing18 = anInstance;
        clothing18.getClass();
        fabricColorArray[17] = clothing18.new FabricColor("tan", 131072, 0, 1, 0);
        Clothing clothing19 = anInstance;
        clothing19.getClass();
        fabricColorArray[18] = clothing19.new FabricColor("teal", 262144, 0, 0, 0);
        Clothing clothing20 = anInstance;
        clothing20.getClass();
        fabricColorArray[19] = clothing20.new FabricColor("gray", 524288, 0, 3, 0);
        Clothing clothing21 = anInstance;
        clothing21.getClass();
        fabricColorArray[20] = clothing21.new FabricColor("almond", 0x100000, 0, 1, 0);
        Clothing clothing22 = anInstance;
        clothing22.getClass();
        fabricColorArray[21] = clothing22.new FabricColor("cream", 0x200000, 0, 1, 0);
        Clothing clothing23 = anInstance;
        clothing23.getClass();
        fabricColorArray[22] = clothing23.new FabricColor("", 0x40000000, 0, 0, 0);
        clothingColors = fabricColorArray;
        Fabric[] fabricArray = new Fabric[28];
        Clothing clothing24 = anInstance;
        clothing24.getClass();
        fabricArray[0] = clothing24.new Fabric("cotton", 1, 25, 6, 0x3FFFFF, 0);
        Clothing clothing25 = anInstance;
        clothing25.getClass();
        fabricArray[1] = clothing25.new Fabric("silk", 2, 5, 5, 0x3FFFFF, 0);
        Clothing clothing26 = anInstance;
        clothing26.getClass();
        fabricArray[2] = clothing26.new Fabric("wool", 4, 5, 7, 0x3FFFFF, 0);
        Clothing clothing27 = anInstance;
        clothing27.getClass();
        fabricArray[3] = clothing27.new Fabric("terrycloth", 8, 5, 7, 4120703, 0);
        Clothing clothing28 = anInstance;
        clothing28.getClass();
        fabricArray[4] = clothing28.new Fabric("flannel", 16, 5, 7, 290748, 0);
        Clothing clothing29 = anInstance;
        clothing29.getClass();
        fabricArray[5] = clothing29.new Fabric("canvas", 32, 5, 10, 3833923, 0);
        Clothing clothing30 = anInstance;
        clothing30.getClass();
        fabricArray[6] = clothing30.new Fabric("satin", 64, 5, 5, 4120703, 0);
        Clothing clothing31 = anInstance;
        clothing31.getClass();
        fabricArray[7] = clothing31.new Fabric("polyester", 128, 5, 6, 0x3FFFFF, 0);
        Clothing clothing32 = anInstance;
        clothing32.getClass();
        fabricArray[8] = clothing32.new Fabric("denim", 256, 20, 10, 3833927, 0);
        Clothing clothing33 = anInstance;
        clothing33.getClass();
        fabricArray[9] = clothing33.new Fabric("corduroy", 512, 5, 9, 286780, 0);
        Clothing clothing34 = anInstance;
        clothing34.getClass();
        fabricArray[10] = clothing34.new Fabric("chamois", 1024, 5, 9, 286780, 3);
        Clothing clothing35 = anInstance;
        clothing35.getClass();
        fabricArray[11] = clothing35.new Fabric("fleece", 2048, 5, 8, 4120703, 0);
        Clothing clothing36 = anInstance;
        clothing36.getClass();
        fabricArray[12] = clothing36.new Fabric("linen", 4096, 5, 7, 3833923, 0);
        Clothing clothing37 = anInstance;
        clothing37.getClass();
        fabricArray[13] = clothing37.new Fabric("velvet", 8192, 5, 7, 356412, 4);
        Clothing clothing38 = anInstance;
        clothing38.getClass();
        fabricArray[14] = clothing38.new Fabric("twill", 16384, 5, 7, 4120703, 0);
        Clothing clothing39 = anInstance;
        clothing39.getClass();
        fabricArray[15] = clothing39.new Fabric("poplin", 32768, 5, 7, 0x3FFFFF, 0);
        Clothing clothing40 = anInstance;
        clothing40.getClass();
        fabricArray[16] = clothing40.new Fabric("broadcloth", 65536, 15, 7, 0x3FFFFF, 0);
        Clothing clothing41 = anInstance;
        clothing41.getClass();
        fabricArray[17] = clothing41.new Fabric("velour", 131072, 5, 6, 356412, 0);
        Clothing clothing42 = anInstance;
        clothing42.getClass();
        fabricArray[18] = clothing42.new Fabric("fur", 262144, 5, 10, 0x40000000, 2);
        Clothing clothing43 = anInstance;
        clothing43.getClass();
        fabricArray[19] = clothing43.new Fabric("faux fur", 524288, 5, 7, 0x40000000, 0);
        Clothing clothing44 = anInstance;
        clothing44.getClass();
        fabricArray[20] = clothing44.new Fabric("leather", 0x100000, 5, 20, 1073741906, 5);
        Clothing clothing45 = anInstance;
        clothing45.getClass();
        fabricArray[21] = clothing45.new Fabric("snakeskin", 0x200000, 5, 20, 0x40000000, 6);
        Clothing clothing46 = anInstance;
        clothing46.getClass();
        fabricArray[22] = clothing46.new Fabric("sharkskin", 0x800000, 5, 25, 0x40000000, 7);
        Clothing clothing47 = anInstance;
        clothing47.getClass();
        fabricArray[23] = clothing47.new Fabric("lizardskin", 0x1000000, 5, 25, 0x40000000, 8);
        Clothing clothing48 = anInstance;
        clothing48.getClass();
        fabricArray[24] = clothing48.new Fabric("khaki", 0x400000, 5, 10, 4120703, 1);
        Clothing clothing49 = anInstance;
        clothing49.getClass();
        fabricArray[25] = clothing49.new Fabric("down", 0x2000000, 5, 6, 4120703, 9);
        Clothing clothing50 = anInstance;
        clothing50.getClass();
        fabricArray[26] = clothing50.new Fabric("sheepskin", 0x4000000, 5, 15, 1077575747, 10);
        Clothing clothing51 = anInstance;
        clothing51.getClass();
        fabricArray[27] = clothing51.new Fabric("", 0x40000000, 5, 10, 0x40000000, 0);
        clothingMaterials = fabricArray;
    }

    private class Fabric {
        String name = null;
        int mask = 0;
        int frequency = 0;
        int sturdiness = 0;
        int colorMask = 0;
        int resistanceBonus = 0;

        public Fabric(String string, int n, int n2, int n3, int n4, int n5) {
            this.name = string;
            this.mask = n;
            this.frequency = n2;
            this.sturdiness = n3;
            this.colorMask = n4;
            this.resistanceBonus = n5;
        }
    }

    private class FabricColor {
        String name = null;
        int mask = 0;
        int charismaBonus = 0;
        int stealthBonus = 0;
        int resistanceBonus = 0;

        public FabricColor(String string, int n, int n2, int n3, int n4) {
            this.name = string;
            this.mask = n;
            this.charismaBonus = n2;
            this.stealthBonus = n3;
            this.resistanceBonus = n4;
        }
    }
}

