/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.Color;
import java.awt.Graphics;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Game;
import mikera.tyrant.MapPanel;
import mikera.tyrant.RPG;

public class Animation
extends BaseObject {
    private static final long serialVersionUID = 1L;
    private static final int TEST = 0;
    private static final int SHOT = 1;
    private static final int EXPLOSION = 2;
    private static final int SPARK = 3;
    private static final int HIT = 4;
    private static final int SEQUENCE = 5;
    private static final int UNION = 6;
    private static final int DELAY = 7;
    private static final int SPRAY = 8;

    public Animation(int n) {
        this.set("Type", n);
        this.set("StartTime", System.currentTimeMillis());
    }

    public static Animation test() {
        return new Animation(0);
    }

    public static Animation spark(int n, int n2, int n3) {
        Animation animation = new Animation(3);
        animation.set("X", n);
        animation.set("Y", n2);
        animation.set("C", n3);
        animation.set("LifeTime", 500);
        return animation;
    }

    public static Animation hit(int n, int n2, int n3) {
        Animation animation = new Animation(4);
        animation.set("X", (double)n + 0.5 * ((double)RPG.random() - 0.5));
        animation.set("Y", (double)n2 + 0.5 * ((double)RPG.random() - 0.5));
        animation.set("C", n3);
        animation.set("LifeTime", 200);
        return animation;
    }

    public static Animation explosion(int n, int n2, int n3, int n4) {
        Animation animation = new Animation(2);
        animation.set("X", n);
        animation.set("Y", n2);
        animation.set("Radius", n4);
        animation.set("C", n3);
        animation.set("LifeTime", 500);
        return animation;
    }

    public static Animation sequence(Animation animation, Animation animation2) {
        Animation animation3 = new Animation(5);
        animation3.set("Animation1", animation);
        animation.set("StartTime", animation3.getDouble("StartTime"));
        animation3.set("Animation2", animation2);
        return animation3;
    }

    public static Animation union(Animation animation, Animation animation2) {
        Animation animation3 = new Animation(6);
        animation3.set("Animation1", animation);
        animation.set("StartTime", animation3.getDouble("StartTime"));
        animation3.set("Animation2", animation2);
        animation2.set("StartTime", animation3.getDouble("StartTime"));
        return animation3;
    }

    public static Animation delay(int n) {
        Animation animation = new Animation(7);
        animation.set("LifeTime", n);
        return animation;
    }

    public static Animation shot(int n, int n2, int n3, int n4, int n5, double d) {
        Animation animation = new Animation(1);
        animation.set("X1", n);
        animation.set("Y1", n2);
        animation.set("X2", n3);
        animation.set("Y2", n4);
        animation.set("C", n5);
        animation.set("LifeTime", RPG.max(1, (int)(1000.0 * RPG.dist(n, n2, n3, n4) / d)));
        return animation;
    }

    public static Animation spray(int n, int n2, int n3, int n4, int n5, double d) {
        Animation animation = new Animation(8);
        animation.set("X1", n);
        animation.set("Y1", n2);
        animation.set("X2", (double)((float)n3 + RPG.random()) - 0.5);
        animation.set("Y2", (double)((float)n4 + RPG.random()) - 0.5);
        animation.set("C", n5);
        animation.set("LifeTime", RPG.max(1, (int)(1000.0 * RPG.dist(n, n2, n3, n4) / d)));
        return animation;
    }

    public void draw(MapPanel mapPanel, Graphics graphics) {
        double d = this.getDouble("StartTime");
        double d2 = System.currentTimeMillis();
        double d3 = d2 - d;
        double d4 = 0.0;
        int n = this.getStat("LifeTime");
        if (n > 0) {
            d4 = d3 / (double)n;
            if (n > 10000) {
                Game.warn("Animation over 10 seconds long expired");
                d4 = 1.0;
            }
            if (d4 >= 1.0) {
                this.set("Expired", true);
                return;
            }
        }
        switch (this.getStat("Type")) {
            case 0: {
                if (this.getStat("Count") > 100) {
                    this.set("Expired", true);
                    break;
                }
                graphics.setColor(Color.BLUE);
                int n2 = this.getStat("N");
                int n3 = 0;
                int n4 = n2 * 5;
                graphics.fillRect(n3, n4, 10, (int)(d3 / 100.0));
                this.set("N", (n2 + 1) % 10);
                this.incStat("Count", 1);
                break;
            }
            case 3: {
                int n5 = this.getStat("X");
                int n6 = this.getStat("Y");
                int n7 = this.getStat("C");
                n7 = n7 / 20 * 20 + (int)(d4 * 6.0);
                mapPanel.drawImage(graphics, n5, n6, n7);
                break;
            }
            case 2: {
                int n8 = this.getStat("X");
                int n9 = this.getStat("Y");
                int n10 = this.getStat("Radius");
                int n11 = this.getStat("C");
                n11 = n11 / 20 * 20 + (int)(d4 * 6.0);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        double d5 = j == 0 || i == 0 ? 1.0 : 1.414;
                        double d6 = (double)n8 + (double)n10 * d4 * (double)j / d5;
                        double d7 = (double)n9 + (double)n10 * d4 * (double)i / d5;
                        mapPanel.drawImage(graphics, d6, d7, n11);
                    }
                }
                break;
            }
            case 1: {
                int n12 = this.getStat("X1");
                int n13 = this.getStat("Y1");
                int n14 = this.getStat("X2");
                int n15 = this.getStat("Y2");
                int n16 = this.getStat("C");
                mapPanel.drawImage(graphics, (double)n12 + d4 * (double)(n14 - n12), (double)n13 + d4 * (double)(n15 - n13), n16);
                break;
            }
            case 4: {
                double d8 = this.getDouble("X");
                double d9 = this.getDouble("Y");
                int n17 = this.getStat("C");
                mapPanel.drawImage(graphics, d8, d9, n17);
                break;
            }
            case 5: {
                Animation animation = (Animation)this.get("Animation1");
                animation.draw(mapPanel, graphics);
                if (!animation.isExpired()) break;
                Animation animation2 = (Animation)this.get("Animation2");
                this.set("Animation1", animation2);
                this.set("Animation2", null);
                if (animation2 == null) {
                    this.set("Expired", true);
                    break;
                }
                animation2.set("StartTime", d2);
                break;
            }
            case 6: {
                Animation animation = (Animation)this.get("Animation1");
                Animation animation3 = (Animation)this.get("Animation2");
                boolean bl = true;
                if (!animation.isExpired()) {
                    animation.draw(mapPanel, graphics);
                    bl = animation.isExpired();
                }
                if (!animation3.isExpired()) {
                    animation3.draw(mapPanel, graphics);
                    bl = animation3.isExpired();
                }
                this.set("Expired", bl);
                break;
            }
            case 8: {
                int n18 = this.getStat("X1");
                int n19 = this.getStat("Y1");
                double d10 = this.getDouble("X2");
                double d11 = this.getDouble("Y2");
                int n20 = this.getStat("C");
                mapPanel.drawImage(graphics, (double)n18 + d4 * (d10 - (double)n18), (double)n19 + d4 * (d11 - (double)n19), n20 / 20 * 20 + (int)(d4 * 6.0));
                break;
            }
        }
    }

    boolean isExpired() {
        return this.getFlag("Expired");
    }
}

