/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Manage.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.lang.InterruptedException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import Enemies;
import Kobo;
import MyShip;
import PlayWin;
import Score;
import Space;


class Manage implements GlobalDefines
{

  static final int TITLE   = 0;
  static final int PLAYING = 1;
  static final int PAUSED  = 2;
  static final int GIGA    = 1000000000;

  static String HighScore;

/******************************** GLOBAL DATA ********************************/

   int state;
   int next_state_out;
   int next_state_next;
   int highscore;
   int last_scene;
   int scene_num;
   int ships;
   int level;
   int count;
   int score;
   int delay_count;
   int rest_cores;
   int return_value;
   boolean go;


/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Manage
 * DESCRIPTION	  :
 *****************************************************************************/
  Manage()
  {
    return_value = 0;
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : gameStart
 * DESCRIPTION	  :
 *****************************************************************************/
  void gameStart()
  {

    ships = 5;
    level = 0;
    score = 0;
    JKobo.Context.getSpace().initScene(scene_num);
    initResourcesToPlay();
    go = false;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : nextScene
 * DESCRIPTION	  :
 *****************************************************************************/
  void nextScene()
  {

    scene_num++;
    if(scene_num >= GIGA - 1)
      scene_num = GIGA - 2;
    JKobo.Context.getSpace().initScene(scene_num);
    JKobo.Context.getPlayWin().toggleInfoUpdate();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : retry
 * DESCRIPTION	  :
 *****************************************************************************/
  void retry()
  {
    boolean cheat_mode;
/*
    int test_scenes[] = { 9, 11, 3, 7, 12 };
    int test_scores[] = { 7000, 6000, 4000, 7000, 8000 };
*/

    cheat_mode = JKobo.Context.getCheatMode();
    if(cheat_mode == false)
      ships--;

    if(ships <= 0)
      {
	if(last_scene < scene_num)
	  last_scene = scene_num;
	if(cheat_mode == false)
	  {
	    if(highscore < score)
	      highscore = score;
	    JKobo.Context.getScore().record(highscore, last_scene);
	  }
	ships = 0;
	initResourcesTitle();
      }
/*
    if(ships >= 0)
      JKobo.Context.getScore().record(test_scores[ships], test_scenes[ships]);
    if(ships <= 0)
	initResourcesTitle();
*/

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : initResourcesToPlay
 * DESCRIPTION	  :
 *****************************************************************************/
  void initResourcesToPlay()
  {
    MyShip myship;
    PlayWin playwin;
    Space space;


    count = delay_count = next_state_out = next_state_next = 0;

    playwin = JKobo.Context.getPlayWin();
    myship = JKobo.Context.getMyShip();
    space = JKobo.Context.getSpace();
    JKobo.Context.getEnemies().init();
    myship.init();
    rest_cores = space.prepare();
    space.generateFixedEnemies();
    playwin.setXOffset(myship.getVirtX());
    playwin.setYOffset(myship.getVirtY());
    playwin.toggleInfoUpdate();
    state = PLAYING;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : initResourcesTitle
 * DESCRIPTION	  :
 *****************************************************************************/
  void initResourcesTitle()
  {

    state = TITLE;
    JKobo.Context.getSpace().initScene(-1);
    JKobo.Context.getPlayWin().updateAll();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init()
  {
    int t[];

    t = new int[2];
    JKobo.Context.getScore().init(t);
    JKobo.Context.getPlayWin().init();
    highscore = t[0];
    last_scene = t[1];
    count = ships = level = delay_count = 0;
    scene_num = last_scene;
    JKobo.Context.getSpace().init();
    initResourcesTitle();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : mainLoop
 * DESCRIPTION	  :
 *****************************************************************************/
  void mainLoop()
  {
    Enemies enemies;
    MyShip myship;


    enemies = JKobo.Context.getEnemies();
    myship = JKobo.Context.getMyShip();

    if(state != PLAYING)
      return;

    count++;
    if(delay_count > 0)
      delay_count--;

    if(delay_count == 1)
      {
	if(enemies.existPipe() != 0)
	  delay_count = 2;
	else
	  {
	    if(next_state_out != 0)
	      {
		retry();
		if(ships <= 0)
		  return;
	      }
	    if(next_state_next != 0)
	      nextScene();
	    initResourcesToPlay();
	    return;
	  }
      }

    myship.move();
    enemies.move();
    myship.hitStructure();

    JKobo.Context.getRadar().traceMyShip();
    JKobo.Context.getPlayWin().updateAll();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setLoopState
 * DESCRIPTION	  :
 *****************************************************************************/
  final synchronized void setLoopState()
  {
    while(go == true)
      {
	try {
	  wait();
	}
	catch(InterruptedException e) {
	}
      }
    go = true;
    notifyAll();
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getLoopState
 * DESCRIPTION	  :
 *****************************************************************************/
  final synchronized boolean getLoopState()
  {
    while(go == false)
      {
	try {
	  wait();
	}
	catch(InterruptedException e) {
	}
      }
    go = false;
    notifyAll();
    return(true);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : isLoopDone
 * DESCRIPTION	  :
 *****************************************************************************/
  final synchronized void isLoopDone()
  {
    while(go == true)
      {
	try {
	  wait();
	}
	catch(InterruptedException e) {
	}
      }
    notifyAll();
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : lostMyShip
 * DESCRIPTION	  :
 *****************************************************************************/
  void lostMyShip()
  {

    if(delay_count == 0)
      delay_count = 20;

    next_state_out = 1;
    JKobo.Context.getPlayWin().toggleInfoUpdate();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : destroyedACore
 * DESCRIPTION	  :
 *****************************************************************************/
  void destroyedACore()
  {

    rest_cores--;
    if(rest_cores == 0)
      {
	next_state_next = 1;
	delay_count = 50;
      }
    JKobo.Context.getSpace().generateFixedEnemies();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : startKey
 * DESCRIPTION	  :
 *****************************************************************************/
  void startKey()
  {

    isLoopDone();
    switch(state)
      {
      case TITLE:
	gameStart();
	break;
      case PAUSED:
	state = PLAYING;
	break;
      case PLAYING:
	state = PAUSED;
	break;
      }
    JKobo.Context.getPlayWin().updateAll();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : exitKey
 * DESCRIPTION	  :
 *****************************************************************************/
  void exitKey()
  {

    isLoopDone();
    if(state == TITLE)
      return_value = 1;
    ships = 0;
    retry();
    if(return_value == 1)
      JKobo.Context.getPlayWin().close();
    else
      JKobo.Context.getPlayWin().updateAll();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : plusKey
 * DESCRIPTION	  :
 *****************************************************************************/
  void plusKey()
  {
    PlayWin playwin;


    isLoopDone();
    if(state == TITLE)
      {
	if((scene_num < last_scene) || (JKobo.Context.getCheatMode() == true))
	  scene_num++;
	playwin = JKobo.Context.getPlayWin();
	playwin.toggleInfoUpdate();
	playwin.updateAll();
      }

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : minusKey
 * DESCRIPTION	  :
 *****************************************************************************/
  void minusKey()
  {
    PlayWin playwin;


    isLoopDone();
    if(state == TITLE)
      {
	scene_num--;
	if(scene_num <= 0)
	  scene_num = 0;
	playwin = JKobo.Context.getPlayWin();
	playwin.toggleInfoUpdate();
	playwin.updateAll();
      }

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : addScore
 * DESCRIPTION	  :
 *****************************************************************************/
  void addScore(int sc)
  {

    score += sc;
    if(score >= GIGA)
      score = GIGA - 1;
    JKobo.Context.getPlayWin().toggleInfoUpdate();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getHighScore
 * DESCRIPTION	  :
 *****************************************************************************/
  String getHighScore()
  {
    Object objs[];

    objs = new Object[1];
    objs[0] = (Object) new Integer(highscore);
    return(MessageFormat.format(HighScore, objs));

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : statePlaying
 * DESCRIPTION	  :
 *****************************************************************************/
  boolean statePlaying()
  {
    return(state == PLAYING ? true : false);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getState
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getState()
  {
    return(state);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScore
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getScore()
  {
    return(score);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSceneNum
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getSceneNum()
  {
    return(scene_num);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getShips
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getShips()
  {
    return(ships);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {
    ResourceBundle bundle;


    bundle = JKobo.Context.getResourceBundle();

    try {
      HighScore = bundle.getString("ManageHighScore.message");
    }
    catch(MissingResourceException e) {
      HighScore = "high score : {0}";
    }

  }

}  /* END OF CLASS : Manage */


/* END OF FILE : Manage.java */

