/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Kobo.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.awt.Color;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

import Enemies;
import EnemySet;
import KoboException;
import LoopThread;
import Manage;
import MyShip;
import PlayWin;
import Radar;
import ScaleParms;
import Scene;
import Score;
import ScoreWin;
import Space;
import TimerThread;
import JUtils;

class Kobo implements GlobalDefines, EnemyDefines, ErrorDefines
{

  static final int TOTAL_SCENES = 51;
  static Scene scenes[];
  static String ExceptionMessage;

/******************************** GLOBAL DATA ********************************/

  int scale_log2;
  boolean cheat_mode;
  long wait_msec;
  String username;
  Random rand_num;
  Enemies enemies;
  MyShip myship;
  Manage manage;
  Radar radar;
  Score score;
  Space space;
  String app_path;
  ScoreWin wscore;
  PlayWin play;
  TimerThread timer;
  LoopThread loop;
  ScaleParms scale_parms;
  ResourceBundle bundle;


/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Kobo
 * DESCRIPTION	  :
 *****************************************************************************/
  Kobo(String lang[]) throws KoboException
  {
    JUtils ju;
    String lng[];
    Locale locale;


    lng = new String[2];
    if(lang[0] == null)
      lng[0] = System.getProperty("user.language");
    else
      lng[0] = lang[0];
    if(lang[1] == null)
      lng[1] = System.getProperty("user.region");
    else
      lng[1] = lang[1];
    if(lang[2] == null)
      locale = new Locale(lng[0], lng[1]);
    else
      locale = new Locale(lng[0], lng[1], lang[2]);
    Locale.setDefault(locale);
    bundle = ResourceBundle.getBundle("_" + JKobo.NAME, locale);

    try {
      ExceptionMessage = bundle.getString("KoboKoboException.message");
    }
    catch(MissingResourceException e) {
      ExceptionMessage = "Cannot locate application directory";
    }

    ju = new JUtils();
    app_path = ju.getAppPath(JKobo.NAME + ".class");
    if(app_path == null)
      {
	throw new KoboException(FATAL, MessageFormat.format(ExceptionMessage,
							    new Object[0]));
      }

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init() throws KoboException
  {
    String t;
    Object objs[];


    username = System.getProperty("user.name");
    scale_parms = new ScaleParms(scale_log2);
    rand_num = new Random();
    manage = new Manage();
    myship = new MyShip();

    /* create graphics dependent objects */
    play = new PlayWin();	    /* create canvas first */
    enemies = new Enemies();
    radar = new Radar();
    space = new Space();
    score = new Score();
    try {
      t = bundle.getString("ScoreWinTitle.message");
    }
    catch(MissingResourceException e) {
      t = "{0} High Scores";
    }
    objs = new Object[1];
    objs[0] = (Object) JKobo.NAME;
    wscore = new ScoreWin(MessageFormat.format(t, objs));
    play.setBackground(Color.gray);

    /* create loop thread */
    loop = new LoopThread(manage);
    loop.start();

    /* create timer thread */
    timer = new TimerThread(manage, wait_msec);
    timer.start();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRandom
 * DESCRIPTION	  :
 *****************************************************************************/
  final Random getRandom()
  {
    return(rand_num);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemies
 * DESCRIPTION	  :
 *****************************************************************************/
  final Enemies getEnemies()
  {
    return(enemies);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getMyShip
 * DESCRIPTION	  :
 *****************************************************************************/
  final MyShip getMyShip()
  {
    return(myship);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScaleLog2
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getScaleLog2()
  {
    return(scale_log2);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setScaleLog2
 * DESCRIPTION	  :
 *****************************************************************************/
  void setScaleLog2(int sl)
  {
    scale_log2 = sl;
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getWaitTime
 * DESCRIPTION	  :
 *****************************************************************************/
  final long getWaitTime()
  {
    return(wait_msec);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setWaitTime
 * DESCRIPTION	  :
 *****************************************************************************/
  void setWaitTime(long t)
  {
    wait_msec = t;
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getCheatMode
 * DESCRIPTION	  :
 *****************************************************************************/
  final boolean getCheatMode()
  {
    return(cheat_mode);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setCheatMode
 * DESCRIPTION	  :
 *****************************************************************************/
  void setCheatMode(boolean m)
  {
    cheat_mode = m;
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getUsername
 * DESCRIPTION	  :
 *****************************************************************************/
  final String getUsername()
  {
    return(username);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getTimerThread
 * DESCRIPTION	  :
 *****************************************************************************/
  final TimerThread getTimerThread()
  {
    return(timer);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getLoopThread
 * DESCRIPTION	  :
 *****************************************************************************/
  final LoopThread getLoopThread()
  {
    return(loop);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScaleParms
 * DESCRIPTION	  :
 *****************************************************************************/
  final ScaleParms getScaleParms()
  {
    return(scale_parms);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getManage
 * DESCRIPTION	  :
 *****************************************************************************/
  final Manage getManage()
  {
    return(manage);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadar
 * DESCRIPTION	  :
 *****************************************************************************/
  final Radar getRadar()
  {
    return(radar);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScore
 * DESCRIPTION	  :
 *****************************************************************************/
  final Score getScore()
  {
    return(score);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScoreWin
 * DESCRIPTION	  :
 *****************************************************************************/
  final ScoreWin getScoreWin()
  {
    return(wscore);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getPlayWin
 * DESCRIPTION	  :
 *****************************************************************************/
  final PlayWin getPlayWin()
  {
    return(play);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getSpace
 * DESCRIPTION	  :
 *****************************************************************************/
  final Space getSpace()
  {
    return(space);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getScenes
 * DESCRIPTION	  :
 *****************************************************************************/
  final Scene[] getScenes()
  {
    return(scenes);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getAppPath
 * DESCRIPTION	  :
 *****************************************************************************/
  final String getAppPath()
  {
    return(app_path);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getResourceBundle
 * DESCRIPTION	  :
 *****************************************************************************/
  final ResourceBundle getResourceBundle()
  {
    return(bundle);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {
    int i = 0;
    Scene sc;


    scenes = new Scene[TOTAL_SCENES];

    /* 1 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY4, 10, 5);
    sc.base_max = 2;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(48, 64, 4, 4);
    sc.base[1] = new Base(24, 80, 4, 4);

    /* 2 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 64;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY4, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY4, 10, 5);
    sc.enemy[2] = new EnemySet(ENEMY1, 10, 5);
    sc.base_max = 4;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 48, 6, 6);
    sc.base[1] = new Base(48, 48, 6, 6);
    sc.base[2] = new Base(16, 64, 6, 6);
    sc.base[3] = new Base(48, 64, 6, 6);

    /* 3 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 64;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = BEAM;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 20, 3);
    sc.base_max = 6;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 40, 4, 4);
    sc.base[1] = new Base(16, 60, 4, 4);
    sc.base[2] = new Base(16, 80, 4, 4);
    sc.base[3] = new Base(48, 40, 4, 4);
    sc.base[4] = new Base(48, 60, 4, 4);
    sc.base[5] = new Base(48, 80, 4, 4);

    /* 4 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 32;
    sc.ek2 = BEAM;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY4, 10, 5);
    sc.base_max = 3;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(14, 55, 6, 6);
    sc.base[1] = new Base(55, 14, 6, 6);
    sc.base[2] = new Base(35, 70, 6, 6);

    /* 5 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 128;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[2] = new EnemySet(ENEMY4, 10, 5);
    sc.base_max = 2;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 32, 6, 6);
    sc.base[1] = new Base(32, 64, 6, 6);

    /* 6 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 40, 10);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 64, 8, 8);

    /* 7 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = RING;
    sc.ek1_interval = 64;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 32;
    sc.enemy_max = 2;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY3, 30, 5);
    sc.enemy[1] = new EnemySet(ENEMY6, 20, 5);
    sc.base_max = 8;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 54, 3, 3);
    sc.base[1] = new Base(42, 54, 3, 3);
    sc.base[2] = new Base(42, 64, 3, 3);
    sc.base[3] = new Base(42, 74, 3, 3);
    sc.base[4] = new Base(32, 74, 3, 3);
    sc.base[5] = new Base(22, 74, 3, 3);
    sc.base[6] = new Base(22, 64, 3, 3);
    sc.base[7] = new Base(22, 54, 3, 3);

    /* 8 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = ENEMY4;
    sc.ek1_interval = 64;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 8;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(RING, 20, 5);
    sc.enemy[1] = new EnemySet(RING, 20, 5);
    sc.enemy[2] = new EnemySet(RING, 20, 5);
    sc.base_max = 8;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(48, 64, 4, 4);
    sc.base[1] = new Base(16, 64, 4, 4);
    sc.base[2] = new Base(32, 80, 4, 4);
    sc.base[3] = new Base(32, 48, 4, 4);
    sc.base[4] = new Base(44, 76, 4, 4);
    sc.base[5] = new Base(20, 76, 4, 4);
    sc.base[6] = new Base(44, 52, 4, 4);
    sc.base[7] = new Base(20, 52, 4, 4);

    /* 9 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 16;
    sc.ek2 = BEAM;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 20, 5);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 32, 7, 7);

    /* 10 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BOMB1;
    sc.ek1_interval = 128;
    sc.ek2 = BOMB1;
    sc.ek2_interval = 4;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 100, 5);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 64, 12, 12);

    /* 11 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = ENEMY2;
    sc.ek1_interval = 128;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 32;
    sc.enemy_max = 5;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 30, 5);
    sc.enemy[1] = new EnemySet(ENEMY3, 50, 5);
    sc.enemy[2] = new EnemySet(ENEMY6, 20, 5);
    sc.enemy[3] = new EnemySet(ENEMY7, 10, 5);
    sc.enemy[4] = new EnemySet(BOMB1, 20, 5);
    sc.base_max = 6;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(5, 64, 3, 3);
    sc.base[1] = new Base(15, 64, 3, 3);
    sc.base[2] = new Base(25, 64, 3, 3);
    sc.base[3] = new Base(35, 64, 3, 3);
    sc.base[4] = new Base(45, 64, 3, 3);
    sc.base[5] = new Base(55, 64, 3, 3);

    /* 12 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 47;
    sc.starty = 33;
    sc.ek1 = BEAM;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[2] = new EnemySet(ROCK, 100, 5);
    sc.base_max = 3;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(15, 88, 12, 12);
    sc.base[1] = new Base(21, 20, 12, 12);
    sc.base[2] = new Base(50, 70, 12, 12);

    /* 13 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = BOMB2;
    sc.ek1_interval = 128;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 32;
    sc.enemy_max = 2;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB1, 30, 5);
    sc.enemy[1] = new EnemySet(BOMB1, 20, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(24, 66, 3, 3);
    sc.base[1] = new Base(23, 80, 3, 3);
    sc.base[2] = new Base(44, 50, 3, 3);
    sc.base[3] = new Base(39, 102, 3, 3);
    sc.base[4] = new Base(15, 43, 3, 3);

    /* 14 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 24;
    sc.starty = 107;
    sc.ek1 = ENEMY2;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 8;
    sc.enemy_max = 4;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY3, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[2] = new EnemySet(ROCK, 100, 5);
    sc.enemy[3] = new EnemySet(ENEMY2, 10, 5);
    sc.base_max = 3;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(9, 36, 5, 5);
    sc.base[1] = new Base(44, 19, 5, 5);
    sc.base[2] = new Base(46, 79, 5, 5);

    /* 15 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 36;
    sc.starty = 94;
    sc.ek1 = ENEMY4;
    sc.ek1_interval = 64;
    sc.ek2 = BOMB1;
    sc.ek2_interval = 32;
    sc.enemy_max = 2;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 10, 5);
    sc.enemy[1] = new EnemySet(ROCK, 50, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 54, 4, 4);
    sc.base[1] = new Base(47, 56, 4, 4);
    sc.base[2] = new Base(24, 70, 4, 4);
    sc.base[3] = new Base(31, 14, 4, 4);
    sc.base[4] = new Base(27, 31, 4, 4);

    /* 16 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 31;
    sc.starty = 37;
    sc.ek1 = ENEMY6;
    sc.ek1_interval = 64;
    sc.ek2 = ENEMY6;
    sc.ek2_interval = 8;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 20, 5);
    sc.enemy[1] = new EnemySet(ENEMY3, 10, 5);
    sc.enemy[2] = new EnemySet(ROCK, 100, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(41, 84, 6, 10);
    sc.base[1] = new Base(12, 115, 6, 5);
    sc.base[2] = new Base(22, 92, 6, 10);
    sc.base[3] = new Base(11, 26, 8, 8);
    sc.base[4] = new Base(51, 65, 9, 7);

    /* 17 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 53;
    sc.starty = 17;
    sc.ek1 = BEAM;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 32;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY3, 10, 5);
    sc.base_max = 10;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(14, 99, 6, 6);
    sc.base[1] = new Base(37, 18, 6, 6);
    sc.base[2] = new Base(13, 67, 6, 6);
    sc.base[3] = new Base(19, 46, 6, 6);
    sc.base[4] = new Base(41, 59, 6, 6);
    sc.base[5] = new Base(39, 97, 6, 6);
    sc.base[6] = new Base(47, 32, 6, 6);
    sc.base[7] = new Base(56, 100, 6, 6);
    sc.base[8] = new Base(19, 25, 6, 6);
    sc.base[9] = new Base(54, 76, 6, 6);

    /* 18 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 80;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 32;
    sc.ek2 = RING;
    sc.ek2_interval = 8;
    sc.enemy_max = 4;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 40, 2);
    sc.enemy[1] = new EnemySet(ENEMY1, 20, 5);
    sc.enemy[2] = new EnemySet(ROCK, 40, 5);
    sc.enemy[3] = new EnemySet(ENEMY1, 20, 5);
    sc.base_max = 3;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(27, 104, 5, 5);
    sc.base[1] = new Base(49, 105, 5, 5);
    sc.base[2] = new Base(32, 90, 5, 5);

    /* 19 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = RING;
    sc.ek1_interval = 128;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 30, 5);
    sc.base_max = 16;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 91, 3, 3);
    sc.base[1] = new Base(42, 89, 3, 3);
    sc.base[2] = new Base(51, 83, 3, 3);
    sc.base[3] = new Base(57, 74, 3, 3);
    sc.base[4] = new Base(59, 64, 3, 3);
    sc.base[5] = new Base(57, 54, 3, 3);
    sc.base[6] = new Base(51, 45, 3, 3);
    sc.base[7] = new Base(42, 39, 3, 3);
    sc.base[8] = new Base(32, 37, 3, 3);
    sc.base[9] = new Base(22, 39, 3, 3);
    sc.base[10] = new Base(13, 45, 3, 3);
    sc.base[11] = new Base(7, 54, 3, 3);
    sc.base[12] = new Base(5, 64, 3, 3);
    sc.base[13] = new Base(7, 74, 3, 3);
    sc.base[14] = new Base(13, 83, 3, 3);
    sc.base[15] = new Base(22, 89, 3, 3);

    /* 20 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 7;
    sc.starty = 84;
    sc.ek1 = ENEMY7;
    sc.ek1_interval = 128;
    sc.ek2 = ENEMY5;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 30, 5);
    sc.base_max = 20;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(37, 82, 6, 6);
    sc.base[1] = new Base(13, 99, 6, 6);
    sc.base[2] = new Base(30, 44, 6, 6);
    sc.base[3] = new Base(19, 14, 6, 6);
    sc.base[4] = new Base(55, 85, 6, 6);
    sc.base[5] = new Base(23, 69, 6, 6);
    sc.base[6] = new Base(16, 35, 6, 6);
    sc.base[7] = new Base(11, 52, 6, 6);
    sc.base[8] = new Base(36, 116, 6, 6);
    sc.base[9] = new Base(39, 97, 6, 6);
    sc.base[10] = new Base(50, 114, 6, 6);
    sc.base[11] = new Base(39, 22, 6, 6);
    sc.base[12] = new Base(55, 43, 6, 6);
    sc.base[13] = new Base(52, 71, 6, 6);
    sc.base[14] = new Base(56, 100, 6, 6);
    sc.base[15] = new Base(54, 25, 6, 6);
    sc.base[16] = new Base(51, 57, 6, 6);
    sc.base[17] = new Base(7, 115, 6, 6);
    sc.base[18] = new Base(47, 8, 6, 6);
    sc.base[19] = new Base(8, 70, 6, 6);

    /* 21 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 26;
    sc.starty = 30;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 2;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY3, 20, 5);
    sc.enemy[1] = new EnemySet(ROCK, 50, 5);
    sc.base_max = 6;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(27, 79, 5, 5);
    sc.base[1] = new Base(6, 105, 5, 5);
    sc.base[2] = new Base(11, 50, 5, 5);
    sc.base[3] = new Base(11, 23, 5, 5);
    sc.base[4] = new Base(56, 57, 5, 5);
    sc.base[5] = new Base(7, 70, 5, 5);

    /* 22 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 38;
    sc.starty = 120;
    sc.ek1 = RING;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 6;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(RING, 10, 5);
    sc.enemy[1] = new EnemySet(RING, 10, 5);
    sc.enemy[2] = new EnemySet(RING, 10, 5);
    sc.enemy[3] = new EnemySet(RING, 10, 5);
    sc.enemy[4] = new EnemySet(RING, 10, 5);
    sc.enemy[5] = new EnemySet(ENEMY_M1, 1, 5);
    sc.base_max = 30;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(55, 25, 4, 4);
    sc.base[1] = new Base(49, 12, 4, 4);
    sc.base[2] = new Base(30, 84, 4, 4);
    sc.base[3] = new Base(33, 97, 4, 4);
    sc.base[4] = new Base(24, 21, 4, 4);
    sc.base[5] = new Base(28, 52, 4, 4);
    sc.base[6] = new Base(50, 117, 4, 4);
    sc.base[7] = new Base(22, 95, 4, 4);
    sc.base[8] = new Base(46, 56, 4, 4);
    sc.base[9] = new Base(36, 10, 4, 4);
    sc.base[10] = new Base(15, 77, 4, 4);
    sc.base[11] = new Base(32, 74, 4, 4);
    sc.base[12] = new Base(7, 15, 4, 4);
    sc.base[13] = new Base(13, 107, 4, 4);
    sc.base[14] = new Base(6, 51, 4, 4);
    sc.base[15] = new Base(11, 62, 4, 4);
    sc.base[16] = new Base(57, 76, 4, 4);
    sc.base[17] = new Base(57, 95, 4, 4);
    sc.base[18] = new Base(11, 90, 4, 4);
    sc.base[19] = new Base(46, 93, 4, 4);
    sc.base[20] = new Base(34, 27, 4, 4);
    sc.base[21] = new Base(58, 56, 4, 4);
    sc.base[22] = new Base(40, 45, 4, 4);
    sc.base[23] = new Base(10, 31, 4, 4);
    sc.base[24] = new Base(44, 35, 4, 4);
    sc.base[25] = new Base(25, 122, 4, 4);
    sc.base[26] = new Base(24, 62, 4, 4);
    sc.base[27] = new Base(51, 107, 4, 4);
    sc.base[28] = new Base(16, 50, 4, 4);
    sc.base[29] = new Base(25, 110, 4, 4);

    /* 23 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 13;
    sc.starty = 92;
    sc.ek1 = BOMB1;
    sc.ek1_interval = 64;
    sc.ek2 = BOMB1;
    sc.ek2_interval = 32;
    sc.enemy_max = 4;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 20, 5);
    sc.enemy[1] = new EnemySet(ENEMY2, 10, 5);
    sc.enemy[2] = new EnemySet(ENEMY7, 10, 5);
    sc.enemy[3] = new EnemySet(ENEMY6, 20, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(40, 95, 15, 15);
    sc.base[1] = new Base(44, 28, 13, 18);
    sc.base[2] = new Base(15, 16, 12, 15);
    sc.base[3] = new Base(14, 50, 13, 12);
    sc.base[4] = new Base(49, 62, 12, 11);

    /* 24 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 127;
    sc.startx = 32;
    sc.starty = 41;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 50, 5);
    sc.enemy[1] = new EnemySet(ENEMY2, 20, 5);
    sc.enemy[2] = new EnemySet(BOMB2, 30, 5);
    sc.base_max = 8;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(38, 73, 4, 4);
    sc.base[1] = new Base(27, 98, 4, 4);
    sc.base[2] = new Base(27, 71, 4, 4);
    sc.base[3] = new Base(56, 89, 4, 4);
    sc.base[4] = new Base(39, 6, 4, 4);
    sc.base[5] = new Base(12, 67, 4, 4);
    sc.base[6] = new Base(58, 14, 4, 4);
    sc.base[7] = new Base(14, 21, 4, 4);

    /* 25 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 256;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 32;
    sc.enemy_max = 2;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 50, 5);
    sc.enemy[1] = new EnemySet(ROCK, 100, 5);
    sc.base_max = 2;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(25, 53, 7, 6);
    sc.base[1] = new Base(40, 70, 5, 4);

    /* 26 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = RING;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 40, 10);
    sc.base_max = 32;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(8, 8, 5, 5);
    sc.base[1] = new Base(24, 8, 5, 5);
    sc.base[2] = new Base(40, 8, 5, 5);
    sc.base[3] = new Base(56, 8, 5, 5);
    sc.base[4] = new Base(8, 24, 5, 5);
    sc.base[5] = new Base(24, 24, 5, 5);
    sc.base[6] = new Base(40, 24, 5, 5);
    sc.base[7] = new Base(56, 24, 5, 5);
    sc.base[8] = new Base(8, 40, 5, 5);
    sc.base[9] = new Base(24, 40, 5, 5);
    sc.base[10] = new Base(40, 40, 5, 5);
    sc.base[11] = new Base(56, 40, 5, 5);
    sc.base[12] = new Base(8, 56, 5, 5);
    sc.base[13] = new Base(24, 56, 5, 5);
    sc.base[14] = new Base(40, 56, 5, 5);
    sc.base[15] = new Base(56, 56, 5, 5);
    sc.base[16] = new Base(8, 72, 5, 5);
    sc.base[17] = new Base(24, 72, 5, 5);
    sc.base[18] = new Base(40, 72, 5, 5);
    sc.base[19] = new Base(56, 72, 5, 5);
    sc.base[20] = new Base(8, 88, 5, 5);
    sc.base[21] = new Base(24, 88, 5, 5);
    sc.base[22] = new Base(40, 88, 5, 5);
    sc.base[23] = new Base(56, 88, 5, 5);
    sc.base[24] = new Base(8, 104, 5, 5);
    sc.base[25] = new Base(24, 104, 5, 5);
    sc.base[26] = new Base(40, 104, 5, 5);
    sc.base[27] = new Base(56, 104, 5, 5);
    sc.base[28] = new Base(8, 120, 5, 5);
    sc.base[29] = new Base(24, 120, 5, 5);
    sc.base[30] = new Base(40, 120, 5, 5);
    sc.base[31] = new Base(56, 120, 5, 5);

    /* 27 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = BEAM;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY5;
    sc.ek2_interval = 32;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 20, 5);
    sc.enemy[1] = new EnemySet(BOMB1, 50, 5);
    sc.enemy[2] = new EnemySet(ENEMY_M2, 1, 5);
    sc.base_max = 4;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(49, 64, 6, 10);
    sc.base[1] = new Base(40, 40, 11, 4);
    sc.base[2] = new Base(36, 95, 13, 4);
    sc.base[3] = new Base(13, 74, 8, 10);

    /* 28 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 4;
    sc.startx = 45;
    sc.starty = 107;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY5;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 50, 5);
    sc.base_max = 4;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(15, 108, 11, 18);
    sc.base[1] = new Base(13, 62, 12, 19);
    sc.base[2] = new Base(46, 42, 11, 41);
    sc.base[3] = new Base(16, 23, 13, 13);

    /* 29 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 60;
    sc.ek1 = ENEMY2;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 4;
    sc.enemy_max = 5;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY5, 20, 5);
    sc.enemy[1] = new EnemySet(BOMB2, 10, 5);
    sc.enemy[2] = new EnemySet(ROCK, 50, 5);
    sc.enemy[3] = new EnemySet(ENEMY_M1, 1, 5);
    sc.enemy[4] = new EnemySet(ENEMY7, 10, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(40, 46, 13, 9);
    sc.base[1] = new Base(20, 74, 12, 8);
    sc.base[2] = new Base(24, 106, 11, 6);
    sc.base[3] = new Base(29, 120, 14, 6);
    sc.base[4] = new Base(54, 90, 5, 8);

    /* 30 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 23;
    sc.starty = 71;
    sc.ek1 = ENEMY5;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 2, 5);
    sc.enemy[1] = new EnemySet(ENEMY6, 2, 5);
    sc.enemy[2] = new EnemySet(ENEMY_M4, 1, 5);
    sc.base_max = 20;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(38, 120, 5, 5);
    sc.base[1] = new Base(43, 64, 5, 5);
    sc.base[2] = new Base(32, 106, 5, 5);
    sc.base[3] = new Base(14, 52, 5, 5);
    sc.base[4] = new Base(48, 76, 5, 5);
    sc.base[5] = new Base(9, 110, 5, 5);
    sc.base[6] = new Base(12, 34, 5, 5);
    sc.base[7] = new Base(40, 90, 5, 5);
    sc.base[8] = new Base(38, 33, 5, 5);
    sc.base[9] = new Base(23, 9, 5, 5);
    sc.base[10] = new Base(22, 120, 5, 5);
    sc.base[11] = new Base(9, 90, 5, 5);
    sc.base[12] = new Base(6, 15, 5, 5);
    sc.base[13] = new Base(41, 46, 5, 5);
    sc.base[14] = new Base(43, 13, 5, 5);
    sc.base[15] = new Base(25, 88, 5, 5);
    sc.base[16] = new Base(8, 65, 5, 5);
    sc.base[17] = new Base(57, 49, 5, 5);
    sc.base[18] = new Base(52, 108, 5, 5);
    sc.base[19] = new Base(6, 77, 5, 5);

    /* 31 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 120;
    sc.ek1 = RING;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 10, 5);
    sc.base_max = 16;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(24, 8, 6, 6);
    sc.base[1] = new Base(24, 24, 6, 6);
    sc.base[2] = new Base(24, 40, 6, 6);
    sc.base[3] = new Base(24, 56, 6, 6);
    sc.base[4] = new Base(24, 72, 6, 6);
    sc.base[5] = new Base(24, 88, 6, 6);
    sc.base[6] = new Base(24, 104, 6, 6);
    sc.base[7] = new Base(24, 120, 6, 6);
    sc.base[8] = new Base(40, 8, 6, 6);
    sc.base[9] = new Base(40, 24, 6, 6);
    sc.base[10] = new Base(40, 40, 6, 6);
    sc.base[11] = new Base(40, 56, 6, 6);
    sc.base[12] = new Base(40, 72, 6, 6);
    sc.base[13] = new Base(40, 88, 6, 6);
    sc.base[14] = new Base(40, 104, 6, 6);
    sc.base[15] = new Base(40, 120, 6, 6);

    /* 32 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 128;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 40, 10);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 64, 24, 24);

    /* 33 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 24;
    sc.starty = 113;
    sc.ek1 = ENEMY4;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY4;
    sc.ek2_interval = 16;
    sc.enemy_max = 5;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY5, 30, 5);
    sc.enemy[1] = new EnemySet(BOMB1, 50, 5);
    sc.enemy[2] = new EnemySet(ENEMY_M2, 1, 5);
    sc.enemy[3] = new EnemySet(ENEMY2, 20, 5);
    sc.enemy[4] = new EnemySet(ROCK, 100, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(17, 70, 13, 21);
    sc.base[1] = new Base(46, 32, 10, 10);
    sc.base[2] = new Base(49, 63, 10, 11);
    sc.base[3] = new Base(18, 25, 14, 21);
    sc.base[4] = new Base(45, 109, 10, 17);

    /* 34 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 54;
    sc.starty = 120;
    sc.ek1 = ENEMY6;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 10, 5);
    sc.base_max = 15;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(8, 87, 6, 15);
    sc.base[1] = new Base(26, 72, 9, 12);
    sc.base[2] = new Base(37, 110, 9, 6);
    sc.base[3] = new Base(36, 31, 16, 5);
    sc.base[4] = new Base(32, 11, 17, 9);
    sc.base[5] = new Base(46, 51, 6, 12);
    sc.base[6] = new Base(54, 96, 5, 10);
    sc.base[7] = new Base(12, 39, 5, 11);
    sc.base[8] = new Base(13, 116, 9, 9);
    sc.base[9] = new Base(40, 93, 7, 6);
    sc.base[10] = new Base(7, 64, 6, 6);
    sc.base[11] = new Base(7, 10, 5, 8);
    sc.base[12] = new Base(47, 77, 8, 5);
    sc.base[13] = new Base(28, 46, 5, 6);
    sc.base[14] = new Base(56, 14, 5, 5);

    /* 35 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = ENEMY3;
    sc.ek1_interval = 128;
    sc.ek2 = RING;
    sc.ek2_interval = 32;
    sc.enemy_max = 8;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY_M1, 1, 5);
    sc.enemy[2] = new EnemySet(BOMB2, 10, 5);
    sc.enemy[3] = new EnemySet(ENEMY2, 10, 5);
    sc.enemy[4] = new EnemySet(ENEMY_M2, 1, 5);
    sc.enemy[5] = new EnemySet(ENEMY4, 10, 5);
    sc.enemy[6] = new EnemySet(ENEMY5, 10, 5);
    sc.enemy[7] = new EnemySet(ENEMY7, 10, 5);
    sc.base_max = 8;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 48, 7, 7);
    sc.base[1] = new Base(48, 48, 7, 7);
    sc.base[2] = new Base(48, 64, 7, 7);
    sc.base[3] = new Base(48, 80, 7, 7);
    sc.base[4] = new Base(32, 80, 7, 7);
    sc.base[5] = new Base(16, 80, 7, 7);
    sc.base[6] = new Base(16, 64, 7, 7);
    sc.base[7] = new Base(16, 48, 7, 7);

    /* 36 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = BEAM;
    sc.ek1_interval = 16;
    sc.ek2 = ENEMY2;
    sc.ek2_interval = 64;
    sc.enemy_max = 5;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 10, 10);
    sc.enemy[1] = new EnemySet(ENEMY2, 10, 10);
    sc.enemy[2] = new EnemySet(BOMB2, 10, 10);
    sc.enemy[3] = new EnemySet(ENEMY_M1, 1, 10);
    sc.enemy[4] = new EnemySet(ENEMY_M2, 1, 10);
    sc.base_max = 10;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 20, 4, 4);
    sc.base[1] = new Base(16, 40, 4, 4);
    sc.base[2] = new Base(16, 60, 4, 4);
    sc.base[3] = new Base(16, 80, 4, 4);
    sc.base[4] = new Base(16, 100, 4, 4);
    sc.base[5] = new Base(48, 20, 4, 4);
    sc.base[6] = new Base(48, 40, 4, 4);
    sc.base[7] = new Base(48, 60, 4, 4);
    sc.base[8] = new Base(48, 80, 4, 4);
    sc.base[9] = new Base(48, 100, 4, 4);

    /* 37 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 256;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 64;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(RING, 0, 5);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 58, 18, 18);

    /* 38 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 72;
    sc.ek1 = RING;
    sc.ek1_interval = 64;
    sc.ek2 = BOMB1;
    sc.ek2_interval = 4;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 10, 5);
    sc.base_max = 20;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 48, 3, 3);
    sc.base[1] = new Base(24, 48, 3, 3);
    sc.base[2] = new Base(32, 48, 3, 3);
    sc.base[3] = new Base(40, 48, 3, 3);
    sc.base[4] = new Base(48, 48, 3, 3);
    sc.base[5] = new Base(16, 64, 3, 3);
    sc.base[6] = new Base(24, 64, 3, 3);
    sc.base[7] = new Base(32, 64, 3, 3);
    sc.base[8] = new Base(40, 64, 3, 3);
    sc.base[9] = new Base(48, 64, 3, 3);
    sc.base[10] = new Base(16, 80, 3, 3);
    sc.base[11] = new Base(24, 80, 3, 3);
    sc.base[12] = new Base(32, 80, 3, 3);
    sc.base[13] = new Base(40, 80, 3, 3);
    sc.base[14] = new Base(48, 80, 3, 3);
    sc.base[15] = new Base(16, 96, 3, 3);
    sc.base[16] = new Base(24, 96, 3, 3);
    sc.base[17] = new Base(32, 96, 3, 3);
    sc.base[18] = new Base(40, 96, 3, 3);
    sc.base[19] = new Base(48, 96, 3, 3);

    /* 39 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 50;
    sc.ek1 = ENEMY5;
    sc.ek1_interval = 32;
    sc.ek2 = ENEMY2;
    sc.ek2_interval = 16;
    sc.enemy_max = 6;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY_M2, 1, 5);
    sc.enemy[1] = new EnemySet(ROCK, 50, 5);
    sc.enemy[2] = new EnemySet(ROCK, 50, 5);
    sc.enemy[3] = new EnemySet(ROCK, 50, 5);
    sc.enemy[4] = new EnemySet(ENEMY_M1, 1, 5);
    sc.enemy[5] = new EnemySet(ROCK, 50, 5);
    sc.base_max = 9;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(34, 14, 4, 4);
    sc.base[1] = new Base(16, 22, 4, 4);
    sc.base[2] = new Base(6, 35, 4, 4);
    sc.base[3] = new Base(22, 38, 4, 4);
    sc.base[4] = new Base(45, 40, 4, 4);
    sc.base[5] = new Base(6, 52, 4, 4);
    sc.base[6] = new Base(46, 66, 4, 4);
    sc.base[7] = new Base(30, 70, 4, 4);
    sc.base[8] = new Base(15, 90, 4, 4);

    /* 40 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 28;
    sc.starty = 11;
    sc.ek1 = BOMB1;
    sc.ek1_interval = 128;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY6, 10, 5);
    sc.base_max = 35;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(12, 48, 9, 9);
    sc.base[1] = new Base(14, 80, 6, 5);
    sc.base[2] = new Base(42, 14, 7, 3);
    sc.base[3] = new Base(52, 112, 4, 9);
    sc.base[4] = new Base(33, 103, 5, 6);
    sc.base[5] = new Base(17, 12, 4, 3);
    sc.base[6] = new Base(49, 78, 5, 4);
    sc.base[7] = new Base(49, 50, 4, 5);
    sc.base[8] = new Base(19, 32, 5, 5);
    sc.base[9] = new Base(32, 77, 6, 4);
    sc.base[10] = new Base(9, 113, 4, 9);
    sc.base[11] = new Base(36, 38, 7, 6);
    sc.base[12] = new Base(50, 96, 8, 3);
    sc.base[13] = new Base(57, 7, 3, 5);
    sc.base[14] = new Base(53, 34, 5, 7);
    sc.base[15] = new Base(11, 94, 5, 3);
    sc.base[16] = new Base(27, 63, 3, 6);
    sc.base[17] = new Base(44, 4, 3, 3);
    sc.base[18] = new Base(48, 63, 5, 6);
    sc.base[19] = new Base(37, 51, 6, 3);
    sc.base[20] = new Base(28, 116, 3, 3);
    sc.base[21] = new Base(8, 31, 4, 5);
    sc.base[22] = new Base(4, 18, 3, 3);
    sc.base[23] = new Base(13, 69, 6, 4);
    sc.base[24] = new Base(21, 96, 3, 3);
    sc.base[25] = new Base(36, 114, 3, 3);
    sc.base[26] = new Base(55, 87, 5, 3);
    sc.base[27] = new Base(58, 63, 3, 7);
    sc.base[28] = new Base(35, 87, 4, 4);
    sc.base[29] = new Base(35, 25, 3, 4);
    sc.base[30] = new Base(20, 107, 3, 5);
    sc.base[31] = new Base(13, 4, 3, 3);
    sc.base[32] = new Base(23, 21, 4, 4);
    sc.base[33] = new Base(5, 8, 3, 5);
    sc.base[34] = new Base(47, 22, 7, 3);

    /* 41 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 96;
    sc.ek1 = BEAM;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 40, 10);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 64, 18, 18);

    /* 42 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 54;
    sc.starty = 46;
    sc.ek1 = ENEMY7;
    sc.ek1_interval = 64;
    sc.ek2 = ENEMY5;
    sc.ek2_interval = 32;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY1, 10, 5);
    sc.enemy[2] = new EnemySet(ENEMY6, 10, 5);
    sc.base_max = 20;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(8, 106, 5, 8);
    sc.base[1] = new Base(7, 32, 5, 13);
    sc.base[2] = new Base(39, 83, 9, 7);
    sc.base[3] = new Base(54, 63, 8, 9);
    sc.base[4] = new Base(28, 20, 6, 13);
    sc.base[5] = new Base(16, 61, 14, 10);
    sc.base[6] = new Base(55, 25, 6, 13);
    sc.base[7] = new Base(53, 106, 8, 7);
    sc.base[8] = new Base(38, 115, 5, 7);
    sc.base[9] = new Base(22, 109, 7, 14);
    sc.base[10] = new Base(12, 82, 7, 8);
    sc.base[11] = new Base(39, 51, 5, 5);
    sc.base[12] = new Base(57, 89, 5, 7);
    sc.base[13] = new Base(41, 21, 5, 7);
    sc.base[14] = new Base(10, 10, 9, 6);
    sc.base[15] = new Base(20, 41, 5, 5);
    sc.base[16] = new Base(38, 66, 5, 5);
    sc.base[17] = new Base(54, 121, 7, 5);
    sc.base[18] = new Base(37, 100, 5, 6);
    sc.base[19] = new Base(41, 7, 5, 5);

    /* 43 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 22;
    sc.starty = 107;
    sc.ek1 = ENEMY2;
    sc.ek1_interval = 64;
    sc.ek2 = BOMB1;
    sc.ek2_interval = 8;
    sc.enemy_max = 7;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY4, 20, 5);
    sc.enemy[1] = new EnemySet(BOMB2, 30, 5);
    sc.enemy[2] = new EnemySet(ENEMY2, 20, 5);
    sc.enemy[3] = new EnemySet(ENEMY6, 20, 5);
    sc.enemy[4] = new EnemySet(BOMB2, 30, 5);
    sc.enemy[5] = new EnemySet(ENEMY7, 30, 5);
    sc.enemy[6] = new EnemySet(ENEMY_M3, 1, 5);
    sc.base_max = 5;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(49, 38, 8, 14);
    sc.base[1] = new Base(20, 86, 5, 10);
    sc.base[2] = new Base(19, 28, 14, 16);
    sc.base[3] = new Base(19, 57, 17, 8);
    sc.base[4] = new Base(48, 86, 8, 18);

    /* 44 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 64;
    sc.ek1 = ENEMY2;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 8;
    sc.enemy_max = 4;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 20, 7);
    sc.enemy[1] = new EnemySet(ROCK, 20, 8);
    sc.enemy[2] = new EnemySet(ENEMY_M1, 1, 5);
    sc.enemy[3] = new EnemySet(ROCK, 20, 8);
    sc.base_max = 24;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(46, 64, 3, 3);
    sc.base[1] = new Base(18, 64, 3, 3);
    sc.base[2] = new Base(32, 79, 3, 3);
    sc.base[3] = new Base(32, 48, 3, 3);
    sc.base[4] = new Base(43, 75, 3, 3);
    sc.base[5] = new Base(21, 75, 3, 3);
    sc.base[6] = new Base(43, 53, 3, 3);
    sc.base[7] = new Base(21, 53, 3, 3);
    sc.base[8] = new Base(32, 91, 3, 3);
    sc.base[9] = new Base(42, 89, 3, 3);
    sc.base[10] = new Base(51, 83, 3, 3);
    sc.base[11] = new Base(57, 74, 3, 3);
    sc.base[12] = new Base(59, 64, 3, 3);
    sc.base[13] = new Base(57, 54, 3, 3);
    sc.base[14] = new Base(51, 45, 3, 3);
    sc.base[15] = new Base(42, 39, 3, 3);
    sc.base[16] = new Base(32, 37, 3, 3);
    sc.base[17] = new Base(22, 39, 3, 3);
    sc.base[18] = new Base(13, 45, 3, 3);
    sc.base[19] = new Base(7, 54, 3, 3);
    sc.base[20] = new Base(5, 64, 3, 3);
    sc.base[21] = new Base(7, 74, 3, 3);
    sc.base[22] = new Base(13, 83, 3, 3);
    sc.base[23] = new Base(22, 89, 3, 3);

    /* 45 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 31;
    sc.starty = 87;
    sc.ek1 = BOMB1;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 16;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 20, 5);
    sc.base_max = 10;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(18, 66, 15, 15);
    sc.base[1] = new Base(52, 59, 7, 54);
    sc.base[2] = new Base(31, 101, 8, 7);
    sc.base[3] = new Base(39, 41, 4, 30);
    sc.base[4] = new Base(9, 97, 7, 13);
    sc.base[5] = new Base(21, 44, 11, 5);
    sc.base[6] = new Base(25, 118, 5, 5);
    sc.base[7] = new Base(20, 16, 8, 14);
    sc.base[8] = new Base(42, 122, 10, 4);
    sc.base[9] = new Base(5, 16, 4, 4);

    /* 46 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 59;
    sc.starty = 34;
    sc.ek1 = BEAM;
    sc.ek1_interval = 64;
    sc.ek2 = BEAM;
    sc.ek2_interval = 16;
    sc.enemy_max = 4;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ROCK, 15, 5);
    sc.enemy[1] = new EnemySet(ENEMY_M3, 1, 5);
    sc.enemy[2] = new EnemySet(ROCK, 15, 5);
    sc.enemy[3] = new EnemySet(ENEMY_M1, 1, 5);
    sc.base_max = 35;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(46, 19, 9, 10);
    sc.base[1] = new Base(45, 115, 10, 4);
    sc.base[2] = new Base(14, 60, 5, 8);
    sc.base[3] = new Base(48, 60, 5, 10);
    sc.base[4] = new Base(21, 45, 8, 5);
    sc.base[5] = new Base(11, 83, 5, 13);
    sc.base[6] = new Base(39, 97, 13, 8);
    sc.base[7] = new Base(36, 49, 4, 3);
    sc.base[8] = new Base(18, 8, 5, 4);
    sc.base[9] = new Base(40, 80, 9, 5);
    sc.base[10] = new Base(54, 44, 8, 4);
    sc.base[11] = new Base(13, 27, 9, 3);
    sc.base[12] = new Base(15, 110, 3, 5);
    sc.base[13] = new Base(9, 122, 5, 4);
    sc.base[14] = new Base(28, 63, 6, 6);
    sc.base[15] = new Base(35, 39, 3, 3);
    sc.base[16] = new Base(6, 5, 5, 3);
    sc.base[17] = new Base(6, 113, 4, 3);
    sc.base[18] = new Base(6, 40, 4, 5);
    sc.base[19] = new Base(29, 116, 3, 9);
    sc.base[20] = new Base(29, 9, 4, 4);
    sc.base[21] = new Base(59, 65, 3, 10);
    sc.base[22] = new Base(21, 86, 3, 7);
    sc.base[23] = new Base(4, 60, 3, 6);
    sc.base[24] = new Base(6, 18, 5, 4);
    sc.base[25] = new Base(29, 22, 5, 6);
    sc.base[26] = new Base(52, 4, 10, 3);
    sc.base[27] = new Base(18, 19, 4, 3);
    sc.base[28] = new Base(46, 34, 5, 3);
    sc.base[29] = new Base(57, 91, 3, 4);
    sc.base[30] = new Base(59, 103, 3, 6);
    sc.base[31] = new Base(25, 35, 4, 3);
    sc.base[32] = new Base(19, 122, 3, 4);
    sc.base[33] = new Base(54, 80, 3, 3);
    sc.base[34] = new Base(5, 101, 3, 3);

    /* 47 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 24;
    sc.starty = 31;
    sc.ek1 = ENEMY5;
    sc.ek1_interval = 64;
    sc.ek2 = RING;
    sc.ek2_interval = 32;
    sc.enemy_max = 5;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 10, 5);
    sc.enemy[1] = new EnemySet(ENEMY7, 10, 5);
    sc.enemy[2] = new EnemySet(ENEMY1, 10, 5);
    sc.enemy[3] = new EnemySet(ENEMY7, 10, 5);
    sc.enemy[4] = new EnemySet(BOMB2, 10, 5);
    sc.base_max = 35;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(29, 37, 19, 2);
    sc.base[1] = new Base(24, 109, 3, 11);
    sc.base[2] = new Base(7, 62, 3, 4);
    sc.base[3] = new Base(47, 92, 2, 4);
    sc.base[4] = new Base(50, 112, 7, 12);
    sc.base[5] = new Base(54, 22, 8, 10);
    sc.base[6] = new Base(35, 104, 5, 7);
    sc.base[7] = new Base(32, 69, 9, 5);
    sc.base[8] = new Base(27, 46, 17, 5);
    sc.base[9] = new Base(32, 14, 9, 10);
    sc.base[10] = new Base(12, 28, 8, 4);
    sc.base[11] = new Base(5, 94, 4, 18);
    sc.base[12] = new Base(46, 57, 7, 2);
    sc.base[13] = new Base(46, 83, 11, 3);
    sc.base[14] = new Base(58, 76, 4, 2);
    sc.base[15] = new Base(56, 94, 4, 4);
    sc.base[16] = new Base(59, 63, 2, 3);
    sc.base[17] = new Base(16, 120, 3, 4);
    sc.base[18] = new Base(14, 75, 2, 11);
    sc.base[19] = new Base(17, 18, 2, 2);
    sc.base[20] = new Base(7, 6, 6, 4);
    sc.base[21] = new Base(37, 28, 6, 2);
    sc.base[22] = new Base(6, 47, 2, 3);
    sc.base[23] = new Base(50, 72, 2, 2);
    sc.base[24] = new Base(57, 44, 2, 9);
    sc.base[25] = new Base(18, 8, 2, 6);
    sc.base[26] = new Base(46, 8, 2, 2);
    sc.base[27] = new Base(25, 90, 4, 2);
    sc.base[28] = new Base(4, 37, 3, 3);
    sc.base[29] = new Base(17, 98, 2, 2);
    sc.base[30] = new Base(27, 58, 9, 2);
    sc.base[31] = new Base(27, 81, 5, 3);
    sc.base[32] = new Base(57, 7, 5, 2);
    sc.base[33] = new Base(7, 120, 2, 6);
    sc.base[34] = new Base(36, 92, 3, 3);

    /* 48 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 19;
    sc.starty = 92;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 64;
    sc.ek2 = ENEMY2;
    sc.ek2_interval = 128;
    sc.enemy_max = 3;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 10, 5);
    sc.enemy[1] = new EnemySet(BOMB2, 10, 5);
    sc.enemy[2] = new EnemySet(ROCK, 20, 5);
    sc.base_max = 38;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(16, 54, 3, 3);
    sc.base[1] = new Base(47, 56, 3, 4);
    sc.base[2] = new Base(24, 70, 4, 3);
    sc.base[3] = new Base(31, 14, 3, 3);
    sc.base[4] = new Base(27, 31, 4, 3);
    sc.base[5] = new Base(36, 94, 4, 4);
    sc.base[6] = new Base(21, 19, 3, 4);
    sc.base[7] = new Base(36, 68, 4, 3);
    sc.base[8] = new Base(53, 4, 3, 3);
    sc.base[9] = new Base(36, 80, 4, 4);
    sc.base[10] = new Base(17, 36, 4, 3);
    sc.base[11] = new Base(34, 118, 4, 3);
    sc.base[12] = new Base(40, 13, 3, 4);
    sc.base[13] = new Base(55, 121, 4, 4);
    sc.base[14] = new Base(43, 26, 4, 3);
    sc.base[15] = new Base(12, 71, 4, 4);
    sc.base[16] = new Base(58, 108, 3, 4);
    sc.base[17] = new Base(51, 36, 4, 4);
    sc.base[18] = new Base(23, 94, 3, 3);
    sc.base[19] = new Base(46, 73, 4, 4);
    sc.base[20] = new Base(9, 25, 4, 3);
    sc.base[21] = new Base(27, 48, 3, 3);
    sc.base[22] = new Base(50, 91, 3, 3);
    sc.base[23] = new Base(14, 122, 3, 3);
    sc.base[24] = new Base(17, 113, 3, 4);
    sc.base[25] = new Base(16, 8, 3, 4);
    sc.base[26] = new Base(36, 38, 3, 4);
    sc.base[27] = new Base(25, 103, 4, 3);
    sc.base[28] = new Base(55, 70, 3, 4);
    sc.base[29] = new Base(28, 56, 3, 3);
    sc.base[30] = new Base(23, 85, 3, 3);
    sc.base[31] = new Base(50, 108, 3, 3);
    sc.base[32] = new Base(25, 122, 3, 3);
    sc.base[33] = new Base(14, 82, 4, 4);
    sc.base[34] = new Base(50, 16, 4, 4);
    sc.base[35] = new Base(38, 49, 4, 3);
    sc.base[36] = new Base(4, 6, 3, 3);
    sc.base[37] = new Base(7, 38, 3, 3);

    /* 49 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 38;
    sc.starty = 67;
    sc.ek1 = BEAM;
    sc.ek1_interval = 32;
    sc.ek2 = BEAM;
    sc.ek2_interval = 8;
    sc.enemy_max = 6;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY2, 10, 5);
    sc.enemy[1] = new EnemySet(BOMB1, 50, 5);
    sc.enemy[2] = new EnemySet(ENEMY1, 20, 5);
    sc.enemy[3] = new EnemySet(ENEMY2, 10, 5);
    sc.enemy[4] = new EnemySet(ENEMY_M1, 1, 5);
    sc.enemy[5] = new EnemySet(ENEMY1, 20, 5);
    sc.base_max = 22;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(28, 104, 10, 6);
    sc.base[1] = new Base(43, 28, 12, 7);
    sc.base[2] = new Base(22, 72, 7, 10);
    sc.base[3] = new Base(11, 16, 8, 6);
    sc.base[4] = new Base(50, 102, 8, 4);
    sc.base[5] = new Base(12, 40, 5, 6);
    sc.base[6] = new Base(49, 80, 11, 5);
    sc.base[7] = new Base(6, 95, 4, 13);
    sc.base[8] = new Base(51, 61, 6, 10);
    sc.base[9] = new Base(30, 14, 4, 4);
    sc.base[10] = new Base(17, 118, 6, 6);
    sc.base[11] = new Base(34, 52, 6, 7);
    sc.base[12] = new Base(40, 119, 15, 6);
    sc.base[13] = new Base(31, 91, 15, 4);
    sc.base[14] = new Base(53, 10, 8, 9);
    sc.base[15] = new Base(8, 61, 4, 7);
    sc.base[16] = new Base(7, 28, 5, 4);
    sc.base[17] = new Base(58, 92, 4, 4);
    sc.base[18] = new Base(19, 55, 5, 5);
    sc.base[19] = new Base(25, 29, 4, 5);
    sc.base[20] = new Base(58, 44, 4, 4);
    sc.base[21] = new Base(9, 76, 4, 4);

    /* 50 */
    sc = scenes[i++] = new Scene();
    sc.ratio = 0;
    sc.startx = 32;
    sc.starty = 120;
    sc.ek1 = BEAM;
    sc.ek1_interval = 8;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 8;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(BOMB2, 80, 5);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(32, 60, 30, 45);

    /******************* dummy *************************/
    sc = scenes[i++] = new Scene();
    sc.ratio = -1;
    sc.startx = 0;
    sc.starty = 0;
    sc.ek1 = ENEMY1;
    sc.ek1_interval = 0;
    sc.ek2 = ENEMY1;
    sc.ek2_interval = 0;
    sc.enemy_max = 1;
    sc.enemy = new EnemySet[sc.enemy_max];
    sc.enemy[0] = new EnemySet(ENEMY1, 0, 0);
    sc.base_max = 1;
    sc.base = new Base[sc.base_max];
    sc.base[0] = new Base(0, 0, 0, 0);

  }

}  /* END OF CLASS : Kobo */


/* END OF FILE : Kobo.java */

