/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Enemy6.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;
import Enemy;

class Enemy6 extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Enemy6
 * DESCRIPTION	  :
 *****************************************************************************/
  Enemy6()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    =	2;
    hitsize  =	6 << sl;
    chipposx =	0;
    chipposy =	5;
    chipsize = 16 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.count = JKobo.Context.getRandom().nextInt() & 0x7f;
    e.di = e.shield = 1;
    e.a = 0;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {
    int wsize;


    wsize = JKobo.Context.getScaleParms().getWindowWidth();
    if(e.a == 0)
      {
	if(e.norm > (wsize >> 1))
	  e.moveEnemyTemplate(6, 192);
	else
	  e.a = 1;
      }
    else
      {
	if(e.norm < wsize)
	  e.moveEnemyTemplate2(5, 192);
	else
	  e.a = 0;
      }
    if((--e.count) <= 0)
      {
	e.count = 128;
	if(e.norm > ((wsize >> 1) - (chipsize << 1)))
	  e.shotTemplate(BEAM, 6, 0, 0);
      }

  }

}  /* END OF CLASS : Enemy6 */


/* END OF FILE : Enemy6.java */

