/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Enemy2.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.util.Random;
import Enemy;

class Enemy2 extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Enemy2
 * DESCRIPTION	  :
 *****************************************************************************/
  Enemy2()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    = 10;
    hitsize  =	6 << sl;
    chipposx =	8;
    chipposy =	1;
    chipsize = 16 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.di = e.shield = 1;
    e.count = JKobo.Context.getRandom().nextInt() & 0x3f;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {

    e.moveEnemyTemplate(4, 192);
    if(--e.count <= 0)
      {
	if(e.norm < ((JKobo.Context.getScaleParms().getWindowWidth() +
		      chipsize) >> 1))
	  {
	    e.shotTemplate(BEAM, 5, 0, 0);
	  }
	e.count = 32;
      }

  }

}  /* END OF CLASS : Enemy2 */


/* END OF FILE : Enemy2.java */

