/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcearcade.jinvaders;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.opensourcearcade.jinvaders.Entity;

public final class ToolBox {
    public static final ToolBox SELF = new ToolBox();

    public static boolean createHomeDirectory() {
        boolean bl;
        boolean bl2 = bl = null != System.getSecurityManager();
        if (bl) {
            return false;
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        boolean bl3 = false;
        try {
            String string3 = ToolBox.getPackageName();
            File file = new File(string + string2 + '.' + string3);
            bl3 = file.exists() ? true : file.mkdir();
        }
        catch (Exception exception) {
            System.err.println("Unable to create home directory " + exception.getLocalizedMessage());
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveGame(String string) {
        boolean bl;
        boolean bl2 = bl = null != System.getSecurityManager();
        if (bl) {
            return false;
        }
        String string2 = ToolBox.getFileSeparator();
        String string3 = ToolBox.getPackageName();
        String string4 = ToolBox.getHomeDir() + string2 + '.' + string3 + string2 + string3;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string4);
            try {
                fileWriter.write(string);
            }
            finally {
                fileWriter.close();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGame() {
        boolean bl;
        boolean bl2 = bl = null != System.getSecurityManager();
        if (bl) {
            return null;
        }
        String string = ToolBox.getFileSeparator();
        String string2 = ToolBox.getPackageName();
        String string3 = ToolBox.getHomeDir() + string + '.' + string2 + string + string2;
        String string4 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string3));
            try {
                string4 = bufferedReader.readLine();
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
        return string4;
    }

    public static String getHomeDir() {
        boolean bl;
        boolean bl2 = bl = null != System.getSecurityManager();
        if (bl) {
            return null;
        }
        return System.getProperty("user.home");
    }

    public static String getFileSeparator() {
        boolean bl;
        boolean bl2 = bl = null != System.getSecurityManager();
        if (bl) {
            return null;
        }
        return System.getProperty("file.separator");
    }

    public static BufferedImage loadImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return ToolBox.convertToCompatibleImage(bufferedImage);
    }

    public static void drawImage(Graphics graphics, BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getWidth() / 3;
        int n5 = bufferedImage.getHeight();
        graphics.drawImage(bufferedImage, n, n2, n + n4, n2 + n5, n4 * n3, 0, n4, n5, null);
    }

    public static void drawImageCentered(Graphics graphics, BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getWidth() / 3;
        int n5 = bufferedImage.getHeight();
        graphics.drawImage(bufferedImage, n - n4 / 2, n2 - n5 / 2, n + n4 / 2, n2 + n5 / 2, n4 * n3, 0, n4, n5, null);
    }

    public static BufferedImage convertToCompatibleImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            int n = bufferedImage.getColorModel().getTransparency();
            bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        }
        catch (Exception exception) {
            bufferedImage2 = bufferedImage;
        }
        return bufferedImage2;
    }

    public static Font loadFont(URL uRL) {
        Font font;
        try {
            InputStream inputStream = uRL.openStream();
            font = Font.createFont(0, inputStream).deriveFont(24.0f);
            inputStream.close();
        }
        catch (Exception exception) {
            font = new Font("arial", 0, 12);
            System.err.println("Unable to load font: " + uRL.getPath());
        }
        return font;
    }

    public static boolean checkCollision(Entity entity, Entity entity2) {
        int n = (int)entity.x;
        int n2 = n + entity.w;
        int n3 = (int)entity.y;
        int n4 = n3 + entity.h;
        return (int)entity2.x <= n2 && n <= (int)entity2.x + entity2.w && (int)entity2.y <= n4 && n3 <= (int)entity2.y + entity2.h;
    }

    public static void drawText(Graphics graphics, String string, int n, int n2, Color color) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawString(string, n - n3 / 2, n2 - n4 / 2);
        if (color2 != null) {
            graphics.setColor(color2);
        }
    }

    public static void drawText(Graphics graphics, String string, int n, Color color) {
        ToolBox.drawText(graphics, string, 224, n, color);
    }

    public static String getPackageName() {
        String string = SELF.getClass().getPackage().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

