/* TestBed: This class provides a Frame window in which new GUI components */
/*    may be developed.                                                    */

import java.awt.*;
import extend.awt.*;

public class TestBed extends Frame {

   public TestBed () {

      setTitle ("Java GUI Testbed");
      setBackground (Color.lightGray);
      resize (570, 310);

      nb = new Notebook (Notebook.Top, Notebook.Simple);
      Image image = Toolkit.getDefaultToolkit ().getImage ("printer.gif");

      nb.addPage ("Pg 1", Color.yellow, new StringPanel ("This is page #1"), null);
      nb.addPage ("Pg 1", new StringPanel ("This is page #1-a"), null);
      nb.addPage ("Pg 2", new StringPanel ("This is page #2"), null);
      nb.addPage ("Pg 3", new StringPanel ("This is page #3"), null);
      nb.addPage (image, Color.blue, new StringPanel ("This is page #4"), null);
//    nb.addPage ("Pg 4", Color.blue, new StringPanel ("This is page #4"), null);
      nb.addPage ("Pg 5", new StringPanel ("This is page #5"), null);
      nb.addPage ("Pg 6", new StringPanel ("This is page #6"), null);
      nb.addPage ("Pg 7", new StringPanel ("This is page #7"), null);
      nb.addPage ("Pg 8", Color.red, Color.white, new StringPanel ("This is page #8"), null);

      add ("Center", nb);

      nb.turnToPage (image, 1);
   }

   public boolean handleEvent (Event event) {

      if (event.id == Event.WINDOW_DESTROY) {

         dispose ();
         System.exit (0);

      } else
         return super.handleEvent (event);

      return true;
   }
      
   public boolean action (Event event, Object arg) {

      if (event.target instanceof Notebook) {

         System.out.println ("Page change.  New top page is: " + arg.toString ());

      } else if (arg.equals ("Top")) {

         nb.setOrientation (Notebook.Top);

      } else if (arg.equals ("Left")) {

         nb.setOrientation (Notebook.Left);

      } else if (arg.equals ("Right")) {

         nb.setOrientation (Notebook.Right);

      } else if (arg.equals ("Bottom")) {

         nb.setOrientation (Notebook.Bottom);

      } else if (arg.equals ("Simple")) {

         nb.setStyle (Notebook.Simple);

      } else if (arg.equals ("Spiral")) {

         nb.setStyle (Notebook.Spiral);

      } else if (arg.equals ("Current")) {

         System.out.println ("Current top page is " + nb.pageShowing ());

      } else
         return super.action (event, arg);

      return true;
   }

   public static void main (String [] args) {

      TestBed tb = new TestBed ();

      tb.show ();
   }

   private Notebook nb;
}
