/* Utilities: This class contains several class methods which provide */
/*    common "workhorse" code for various extend.awt controls.  It is */
/*    meant to be instantiated.                                       */

package extend.awt;

import java.awt.*;
import java.awt.image.*;

public class Utilities {

   protected static int lineHeight (FontMetrics fm, Object [] data,
                                    ImageObserver observer) {

      int result = fm.getHeight ();

      if (data != null)
         for (int loop = 0; loop < data.length; loop++)
            if (data [loop] != null)
               if (data [loop] instanceof Image)
                  result = Math.max (result, (((Image) data [loop]).getHeight (observer)) + 4);

      return result;
   }

   protected static int itemWidth (FontMetrics fm, Object item,
                                   ImageObserver observer) {

      int result = 0;

      if (item != null)
         result += ((item instanceof Image) ?
                      ((Image) item).getWidth (observer) :
                      fm.stringWidth (item.toString ()));

      return result;
   }

   protected static Object [] subArray (Object [] source, int start, int end) {

      Object [] result = new Object [end - start];

      for (int loop = start; loop < end; loop++)
         result [loop - start] = source [loop];

      return result;
   }
}
