/* TreeCanvas: This class draws a Tree view.  It is used by the */
/*    DataContainer class.                                      */

package extend.awt;

import java.awt.*;

public class TreeCanvas extends Canvas {

   protected TreeCanvas (DataContainer dc) {

      setBackground (Color.white);

      parent = dc;
   }

   public void paint (Graphics g) {

      FontMetrics fm = getFontMetrics (getFont ());
      int lHeight = fm.getHeight ();
      ContainerItem item = parent.getRoot ();
      int width = 0;
      int lines = 0;
      int which = 0;
      int y = lHeight;
      int buttonHeight = (lHeight * 2) / 3;
      int left = 4;
      int tx = 0;

      parent.clearHotSpotList ();
      parent.drawDataArea (g, 0, size ());

      if (item != null)
         item = item.getFirst ();

      while ((item != null) && (y < size ().height)) {

         if (which >= parent.getFirst ()) {

            width = fm.stringWidth (item.textFor ().replace ('\n', ' ')) + 4;

            drawTreeLines (g, left, y, lHeight, buttonHeight, item);

            if (item.getFirstChild () != null) {

               if (item.isExpanded ())
                  drawMinus (g, left, y, lHeight, buttonHeight);
               else
                  drawPlus (g, left, y, lHeight, buttonHeight);

               parent.addHotSpot (left, y - buttonHeight, buttonHeight, buttonHeight,
                                  item, DataContainer.Tree_Button, this);
            }

            tx = left + lHeight;

            if (item.isSelected ()) {

               g.setColor (new Color (0, 0, 64));
               g.fillRect (tx - 2, y - lHeight + 4, width, lHeight);
               g.setColor (Color.white);
            }

            parent.addHotSpot (tx, y - lHeight, width, lHeight, item,
                               DataContainer.Selectable, this);

            g.drawString (item.textFor ().replace ('\n', ' '), tx, y);
            y += lHeight;
            lines++;
         }

         if (item.isExpanded () && item.getFirstChild () != null) {

            item = item.getFirstChild ();
            left += lHeight;

         } else if (item.getNext () == null) {

            boolean notDone = true;

            while (notDone) {

               item = item.getParent ();
               notDone = (item != null);

               if (notDone) {

                  notDone = (item.getNext () == null);

                  if (!notDone)
                     item = item.getNext ();
               }

               left -= lHeight;
            }

         } else
            item = item.getNext ();

         which++;
      }

      parent.setLines (lines);
   }

   private void drawTreeLines (Graphics g, int x, int y, int lHeight,
                               int bHeight, ContainerItem item) {

      g.setColor (Color.darkGray);

      if (item.getParent () != null) {

         g.drawLine (x + (bHeight / 2), y - (bHeight / 2), x + lHeight - 2,
                     y - (bHeight / 2));
         g.drawLine (x + (bHeight / 2), y -
                     ((item.getNext () == null) ? (bHeight / 2) : 0),
                     x + (bHeight / 2), y - lHeight +
                     ((item.getPrevious () == null) ? 2 : 0));

         item = item.getParent ();

         while (item.getParent () != null) {

            x -= lHeight;

            if (item.getNext () != null)
               g.drawLine (x + (bHeight / 2), y, x + (bHeight / 2), y - lHeight);

            item = item.getParent ();
         }
      }
   }

   private void drawPlus (Graphics g, int x, int y, int lHeight, int bHeight) {

      drawMinus (g, x, y, lHeight, bHeight);

      g.drawLine (x + (bHeight / 2), y - 2, x + (bHeight / 2), y - bHeight + 2);
   }

   private void drawMinus (Graphics g, int x, int y, int lHeight, int bHeight) {

      g.setColor (getBackground ());

      g.fillRect (x, y - bHeight, bHeight, bHeight);

      g.setColor (Color.darkGray);

      g.drawRect (x, y - bHeight, bHeight, bHeight);

      g.setColor (Color.black);

      g.drawLine (x + 2, y - (bHeight / 2), x + bHeight - 2, y - (bHeight / 2));
   }

   DataContainer parent;
}
