/* ManagedContainer: This class extends the extend.awt.DataContainer to */
/*    add item management.  This allows the container to be used like a */
/*    list box.                                                         */

package extend.awt;

public class ManagedContainer extends DataContainer {

   public ManagedContainer (int newView) {

      super (newView);

      if (newView == Tree_View)
         throw new IllegalArgumentException ("Invalid view selection");

      autoRefreshEnabled = true;
   }

   public void setView (int newView) {

      if (newView == Tree_View)
         throw new IllegalArgumentException ("Invalid view selection");

      super.setView (newView);
   }

   public int countItems () {return (root == null) ? 0 : root.itemCount ();}

   public ContainerItem getItem (int which) {

      checkForEmptyList ();

      return (root.getItem (which));
   }

   public void addItem (ContainerItem item) {

      if (root == null)
         root = item;
      else
         item.addToEnd (root);

      if (autoRefreshEnabled)
         refresh ();
   }

   public void addItem (ContainerItem item, int which) {

      if (root == null)
         root = item;
      else if (which < 0 || which >= root.itemCount ())
         item.addToEnd (root);
      else
         item.addBefore (root.getItem (which));

      if (autoRefreshEnabled)
         refresh ();
   }

   public void replaceItem (ContainerItem item, int which) {

      ContainerItem work;

      checkForEmptyList ();

      work = root.getItem (which);

      if (work.itemCount () == 1)

         root = item;

      else {

         if (work.getNext () == null)
            item.addBefore (work);
         else
            item.addAfter (work);

         item.setSelected (work.isSelected ());
         work.remove ();

         if (which == 0)
            root = item;
      }

      if (autoRefreshEnabled)
         refresh ();
   }

   public void clear () {

      root = null;

      if (autoRefreshEnabled)
         refresh ();
   }

   public void delItem (int which) {

      ContainerItem work;

      checkForEmptyList ();

      work = root.getItem (which);

      if (root.itemCount () == 1)
         root = null;
      else {
         
         if (which == 0)
            root = root.getNext ();

         work.remove ();
      }
      
      if (autoRefreshEnabled)
         refresh ();
   }

   public void delItems (int first, int last) {

      ContainerItem work;
      ContainerItem hold;

      checkForEmptyList ();

      work = root.getItem (first);
      hold = root.getItem (last);

      if (first == 0 && last == root.itemCount () - 1)
         root = null;
      else
         for (int loop = first; loop <= last; loop++) {

            hold = work.getNext ();
            work.remove ();
            work = hold;
         }

      if (autoRefreshEnabled)
         refresh ();
   }

   public int getSelectedIndex () {

      ContainerItem [] list = getSelected ();
      int result = -1;

      if (list != null)
         if (list.length == 1)
            result = indexOf (list [0]);

      return result;
   }

   public int [] getSelectedIndexes () {

      ContainerItem [] list = getSelected ();
      int [] newList = null;

      if (list != null) {

         newList = new int [list.length];

         for (int loop = 0; loop < list.length; loop++)
            newList [loop] = indexOf (list [loop]);
      }

      return newList;
   }

   private int indexOf (ContainerItem item) {

      int result = -1;
      ContainerItem work = root.getFirst ();

      for (int loop = 0; work != null; loop++) {

         if (work.equals (item))
            result = loop;

         work = work.getNext ();

      }

      return result;
   }

   public ContainerItem getSelectedItem () {

      ContainerItem [] list = getSelected ();
      ContainerItem result = null;

      if (list != null)
         if (list.length == 1)
            result = list [0];

      return result;
   }

   public ContainerItem [] getSelectedItems () {return getSelected ();}

   public void select (int which) {

      checkForEmptyList ();

      root.getItem (which).setSelected (true);

      if (autoRefreshEnabled)
         refresh ();
   }

   public void deselect (int which) {

      checkForEmptyList ();

      root.getItem (which).setSelected (false);

      if (autoRefreshEnabled)
         refresh ();
   }

   public boolean isSelected (int which) {

      checkForEmptyList ();

      return (root.getItem (which).isSelected ());
   }

   public void setAutoRefresh (boolean newState) {

      autoRefreshEnabled = newState;
   }

   public boolean isAutoRefreshEnabled () {return autoRefreshEnabled;}

   private void checkForEmptyList () {

      if (root == null)
         throw new IllegalArgumentException ("No such item.");
   }

   private boolean autoRefreshEnabled;
}
