/* Calendar: This class provides a visual calendar which allows the user */
/*    to either select a date or simply view a month at a time.          */

package extend.awt;

import java.awt.*;
import extend.util.ADate;

public class Calendar extends Panel {

   public Calendar (int titles) {

      if (titles != No_Names && titles != Short_Names && titles != Long_Names)
         throw new IllegalArgumentException ("Invalid title specification.");

      today = new ADate ();
      current = new ADate ();

      setLayout (new BorderLayout ());

      Panel top = new Panel ();
      top.setLayout (new BorderLayout ());
      top.add ("East", new Button (" >> "));
      top.add ("West", new Button (" << "));

      todayInText = new Label ("", Label.CENTER);

      top.add ("Center", todayInText);

      add ("North", top);

      Panel grid = new Panel ();
      grid.setLayout (new GridLayout ((titles == No_Names) ? 6 : 7, 7));

      if (titles != No_Names)
         for (int loop = 0; loop < 7; loop++)
            switch (titles) {

               case Short_Names:
                  grid.add (new Label (ADate.getWeekdayName (loop).substring (0, 3),
                                       Label.CENTER));
                  break;

               case Long_Names:
                  grid.add (new Label (ADate.getWeekdayName (loop),
                                       Label.CENTER));
                  break;
            }

      buttonSet = new Button [42];

      for (int loop = 0; loop < buttonSet.length; loop++) {
                                              
         buttonSet [loop] = new Button ("");
         grid.add (buttonSet [loop]);
      }

      showButtons ();

      add ("Center", grid);
   }

   public void showButtons () {

      todayInText.setText (current.toString (ADate.Typical));

      ADate work = new ADate (current.getYear (), current.getMonth (), 1);

      int index;

      for (index = 0; index < work.dayOfWeek (); index++)
         buttonSet [index].hide ();

      for (int loop = 0; loop < work.daysInMonth (); loop++) {

         buttonSet [index].setLabel ("" + (loop + 1));
         buttonSet [index].show ();

         work.setDay (loop + 1);

         if (work.equals (today))
            buttonSet [index].requestFocus ();

         index++;
      }

      while (index < buttonSet.length) {

         buttonSet [index].hide ();
         index++;
      }
   }
      
   public boolean action (Event event, Object arg) {

      if (event.arg instanceof ADate) {

         return super.action (event, arg);

      } else if (arg.equals (" >> ")) {

         current.nextMonth ();
         showButtons ();

      } else if (arg.equals (" << ")) {

         current.previousMonth ();
         showButtons ();

      } else {

         current.setDay (Integer.parseInt ((String) arg));
         todayInText.setText (current.toString (ADate.Typical));

         deliverEvent (new Event (this, Event.ACTION_EVENT, current));

         return super.action (event, arg);
      }

      return true;
   }

   public Dimension preferredSize () {

      return minimumSize ();
   }

   public Dimension minimumSize () {

      Dimension d = super.minimumSize ();

      FontMetrics fm = getFontMetrics (getFont ());

      d.width = (fm.stringWidth ("MMM") - 1) * 7;
      d.height = (fm.getHeight () + 9) * 7;

      return (d);
   }

   private ADate current;
   private ADate today;
   private Label todayInText;
   private Button [] buttonSet;
   private int titleStyle;

   public static final int No_Names = 0;
   public static final int Short_Names = 1;
   public static final int Long_Names = 2;
}
