/*************************************************************************
*
*  File Name   : SELECT.C
*
*  Description : This module contains the code for the
*                WM_COMMAND messages posted by the select menu option
*
*  Concepts    : Capture mouse , hide window until button1 pressed
*                analyse window and generate java code
*
*  API's       : WinSetCapture
*
************************************************************************/

/*  Include files, macros, defined constants, and externs               */

#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <malloc.h>
#include "main.h"
#include "xtrn.h"
#include "help.h"
#include "dlg.h"

/*----------------------------------------*/
/*- structure to dump menu Items ---------*/
typedef struct _MENUDUMP {
  struct _MENUDUMP * NextMenu;
  BOOL   fSubmenu;
  BOOL   fLast;
  BOOL   fSeparator;
  USHORT IdParent;
  USHORT IdItem;
  SHORT  TextLength;
  CHAR   ItemText[1];
} MENUDUMP;
MENUDUMP **LastMenu=NULL;
MENUDUMP * NewMenu =NULL;

HWND   hwndFound=0;
SWP    SwpFound;
SHORT   Current=-1;         /* Current number of childs found  */
USHORT  MaxObj =0;          /* Max allocated objects in memory */
PID     pid;                /* Selected window Process id        */
static  char blankTab[]="";
/*----------------------------------------*/
/*- structure to dump list Items ---------*/
typedef struct _LISTDUMP {
  struct _LISTDUMP * NextList;
  SHORT  TextLength;
  CHAR   ItemText[1];
} LISTDUMP;
LISTDUMP **LastList=NULL;
LISTDUMP * NewList =NULL;
/*----------------------------------------*/
/*- structure to hold dumped information -*/
typedef struct _OBJECT {
   HWND   Handle;
   ULONG  Class;
   PSZ    ClassName;
   PSZ    Text;
   int    x;
   int    y;
   int    cx;
   int    cy;
   USHORT Id;
   ULONG  Style;
   MENUDUMP * NextMenu;
   LISTDUMP * NextList;
   FIELDINFO * NextCnrH;
   CHAR   Name[32];
   int    ComboPart;
   int    Group;
   int    nextGroupBox;
   int    ButtonGroup;  /* Radio and Autoradio buttons  or Notebook global */
   int    Page;         /* Notebook page               */
   int    sPage;         /* Notebook start page               */
   int    ePage;         /* Notebook end page               */
   int    OwnerNotebook;
   int    CurrentGroup;
   int    nCheckGroups;
   int    spmin;
   int    spmax;
   BOOL   hasLimits;
   ULONG  View;
   int    pctSplit;
   PSZ    tabText;
} OBJECT;
int     maxPage=0;
int     Combos=0;
OBJECT *Objects=0;
int     CurrentNotebook=0; /* Object 0 is top frame */
int     PageFirst=0;         /* Object 0 is top frame */
#define TEMPFILE "code.tmp"
/*----------------------------------------------*/
/*- Count of window elements                   -*/
/*----------------------------------------------*/
int currentGroupBox=0;
int nButtons=0;
int ngButtons=0;
int nLabels =0;
int nMultiLabels =0;
int nLists  =0;
int nChoices=0;
int nSimples=0;
int nTextFields=0;
int nTextAreas=0;
int nChecks=0;
int nCheckGroups=0;
int nButtonImages=0;
int nTextImages=0;
int nRectangles=0;
int nGroupBoxes=0;
int nNotebooks=0;
int nContainers=0;
int nSpinButtons=0;
/*----------------------------------------------*/
PSZ Title=NULL;
CHAR szJavaName[LENGTH_STRING+1];
CHAR szFileName[LENGTH_STRING+1+5];
/*----------------------------------------*/
/*- declares for shared memory           -*/
typedef union _SHRDATA {
  char      ItemText[CCHMAXPATH];
  MENUITEM  MenuItem;
  WNDPARAMS WndParams;
  RECTL  Inside;
  struct {
     BOOKTEXT TextData;
     CHAR     TabText[CCHMAXPATH];
  } NBText;
  CNRINFO   CnrInfo;
  struct {
     LONG spmin;
     LONG spmax;
  } SpinData;
} SHRDATA;
SHRDATA   *pShrData;
PSZ        ItemText;
MENUITEM  *MenuItem;
WNDPARAMS *WndParams;
BOOKTEXT  *pBookText;
CHAR      *TabText;
LONG      *pspmin;
LONG      *pspmax;
RECTL     *pInside;
CNRINFO   *pCnrInfo;
RECTL     Inside;
HMODULE   hDll;
/*----------------------------------------*/
void    EnumChilds(HWND Parent,int  ComboPart,int Page);
int     _Optlink SortChildsByPos(  );
void    GenerateJava(int Page);
void    DumpWindow(HWND hwndChild,int  ComboPart,int Page);
MENUDUMP * AddMenu(MENUDUMP *inMenu,FILE*OutCode,int level);
BOOL  NextInsert(BOOL Copy,int Page);
void  DclElements(int Page);
void  Constructor(int Page);
void  Paint(int Page);
void  flushConstructors(void);
/*----------------------------------------*/
/*----------------------------------------*/
/*---                                   --*/
VOID Select(MPARAM mp2) {

     if (WinQueryCapture(HWND_DESKTOP)) return;
     WinDlgBox(HWND_DESKTOP,
             hwndMain,
             (PFNWP)JavaInfoDlgProc,
             0,
             IDD_JAVANAMEDDLG,
             (PVOID)NULL);
     if (strlen(szJavaName)==0) {
        strcpy(szJavaName,"outCode");
     }
     sprintf(szFileName,"%s.java",szJavaName);
     WinSetWindowPos(hwndMainFrame,HWND_BOTTOM,0,0,0,0,SWP_ZORDER);
     WinSetCapture(HWND_DESKTOP,hwndMain);
     DosQueryModuleHandle( "PM2JAVAD", (PHMODULE)&hDll);
     WinSetHook(hab, 0, HK_INPUT  , (PFN)InputHookProc, hDll);
     return;
}
VOID EndSelect(MPARAM mp1,MPARAM mp2) {
     POINTL point;
     ULONG  fFrameInfo;
     TID    tid;
     int rc;
     BOOL Warn64K=FALSE;
     FileSize=0;
     WinSetCapture(HWND_DESKTOP,0);
     /* find the clicked window */
     WinQueryPointerPos(HWND_DESKTOP,&point);
     hwndFound=WinWindowFromPoint(HWND_DESKTOP,&point,TRUE);
     /* find the owning frame window */
     fFrameInfo=(ULONG)WinSendMsg(hwndFound,WM_QUERYFRAMEINFO,0,0);
     printf("Frameinfo %X Have title ? %p\n",fFrameInfo,WinWindowFromID(hwndFound,FID_TITLEBAR));
     if ((fFrameInfo&FI_FRAME)&&
          (WinWindowFromID(hwndFound,FID_TITLEBAR)==NULLHANDLE)) {
          fFrameInfo=0;
     }
     while (((fFrameInfo&FI_FRAME)==FALSE)&&(hwndFound!=0)) {
           hwndFound=WinQueryWindow(hwndFound,QW_PARENT);
           fFrameInfo =(ULONG)WinSendMsg(hwndFound,WM_QUERYFRAMEINFO,0,0);
           printf("Frameinfo %X Have title ? %p\n",fFrameInfo,WinWindowFromID(hwndFound,FID_TITLEBAR));
           if ((fFrameInfo&FI_FRAME)&&
               (WinWindowFromID(hwndFound,FID_TITLEBAR)==NULLHANDLE)) {
              fFrameInfo=0;
           }
     }
     if (hwndFound==0) {
        MessageBox(HWND_DESKTOP,
                IDMSG_SELECTWINDOW,
                MB_OK | MB_ERROR,
                TRUE);
        WinSetWindowPos(hwndMainFrame,HWND_TOP,0,0,0,0,SWP_ZORDER);
        return;
     }
     printf("Get Frame data\n");
     WinQueryWindowProcess(hwndFound,&pid,&tid);
     WinQueryWindowPos(hwndFound,&SwpFound);
     /*----------------------------------------------*/
     /*- Allocate Shared memory for communication   -*/
     pShrData=NULL;
     rc=DosAllocSharedMem((PVOID)&pShrData,NULL,sizeof(SHRDATA),fALLOCSHR);
     if (rc==0) {
       rc=DosGiveSharedMem(pShrData,pid,fGIVESHR);
     } /* endif */
     if (rc==0) {
        /*----------------------------------------------*/
        /*- Initialise pointer to shared memory        -*/
        ItemText=(PSZ)pShrData;
        MenuItem=(MENUITEM *)pShrData;
        WndParams=(WNDPARAMS *)pShrData;
        pInside  =(PRECTL)pShrData;
        pCnrInfo=(CNRINFO *)pShrData;
        pBookText=(BOOKTEXT *)&(pShrData->NBText.TextData);
        TabText  =(PSZ)&(pShrData->NBText.TabText);
        pspmin   =(PLONG)&(pShrData->SpinData.spmin);
        pspmax   =(PLONG)&(pShrData->SpinData.spmax);
        /*----------------------------------------------*/
        /*- Dump Data for hwndFound window itself         -*/
        Current=-1;       /* Current number of childs found  */
        Title=NULL;
        Combos=0;
        DumpWindow(hwndFound,0,0);
        if (Current==0) Title=Objects[0].Text;
        /*----------------------------------------------*/
        /*- Dump Data for all childs                   -*/
        EnumChilds(hwndFound,FALSE,0);
        /*----------------------------------------------*/
        /*- If data was found sort it by position      -*/
        if (Current>=0) {
           /*qsort(Objects,Current+1,sizeof(OBJECT),SortChildsByPos);*/
           /*----------------------------------------------*/
           /*- Generate Java code for top window          -*/
           GenerateJava(0);
           if (FileSize>0x0000FFFF) Warn64K=TRUE;
        } /* endif */
        /*----------------------------------------------*/
        /*- Free the allocated shared memory           -*/
        DosFreeMem(pShrData);
     }
     WinSetWindowPos(hwndMainFrame,HWND_TOP,0,0,0,0,SWP_ZORDER);
     if (Warn64K) {
        MessageBox(HWND_DESKTOP,
              IDMSG_SAVEWARNING,
              MB_OK | MB_WARNING,
              FALSE);
     }
     WinReleaseHook(hab , 0, HK_INPUT  , (PFN)InputHookProc, hDll);
}
#define ID_WC_FRAME             0x0001
#define ID_WC_COMBOBOX          0x0002
#define ID_WC_BUTTON            0x0003
#define ID_WC_MENU              0x0004
#define ID_WC_STATIC            0x0005
#define ID_WC_ENTRYFIELD        0x0006
#define ID_WC_LISTBOX           0x0007
#define ID_WC_SCROLLBAR         0x0008
#define ID_WC_TITLEBAR          0x0009
#define ID_WC_MLE               0x000A
#define ID_WC_APPSTAT           0x0010
#define ID_WC_KBDSTAT           0x0011
#define ID_WC_PECIC             0x0012
#define ID_WC_DBE_KKPOPUP       0x0013
#define ID_WC_SPINBUTTON        0x0020
#define ID_WC_CONTAINER         0x0025
#define ID_WC_SLIDER            0x0026
#define ID_WC_VALUESET          0x0027
#define ID_WC_NOTEBOOK          0x0028
/*--------------------------------------------------------------------*/
/*-- Dumps given menu handle & submenu Items   -----------------------*/
void DumpMenu(HWND HwndMenu,int IdParent) {
   SHORT ItemCount,ItemPos,ItemID;
   SHORT TextLength;
   int   i,j;
   /*----------------------------------------------*/
   /*- Get Item count                             -*/
   ItemCount =(SHORT)WinSendMsg(HwndMenu, MM_QUERYITEMCOUNT,0,0);
   for ( ItemPos =0;ItemPos<ItemCount ;ItemPos++ ) {
      /*----------------------------------------------*/
      /*- Get Item ID from its ordinal position      -*/
      ItemID =(SHORT)WinSendMsg(HwndMenu, MM_ITEMIDFROMPOSITION,
                                MPFROM2SHORT(ItemPos,TRUE),0);
      /*---------------------------------------------------*/
      /*- Get Its text (here I limit it to ITEMTEXTSIZE    */
      /*- MM_QUERYITEMTEXTSIZE could be used to get length */
      TextLength =(SHORT)WinSendMsg(HwndMenu, MM_QUERYITEMTEXT,
                                   MPFROM2SHORT(ItemID,(SHORT)CCHMAXPATH),
                                   MPFROMP((ItemText)));
      /*----------------------------------------------*/
      /*- If some text was found (not separator or   -*/
      /*- bitmap) then store it                      -*/
      /*if (TextLength)*/
      NewMenu=(MENUDUMP *)malloc(sizeof(MENUDUMP)+TextLength);
      if (NewMenu) {
         *LastMenu=NewMenu;
         NewMenu->NextMenu=NULL;
         LastMenu=&NewMenu->NextMenu;
         NewMenu->IdParent=IdParent;
         NewMenu->IdItem  =ItemID;
         if (ItemPos<ItemCount-1) {
            NewMenu->fLast= FALSE;
         } else {
            NewMenu->fLast= TRUE;
         }
         NewMenu->fSubmenu= FALSE;
         /*----------------------------------*/
         /* suppress control chars and copy--*/
         for (i=0,j=0;i<TextLength;i++) {
            if ((ItemText[i]>=0x20)&&(ItemText[i]!='~')) {
               NewMenu->ItemText[j]=ItemText[i];
               j++;
            } /* endif */
         } /* endfor */
         NewMenu->ItemText[j]=0x00;
         NewMenu->TextLength= j-1;
      } /* endif */
      /*----------------------------------------------*/
      /*- Lets see if some submenu are present       -*/
      if ((BOOL)WinSendMsg(HwndMenu, MM_QUERYITEM,
                                     MPFROM2SHORT(ItemID, TRUE),
                                     MPFROMP(MenuItem))
         ) {
         if (MenuItem->afStyle&MIS_SEPARATOR) {
            NewMenu->fSeparator=TRUE;
         } else {
            NewMenu->fSeparator=FALSE;
         }
         if (MenuItem->hwndSubMenu) {
            NewMenu->fSubmenu= TRUE;
            /*----------------------------------------------*/
            /*- found submenu so recurse to dump it        -*/
            DumpMenu(MenuItem->hwndSubMenu,ItemID);
         } /* endif */
      }
   } /* endfor */
}
/*--------------------------------------------------------------------*/
/*-- Dumps given listbox handle Items          -----------------------*/
void DumpListBox(HWND HwndList) {
   SHORT ItemCount,ItemPos;
   SHORT TextLength;
   int   i;
   /*----------------------------------------------*/
   /*- Get Item count                             -*/
   ItemCount =(SHORT)WinSendMsg(HwndList, LM_QUERYITEMCOUNT,0,0);
   for ( ItemPos =0;ItemPos<ItemCount ;ItemPos++ ) {
      /*---------------------------------------------------*/
      /*- Get Its text (here I limit it to ITEMTEXTSIZE    */
      /*- MM_QUERYITEMTEXTSIZE could be used to get length */
      TextLength =(SHORT)WinSendMsg(HwndList, LM_QUERYITEMTEXT,
                                   MPFROM2SHORT(ItemPos,(SHORT)CCHMAXPATH),
                                   MPFROMP((ItemText)));
      NewList=(LISTDUMP *)malloc(sizeof(LISTDUMP)+TextLength);
      if (NewList) {
         *LastList=NewList;
         NewList->NextList=NULL;
         LastList=&NewList->NextList;
         NewList->TextLength= TextLength;
         /*----------------------------------*/
         /* suppress control chars and copy--*/
         for (i=0;i<TextLength;i++) {
            if (ItemText[i]>=0x20) {
               NewList->ItemText[i]=ItemText[i];
            } /* endif */
         } /* endfor */
         NewList->ItemText[TextLength]=0x00;
      } /* endif */
   }
}
/*--------------------------------------------------------------------*/
/*-- Dumps given Container headers             -----------------------*/
void DumpCnrH(HWND HwndCnr) {
   SHORT HeaderCount,HeaderPos;
   SHORT TextLength;
   FIELDINFO *pFieldInfo;
   int   i;
   int   xSplit;
   printf("\nContainer %X Last %p columns %d \n",
                    pCnrInfo->flWindowAttr,
                    pCnrInfo->pFieldInfoLast,
                    pCnrInfo->cFields
                    );
   /*----------------------------------------------*/
   /*- Get header count                           -*/
   HeaderCount=pCnrInfo->cFields;
   /*- Get access to fields                       -*/
   ItemText[0]=0x0;
   SetContainer(HwndCnr,pCnrInfo,ItemText);
   GetImage(0,"cnr",0);
   pFieldInfo = GetFieldinfo(HwndCnr);
   Objects[Current].NextCnrH=pFieldInfo;
   printf("Container title %s\n",ItemText);
   Objects[Current].Text= (PSZ)malloc(strlen(ItemText)+1);
   strcpy(Objects[Current].Text,ItemText);
   Objects[Current].View =pCnrInfo->flWindowAttr;

   printf("Vsplit %d\n",pCnrInfo->xVertSplitbar);
   /*----------------------------------------------*/
   if (0<(ULONG)WinSendMsg(Objects[Current].Handle,
                                 CM_QUERYVIEWPORTRECT,
                                  MPFROMP(pInside),
                                  MPFROM2SHORT(CMA_WINDOW,FALSE))  ) {
      xSplit=(pInside->xRight-pInside->xLeft);
      printf("xsplit %d\n",xSplit);
   }
   if (0<(ULONG)WinSendMsg(Objects[Current].Handle,
                                 CM_QUERYVIEWPORTRECT,
                                  MPFROMP(pInside),
                                  MPFROM2SHORT(CMA_WINDOW,TRUE))  ) {
      if ((pInside->xRight-pInside->xLeft)>0) {
          Objects[Current].pctSplit =(xSplit*100)/(xSplit+(pInside->xRight-pInside->xLeft));
      }
   }
   while (pFieldInfo!=NULL) {
         printf("Header title %s,title style %X,field style %X\n",
                                       pFieldInfo->pTitleData,
                                       pFieldInfo->flTitle ,
                                       pFieldInfo->flData
                                       );

         pFieldInfo=pFieldInfo->pNextFieldInfo;
   }


}
char *CleanText(char * Text) {
    int More,Length,l;
    char *NewText;
    Length=0;
    More=0;
    while (Text[Length]!=0x00) {
        if (Text[Length]== '\\') More++;
        else if (Text[Length]== '\n') {
           NewText[l]=' ';
        }
        else if (Text[Length]== '\r') {
           NewText[l]=' ';
        }
        Length++;
    }
    NewText=malloc(Length+More+1);
    l=0;
    Length=0;
    while (Text[Length]!=0x00) {
        if (Text[Length]== '\\') {
           NewText[l]=Text[Length];
           l++;
        }
        NewText[l]=Text[Length];
        Length++;
        l++;
    }
    NewText[l]=0x00;
    free(Text);
    return NewText;


}
/*----------------------------------------------*/
/*- Dump the given handle information          -*/
void DumpWindow(HWND hwndChild,int ComboPart,int Page) {
   static CHAR ClassName[256];
   int         Length;
   POINTL      WinPt,FramePt;
   ULONG       WUlong;
   CLASSINFO   ClassInfo;
   APIRET      rc;
   ATOM        Atom;
   SWP         Swp;
   ULONG       bStyle;
   /*-----------------------------*/
   /*- One more Child          ---*/
   Current++;
   if (Current>=MaxObj) {
      MaxObj+=16;
      Objects=realloc(Objects,MaxObj*sizeof(OBJECT));
   } /* endif */
   /*-----------------------------*/
   /*- Save Child Class & Handle -*/
   Objects[Current].Handle     = hwndChild;
   Length=WinQueryClassName(hwndChild,sizeof(ClassName), ClassName);
   Objects[Current].ClassName    = (PSZ)malloc(Length+1);
   strcpy(Objects[Current].ClassName,ClassName);
   Objects[Current].ClassName[Length]=0x00;
   Objects[Current].ComboPart=ComboPart;
   /*-----------------------------*/
   /*- Save Child Text           -*/
   Length=WinQueryWindowTextLength(hwndChild);
   Objects[Current].Text           = (PSZ)malloc(Length+1);
   WinQueryWindowText(hwndChild,Length+1,Objects[Current].Text);
   Objects[Current].Text[Length]=0x00;
   Objects[Current].Text=CleanText(Objects[Current].Text);
   /*-----------------------------*/
   /*- Save Child Style and else -*/
   Objects[Current].Id=WinQueryWindowUShort(hwndChild,QWS_ID);
   WinQueryClassInfo( WinQueryAnchorBlock(hwndChild),ClassName,&ClassInfo);
   WUlong = WinQueryWindowULong(hwndChild,QWP_PFNWP);
   Objects[Current].Style= WinQueryWindowULong(hwndChild,QWL_STYLE);
   /*----------------------------------------------*/
   /*- See if it is a known Class                 -*/
   printf("i=%d Found Class %s ",Current,ClassName);
   Atom=WinFindAtom(WinQuerySystemAtomTable(),ClassName);
   Objects[Current].NextMenu=NULL;  /* May be not a menu or no Items in Menu */
   Objects[Current].NextList=NULL;  /* May be not a list or no Items in List */
   Objects[Current].NextCnrH=NULL;  /* May be not a container or no titles   */
   Objects[Current].Class   =Atom;  /* May be not a list or no Items in List */
   if ( (Objects[Current].Style&WS_GROUP) ||
        (((Objects[Current].Style&0x7F)==SS_GROUPBOX)&&
         (Atom==ID_WC_STATIC)) ) {
        Objects[PageFirst].CurrentGroup++;
   }
   if (((Objects[Current].Style&0x7F)==SS_GROUPBOX)&&
        (Atom==ID_WC_STATIC))  {
       Objects[currentGroupBox].nextGroupBox=Current;
       currentGroupBox=Current;
   }
   Objects[Current].nextGroupBox=0;
   Objects[Current].ButtonGroup=0;
   Objects[Current].tabText=0;

   switch (Atom) {
      /*----------------------------------------------*/

      case ID_WC_CONTAINER:
         if (0<(ULONG)WinSendMsg(Objects[Current].Handle,
                                 CM_QUERYCNRINFO,
                                 MPFROMP(pCnrInfo),
                                 MPFROMLONG(sizeof(CNRINFO))) ) {
             DumpCnrH(Objects[Current].Handle);
         }
         break;
      case ID_WC_BUTTON:
         bStyle=Objects[Current].Style&BS_PRIMARYSTYLES;
         if (Objects[PageFirst].ButtonGroup!=
             Objects[PageFirst].CurrentGroup) {
             if ((bStyle==BS_RADIOBUTTON) ||
                 (bStyle==BS_AUTORADIOBUTTON)) {

                Objects[PageFirst].ButtonGroup=
                     Objects[PageFirst].CurrentGroup;
                Objects[PageFirst].nCheckGroups++;
             }
         }
         if ((bStyle==BS_RADIOBUTTON) ||
             (bStyle==BS_AUTORADIOBUTTON)) {
            Objects[Current].ButtonGroup=Objects[PageFirst].nCheckGroups;
         }
         break;
      case ID_WC_MENU:
         LastMenu=&Objects[Current].NextMenu;
         printf("Found menu \n");
         if ((Objects[Current].Id==FID_MENU)&&
             (Objects[CurrentNotebook].Handle==WinQueryWindow(Objects[Current].Handle,QW_PARENT))){
             printf("Dump menu\n");
             DumpMenu(hwndChild,0);
         }
         break;
      /*----------------------------------------------*/
      /*- If it is a listbox or combo specific dump  -*/
      case ID_WC_COMBOBOX:
         if (!(Objects[Current].Style&CBS_SIMPLE)) {
            LastList=&Objects[Current].NextList;
            DumpListBox(hwndChild);
         }
         break;
      case ID_WC_LISTBOX:
         LastList=&Objects[Current].NextList;
         DumpListBox(hwndChild);
         break;
      default:
         break;
   } /* endswitch */
   /*-----------------------------*/
   /* Now get the position        */
   /* relative to Frame window    */
   WinPt.x=0; WinPt.y=0;
   WinMapWindowPoints(hwndChild,Objects[CurrentNotebook].Handle,  &WinPt,1);
   WinQueryWindowPos(hwndChild,&Swp);
   /* Get client rect requires shared area */
   if (CurrentNotebook==Current) {
      if (WinQueryWindowRect(Objects[Current].Handle,pInside)) {
         ULONG  fFrameInfo;
         fFrameInfo=(ULONG)WinSendMsg(Objects[Current].Handle,WM_QUERYFRAMEINFO,0,0);
         if (fFrameInfo&FI_FRAME) {
            pInside->xLeft=0;
            pInside->xRight=Swp.cx;
            pInside->yBottom=0;
            pInside->yTop=Swp.cy;
            if (WinCalcFrameRect(Objects[Current].Handle,pInside,TRUE)==FALSE) {
               pInside->xLeft=0;
               pInside->xRight=Swp.cx;
               pInside->yBottom=0;
               pInside->yTop=Swp.cy;
            }
            printf("pInside left %d right %d top %d bottom %d\n",
              pInside->xLeft,
              pInside->xRight,
              pInside->yTop,
              pInside->yBottom);
            Inside.xLeft   =pInside->xLeft  ;
            Inside.xRight  =pInside->xRight ;
            Inside.yBottom =pInside->yBottom;
            Inside.yTop    =pInside->yTop   ;
            Swp.cx=(Inside.xRight-Inside.xLeft);
            Swp.cy=(Inside.yTop-Inside.yBottom);
         } else {
            Inside.xLeft  =0;
            Inside.xRight =Swp.cx;
            Inside.yBottom=0;
            Inside.yTop   =Swp.cy;
         }
      } else {
         Inside.xLeft  =0;
         Inside.xRight =0;
         Inside.yTop   =0;
         Inside.yBottom=0;
         printf("Failed to get rect\n");
      }
   }
   Objects[Current].x=WinPt.x-Inside.xLeft;
   // Objects[Current].y=Objects[CurrentNotebook].cy-Swp.cy-WinPt.y; // Java y is top left
   Objects[Current].y=WinPt.y-Inside.yBottom; // PM layout handles it
   Objects[Current].cx=Swp.cx;
   Objects[Current].cy=Swp.cy;
   Objects[Current].Group=Objects[PageFirst].CurrentGroup;
   printf("Current Note %d Child %p Behind %p bg=%d Style %X group=%d %s \n",
   CurrentNotebook,
   hwndChild,Swp.hwndInsertBehind,
   Objects[Current].ButtonGroup,
   Objects[Current].Style&WS_GROUP,
   Objects[PageFirst].CurrentGroup,
   Objects[Current].Text);
   printf("Id %X Style %X ",Objects[Current].Id,Objects[Current].Style);
   printf("Set  page %d \n",Page);
   Objects[Current].Page=Page;
   Objects[Current].OwnerNotebook=CurrentNotebook;
   Objects[Current].nCheckGroups=Objects[PageFirst].nCheckGroups;
}
void DumpNotebook(HWND Notebook,int ComboPart,int Page) {
   ULONG       Pages,ip;
   LONG PageId;
   PSZ   lastTabText;
   lastTabText=0;
   /* If a Notebook dump its pages now */
   Pages=(ULONG)WinSendMsg(Notebook,BKM_QUERYPAGECOUNT,0,MPFROMSHORT(BKA_END));
   printf("Notebook has %d pages\n",Pages);
   PageId=(LONG)WinSendMsg(Notebook,BKM_QUERYPAGEID,0,MPFROMSHORT(BKA_FIRST));
   for (ip=1;ip<=Pages;ip++) {
       HWND hPage=0;
       printf("Turn to page %d id %d result %X\n",ip,PageId,
            WinSendMsg(Notebook,BKM_TURNTOPAGE,MPFROMLONG(PageId),0L));
       hPage=(HWND)WinSendMsg(Notebook,BKM_QUERYPAGEWINDOWHWND,
                     MPFROMLONG(PageId),0);
       if (hPage) {
            maxPage++;
            printf("Dump page %p \n",hPage);
            DumpWindow(hPage,0,maxPage);
            PageFirst=Current;   /* Object 0 is top frame */

            pBookText->textLen=CCHMAXPATH-1;
            pBookText->pString=TabText;

            if (WinSendMsg(Notebook,BKM_QUERYTABTEXT,
                     MPFROMLONG(PageId),
                     MPFROMP(pBookText))>0) {
               int it,jt;
               Objects[Current].tabText=malloc(pBookText->textLen+1);
               for (it=0,jt=0;it<pBookText->textLen;it++) {
                   if (pBookText->pString[it]!='~') {
                       Objects[Current].tabText[jt]=pBookText->pString[it];
                       jt++;
                   }
               }
               Objects[Current].tabText[jt]=0x00;
               /* strcpy(Objects[Current].tabText,pBookText->pString); */
               lastTabText=Objects[Current].tabText;
            } else {
               if (!lastTabText) {
                  lastTabText=blankTab;
               }
               Objects[Current].tabText=lastTabText;
            }
            EnumChilds(hPage,0,maxPage);
            printf("End Dump page %p \n",hPage);
       } else {
            printf("Bad page %p \n",hPage);
       }
       PageId=(LONG)WinSendMsg(Notebook,BKM_QUERYPAGEID,
                     MPFROMLONG(PageId),
                     MPFROMSHORT(BKA_NEXT));
   }
   PageFirst=0;         /* Object 0 is top frame */
}
/*----------------------------------------------*/
/*- Enumerate Child of given window            -*/
void EnumChilds(HWND Parent,int ComboPart,int Page) {
   HENUM ChildEnum;
   HWND  hwndChild;
   int   LocalCurrent;
   LocalCurrent=Current;
   ChildEnum=WinBeginEnumWindows(Parent);
   while( ( hwndChild =WinGetNextWindow(ChildEnum))!=0) {
     /*----------------------------------------------*/
     /*- Found one child dump data                  -*/
     printf("Dump %X\n",hwndChild);
     DumpWindow(hwndChild,ComboPart,Page);
     /*-----------------------------*/
     /* Get childs of child if any  */
     printf("Enum %X\n",hwndChild);
     /* Do not get childs of non simple combo box */
     if (Objects[Current].Class!=ID_WC_COMBOBOX) {
        if (Objects[Current].Class!=ID_WC_NOTEBOOK) {
           if (Objects[Current].Class!=ID_WC_CONTAINER) {
              if (Objects[Current].Class!=ID_WC_SPINBUTTON) {
                 EnumChilds(hwndChild,0,Page);
              } else {
                 if ( (!(Objects[Current].Style&SPBS_NUMERICONLY))||
                      (!(Objects[Current].Style&SPBS_MASTER)) ) {
                    EnumChilds(hwndChild,0,Page);
                 } else {
                    LONG spmin,spmax;
                    Objects[Current].hasLimits=(BOOL)
                        WinSendMsg(hwndChild,SPBM_QUERYLIMITS,
                                   MPFROMP(pspmax),
                                   MPFROMP(pspmin)) ;
                     Objects[Current].spmin=*pspmin;
                     Objects[Current].spmax=*pspmax;

                 }
              }
           }
        } else {
           CurrentNotebook=Current;
           printf("Current Notebook %d\n",Current);
           Objects[Current].nCheckGroups=0;
           Objects[Current].ButtonGroup=0;
           Objects[Current].CurrentGroup=0;
           Objects[Current].sPage=maxPage+1;
           DumpNotebook(hwndChild,0,Page);
           Objects[CurrentNotebook].Page=Page;
           Objects[CurrentNotebook].ePage=maxPage;
           CurrentNotebook =0;
        }
     } else {
        if (Objects[Current].Style&CBS_SIMPLE) {
           Combos++;
           EnumChilds(hwndChild,Combos,Page);
        }
     }
   }
   if (!WinEndEnumWindows(ChildEnum)) WinAlarm(HWND_DESKTOP,WA_ERROR);
}
/*----------------------------------------------*/
/*- Sort routine for qsort by position         -*/
int     _Optlink SortChildsByPos( OBJECT * El1,OBJECT * El2) {
  if ((El1->y)==(El2->y))
  {
    if ((El1->x)==(El2->x)) return  0;
    if ((El1->x)> (El2->x)) return  1;
    else                return -1;
  } else {
    if ((El1->y)> (El2->y))  return  1;
    else                return -1;
  }
}

int items=0;
/*----------------------------------------------*/
/*- Generate java code routines                -*/

/*----------------------------------------------*/
/*- Generate menu items and menus              -*/
char LevelString[64];
FILE *ConstructorCode=NULL;
MENUDUMP * AddMenu(MENUDUMP *inMenu,FILE*OutCode,int level) {
   int j;
   int inLen;
   MENUDUMP *  DoneMenu;
   FILE *Target;
   BOOL fLast;
   j=0;
   level++;
   printf("In Menu %d File * %X \n",level,ConstructorCode);
   if (ConstructorCode==NULL)  {
      return NULL;
   }
   inLen=strlen(LevelString);
   if (level>1) {
       Target=ConstructorCode;
   } else {
       Target=OutCode;
   }
   while (inMenu!=NULL) {
      items++;
      if (items>200) return NULL;
      j++;
      fLast=inMenu->fLast;
      if (inMenu->fSubmenu) {
         fprintf(Target,"       Menu %s_%d = new Menu(\"%s\", true);\n",
                         LevelString,j,
                         inMenu->ItemText);
         fprintf(Target,"        %s.add(%s_%d);\n",
                     LevelString, LevelString, j);
         sprintf(LevelString+inLen,"_%d",j);
         if (level==1) {
             fprintf(Target,"        add_%s(%s);\n",
                          LevelString, LevelString);
             fprintf(ConstructorCode,"      void add_%s(Menu %s) {\n",
                LevelString, LevelString);
         }
         inMenu=AddMenu(inMenu->NextMenu,OutCode,level);
         if (level==1) {
             fprintf(ConstructorCode,"      }\n");
         }
         LevelString[inLen]=0x00;
      } else {
         if (inMenu->fSeparator) {
            fprintf(Target,"        %s.addSeparator();\n",
                        LevelString);
         } else {
            fprintf(Target,"        MenuItem %s_%d = new MenuItem(\"%s\");\n",
                            LevelString,j,
                           inMenu->ItemText);
            fprintf(Target,"        %s.add(%s_%d);\n",
                        LevelString, LevelString, j);
            fprintf(Target,"        PMElements.put(%s_%d,new Integer(%d));\n",
                                   LevelString,j,
                                   inMenu->IdItem);
         }

      }
      if (inMenu!=NULL) {
         if (fLast) return inMenu;
         else {
            DoneMenu=inMenu;
            inMenu=inMenu->NextMenu;
            /*free(DoneMenu); */
         }
      } else {
        return inMenu;
      }
   } /* endwhile */
   return inMenu;
}
FILE *Skeleton=NULL;
FILE *OutCode=NULL;
void flushConstructors() {
   int  CodeChar;
   ConstructorCode=fopen(TEMPFILE,"r");
   if (ConstructorCode!=NULL)  {
      CodeChar=fgetc(ConstructorCode);
      while (CodeChar!=EOF) {
         fputc(CodeChar,OutCode);
         CodeChar=fgetc(ConstructorCode);
      }
      fclose(ConstructorCode);
   }
}
/*----------------------------------------------*/
/*- Next Insert point location                 -*/
int lastChar=0;
int nextChar1=0;
int nextChar2=0;
BOOL  NextInsert(BOOL Copy,int Page) {
   /* Check files validity */
   if (Skeleton==NULL) {
      Skeleton =fopen("skelWindow.java","r");
      if (Skeleton==NULL) {
        MessageBox(HWND_DESKTOP,
                IDMSG_SKELETONMISSING,
                MB_OK | MB_ERROR,
                TRUE);
         return FALSE;
      }
      lastChar=fgetc(Skeleton);
      nextChar1=fgetc(Skeleton);
      nextChar2=fgetc(Skeleton);
   }
   if (OutCode==NULL)  {
      OutCode=fopen(szFileName,"a");
      if (OutCode==NULL)  {
         fclose(Skeleton);
         Skeleton=NULL;
         return FALSE;
      }
   }
   /* Find insertion point */
   while ( (lastChar!='\n')|| (nextChar1!='%')|| (nextChar2!='%')) {
        if (lastChar==EOF) {
           fclose(Skeleton);
           fclose(OutCode);
           Skeleton=NULL;
           OutCode=NULL;
           printf("End of file\n");
           return FALSE;
        }
        /* Name replacement */
        if ((lastChar=='#')&& (nextChar1=='<')&& (nextChar2=='>')) {
           if (Copy) {
              if (Page==0) {
                 fprintf(OutCode,"%s",szJavaName);
              } else {
                    fprintf(OutCode,"%s_Page%d",szJavaName,Page);
              }

           }
           lastChar=fgetc(Skeleton);
           if (lastChar=='>') {
              if (Copy) {
                 if (Page==0) {
                    fprintf(OutCode," extends Frame");
                 } else {
                    fprintf(OutCode," extends Panel");
                 }
              }
              lastChar=fgetc(Skeleton);
           } else {
              if (lastChar=='<') {
                 if (Copy) {
                    if (Page==0) {
                       fprintf(OutCode,"() ");
                    } else {
                       fprintf(OutCode,"(Hashtable hash) ");
                    }
                 }
                 lastChar=fgetc(Skeleton);
              }
           }
           /* eat 2 chars */
           nextChar1=fgetc(Skeleton);
           nextChar2=fgetc(Skeleton);
        } else {
           if (Copy) fputc(lastChar,OutCode);
           lastChar=nextChar1;
           nextChar1=nextChar2;
           nextChar2=fgetc(Skeleton);
        }
   }
   lastChar=' ';
   nextChar1=' ';
   nextChar2=' ';
   return TRUE;
}
BOOL GetImage(int i,char * Prefix,int Index) {
   char *Path;
   Path=_getcwd(0,_MAX_PATH);
   if (Path[strlen(Path)-1]!='\\') strcat(Path,"\\");
   sprintf(Path+strlen(Path),"%s_%s%d",szJavaName,Prefix,Index);
   if (SetPath(Path)) {
      SetClient(hwndMain);
      if (WinPostMsg(Objects[i].Handle,WM_CHAR,0,0)) {
         ULONG idTimer;
         QMSG qmsg;
         int  iBtn,pLen;
         idTimer=WinStartTimer(hab,0,0,4000); /* Avoid lock */
         while(WinGetMsg(hab, (PQMSG)&qmsg, (HWND)NULL, (ULONG)NULL, (ULONG)NULL)){
             if ((qmsg.msg==WM_TIMER)&&
                 (SHORT1FROMMP(qmsg.mp1)==idTimer)) break;
             WinDispatchMsg(hab, (PQMSG)&qmsg);
         }
         pLen=strlen(Path);
         for (iBtn=0;iBtn<pLen;iBtn++) {
             if (Path[iBtn]=='\\') Path[iBtn]='/';
         }

         SetPath("");
         /*free(Path);*/
         WinStopTimer(hab,0,idTimer);
         SetButton(0);
         SetClient(0);
         return TRUE;
      }
   } else {
      fprintf(OutCode,"        // Post failed\n");
      DosBeep(1200,30);
   }
   return FALSE;

}
int GetPageNotebook(int Page) {
   int i;
   int PageNotebook=0;
   if (Page==0) return 0;
   for (i=0;i<=Current;i++) {
        if (Objects[i].Page!=Page) {
           /* printf("Skipping Object %d class %s Page %d<>Object page %d\n",
                 i,
                 Objects[i].ClassName,
                 Page,
                 Objects[i].Page
           );*/
           continue;
        }
        if ((Page!=0)&&(PageNotebook==0)&&(Objects[i].OwnerNotebook!=0)) {
            PageNotebook=Objects[i].OwnerNotebook;
            return PageNotebook;
        }
   }
   return 0;
}
int FindGroupBox(int Page,int iObject,int *pnGB) {
  int iGB;
  int fGB=0;
  int nGB=0;
  int x,y,cx,cy;
  iGB=Objects[0].nextGroupBox;
  printf("find group box\n");
  while (iGB!=0) {
      if ((Objects[iGB].Page==Page)&&
          (iGB!=iObject))
      {
          /* printf("find group box page %d iGroup %d\n",Page,iGB); */
          if ((Objects[iGB].x<=Objects[iObject].x) &&
              (Objects[iGB].y<=Objects[iObject].y) &&
              (Objects[iGB].x+Objects[iGB].cx>=Objects[iObject].x+Objects[iObject].cx) &&
              (Objects[iGB].y+Objects[iGB].cy>=Objects[iObject].y+Objects[iObject].cy)) {
              if (fGB!=0) {
                 /* find if inside latest group box */
                 if ((Objects[iGB].x>=x) &&
                     (Objects[iGB].y>=y) &&
                     (Objects[iGB].x+Objects[iGB].cx<=x+cx) &&
                     (Objects[iGB].y+Objects[iGB].cy<=y+cy)) {
                    fGB=iGB; /* inside take it */
                    x=Objects[iGB].x;
                    y=Objects[iGB].y;
                    cx=Objects[iGB].cx;
                    cy=Objects[iGB].cy;

                 }
              } else {
                 fGB=iGB;
                 x=Objects[iGB].x;
                 y=Objects[iGB].y;
                 cx=Objects[iGB].cx;
                 cy=Objects[iGB].cy;
              }
              *pnGB=nGB;
          }
          nGB++;
      }

      iGB=Objects[iGB].nextGroupBox;
  }
  if (fGB!=0) printf("found group box page %d iGroup %d %s\n",Page,fGB,Objects[fGB].Text);
  return fGB;
}
void AddLayoutObject(int Page,FILE *OutCode,int i,PSZ prefix,int index,int iGb,int nGb) {
     if (iGb==0) iGb=FindGroupBox(Page,i,&nGb);
     if (iGb==0) {
        fprintf(OutCode,"        cst.setBounds(%d,%d,%d,%d);\n",
                              Objects[i].x,Objects[i].y,
                              Objects[i].cx,Objects[i].cy );
        fprintf(OutCode,"        ly.setConstraints(%s[%d],cst);\n",prefix,index);
        fprintf(OutCode,"        add(%s[%d]);\n",prefix,index);
     } else {
  printf("%s map x %d - x %d ,y %d - y %d of Box %d\n",
                              Objects[i].Text,
                              Objects[i].x,Objects[iGb].x,
                              Objects[i].y,Objects[iGb].y,
                              iGb);
        fprintf(OutCode,"        cst.setBounds(%d,%d,%d,%d);\n",
                              Objects[i].x-Objects[iGb].x,
                              Objects[i].y-Objects[iGb].y,
                              Objects[i].cx,
                              Objects[i].cy );
        fprintf(OutCode,"        ((PMLayout)gbx[%d].getLayout()).setConstraints(%s[%d],cst);\n",nGb,prefix,index);
        fprintf(OutCode,"        gbx[%d].add(%s[%d]);\n",nGb,prefix,index);
     }
     fprintf(OutCode,"        PMElements.put(%s[%d],new Integer(%d));\n",
                                   prefix,index,
                                   Objects[i].Id);
}
/*----------------------------------------------*/
/*- Count window elements&generate variables   -*/
/*----------------------------------------------*/

void DclElements(int Page) {
   int i;
   ULONG bStyle;
   int   PageNotebook=0;
   /* reset element count   */
   nButtons=0;
   ngButtons=0;
   nLabels =0;
   nMultiLabels=0;
   nLists  =0;
   nChoices=0;
   nTextFields=0;
   nTextAreas=0;
   nChecks=0;
   nButtonImages=0;
   nTextImages=0;
   nRectangles=0;
   nGroupBoxes=0;
   nCheckGroups=0;
   nNotebooks=0;
   nContainers=0;
   nSpinButtons=0;
   for (i=0;i<=Current;i++) {
            if (Objects[i].Page!=Page) {
               /*printf("Skipping Object %d class %s Page %d<>Object page %d\n",
                     i,
                     Objects[i].ClassName,
                     Page,
                     Objects[i].Page
               );*/
               continue;
            }
            if ((Page!=0)&&(PageNotebook==0)&&(Objects[i].OwnerNotebook!=0)) {
                PageNotebook=Objects[i].OwnerNotebook;
            }
            switch (Objects[i].Class) {
               case ID_WC_CONTAINER:
                     nContainers++;
                  break;
               case ID_WC_SPINBUTTON:
                  if ((Objects[i].Style&SPBS_NUMERICONLY)&&
                      (Objects[i].Style&SPBS_MASTER) ) {
                     nSpinButtons++;
                  }
                  break;
               case ID_WC_NOTEBOOK:
                     nNotebooks++;
                  break;
               case ID_WC_COMBOBOX:
                  if   (!(Objects[i].Style&CBS_SIMPLE)) {
                    nChoices++;
                  } else {
                    nSimples++;
                  }
                  break;
               case ID_WC_LISTBOX:
                  nLists++;
                  break;
               case ID_WC_BUTTON:
                  bStyle=Objects[i].Style&BS_PRIMARYSTYLES;
                  if (nCheckGroups<Objects[i].nCheckGroups) {
                      nCheckGroups=Objects[i].nCheckGroups;
                  }
                  switch (bStyle) {
                     case BS_PUSHBUTTON:
                        if ((Objects[i].Style&BS_ICON) ||
                            (Objects[i].Style&BS_MINIICON) ||
                            (Objects[i].Style&BS_BITMAP))
                           {
                           ngButtons++;
                        } else {
                           nButtons++;
                        }
                        break;
                     case BS_CHECKBOX:
                     case BS_AUTOCHECKBOX:
                     case BS_RADIOBUTTON:
                     case BS_AUTORADIOBUTTON:
                        nChecks++;
                        break;
                  }
                  if ((Objects[i].Style&BS_ICON) ||
                      (Objects[i].Style&BS_MINIICON) ||
                      (Objects[i].Style&BS_BITMAP))
                  {
                     nButtonImages++;
                  }
                  break;
               case ID_WC_ENTRYFIELD:
                  nTextFields++;
                  break;
               case ID_WC_MLE:
                  nTextAreas++;
                  break;
               case ID_WC_STATIC:
                  bStyle=(Objects[i].Style&0x7F);
                  if (bStyle==SS_TEXT) {
                     if (Objects[i].Style&DT_WORDBREAK) {
                        nMultiLabels++;
                     } else {
                        nLabels++;
                     }
                  }
                  if (bStyle==SS_GROUPBOX) {
                     nGroupBoxes++;
                  }
                  if ((bStyle==SS_FGNDRECT) ||
                      (bStyle==SS_FGNDFRAME) ||
                      (bStyle==SS_BKGNDFRAME) ||
                      (bStyle==SS_BKGNDRECT)) {
                    nRectangles++;
                  }
                  if ((bStyle==SS_ICON)||
                      (bStyle==SS_SYSICON)||
                      (bStyle==SS_BITMAP)) {
                     nTextImages++;
                  }
                  break;
               default:
                  break;
            } /* endswitch */
   }
   if (Page==0) {
      fprintf(OutCode,"\n    private Hashtable PMElements=new Hashtable();\n");
      fprintf(OutCode,"\n    private boolean inAnApplet = true;\n");
   } else {
      fprintf(OutCode,"\n    private Hashtable PMElements;\n");
   }
   if (nButtons) {
      fprintf(OutCode,"\n    private Button b[]=new Button[%d];",nButtons);
   }
   if (ngButtons) {
      fprintf(OutCode,"\n    private ImageButton ib[]=new ImageButton[%d];",ngButtons);
   }
   fprintf(OutCode,"\n    Toolkit toolkit;");
   if (nButtonImages) {
      fprintf(OutCode,"\n    Image bi[]=new Image[%d];",nButtonImages);
   }
   if (nLabels) {
      fprintf(OutCode,"\n    private Label lb[]=new Label[%d];",nLabels);
   }
   if (nMultiLabels) {
      fprintf(OutCode,"\n    private MultiLineLabel mlb[]=new MultiLineLabel[%d];",nMultiLabels);
   }
   if (nTextImages) {
      fprintf(OutCode,"\n    Image ti[]=new Image[%d];",nTextImages);
      fprintf(OutCode,"\n    TextBox gtb[]=new TextBox[%d];",nTextImages);
   }
   if (nRectangles) {
      fprintf(OutCode,"\n    TextBox rtb[]=new TextBox[%d];",nRectangles);
   }

   if (nLists) {
      fprintf(OutCode,"\n    private List li[]=new List[%d];",nLists);
   } else {
      if (Page==0) {
         fprintf(OutCode,"\n    private List li[];");
      }
   }
   if (nTextFields) {
      fprintf(OutCode,"\n    private TextField tf[]=new TextField[%d];",nTextFields);
   } else {
      if (Page==0) {
         fprintf(OutCode,"\n    private TextField tf[];");
      }
   }
   if (nTextAreas) {
      fprintf(OutCode,"\n    private TextArea ta[]=new TextArea[%d];",nTextAreas);
   }
   if (nChoices) {
      fprintf(OutCode,"\n    private Choice   ch[]=new Choice[%d];",nChoices);
   }
   if (nChecks) {
      fprintf(OutCode,"\n    private Checkbox ck[]=new Checkbox[%d];",nChecks);
   }
   if (nCheckGroups) {
      fprintf(OutCode,"\n    private CheckboxGroup ckg[]=new CheckboxGroup[%d];",nCheckGroups);
   }
   if (nGroupBoxes) {
      fprintf(OutCode,"\n    private GroupBox gbx[]=new GroupBox[%d];",nGroupBoxes);
   }
   if (nSimples) {
      fprintf(OutCode,"\n    private int      sList[]=new int[%d];",nSimples);
      fprintf(OutCode,"\n    private int      sText[]=new int[%d];",nSimples);
   } else {
      if (Page==0) {
         fprintf(OutCode,"\n    private int      sList[];");
         fprintf(OutCode,"\n    private int      sText[];");
      }
   }
   if ((maxPage)&&(Page==0)) {
         fprintf(OutCode,"\n    private Panel     cpList[]=new Panel[%d];",maxPage);
         fprintf(OutCode,"\n    private String    tabList[]=new String[%d];",maxPage);
   } else {
         fprintf(OutCode,"\n    private String    tabList[];");
   }
   if (nNotebooks) {
      /*   fprintf(OutCode,"\n    private cardPanel cp;"); */
         fprintf(OutCode,"\n    private Notebook nbk[]=new Notebook[%d];",nNotebooks);
   }
   if (nContainers) {
         fprintf(OutCode,"\n    private DataContainer cnr[]=new DataContainer[%d];",nContainers);
   }
   if (nSpinButtons) {
         fprintf(OutCode,"\n    private SpinButton spb[]=new SpinButton[%d];",nSpinButtons);
   }
   fprintf(OutCode,"\n    private Dimension  d=new Dimension(%d,%d);",
            Objects[PageNotebook].cx,Objects[PageNotebook].cy); // leave room for the choice
   fprintf(OutCode,"\n");
}
/*----------------------------------------------*/
/*- Constructor code                           -*/
void Constructor(int Page) {
   int i,nElement;
   int iGroupBox;
   int nGroupBox;
   int gGroupBox;
   int iTabText;
   int cx,ifield;
   LISTDUMP *  DoneList;
   FIELDINFO *pFieldInfo;
   char  *prefix;
   ULONG bStyle;
   /* reset element count   */
   nButtons=0;
   ngButtons=0;
   nLabels =0;
   nMultiLabels =0;
   nLists  =0;
   nChoices=0;
   nTextFields=0;
   nTextAreas=0;
   nChecks=0;
   nButtonImages=0;
   nTextImages=0;
   nRectangles=0;
   nGroupBoxes=0;
   gGroupBox=0;
   iGroupBox=0;
   nGroupBox=0;
   nNotebooks=0;
   nContainers=0;
   nSpinButtons=0;
   iTabText=0;
   if ((Title)&&(Page==0)) fprintf(OutCode,"        super(\"%s\");\n",Title);
   else       fprintf(OutCode,"        super();\n");
   if (Page!=0) {
      fprintf(OutCode,"        PMElements=hash;\n");
   }
   fprintf(OutCode,"        PMLayout     ly=new PMLayout(d.width,d.height);\n");
   fprintf(OutCode,"        PMConstraint cst= new PMConstraint();\n");
   fprintf(OutCode,"        setLayout(ly);\n");
   fprintf(OutCode,"        toolkit = Toolkit.getDefaultToolkit();\n");
   /* Write menu and notebook tabs code first and group boxes init first*/
   for (i=0;i<=Current;i++) {
            if ((Page==0)&&(Objects[i].tabText!=0)) {
                fprintf(OutCode,"        tabList[%d]=new String(\"%s\");\n",
                              iTabText,Objects[i].tabText);
                iTabText++;
            }
            if (Objects[i].Page!=Page) continue;
            /*  */
            switch (Objects[i].Class) {
               case ID_WC_STATIC:
                  bStyle=(Objects[i].Style&0x7F);
                  if (bStyle==SS_GROUPBOX) {
                      fprintf(OutCode,"        gbx[%d]=new GroupBox(\"%s\");\n",
                                      nGroupBoxes,Objects[i].Text);
                      AddLayoutObject(Page,OutCode,i,"gbx",nGroupBoxes,0,0);
                      fprintf(OutCode,"        gbx[%d].setLayout(new PMLayout(%d,%d));\n",
                                              nGroupBoxes,
                                              Objects[i].cx,
                                              Objects[i].cy);
                      iGroupBox=i;
                      gGroupBox=Objects[i].Group;
                      nGroupBox=nGroupBoxes;
                      nGroupBoxes++;
                  }
               break;
            }
            printf("Test menu %d %p\n",i,Objects[i].NextMenu);
            /*----------------------------------------------*/
            /*- Add one level for menu Items               -*/
            NewMenu=Objects[i].NextMenu;
            if (NewMenu!=NULL) {
               fprintf(OutCode,"        MenuBar mb;\n");
               fprintf(OutCode,"        mb = new MenuBar();\n");
               fprintf(OutCode,"        setMenuBar(mb);\n");
               strcpy(LevelString,"mb");
               ConstructorCode=fopen(TEMPFILE,"a");
               if (ConstructorCode!=NULL)  {
                 int  MenuChar;
                 AddMenu(NewMenu,OutCode,0);
                 fclose(ConstructorCode);
               } else {
                 perror("Open menu code write failed");
               }
            }
            printf("Next\n");
          /*if (Objects[i].ClassName!=NULL) {
               free(Objects[i].ClassName);
            }    endif */
   }
   for (i=0;i<nCheckGroups;i++) {
       fprintf(OutCode,"        ckg[%d]=new CheckboxGroup();\n",i);
   }
   if ((maxPage)&&(Page==0)) {
       for (i=0;i<maxPage;i++) {
         fprintf(OutCode,"        cpList[%d]=new %s_Page%d(PMElements);\n",i,szJavaName,i+1);

       }
       /*fprintf(OutCode,"        cp=new cardPanel(%d,cpList);\n",maxPage);
       fprintf(OutCode,"        add(cp);\n"); */
   }
   nGroupBoxes=0;
   for (i=0;i<=Current;i++) {
            if (Objects[i].Page!=Page) continue;
            if (Objects[i].Group!=gGroupBox) {
                    gGroupBox=0;
                    iGroupBox=0;
                    nGroupBox=0;
            }
            switch (Objects[i].Class) {
               /*----------------------------------------------*/
               case ID_WC_SPINBUTTON:
                  if ((Objects[i].Style&SPBS_NUMERICONLY)&&
                      (Objects[i].Style&SPBS_MASTER) ) {
                     fprintf(OutCode,"        spb[%d]=new SpinButton();\n",nSpinButtons);
                     AddLayoutObject(Page,OutCode,i,"spb",nSpinButtons,iGroupBox,nGroupBox);
                     if (Objects[i].hasLimits) {
                        fprintf(OutCode,"        spb[%d].setRange(%d,%d);\n",nSpinButtons,Objects[i].spmin,Objects[i].spmax);
                     }
                     if (Objects[i].Style&SPBS_READONLY) {
                        fprintf(OutCode,"        spb[%d].setReadOnly(true);\n",nSpinButtons);
                     } else {
                        fprintf(OutCode,"        spb[%d].setReadOnly(false);\n",nSpinButtons);
                     }
                     prefix="spb";
                     nSpinButtons ++;
                  }
                  break;
               case ID_WC_CONTAINER:
                  switch ( Objects[i].View&
                          (CV_TEXT|CV_ICON|CV_DETAIL|CV_ICON)) {
                    case CV_TEXT:
                      fprintf(OutCode,"        cnr[%d]=new DataContainer(DataContainer.List_View);\n",
                                   nContainers);
                      break;
                    case CV_ICON:
                      fprintf(OutCode,"        cnr[%d]=new DataContainer(DataContainer.Icon_View);\n",
                                   nContainers);
                      break;
                    case CV_DETAIL:
                     fprintf(OutCode,"        cnr[%d]=new DataContainer(DataContainer.Details_View);\n",
                                   nContainers);
                      break;
                    case CV_TREE:
                     fprintf(OutCode,"        cnr[%d]=new DataContainer(DataContainer.Tree_View);\n",
                                   nContainers);
                      break;
                    default:
                      fprintf(OutCode,"        cnr[%d]=new DataContainer(DataContainer.List_View);\n",
                                   nContainers);
                      break;

                  }

                  fprintf(OutCode,"        cnr[%d].setTitle(\"%s\");\n",
                                   nContainers,Objects[i].Text);
                  cx=0;ifield=0;
                  pFieldInfo=Objects[i].NextCnrH;
                  while (pFieldInfo!=NULL) {
                     if (!(pFieldInfo->flData&CFA_INVISIBLE)) {
                        fprintf(OutCode,"        cnr[%d].setColumnData(\"%s\",",
                                      nContainers,pFieldInfo->pTitleData);

                        if (pFieldInfo->flData&CFA_CENTER) {
                           fprintf(OutCode,"DataContainer.Center_Justify,");
                        } else
                        if (pFieldInfo->flData&CFA_RIGHT) {
                           fprintf(OutCode,"DataContainer.Right_Justify,");
                        } else {
                           fprintf(OutCode,"DataContainer.Left_Justify,");
                        }
                        if (pFieldInfo->flData&CFA_SEPARATOR) {
                           fprintf(OutCode,"DataContainer.Vertical_Line);\n");
                        } else {
                           fprintf(OutCode,"DataContainer.No_Vertical_Line);\n");
                        }
                        if (pFieldInfo->cb) {
                           if ((Objects[i].pctSplit<10)||(Objects[i].pctSplit>90)) {
                               Objects[i].pctSplit=30;
                           }
                           fprintf(OutCode,"        cnr[%d].setSplitBar(%d,%d);\n",
                                         nContainers,ifield,Objects[i].pctSplit);
                        }
                        printf("Header title %s,title style %X,field style %X\n",
                                               pFieldInfo->pTitleData,
                                               pFieldInfo->flTitle ,
                                               pFieldInfo->flData);
                        ifield++;
                     }
                     pFieldInfo=pFieldInfo->pNextFieldInfo;
                  }
                  AddLayoutObject(Page,OutCode,i,"cnr",nContainers,iGroupBox,nGroupBox);
                  fprintf(OutCode,"        /*---------------------*/\n");
                  fprintf(OutCode,"        /*-Container test item */\n");
                  fprintf(OutCode,"        ContainerItem cnrTest_%d=new ContainerItem(null, \"test item\");\n",
                                   nContainers);
                  cx=0;ifield=0;
                  pFieldInfo =Objects[i].NextCnrH;
                  while (pFieldInfo!=NULL) {
                     FIELDINFO *oldInfo;
                     if (!(pFieldInfo->flData&CFA_INVISIBLE)) {
                        fprintf(OutCode,"        cnrTest_%d.setColumn(%d,\"%s test\");\n",
                                   nContainers,ifield,pFieldInfo->pTitleData);
                        ifield++;
                     }
                     oldInfo =pFieldInfo;
                     pFieldInfo =pFieldInfo->pNextFieldInfo;
                     DosFreeMem(oldInfo);
                  }
                  Objects[i].NextCnrH=0;
                  fprintf(OutCode,"        cnr[%d].setRoot(cnrTest_%d);\n",
                                           nContainers,nContainers);
                  fprintf(OutCode,"        /*---------------------*/\n");
                  nContainers++;

                  break;
               case ID_WC_NOTEBOOK:
                     /* remove invalid styles */
                     if   (Objects[i].Style&BKS_BACKPAGESBR) {
                         Objects[i].Style&=
                           (~(BKS_MAJORTABLEFT|BKS_MAJORTABTOP));
                     } else
                     if   (Objects[i].Style&BKS_BACKPAGESBL) {
                         Objects[i].Style&=
                           (~(BKS_MAJORTABRIGHT|BKS_MAJORTABTOP));
                     } else
                     if   (Objects[i].Style&BKS_BACKPAGESTR) {
                         Objects[i].Style&=
                           (~(BKS_MAJORTABBOTTOM|BKS_MAJORTABLEFT));
                     } else
                     if   (Objects[i].Style&BKS_BACKPAGESTL) {
                         Objects[i].Style&=
                           (~(BKS_MAJORTABBOTTOM|BKS_MAJORTABRIGHT));
                     }
                     if   (Objects[i].Style&BKS_MAJORTABBOTTOM) {
                        Objects[i].Style&=(~BKS_SPIRALBIND);
                        fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Bottom",nNotebooks);
                     } else
                     if   (Objects[i].Style&BKS_MAJORTABLEFT) {
                        fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Left",nNotebooks);
                     } else
                     if   (Objects[i].Style&BKS_MAJORTABTOP) {
                        Objects[i].Style&=(~BKS_SPIRALBIND);
                        fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Top",nNotebooks);
                     } else
                     if   (Objects[i].Style&BKS_MAJORTABRIGHT) {
                        fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Right",nNotebooks);
                     } else  {
                        if   (Objects[i].Style&BKS_BACKPAGESBR) {
                           fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Right",nNotebooks);
                        } else
                        if   (Objects[i].Style&BKS_BACKPAGESTL) {
                           fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Left",nNotebooks);
                        } else
                        if   (Objects[i].Style&BKS_BACKPAGESBL) {
                           Objects[i].Style&=(~BKS_SPIRALBIND);
                           fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Bottom",nNotebooks);
                        } else {
                           fprintf(OutCode,"        nbk[%d]=new Notebook(Notebook.Right",nNotebooks);
                        }

                     }
                     if   (Objects[i].Style&BKS_SPIRALBIND) {
                        fprintf(OutCode,",Notebook.Spiral);\n");
                     } else  {
                        fprintf(OutCode,",Notebook.Plain);\n");
                     }

                     AddLayoutObject(Page,OutCode,i,"nbk",nNotebooks,iGroupBox,nGroupBox);
                     fprintf(OutCode,"        buildNotebook(nbk[%d],%d,%d,%d,cpList);\n",
                        nNotebooks,Objects[i].sPage,Objects[i].ePage,
                        maxPage);
                     nNotebooks++;
                     prefix="nbk";
                  break;
               case ID_WC_COMBOBOX:
                  if   (!(Objects[i].Style&CBS_SIMPLE)) {
                     fprintf(OutCode,"        ch[%d]=new Choice();\n", nChoices);
                     AddLayoutObject(Page,OutCode,i,"ch",nChoices,iGroupBox,nGroupBox);
                     nElement=nChoices;
                     nChoices++;
                     prefix="ch";
                  }
                  break;
               case ID_WC_LISTBOX:
                  if (Objects[i].Style&LS_MULTIPLESEL) {
                     fprintf(OutCode,"        li[%d]=new List(1,true);\n", nLists);
                  } else {
                     fprintf(OutCode,"        li[%d]=new List(1,false);\n", nLists);
                  }
                     AddLayoutObject(Page,OutCode,i,"li",nLists,iGroupBox,nGroupBox);
                  nElement=nLists;
                  prefix="li";
                  if (Objects[i].ComboPart>0) {
                      fprintf(OutCode,"         sList[%d]=%d;\n",
                              Objects[i].ComboPart-1,nLists);
                  }
                  nLists++;
                  break;
               case ID_WC_BUTTON:
                  bStyle=(Objects[i].Style&BS_PRIMARYSTYLES);
                  switch (bStyle) {
                     case BS_PUSHBUTTON:
                        printf("Icon \n");
                        if ((Objects[i].Style&BS_ICON) ||
                            (Objects[i].Style&BS_MINIICON) ||
                            (Objects[i].Style&BS_BITMAP))
                           {
                           SetButton(Objects[i].Handle);
                           if (GetImage(i,"button",nButtonImages)) {
                              fprintf(OutCode,"        bi[%d]=toolkit.getImage(\"%s_button%d.GIF\");\n",
                                         nButtonImages,szJavaName, nButtonImages);
                              fprintf(OutCode,"        ib[%d]=new ImageButton(bi[%d]);\n",
                                  ngButtons,nButtonImages);
                              AddLayoutObject(Page,OutCode,i,"ib",ngButtons,iGroupBox,nGroupBox);
                           }
                           nButtonImages++;
                           ngButtons++;
                        } else {
                           fprintf(OutCode,"        b[%d]=new Button(\"%s\");\n",
                                     nButtons, Objects[i].Text);
                           AddLayoutObject(Page,OutCode,i,"b",nButtons,iGroupBox,nGroupBox);
                           nButtons++;
                        }
                        break;
                     case BS_CHECKBOX:
                     case BS_AUTOCHECKBOX:
                     case BS_RADIOBUTTON:
                     case BS_AUTORADIOBUTTON:
                        if (Objects[i].ButtonGroup>0) {
                           fprintf(OutCode,"        ck[%d]=new Checkbox(\"%s\",ckg[%d],false);\n",
                                     nChecks, Objects[i].Text,Objects[i].ButtonGroup-1);
                        } else {
                           fprintf(OutCode,"        ck[%d]=new Checkbox(\"%s\");\n",
                                     nChecks, Objects[i].Text);
                        }
                        AddLayoutObject(Page,OutCode,i,"ck",nChecks,iGroupBox,nGroupBox);
                        nChecks++;
                        break;
                  }
                  break;
               case ID_WC_ENTRYFIELD:
                  fprintf(OutCode,"        tf[%d]=new TextField(\"%s\");\n",
                                   nTextFields,Objects[i].Text);
                  AddLayoutObject(Page,OutCode,i,"tf",nTextFields,iGroupBox,nGroupBox);
                  if (Objects[i].ComboPart>0) {
                      fprintf(OutCode,"         sText[%d]=%d;\n",
                              Objects[i].ComboPart-1,nTextFields);
                  }
                  if (Objects[i].Style&ES_UNREADABLE) {
                     fprintf(OutCode,"        tf[%d].setEchoCharacter(\'*\');\n",
                                   nTextFields);
                  }
                  nTextFields++;
                  break;
               case ID_WC_MLE:
                  fprintf(OutCode,"        ta[%d]=new TextArea(\"%s\");\n",
                                   nTextAreas,Objects[i].Text);
                  AddLayoutObject(Page,OutCode,i,"ta",nTextAreas,iGroupBox,nGroupBox);
                  nTextAreas++;
                  break;
               case ID_WC_STATIC:
                  bStyle=(Objects[i].Style&0x7F);
                  if (bStyle==SS_GROUPBOX) {
                      iGroupBox=i;
                      gGroupBox=Objects[i].Group;
                      nGroupBox=nGroupBoxes;
                      nGroupBoxes++;
                  }
                  if (bStyle==SS_TEXT) {
                     if (Objects[i].Style&DT_WORDBREAK) {
                        fprintf(OutCode,"        mlb[%d]=new MultiLineLabel(\"%s\");\n",
                                      nMultiLabels,Objects[i].Text);
                        AddLayoutObject(Page,OutCode,i,"mlb",nMultiLabels,iGroupBox,nGroupBox);
                        nMultiLabels++;
                     } else {
                        fprintf(OutCode,"        lb[%d]=new Label(\"%s\");\n",
                                      nLabels,Objects[i].Text);
                        AddLayoutObject(Page,OutCode,i,"lb",nLabels,iGroupBox,nGroupBox);
                        nLabels++;
                     }

                  }
                  if (bStyle==SS_FGNDRECT) {
                     fprintf(OutCode,"        rtb[%d]=new TextBox(new Rectangle(%d,%d,%d,%d),true,true);\n",
                                      nRectangles,
                                      Objects[i].x, Objects[i].y,
                                      Objects[i].cx-1, Objects[i].cy-1 );
                     AddLayoutObject(Page,OutCode,i,"rtb",nRectangles,iGroupBox,nGroupBox);
                     nRectangles++;
                  }

                  if (bStyle==SS_BKGNDRECT) {
                     fprintf(OutCode,"        rtb[%d]=new TextBox(new Rectangle(%d,%d,%d,%d),true,false);\n",
                                      nRectangles,
                                      Objects[i].x, Objects[i].y,
                                      Objects[i].cx-1, Objects[i].cy-1 );
                     AddLayoutObject(Page,OutCode,i,"rtb",nRectangles,iGroupBox,nGroupBox);
                    nRectangles++;
                  }
                  if (bStyle==SS_FGNDFRAME) {
                     fprintf(OutCode,"        rtb[%d]=new TextBox(new Rectangle(%d,%d,%d,%d),false,true);\n",
                                      nRectangles,
                                      Objects[i].x, Objects[i].y,
                                      Objects[i].cx-1, Objects[i].cy-1 );
                     AddLayoutObject(Page,OutCode,i,"rtb",nRectangles,iGroupBox,nGroupBox);
                    nRectangles++;
                  }
                  if (bStyle==SS_BKGNDFRAME) {
                     fprintf(OutCode,"        rtb[%d]=new TextBox(new Rectangle(%d,%d,%d,%d),false,false);\n",
                                      nRectangles,
                                      Objects[i].x, Objects[i].y,
                                      Objects[i].cx-1, Objects[i].cy-1 );
                     AddLayoutObject(Page,OutCode,i,"rtb",nRectangles,iGroupBox,nGroupBox);
                  }
                  if ((bStyle==SS_ICON)||
                      (bStyle==SS_SYSICON)||
                      (bStyle==SS_BITMAP)) {
                       SetText(Objects[i].Handle);
                       if (GetImage(i,"text",nTextImages)) {
                          fprintf(OutCode,"        ti[%d]=toolkit.getImage(\"%s_text%d.GIF\");\n",
                                     nTextImages,szJavaName,nTextImages);
                          fprintf(OutCode,"        gtb[%d]=new TextBox(ti[%d]);\n",
                                     nTextImages,nTextImages);
                          AddLayoutObject(Page,OutCode,i,"gtb",nTextImages,iGroupBox,nGroupBox);
                       }
                       nTextImages++;
                  }
                  break;
               default:
                  break;
            } /* endswitch */
            /*----------------------------------------------*/
            /*- Add one level for Listbox Items & combobox -*/
            NewList=Objects[i].NextList;
            while (NewList!=NULL) {
               char *NewTxt;
               NewTxt=strdup(NewList->ItemText);
               fprintf(OutCode,"        %s[%d].addItem(\"%s\");\n",
                                      prefix,nElement,
                                      CleanText(NewTxt));
               DoneList=NewList;
               NewList=NewList->NextList;
               /*free(DoneList); */
            } /* endwhile */
   } /* endfor */

}
/*----------------------------------------------*/
/*- Paint code                                 -*/
/*----------------------------------------------*/
/*- Paint code                                 -*/
void Paint(int Page) {
   int i;
   ULONG       bStyle;
   int         PageNotebook=0;
   /* reset element count   */
   nButtons=0;
   ngButtons=0;
   nLabels =0;
   nMultiLabels =0;
   nLists  =0;
   nChoices=0;
   nTextFields=0;
   nTextAreas=0;
   nChecks=0;
   nButtonImages=0;
   nTextImages=0;
   nRectangles=0;
   nGroupBoxes=0;
   nCheckGroups=0;
   nNotebooks=0;
   nContainers=0;
   nSpinButtons=0;
   fprintf(OutCode,"\n");
   if ((Title)&&(Page==0)) fprintf(OutCode,"            setTitle(\"%s\");\n",Title);
   PageNotebook =GetPageNotebook(Page);
   if (Page==0) {
      fprintf(OutCode,"\n            this.resize(%d+insets.left + insets.right,\n",
                      Objects[0].cx);
      fprintf(OutCode,"                          %d + insets.top + insets.bottom);\n",
                      Objects[0].cy);
      if (maxPage>0) {
         /*fprintf(OutCode,"            cp.validate();\n"); */
      }
   }
   fprintf(OutCode,"        }\n"); // End of laid out block
}
/*----------------------------------------------*/
/*- Main Java generator                        -*/
void    GenerateJava(int Page) {
   int i,j;
   MENUDUMP *  DoneMenu;
   LISTDUMP *  DoneList;
   HFILE hfile;
   ULONG ulAction;
   static char DataBuffer[CCHMAXPATH];
   setbuf(stdout,NULL);
   if (access(TEMPFILE,00)!=-1) {
       system(" erase Code.tmp");
   }
   if (Page==0) {
      if (access(szFileName,00)!=-1) {
          FILE *OutCode=NULL;
          OutCode=fopen(szFileName,"w");
          if (OutCode) fclose(OutCode);
      }
   }
   /** Go to first  insertion point global header  */
   if (Page==0) {
      if (!NextInsert(TRUE,Page)) return;
      fprintf(OutCode,"\n   public ");
   } else {
      if (!NextInsert(FALSE,Page)) return;
   }
   /** Go to next   insertion point */
   if (!NextInsert(TRUE,Page)) return;
   /** Get elements count and declare them */
   DclElements(Page);
   /** Go to second insertion point */
   if (!NextInsert(TRUE,Page)) return;
   /** Generate element constructor */
   Constructor(Page);
   /** Go to next insertion point: menus */
   if (!NextInsert(TRUE,Page)) return;
   /** Insert panels constructors        */
   /** Insert menus  constructors        */
   flushConstructors();
   /** Go to next insertion point paint */
   if (!NextInsert(TRUE,Page)) return;
   /** Generate element paint       */
   Paint(Page);
   /** Go to Paint end              */
   if (!NextInsert(TRUE,Page)) return;
   /** Go to Frame resize         */
   if (Page==0) {
      if (!NextInsert(TRUE,Page)) return;
      fprintf(OutCode,"\n        window.resize(%d+insets.left + insets.right,\n",
                      Objects[0].cx);
      fprintf(OutCode,"                      %d + insets.top + insets.bottom);\n",
                      Objects[0].cy);
      /** Flush skeleton and leave   */
      NextInsert(TRUE,Page);
    } else {
      NextInsert(FALSE,Page);
      NextInsert(FALSE,Page);
    }
    NextInsert(TRUE,Page);
   /** now frame only copy        */
   if (Page==0) {
      NextInsert(TRUE,Page);
   } else {
      NextInsert(FALSE,Page);
   }

   /** Process end                */
   if (OutCode) {
      fclose(OutCode);
   }
   if (Skeleton) fclose(Skeleton);
   if (Page==0) {
      if (maxPage>0) {
         for (i=1;i<=maxPage;i++) {
            GenerateJava(i);
         }
      }
      strcpy(szFullPath,szFileName);
      if ( DosOpen(szFileName, &hfile, &ulAction, 0, FILE_NORMAL,
             FILE_OPEN, OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE, NULL))
      {
         MessageBox(hwndMain, IDMSG_CANNOTOPENINPUTFILE, MB_OK | MB_ERROR,
            FALSE);
         return;
      }
      Load(hfile);
      DosClose(hfile);
      UpdateTitleText(hwndMainFrame);
   }
}
