#pragma pack(1)
typedef struct _GIFCOLOR {
    char red;
    char green;
    char blue;
} GIFCOLOR;
typedef struct _GIF_HEADER {
    char gif[3];
    char year[3];
} GIF_HEADER;
typedef struct _LOGICAL_SCREEN_DESCRIPTOR {
    short int  width;
    short int  height;
    char       colorInfo;
    char       backColorIndex;
    char       aspectRatio;
} LOGICAL_SCREEN_DESCRIPTOR;

typedef struct _GRAPHIC_CONTROL{
    char       flags;
    char       reserved1;
    char       reserved2;
    char       transparentColorIndex;
    char       reserved3;
} GRAPHIC_CONTROL;


typedef struct _IMAGE_DESCRIPTOR {
    short int  xLeft;
    short int  yTop;
    short int  width;
    short int  height;
    char       colorInfo;
    char       compressMinimumSize;
} IMAGE_DESCRIPTOR;

#define EXTENSION_FOLLOWS            0x21
#define IMAGE_DESCRIPTOR_FOLLOWS     0x2C
#define TRAILER_FOLLOWS              0x3B
#define PLAIN_TEXT_EXTENSION         0X01
#define GRAPHIC_CONTROL_EXTENSION    0XF9
#define COMMENT_EXTENSION            0XFE
#define APPLICATION_EXTENSION        0XFF

#define SETTRANSPARENT(gc)   (gc).flags|=0x01;
#define SetDispose(gc)       (gc).flags|=0x20;
#define HasTransparent(gc) (((gc).flags)&0x01)
#define HasColorTable(lsd) (((lsd).colorInfo)&0x80)
#define ColorResolution(lsd) (((((lsd).colorInfo)&0x70)>>4)+1)
#define ColorTableSize(lsd)  (2<<(((lsd).colorInfo)&0x07))

extern void APIENTRY  Ico2Gif(HAB hab,PPOINTERINFO pPointerInfo,char *Path);
extern void FileToGif(unsigned long hbm,char *Path);



#pragma pack()
