/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.awt.EventQueue;
import de.schlichtherle.key.PromptingKeyProvider;
import de.schlichtherle.key.passwd.swing.BasicCreateKeyFeedback;
import de.schlichtherle.key.passwd.swing.BasicInvalidOpenKeyFeedback;
import de.schlichtherle.key.passwd.swing.BasicUnknownOpenKeyFeedback;
import de.schlichtherle.key.passwd.swing.CreateKeyFeedback;
import de.schlichtherle.key.passwd.swing.CreateKeyPanel;
import de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback;
import de.schlichtherle.key.passwd.swing.OpenKeyPanel;
import de.schlichtherle.key.passwd.swing.PromptingKeyManager;
import de.schlichtherle.key.passwd.swing.UnknownOpenKeyFeedback;
import java.awt.Window;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PromptingKeyProviderUI
implements de.schlichtherle.key.PromptingKeyProviderUI {
    private static final String CLASS_NAME = "de/schlichtherle/key/passwd/swing/PromptingKeyProviderUI".replace('/', '.');
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final Logger logger = Logger.getLogger(CLASS_NAME);
    public static final int KEY_FILE_LEN = 512;
    static String lastResourceID = "";
    private CreateKeyPanel createKeyPanel;
    private OpenKeyPanel openKeyPanel;
    private CreateKeyFeedback createKeyFeedback;
    private UnknownOpenKeyFeedback unknownOpenKeyFeedback;
    private InvalidOpenKeyFeedback invalidOpenKeyFeedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(String string) throws IOException {
        byte[] byArray = new byte[512];
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        try {
            randomAccessFile.readFully(byArray);
        }
        finally {
            randomAccessFile.close();
        }
        return byArray;
    }

    protected CreateKeyPanel getCreateKeyPanel() {
        if (this.createKeyPanel == null) {
            this.createKeyPanel = this.createCreateKeyPanel();
        }
        return this.createKeyPanel;
    }

    protected CreateKeyPanel createCreateKeyPanel() {
        return new CreateKeyPanel();
    }

    protected OpenKeyPanel getOpenKeyPanel() {
        if (this.openKeyPanel == null) {
            this.openKeyPanel = this.createOpenKeyPanel();
        }
        return this.openKeyPanel;
    }

    protected OpenKeyPanel createOpenKeyPanel() {
        return new OpenKeyPanel();
    }

    protected CreateKeyFeedback getCreateKeyFeedback() {
        if (this.unknownOpenKeyFeedback == null) {
            try {
                String string = System.getProperty("de.schlichtherle.key.passwd.swing.CreateKeyFeedback");
                if (string != null) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                    this.createKeyFeedback = (CreateKeyFeedback)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "", instantiationException);
            }
            if (this.createKeyFeedback == null) {
                this.createKeyFeedback = new BasicCreateKeyFeedback();
            }
        }
        return this.createKeyFeedback;
    }

    protected void setCreateKeyFeedback(CreateKeyFeedback createKeyFeedback) {
        this.createKeyFeedback = createKeyFeedback;
    }

    protected UnknownOpenKeyFeedback getUnknownOpenKeyFeedback() {
        if (this.unknownOpenKeyFeedback == null) {
            try {
                String string = System.getProperty("de.schlichtherle.key.passwd.swing.UnknownOpenKeyFeedback");
                if (string != null) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                    this.unknownOpenKeyFeedback = (UnknownOpenKeyFeedback)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "", instantiationException);
            }
            if (this.unknownOpenKeyFeedback == null) {
                this.unknownOpenKeyFeedback = new BasicUnknownOpenKeyFeedback();
            }
        }
        return this.unknownOpenKeyFeedback;
    }

    protected void setUnknownOpenKeyFeedback(UnknownOpenKeyFeedback unknownOpenKeyFeedback) {
        this.unknownOpenKeyFeedback = unknownOpenKeyFeedback;
    }

    protected InvalidOpenKeyFeedback getInvalidOpenKeyFeedback() {
        if (this.invalidOpenKeyFeedback == null) {
            try {
                String string = System.getProperty("de.schlichtherle.key.passwd.swing.InvalidOpenKeyFeedback");
                if (string != null) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                    this.invalidOpenKeyFeedback = (InvalidOpenKeyFeedback)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "", classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "", instantiationException);
            }
            if (this.invalidOpenKeyFeedback == null) {
                this.invalidOpenKeyFeedback = new BasicInvalidOpenKeyFeedback();
            }
        }
        return this.invalidOpenKeyFeedback;
    }

    protected void setInvalidOpenKeyFeedback(InvalidOpenKeyFeedback invalidOpenKeyFeedback) {
        this.invalidOpenKeyFeedback = invalidOpenKeyFeedback;
    }

    public final synchronized void promptCreateKey(final PromptingKeyProvider promptingKeyProvider) {
        PromptingKeyProviderUI.multiplexOnEDT(new Runnable(){

            public void run() {
                PromptingKeyProviderUI.this.promptCreateKey(promptingKeyProvider, null);
            }
        });
    }

    public final synchronized boolean promptUnknownOpenKey(final PromptingKeyProvider promptingKeyProvider) {
        BooleanRunnable booleanRunnable = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(promptingKeyProvider, false, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(booleanRunnable);
        return booleanRunnable.result;
    }

    public final synchronized boolean promptInvalidOpenKey(final PromptingKeyProvider promptingKeyProvider) {
        BooleanRunnable booleanRunnable = new BooleanRunnable(){

            public void run() {
                this.result = PromptingKeyProviderUI.this.promptOpenKey(promptingKeyProvider, true, null);
            }
        };
        PromptingKeyProviderUI.multiplexOnEDT(booleanRunnable);
        return booleanRunnable.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void promptCreateKey(PromptingKeyProvider promptingKeyProvider, JComponent jComponent) {
        CreateKeyPanel createKeyPanel = this.getCreateKeyPanel();
        createKeyPanel.resetPasswd();
        createKeyPanel.setError(null);
        createKeyPanel.setExtraDataUI(jComponent);
        Window window = PromptingKeyManager.getParentWindow();
        try {
            Object object;
            do {
                createKeyPanel.setResourceID(promptingKeyProvider.getResourceID());
                createKeyPanel.setFeedback(this.getCreateKeyFeedback());
                int n = JOptionPane.showConfirmDialog(window, createKeyPanel, resources.getString("newPasswdDialog.title"), 2, 3);
                if (n != 0) return;
            } while ((object = createKeyPanel.getCreateKey()) == null);
            promptingKeyProvider.setKey(object);
            return;
        }
        finally {
            PromptingKeyProviderUI.eventuallyDispose(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean promptOpenKey(PromptingKeyProvider promptingKeyProvider, boolean bl, JComponent jComponent) {
        OpenKeyPanel openKeyPanel;
        block7: {
            openKeyPanel = this.getOpenKeyPanel();
            if (bl) {
                openKeyPanel.setError(resources.getString("passwdWrong"));
            } else {
                openKeyPanel.setKeyChangeRequested(false);
                openKeyPanel.setError(null);
            }
            openKeyPanel.setExtraDataUI(jComponent);
            Window window = PromptingKeyManager.getParentWindow();
            try {
                block6: {
                    Object object;
                    do {
                        openKeyPanel.setResourceID(promptingKeyProvider.getResourceID());
                        openKeyPanel.setFeedback(openKeyPanel.getError() != null ? this.getInvalidOpenKeyFeedback() : this.getUnknownOpenKeyFeedback());
                        int n = JOptionPane.showConfirmDialog(window, openKeyPanel, resources.getString("passwdDialog.title"), 2, 3);
                        if (n != 0) break block6;
                    } while ((object = openKeyPanel.getOpenKey()) == null);
                    promptingKeyProvider.setKey(object);
                    break block7;
                }
                promptingKeyProvider.setKey(null);
            }
            finally {
                PromptingKeyProviderUI.eventuallyDispose(window);
            }
        }
        return openKeyPanel.isKeyChangeRequested();
    }

    private static void eventuallyDispose(Window window) {
        if (!window.isShowing()) {
            window.dispose();
        }
    }

    private static synchronized void multiplexOnEDT(Runnable runnable) {
        try {
            EventQueue.invokeAndWaitUninterruptibly(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    private static abstract class BooleanRunnable
    implements Runnable {
        public boolean result;

        private BooleanRunnable() {
        }
    }
}

