/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.ChainableIOException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.tar.TarEntry;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.tar.TarOutputStream;

public class TarOutputArchive
extends TarOutputStream
implements OutputArchive {
    private final Map entries = new HashMap();
    private boolean busy;
    private final Map temps = new HashMap();
    private OutputArchiveMetaData metaData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarOutputArchive(OutputStream outputStream) {
        super(outputStream);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (TarEntry)this.entries.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        TarEntry tarEntry = (TarEntry)archiveEntry;
        if (archiveEntry2 instanceof TarEntry) {
            tarEntry.setSize(((TarEntry)archiveEntry2).getSize());
        }
        TarOutputArchive tarOutputArchive = this;
        synchronized (tarOutputArchive) {
            return this.createEntryOutputStream(tarEntry, archiveEntry2);
        }
    }

    protected boolean busy() {
        return this.busy;
    }

    protected OutputStream createEntryOutputStream(TarEntry tarEntry, ArchiveEntry archiveEntry) throws IOException {
        if (archiveEntry instanceof TarEntry && !this.busy()) {
            return new EntryOutputStream(tarEntry);
        }
        java.io.File file = java.io.File.createTempFile("tar", null);
        return new EntryTempOutputStream(tarEntry, file);
    }

    private synchronized void storeAllRemainingTempEntries() throws IOException {
        ChainableIOException chainableIOException = null;
        Iterator iterator = this.temps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TarEntry tarEntry = (TarEntry)entry.getKey();
            java.io.File file = (java.io.File)entry.getValue();
            try {
                this.storeTempEntry(tarEntry, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                chainableIOException = new ChainableIOException(chainableIOException, fileNotFoundException);
            }
            catch (InputIOException inputIOException) {
                chainableIOException = new ChainableIOException(chainableIOException, inputIOException);
            }
            catch (IOException iOException) {
                throw new ChainableIOException(chainableIOException, iOException);
            }
            iterator.remove();
        }
        if (chainableIOException != null) {
            throw chainableIOException.sortPriority();
        }
        if (!$assertionsDisabled && !this.temps.isEmpty()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storeTempEntry(TarEntry tarEntry, java.io.File file) throws IOException {
        if (!$assertionsDisabled && this.busy()) {
            throw new AssertionError();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                tarEntry.setSize(file.length());
                this.putNextEntry(tarEntry);
                try {
                    File.cat(fileInputStream, (OutputStream)((Object)this));
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public synchronized void storeDirectory(ArchiveEntry archiveEntry) throws IOException {
        this.putNextEntry((TarEntry)archiveEntry);
        this.entries.put(archiveEntry.getName(), archiveEntry);
        this.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.deleteAllRemainingTempEntries();
        }
    }

    private void deleteAllRemainingTempEntries() throws IOException {
        Iterator iterator = this.temps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            java.io.File file = (java.io.File)entry.getValue();
            if (!file.delete()) {
                file.deleteOnExit();
            }
            iterator.remove();
        }
        if (!$assertionsDisabled && !this.temps.isEmpty()) {
            throw new AssertionError();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData outputArchiveMetaData) {
        this.metaData = outputArchiveMetaData;
    }

    static {
        $assertionsDisabled = !TarOutputArchive.class.desiredAssertionStatus();
    }

    protected class EntryTempOutputStream
    extends FileOutputStream {
        private final TarEntry entry;
        private final java.io.File temp;

        public EntryTempOutputStream(TarEntry tarEntry, java.io.File file) throws IOException {
            super(file);
            this.entry = tarEntry;
            this.temp = file;
            TarOutputArchive.this.entries.put(tarEntry.getName(), tarEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            super.close();
            TarOutputArchive tarOutputArchive = TarOutputArchive.this;
            synchronized (tarOutputArchive) {
                TarOutputArchive.this.temps.put(this.entry, this.temp);
                if (!TarOutputArchive.this.busy()) {
                    TarOutputArchive.this.storeAllRemainingTempEntries();
                }
            }
        }
    }

    protected class EntryOutputStream
    extends FilterOutputStream {
        static final /* synthetic */ boolean $assertionsDisabled;

        public EntryOutputStream(TarEntry tarEntry) throws IOException {
            super((OutputStream)((Object)TarOutputArchive.this));
            if (!$assertionsDisabled && TarOutputArchive.this.busy()) {
                throw new AssertionError();
            }
            TarOutputArchive.this.putNextEntry(tarEntry);
            TarOutputArchive.this.busy = true;
            TarOutputArchive.this.entries.put(tarEntry.getName(), tarEntry);
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!$assertionsDisabled && this.out != TarOutputArchive.this) {
                throw new AssertionError();
            }
            TarOutputArchive tarOutputArchive = TarOutputArchive.this;
            synchronized (tarOutputArchive) {
                TarOutputArchive.this.busy = false;
                TarOutputArchive.this.closeEntry();
                TarOutputArchive.this.storeAllRemainingTempEntries();
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$tar$TarOutputArchive == null ? (class$de$schlichtherle$io$archive$tar$TarOutputArchive = TarOutputArchive.class$("de.schlichtherle.io.archive.tar.TarOutputArchive")) : class$de$schlichtherle$io$archive$tar$TarOutputArchive).desiredAssertionStatus();
        }
    }
}

