/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.util.ThreadLocalCounter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class OutputArchiveMetaData {
    private final OutputArchive outArchive;
    private final Map streams = new WeakHashMap();
    private final ThreadLocalCounter localThreadStreams = new ThreadLocalCounter();
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    OutputArchiveMetaData(OutputArchive outputArchive) {
        if (!$assertionsDisabled && outputArchive == null) {
            throw new AssertionError();
        }
        this.outArchive = outputArchive;
    }

    OutputStream getStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        OutputStream outputStream = this.outArchive.getOutputStream(archiveEntry, archiveEntry2);
        return new EntryOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStreams() {
        OutputArchive outputArchive = this.outArchive;
        synchronized (outputArchive) {
            return this.streams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitAllStreamsInOtherThreads() {
        OutputArchive outputArchive = this.outArchive;
        synchronized (outputArchive) {
            try {
                while (this.streams.size() - this.localThreadStreams.getCounter() > 0) {
                    this.outArchive.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArchiveException closeAllStreams(ArchiveException archiveException) {
        OutputArchive outputArchive = this.outArchive;
        synchronized (outputArchive) {
            Iterator iterator = this.streams.keySet().iterator();
            while (iterator.hasNext()) {
                EntryOutputStream entryOutputStream = (EntryOutputStream)iterator.next();
                try {
                    entryOutputStream.doClose();
                }
                catch (IOException iOException) {
                    archiveException = new ArchiveWarningException(archiveException, iOException);
                }
            }
            this.stopped = true;
            this.streams.clear();
            return archiveException;
        }
    }

    static {
        $assertionsDisabled = !OutputArchiveMetaData.class.desiredAssertionStatus();
    }

    private final class EntryOutputStream
    extends FilterOutputStream {
        private volatile boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryOutputStream(OutputStream outputStream) {
            super(outputStream);
            if (!$assertionsDisabled && outputStream == null) {
                throw new AssertionError();
            }
            OutputArchive outputArchive = OutputArchiveMetaData.this.outArchive;
            synchronized (outputArchive) {
                OutputArchiveMetaData.this.streams.put(this, OutputArchiveMetaData.this);
                OutputArchiveMetaData.this.localThreadStreams.increment();
                OutputArchiveMetaData.this.outArchive.notify();
            }
        }

        private final void ensureNotStopped() throws IOException {
            if (OutputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public void write(int n) throws IOException {
            this.ensureNotStopped();
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.ensureNotStopped();
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureNotStopped();
            this.out.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.ensureNotStopped();
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            OutputArchive outputArchive = OutputArchiveMetaData.this.outArchive;
            synchronized (outputArchive) {
                Object v = OutputArchiveMetaData.this.streams.remove(this);
                if (!$assertionsDisabled && v != OutputArchiveMetaData.this) {
                    throw new AssertionError();
                }
                OutputArchiveMetaData.this.localThreadStreams.decrement();
                OutputArchiveMetaData.this.outArchive.notify();
                this.doClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.out.flush();
            }
            finally {
                this.out.close();
            }
        }

        protected void finalize() throws IOException {
            this.doClose();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$OutputArchiveMetaData == null ? (class$de$schlichtherle$io$OutputArchiveMetaData = OutputArchiveMetaData.class$("de.schlichtherle.io.OutputArchiveMetaData")) : class$de$schlichtherle$io$OutputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

