/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.util.ThreadLocalCounter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class InputArchiveMetaData {
    private final InputArchive inArchive;
    private final Map streams = new WeakHashMap();
    private final ThreadLocalCounter localThreadStreams = new ThreadLocalCounter();
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    InputArchiveMetaData(InputArchive inputArchive) {
        if (!$assertionsDisabled && inputArchive == null) {
            throw new AssertionError();
        }
        this.inArchive = inputArchive;
    }

    InputStream getStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        InputStream inputStream = this.inArchive.getInputStream(archiveEntry, archiveEntry2);
        if (inputStream != null) {
            return new EntryInputStream(inputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStreams() {
        InputArchive inputArchive = this.inArchive;
        synchronized (inputArchive) {
            return this.streams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitAllStreamsInOtherThreads() {
        InputArchive inputArchive = this.inArchive;
        synchronized (inputArchive) {
            try {
                while (this.streams.size() - this.localThreadStreams.getCounter() > 0) {
                    this.inArchive.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArchiveException closeAllStreams(ArchiveException archiveException) {
        InputArchive inputArchive = this.inArchive;
        synchronized (inputArchive) {
            Iterator iterator = this.streams.keySet().iterator();
            while (iterator.hasNext()) {
                EntryInputStream entryInputStream = (EntryInputStream)iterator.next();
                try {
                    entryInputStream.doClose();
                }
                catch (IOException iOException) {
                    archiveException = new ArchiveWarningException(archiveException, iOException);
                }
            }
            this.stopped = true;
            this.streams.clear();
            return archiveException;
        }
    }

    static {
        $assertionsDisabled = !InputArchiveMetaData.class.desiredAssertionStatus();
    }

    private final class EntryInputStream
    extends FilterInputStream {
        private volatile boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryInputStream(InputStream inputStream) {
            super(inputStream);
            if (!$assertionsDisabled && inputStream == null) {
                throw new AssertionError();
            }
            InputArchive inputArchive = InputArchiveMetaData.this.inArchive;
            synchronized (inputArchive) {
                InputArchiveMetaData.this.streams.put(this, InputArchiveMetaData.this);
                InputArchiveMetaData.this.localThreadStreams.increment();
                InputArchiveMetaData.this.inArchive.notify();
            }
        }

        private final void ensureNotStopped() throws IOException {
            if (InputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public int read() throws IOException {
            this.ensureNotStopped();
            return this.in.read();
        }

        public int read(byte[] byArray) throws IOException {
            this.ensureNotStopped();
            return this.in.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureNotStopped();
            return this.in.read(byArray, n, n2);
        }

        public long skip(long l) throws IOException {
            this.ensureNotStopped();
            return this.in.skip(l);
        }

        public int available() throws IOException {
            this.ensureNotStopped();
            return this.in.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (this.closed) {
                return;
            }
            InputArchive inputArchive = InputArchiveMetaData.this.inArchive;
            synchronized (inputArchive) {
                Object v = InputArchiveMetaData.this.streams.remove(this);
                if (!$assertionsDisabled && v != InputArchiveMetaData.this) {
                    throw new AssertionError();
                }
                InputArchiveMetaData.this.localThreadStreams.decrement();
                InputArchiveMetaData.this.inArchive.notify();
                this.doClose();
            }
        }

        private void doClose() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.in.close();
        }

        public void reset() throws IOException {
            this.ensureNotStopped();
            this.in.reset();
        }

        protected void finalize() throws IOException {
            this.doClose();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$InputArchiveMetaData == null ? (class$de$schlichtherle$io$InputArchiveMetaData = InputArchiveMetaData.class$("de.schlichtherle.io.InputArchiveMetaData")) : class$de$schlichtherle$io$InputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

