/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.io.CipherReadOnlyFile;
import de.schlichtherle.crypto.io.raes.RAES;
import de.schlichtherle.crypto.io.raes.RaesAuthenticationException;
import de.schlichtherle.crypto.io.raes.RaesException;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesParametersAgent;
import de.schlichtherle.crypto.io.raes.RaesParametersException;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.io.raes.Type0RaesReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class RaesReadOnlyFile
extends CipherReadOnlyFile
implements RAES {
    static final int parseUByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    static final int parseUShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    static final long parseUInt(byte[] byArray, int n) {
        n += 3;
        long l = (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    public static RaesReadOnlyFile getInstance(File file, RaesParameters raesParameters) throws FileNotFoundException, RaesParametersException, RaesException, IOException {
        SimpleReadOnlyFile simpleReadOnlyFile = new SimpleReadOnlyFile(file);
        try {
            return RaesReadOnlyFile.getInstance(simpleReadOnlyFile, raesParameters);
        }
        catch (IOException iOException) {
            simpleReadOnlyFile.close();
            throw iOException;
        }
    }

    public static RaesReadOnlyFile getInstance(ReadOnlyFile readOnlyFile, RaesParameters raesParameters) throws FileNotFoundException, RaesParametersException, RaesException, IOException {
        byte[] byArray = new byte[5];
        readOnlyFile.seek(0L);
        readOnlyFile.readFully(byArray);
        if (RaesReadOnlyFile.parseUInt(byArray, 0) != 1397047634L) {
            throw new RaesException("No RAES signature!");
        }
        int n = RaesReadOnlyFile.parseUByte(byArray, 4);
        switch (n) {
            case 0: {
                raesParameters = RaesReadOnlyFile.getParameters(Type0RaesParameters.class, raesParameters);
                return new Type0RaesReadOnlyFile(readOnlyFile, (Type0RaesParameters)raesParameters);
            }
        }
        throw new RaesException("Unknown RAES type: " + n);
    }

    private static RaesParameters getParameters(Class clazz, RaesParameters raesParameters) throws RaesParametersException {
        if (raesParameters == null) {
            throw new RaesParametersException();
        }
        if (clazz.isAssignableFrom(raesParameters.getClass())) {
            return raesParameters;
        }
        if (raesParameters instanceof RaesParametersAgent) {
            return RaesReadOnlyFile.getParameters(clazz, ((RaesParametersAgent)raesParameters).getParameters(clazz));
        }
        throw new RaesParametersException();
    }

    RaesReadOnlyFile(ReadOnlyFile readOnlyFile) {
        super(readOnlyFile);
    }

    public abstract int getKeySizeBits();

    public abstract void authenticate() throws RaesAuthenticationException, IOException;
}

