/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.ConstOperator;
import jode.expr.Expression;
import jode.expr.Operator;
import jode.type.ArrayType;
import jode.type.Type;

public class ConstantArrayOperator
extends Operator {
    boolean isInitializer;
    ConstOperator empty;
    Type argType;

    public void updateSubTypes() {
        this.argType = this.type instanceof ArrayType ? Type.tSubType(((ArrayType)this.type).getElementType()) : Type.tError;
        int n = 0;
        while (n < this.subExpressions.length) {
            if (this.subExpressions[n] != null) {
                this.subExpressions[n].setType(this.argType);
            }
            ++n;
        }
    }

    public void updateType() {
    }

    public boolean setValue(int n, Expression expression) {
        if (n < 0 || n > this.subExpressions.length || this.subExpressions[n] != this.empty) {
            return false;
        }
        expression.setType(this.argType);
        this.setType(Type.tSuperType(Type.tArray(expression.getType())));
        this.subExpressions[n] = expression;
        expression.parent = this;
        expression.makeInitializer(this.argType);
        return true;
    }

    public int getPriority() {
        return 200;
    }

    public void makeInitializer(Type type) {
        if (type.getHint().isOfType(this.getType())) {
            this.isInitializer = true;
        }
    }

    public Expression simplify() {
        int n = 0;
        while (n < this.subExpressions.length) {
            if (this.subExpressions[n] != null) {
                this.subExpressions[n] = this.subExpressions[n].simplify();
            }
            ++n;
        }
        return this;
    }

    public void dumpExpression(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (!this.isInitializer) {
            tabbedPrintWriter.print("new ");
            tabbedPrintWriter.printType(this.type.getHint());
            tabbedPrintWriter.breakOp();
            tabbedPrintWriter.print(" ");
        }
        tabbedPrintWriter.print("{ ");
        tabbedPrintWriter.startOp(0, 0);
        int n = 0;
        while (n < this.subExpressions.length) {
            if (n > 0) {
                tabbedPrintWriter.print(", ");
                tabbedPrintWriter.breakOp();
            }
            if (this.subExpressions[n] != null) {
                this.subExpressions[n].dumpExpression(tabbedPrintWriter, 0);
            } else {
                this.empty.dumpExpression(tabbedPrintWriter, 0);
            }
            ++n;
        }
        tabbedPrintWriter.endOp();
        tabbedPrintWriter.print(" }");
    }

    public ConstantArrayOperator(Type type, int n) {
        super(type);
        Number number;
        Type type2 = this.argType = type instanceof ArrayType ? Type.tSubType(((ArrayType)type).getElementType()) : Type.tError;
        if (this.argType == Type.tError || this.argType.isOfType(Type.tUObject)) {
            number = null;
        } else if (this.argType.isOfType(Type.tBoolUInt)) {
            number = new Integer(0);
        } else if (this.argType.isOfType(Type.tLong)) {
            number = new Long(0L);
        } else if (this.argType.isOfType(Type.tFloat)) {
            number = new Float(0.0f);
        } else if (this.argType.isOfType(Type.tDouble)) {
            number = new Double(0.0);
        } else {
            throw new IllegalArgumentException("Illegal Type: " + this.argType);
        }
        this.empty = new ConstOperator(number);
        this.empty.setType(this.argType);
        this.empty.makeInitializer(this.argType);
        this.initOperands(n);
        int n2 = 0;
        while (n2 < this.subExpressions.length) {
            this.setSubExpressions(n2, this.empty);
            ++n2;
        }
    }
}

