/*
 * Decompiled with CFR 0.152.
 */
package sdoc.lexers.tokens;

import java.util.HashMap;
import java.util.Map;
import sdoc.lexers.tokens.Token;
import sdoc.lexers.tokens.ui.TokenUI;

public class TokenFactory {
    private static final Map uiMap = new HashMap();

    public static Token createToken(int type, String text) {
        TokenUI ui = (TokenUI)uiMap.get(new Integer(type));
        return TokenFactory.createToken(type, text, ui);
    }

    public static Token createToken(int type, String text, TokenUI ui) {
        Token t = new Token(text, type);
        if (ui != null) {
            t.setUI(ui);
        }
        return t;
    }

    public static Token createNullToken() {
        return new Token();
    }

    public static void setUIForType(int type, TokenUI ui) {
        uiMap.put(new Integer(type), ui);
    }

    public static void setUIForType(int[] types, TokenUI ui) {
        int i = 0;
        while (i < types.length) {
            uiMap.put(new Integer(types[i]), ui);
            ++i;
        }
    }

    public static TokenUI getUIForType(int type) {
        return (TokenUI)uiMap.get(new Integer(type));
    }

    public static void clearAllUIs() {
        uiMap.clear();
    }
}

