/*
 Violet - A program for editing UML diagrams.

 Copyright (C) 2007 Cay S. Horstmann (http://horstmann.com)
 Alexandre de Pellegrin (http://alexdp.free.fr);

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.horstmann.violet.framework.file.naming;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * A file filter that accepts all files with a given set of extensions.
 */
public class ExtensionFilter extends FileFilter
{


    /**
     * Constructs an extension file filter.
     * 
     * @param description the description (e.g. "Woozle files")
     * @param extensions the accepted extension(e.g.".woozle")
     */
    public ExtensionFilter(String description, String extension)
    {
        this.description = description;
        this.extension = extension;
    }

    public boolean accept(File f)
    {
        if (f.isDirectory()) return true;
        String fname = f.getName().toLowerCase();
        if (fname.endsWith(extension.toLowerCase())) return true;
        return false;
    }

    public String getDescription()
    {
        return description;
    }

    public String getExtension()
    {
        return extension;
    }

    private String description;
    private String extension;
}
