MODULE SpokeLength2;

  IMPORT 
        RTS,
        CPJ,
	Console, 
        (* java_net, *)         (* java.net *) 
	java_awt, 		(* java.awt *)
	java_lang,		(* java.lang *)
	java_applet,		(* java.applet *)
	java_awt_event,		(* java.awt.event *)
	java_awt_image;		(* java.awt.image *)


(* ==================================================================== *)

  TYPE	Message   = ARRAY 80 OF CHAR;

(* ==================================================================== *)

  TYPE
	WheelDims* = RECORD
(*
 *		      spokeNum : INTEGER;
 *		      crossNum : INTEGER;
 *)
		      angle    : INTEGER;
		      rimDiam  : REAL;
		      flgDiam  : REAL;
		      flgOfst  : REAL;
		      nipProt  : REAL;
		      nipLeng  : REAL;
		    END;

(* ==================================================================== *)

  TYPE
	Canvas*     = POINTER TO RECORD
			(java_awt.Canvas)
			disp : java_awt.Rectangle;
			imag : java_awt.Image;
			warn : Message;
			rslt : Message;
			dims : WheelDims;
			theFont : java_awt.Font;
		      END;

(* ==================================================================== *)

  TYPE
	Controls*    = POINTER TO RECORD
			(java_awt.Panel + 
			 java_awt_event.ActionListener + 
			 java_awt_event.ItemListener)
			canvas  : Canvas;
			rimD    : java_awt.TextField;
			flangeD : java_awt.TextField;
			spokeN  : java_awt.TextField;
			angleN  : java_awt.TextField;
			offsetL : java_awt.TextField;
			protruL : java_awt.TextField;
			proLLab : java_awt.Label;
			nippleL : java_awt.TextField;
			nipLLab : java_awt.Label;
			checkE  : java_awt.Checkbox;
			checkI  : java_awt.Checkbox;
		      END;

(* ==================================================================== *)

  TYPE
	Applet*     = POINTER TO RECORD
			(java_applet.Applet)
			controls : Controls;
		      END;

(* ==================================================================== *)
(* 			Some static helper procedures			*)
(* ==================================================================== *)

  PROCEDURE MkButton(IN s : ARRAY OF CHAR) : java_awt.Button;
  BEGIN
    RETURN java_awt.Button.Init(MKSTR(s));
  END MkButton;

  PROCEDURE MkLabel(IN s : ARRAY OF CHAR; j : INTEGER) : java_awt.Label;
  BEGIN
    RETURN java_awt.Label.Init(MKSTR(s), j);
  END MkLabel;

  PROCEDURE MkTextField(IN s : ARRAY OF CHAR; j : INTEGER) : java_awt.TextField;
  BEGIN
    RETURN java_awt.TextField.Init(MKSTR(s), j);
  END MkTextField;

  PROCEDURE RoundToOneDigit(num : REAL; OUT res : Message);
    VAR str : java_lang.String;
	buf : java_lang.StringBuffer;
  BEGIN
    str := java_lang.String.valueOf(SHORT(ENTIER(num * 10.0 + 0.5)));
    buf := java_lang.StringBuffer.Init(str);
    buf := buf.insert(buf.length()-1, CHR(ORD(".")));
    buf.getChars(0, buf.length(), res, 0);
  END RoundToOneDigit;

(* ==================================================================== *)

  PROCEDURE (IN d : WheelDims)ValidateDimensions(OUT msg : Message),NEW;
  BEGIN (* Check for bad format input *)
    IF d.rimDiam < 0.0 THEN
      msg := "Invalid number format in rim diameter";
    ELSIF d.flgDiam < 0.0 THEN
      msg := "Invalid number format in flange diameter";
(*
 *  ELSIF d.spokeNum = -1 THEN
 *    msg := "Invalid number format in spoke number";
 *)
    ELSIF d.angle = -1 THEN
      msg := "Invalid number format in spoke angle";
    ELSIF d.flgOfst = -1 THEN
      msg := "Invalid number format in flange offset length";
    ELSIF d.nipProt = -1 THEN
      msg := "Invalid number format in nipple protrusion length";
    ELSIF d.nipLeng = -1 THEN
      msg := "Invalid number format in nipple overall length";
    ELSIF d.nipProt > d.nipLeng THEN
      msg := "Nipple cannot protrude more than overall length";
(*
 *  ELSIF d.spokeNum MOD 2 # 0 THEN
 *    msg := "Number of spokes must be even";
 *  ELSIF (d.spokeNum MOD 4 # 0) & (d.crossNum # 0) THEN
 *    msg := "Spoke-num must divide by four unless spoking is radial";
 *)
    ELSIF (d.rimDiam > 620) OR (d.rimDiam < 450) THEN
      msg := "Unusual rim diameter: are you sure?";
    ELSIF (d.flgDiam > 70) OR (d.flgDiam < 25) THEN
      msg := "Unusual flange diameter: are you sure?";
    ELSIF (d.flgOfst > 40) OR (d.flgOfst < 15) THEN
      msg := "Unusual flange offset: are you sure?";
(*
 *  ELSIF (d.crossNum > d.spokeNum DIV 8) THEN
 *    msg := "Crossings too high: worse than tangential";
 *)
    ELSIF (d.angle > 90) THEN
      msg := "Angle too high: worse than tangential";
    ELSIF (d.nipLeng = 0.0) & (d.nipProt = 0.0) THEN
      msg := "";	(* text fields must be disabled *)
(*
 *  ELSIF (d.nipLeng = 0.0) & (d.nipProt = 0.0) THEN
 *    msg := '"Rim inside diameter" interpreted as effective rim diam.';
 *)
    ELSIF (d.nipLeng > 15) OR (d.nipLeng < 8) THEN
      msg := "Unusual nipple length: are you sure?";
    ELSIF d.nipProt < 5 THEN
      msg := "Very short nipple protrusion: are you sure?";
    ELSE
      msg := "";
    END;
  END ValidateDimensions;

(* ==================================================================== *)

  PROCEDURE (c : Canvas)paint*(g : java_awt.Graphics);
    VAR j : BOOLEAN;
	m : Message;
  BEGIN
    c.disp := c.getBounds();
    g.setColor(java_awt.Color.white);
    g.fillRect(c.disp.x, c.disp.y, c.disp.width, c.disp.height);
    j := g.drawImage(c.imag, 0,0, c(java_awt_image.ImageObserver));
    g.setFont(c.theFont);
    IF c.warn[0] # 0X THEN
      g.setColor(java_awt.Color.red);
      m := "WARNING: " + c.warn;
      g.drawString(MKSTR(m), 50, 330);
(*
 *    g.drawString(MKSTR(m), 0, 280);
 *)
    END;
    IF c.rslt[0] # 0X THEN
      g.setColor(java_awt.Color.black);
      m := "SPOKE LENGTH: " + c.rslt + "mm";
      g.drawString(MKSTR(m), 50, 300);
(*
 *    g.drawString(MKSTR(m), 300, 50);
 *)
    END;
  END paint;

  PROCEDURE (c : Canvas)compute(),NEW;
    VAR theta,efctv,xDiff,yDiff,length : REAL;
  BEGIN
    c.dims.ValidateDimensions(c.warn);
    efctv := c.dims.rimDiam + 2.0 * (c.dims.nipLeng - c.dims.nipProt);
(*
 * This is the theta calculation for SpokeLength
 *  theta := 4.0 * java_lang.Math.PI * c.dims.crossNum / c.dims.spokeNum;
 *)
(*
 * While this is the one for SpokeLength2
 *)
    theta := java_lang.Math.PI * c.dims.angle / 180.0;
(*
 *)
    xDiff := (efctv - c.dims.flgDiam * java_lang.Math.cos(theta)) / 2.0;
    yDiff := c.dims.flgDiam * java_lang.Math.sin(theta) / 2.0;
    length := java_lang.Math.sqrt(c.dims.flgOfst * c.dims.flgOfst +
				xDiff * xDiff + yDiff * yDiff);
    length := length - 1.0; (* adjust for spoke diameter = 2mm *)
    RoundToOneDigit(length, c.rslt);
    c.repaint();
  END compute;

(* ==================================================================== *)

  PROCEDURE (p : Controls)initialize(canvas : Canvas),NEW;
    VAR buttn : java_awt.Button; 
	comp1, comp2 : java_awt.Component;
  BEGIN
    p.canvas := canvas;
    p.setLayout(java_awt.GridLayout.Init(4,4)(java_awt.LayoutManager));

    buttn := MkButton("COMPUTE-LENGTH");
    p.add(buttn, NIL);

    p.checkE := java_awt.Checkbox.Init("Effective rim diam.", FALSE);
    p.checkI := java_awt.Checkbox.Init("Inside rim diam. mm", TRUE);
    p.add(p.checkE, NIL);
    p.add(p.checkI, NIL);

    p.rimD := MkTextField("600",6);
    p.add(p.rimD, NIL);

    comp1     := MkLabel("Flange offset B: mm", java_awt.Label.RIGHT);
    p.offsetL := MkTextField("35.5",6);
    p.add(comp1, NIL);
    p.add(p.offsetL, NIL);

    comp1     := MkLabel("Flange pitch diam C: mm", java_awt.Label.RIGHT);
    p.flangeD := MkTextField("38",6);
    p.add(comp1, NIL);
    p.add(p.flangeD, NIL);

    p.nipLLab := MkLabel("Nipple length D: mm", java_awt.Label.RIGHT);
    p.nippleL := MkTextField("13",6);
    p.add(p.nipLLab, NIL);
    p.add(p.nippleL, NIL);

    p.proLLab := MkLabel("Nipple protrusion E: mm", java_awt.Label.RIGHT);
    p.protruL := MkTextField("9",6);
    p.add(p.proLLab, NIL);
    p.add(p.protruL, NIL);

(*
 *  comp1    := MkLabel("Number of spokes ", java_awt.Label.RIGHT);
 *  p.spokeN := MkTextField("32",6);
 *  p.add(comp1, NIL);
 *  p.add(p.spokeN, NIL);
 *)
    comp1    := MkLabel("Spoke angle T: degrees", java_awt.Label.RIGHT);
    p.angleN := MkTextField("0",6);
    p.add(comp1, NIL);
    p.add(p.angleN, NIL);

    buttn.addActionListener(p(java_awt_event.ActionListener));
    p.checkE.addItemListener(p(java_awt_event.ItemListener));
    p.checkI.addItemListener(p(java_awt_event.ItemListener));
  END initialize;

(* ==================================================================== *)

  PROCEDURE (p : Controls)actionPerformed*(e : java_awt_event.ActionEvent),NEW;
    VAR isOk : BOOLEAN;
  BEGIN
(*
    Console.WriteString("Action event registered: "); Console.WriteLn;
 *)
    RTS.StrToReal(p.rimD.getText(), p.canvas.dims.rimDiam, isOk);
    IF ~isOk THEN p.canvas.dims.rimDiam := -1.0 END;

    RTS.StrToReal(p.flangeD.getText(), p.canvas.dims.flgDiam, isOk);
    IF ~isOk THEN p.canvas.dims.flgDiam := -1.0 END;

    RTS.StrToReal(p.offsetL.getText(), p.canvas.dims.flgOfst, isOk);
    IF ~isOk THEN p.canvas.dims.flgOfst := -1.0 END;

    IF p.protruL.isEnabled() THEN
      RTS.StrToReal(p.protruL.getText(), p.canvas.dims.nipProt, isOk);
      IF ~isOk THEN p.canvas.dims.nipProt := -1.0 END;
    ELSE
      p.canvas.dims.nipProt := 0.0;
    END;

    IF p.nippleL.isEnabled() THEN
      RTS.StrToReal(p.nippleL.getText(), p.canvas.dims.nipLeng, isOk);
      IF ~isOk THEN p.canvas.dims.nipLeng := -1.0 END;
    ELSE
      p.canvas.dims.nipLeng := 0.0;
    END;
(*
 *  RTS.StrToInt(p.spokeN.getText(), p.canvas.dims.spokeNum, isOk);
 *  IF ~isOk THEN p.canvas.dims.spokeNum := -1 END;
 *)
    RTS.StrToInt(p.angleN.getText(), p.canvas.dims.angle, isOk);
    IF ~isOk THEN p.canvas.dims.angle := -1 END;

    p.canvas.compute(); 
  END actionPerformed;

(* ==================================================================== *)

  PROCEDURE (p : Controls)itemStateChanged*(e : java_awt_event.ItemEvent),NEW; 
    VAR str : java_lang.String;
	eOn : BOOLEAN;
  BEGIN
(*
 *  Console.WriteString("Item state changed: "); Console.WriteLn;
 *)
    str := e.getItem()(java_lang.String);
    IF str.equals(p.checkE.getLabel()) THEN
       eOn := TRUE;
       p.checkE.setState(TRUE);
       p.checkI.setState(FALSE);
    ELSE	(* must be checkI *)
       eOn := FALSE;
       p.checkI.setState(TRUE);
       p.checkE.setState(FALSE);
    END;
(*
 *  Console.WriteString("New item state: ");
 *  IF eOn THEN Console.WriteString("eOn is TRUE");
 *  ELSE Console.WriteString("eOn is FALSE"); END;
 *  Console.WriteLn;
 *)
    p.nipLLab.setEnabled(~eOn);
    p.proLLab.setEnabled(~eOn);
    p.nippleL.setEnabled(~eOn);
    p.protruL.setEnabled(~eOn);
  END itemStateChanged;

(* ==================================================================== *)

  PROCEDURE (thisApp : Applet)init*();	(* overrides JApplet.init() *)
    VAR tmpCan : Canvas;
  BEGIN
    thisApp.setLayout(java_awt.BorderLayout.Init()(java_awt.LayoutManager));
    NEW(tmpCan);
    tmpCan.imag := 
	thisApp.getImage(thisApp.getCodeBase(), 
                               "spokegif.gif");
(*
                               "spokegif.jpg");
 *                             "CP/SpokeLength/spoke.gif");
 *)
    NEW(thisApp.controls);
    thisApp.controls.canvas := tmpCan;
    thisApp.controls.initialize(tmpCan);
    thisApp.controls.canvas.theFont := 
		java_awt.Font.Init("TimesRoman", java_awt.Font.PLAIN, 20);
     thisApp.add(tmpCan, "Center");
     thisApp.add(thisApp.controls, "South");
  END init;

  PROCEDURE (thisApp : Applet)start*();	(* overrides JApplet.start() *)
  BEGIN
    thisApp.controls.setEnabled(TRUE);
  END start;

  PROCEDURE (thisApp : Applet)stop*();	(* overrides JApplet.stop() *)
  BEGIN
    thisApp.controls.setEnabled(FALSE);
  END stop;

(* ==================================================================== *)

BEGIN
END SpokeLength2.
