
import JavaDive.*;

/**
 * 	[En]	JavaDive tester		[En]
 * 	[Ru]	஢ઠ JavaDive	[Ru]
 */

public final class Tester extends java.applet.Applet
{

/**
 * 	[En]	JavaDive tester		[En]
 * 	[Ru]	஢ઠ JavaDive	[Ru]
 */

public static void main( String args[] )
{
	System.out.print( "\n" );
	System.out.println( "" );

	System.out.println( "Initializing the Java to C interface..." );
	try
	{
		Java2C.queueIsEmpty( 0x00 );
	}	
	catch( Exception error )
	{
		System.out.println( " ******** Unable to load Java2C.dll *********" );
		System.out.println( "*** Check the LIBPATH environment variable ***" );
		
		return;
	}
	System.out.println( "Java2C is loaded!" );

	sleep( 500 );
	System.out.println( "" );
	System.out.println( "Checking the OS/2 data queues..." );

	System.out.println( "  creating the queue..." );
	int queueHandle = Java2C.createQueue();
	System.out.println( "  the queue handle is: 0x" + Integer.toHexString( queueHandle ).toUpperCase() );

	sleep( 500 );
	int integerValue = 1234567;
	System.out.println( "  writing an integer value: " + integerValue );
	Java2C.writeInteger( queueHandle, integerValue );

	sleep( 500 );
	double floatValue = 0.01;
	System.out.println( "  writing a float value: " + floatValue );
	Java2C.writeFloat( queueHandle, 1, 100 );

	sleep( 500 );
	String string = "Serg was here :-)";
	System.out.println( "  writing a string: \"" + string + "\"" );
	Java2C.writeString( queueHandle, string );

	sleep( 500 );	
	System.out.println( "  reading first value..." );
	integerValue = 0; integerValue = Java2C.readInteger( queueHandle );
	sleep( 500 );
	System.out.println( "  the value from queue is: " + integerValue );

	sleep( 500 );	
	System.out.println( "  reading second value..." );
	floatValue = 0; floatValue = Java2C.readFloat( queueHandle );
	sleep( 500 );
	System.out.println( "  the value from queue is: " + floatValue );	

	sleep( 500 );	
	System.out.println( "  reading third value..." );
	string = ""; string = Java2C.readString( queueHandle );
	sleep( 500 );
	System.out.println( "  the value from queue is: \"" + string + "\"" );

	System.out.println( "" );
	System.out.println( "Java2C methods are tested!" );

	sleep( 1000 );
	System.out.print( "\n" );
	System.out.println( "" );
	System.out.println( "Initializing the JavaDive..." );
	try
	{
		Dive.inp( Ports.Speaker );
	}	
	catch( Exception error )
	{
		System.out.println( "*** Unable to load JavaDive.dll and Iopl32.dll ***" );
		System.out.println( "*** Check the LIBPATH environment variable ***" );
		
		return;
	}
	System.out.println( "All correct!" );
	
	sleep( 500 );
	System.out.println( "" );
	System.out.println( "Checking the PC Speaker..." );

	sleep( 500 );
	System.out.println( "  reading data from port 0x61..." );	
	int bits = Dive.inp( Ports.Speaker );
	sleep( 500 );
	System.out.println( "  the port content is: " + Integer.toBinaryString( bits ) );

	sleep( 500 );
	System.out.println( "  enjoy the music :-)" );
	long time = System.currentTimeMillis();
	long currentTime = time + 1;
	while( currentTime > time && currentTime - time < 5000 )
	{
		Dive.outp( Ports.Speaker, bits | 3 );			for( int delay = 0; delay < 10000; delay ++ ) {}
		Dive.outp( Ports.Speaker, bits &= 0xFC );	for( int delay = 0; delay < 10000; delay ++ ) {}

		currentTime = System.currentTimeMillis();
	}

	sleep( 500 );
	System.out.println( "  restoring port 0x61" );
	Dive.outp( Ports.Speaker, bits );
	
	sleep( 1000 );
	System.out.println( "" );
	System.out.println( "Writing 0xFF to the COM ports..." );

	System.out.print( " " );
	for( int count = 0; count < 10; count ++ )
	{
		Dive.outp( Ports.COM1, 0xFF ); Dive.outp( Ports.COM2, 0xFF );
		Dive.outp( Ports.COM3, 0xFF ); Dive.outp( Ports.COM4, 0xFF );

		System.out.print( "" ); sleep( 100 );
	}	
	System.out.print( "\n" );

	System.out.println( "" );
	System.out.println( "All done!" );
}

static void sleep( int delay )
{
	try { Thread.currentThread().sleep( delay ); } catch( InterruptedException signal ) { }
}
}
