/**
 *
 *         (C) Sergey Posokhov - Advanced Java to C interface.
 *
 */

#include "Java2C.h"

#define MARKER_OF_INTEGER   ( (ULONG) 'i')
#define MARKER_OF_FLOAT     ( (ULONG) 'f')
#define MARKER_OF_STRING    ( (ULONG) 'S')

/*
 #define PRINT_DEBUG_MESSAGES
 #define APPLET_HAB_IS_REQUIRED
*/

VOID EXPENTRY SystemOutPrintln( PCHAR English_message, PCHAR Russian_message )
{
 ULONG Code_page = 0; ULONG Size_of_list = 0;
 DosQueryCp( sizeof( Code_page ), &Code_page, &Size_of_list );

 if( Code_page == RUSSIAN ) fprintf( stderr, "%s\n", Russian_message );
 else fprintf( stderr, "%s\n", English_message );
}

                                         /*  */

INT EXPENTRY J2CConvertToInteger( PJAVALONG Value ) { return Value->lo; }

HANDLE EXPENTRY J2CConvertToHandle( PJAVALONG Value ) { return Value->lo; }

FLOAT EXPENTRY J2CConvertToFloat( PJAVALONG Float_value )
{
 FLOAT Value = (FLOAT) Float_value->lo;
 FLOAT Divider = (FLOAT) Float_value->hi;

 return Value / Divider;
}

                                         /*  */

INT EXPENTRY J2CCreateQueue( VOID )
{
 while( 1 )
  {
   DATETIME Time = { 0, 0, 0, 0, 0, 0, 0, 0, 0 }; DosGetDateTime( &Time );
   INT Queue_number = Time.hours * Time.minutes * Time.seconds * Time.hundredths * Time.year * Time.month * Time.day;

   CHAR Name[ 50 ] = "\\Queues\\Java2C\\";
   itoa( Queue_number, &Name[ strlen( Name ) ], 16 ); strcat( Name, ".queue" );

   HQUEUE Queue = NULLHANDLE;
   APIRET Report = DosCreateQueue( &Queue, QUE_FIFO, Name );

   if( Report == ERROR_QUE_DUPLICATE )
    {
     DosSleep( 50 ); continue;
    }

   if( Report != NO_ERROR )
    {
     CHAR English_message[] = "Java2C: Unable to create a queue.";
     CHAR Russian_message[] = "Java2C: ।  뫠 ᮧ.";
     SystemOutPrintln( English_message, Russian_message );

     return 0;
    }
   else
    {
     #ifdef PRINT_DEBUG_MESSAGES
     CHAR English_message[ 50 ] = "Java2C: The name of queue is: "; strcat( English_message, Name );
     CHAR Russian_message[ 50 ] = "Java2C:  ।: "; strcat( Russian_message, Name );
     SystemOutPrintln( English_message, Russian_message );
     #endif

     return Queue;
    }
  }
}

JAVAINT EXPENTRY Java_JavaDive_Java2C_createQueue( PVOID This )
{
 return J2CCreateQueue();
}

VOID EXPENTRY J2CDeleteQueue( HQUEUE Queue )
{
 APIRET Report = DosCloseQueue( Queue );

 #ifdef PRINT_DEBUG_MESSAGES
 if( Report == NO_ERROR )
  {
   CHAR English_message[] = "Java2C: Empty queue is deleted.";
   CHAR Russian_message[] = "Java2C:  । 㤠.";
   SystemOutPrintln( English_message, Russian_message );
  }
 #endif
}

VOID EXPENTRY Java_JavaDive_Java2C_deleteQueue( PVOID This, JAVALONG Queue_handle )
{
 J2CDeleteQueue( J2CConvertToHandle( &Queue_handle ) );
}

INT EXPENTRY J2CQueueIsEmpty( HQUEUE Queue )
{
 ULONG Elements = 0; DosQueryQueue( Queue, &Elements );

 if( !Elements ) return 1; else return 0;
}

JAVABOOLEAN EXPENTRY Java_JavaDive_Java2C_queueIsEmpty( PVOID This, JAVALONG Queue_handle )
{
 return J2CQueueIsEmpty( J2CConvertToHandle( &Queue_handle ) );
}

                                         /*  */

VOID J2CWrite( HQUEUE Queue, ULONG Data )
{
 BYTE Empty_space = 0; ULONG Length = sizeof( BYTE );
 APIRET Report = DosWriteQueue( Queue, Data, Length, &Empty_space, 0 );

 #ifdef PRINT_DEBUG_MESSAGES
 if( Report != NO_ERROR )
  {
   CHAR English_message[] = "Java2C: Unable to write a data to a queue.";
   CHAR Russian_message[] = "Java2C:   뫨   ।.";
   SystemOutPrintln( English_message, Russian_message );
  }
 #endif
}

VOID EXPENTRY J2CWriteInteger( HQUEUE Queue, INT Value )
{
 J2CWrite( Queue, MARKER_OF_INTEGER );
 J2CWrite( Queue, Value );
}

VOID EXPENTRY Java_JavaDive_Java2C_writeInteger( PVOID This, JAVALONG Queue_handle, JAVALONG Value )
{
 J2CWriteInteger( J2CConvertToHandle( &Queue_handle ), J2CConvertToInteger( &Value ) );
}

VOID EXPENTRY J2CWriteFloat( HQUEUE Queue, INT Value, INT Divider )
{
 J2CWrite( Queue, MARKER_OF_FLOAT );
 J2CWrite( Queue, Value );
 J2CWrite( Queue, Divider );
}

VOID EXPENTRY Java_JavaDive_Java2C_writeFloat( PVOID This, JAVALONG Queue_handle, JAVALONG Value, JAVALONG Divider )
{
 J2CWriteFloat( J2CConvertToHandle( &Queue_handle ), J2CConvertToInteger( &Value ), J2CConvertToInteger( &Divider ) );
}

VOID EXPENTRY J2CWriteString( HQUEUE Queue, PCHAR String )
{
 J2CWrite( Queue, MARKER_OF_STRING );
 for( INT Count = 0; Count < strlen( String ); Count ++ ) J2CWrite( Queue, String[ Count ] );
 J2CWrite( Queue, 0 );
}

VOID EXPENTRY Java_JavaDive_Java2C_writeSMarker( PVOID This, JAVALONG Queue_handle )
{
 J2CWrite( J2CConvertToHandle( &Queue_handle ), MARKER_OF_STRING );
}

VOID EXPENTRY Java_JavaDive_Java2C_writeSCharacter( PVOID This, JAVALONG Queue_handle, JAVALONG Character )
{
 J2CWrite( J2CConvertToHandle( &Queue_handle ), J2CConvertToInteger( &Character ) );
}

                                         /*  */

ULONG J2CRead( HQUEUE Queue )
{
 if( J2CQueueIsEmpty( Queue ) ) { J2CDeleteQueue( Queue ); return 0; }

 REQUESTDATA Request = { 0, 0 };
 BYTE Empty_space = 0; ULONG Length = sizeof( BYTE ); PBYTE Pointer = &Empty_space; BYTE Priority = 0;
 APIRET Report = DosReadQueue( Queue, &Request, &Length, (PPVOID) &Pointer, 0, DCWW_WAIT, &Priority, NULLHANDLE );

 #ifdef PRINT_DEBUG_MESSAGES
 if( Report != NO_ERROR )
  {
   CHAR English_message[] = "Java2C: Unable to read a data from a queue.";
   CHAR Russian_message[] = "Java2C:   뫨 祭  ।.";
   SystemOutPrintln( English_message, Russian_message );
  }
 #endif

 if( J2CQueueIsEmpty( Queue ) ) J2CDeleteQueue( Queue );

 return Request.ulData;
}

INT EXPENTRY J2CReadInteger( HQUEUE Queue )
{
 ULONG Marker = J2CRead( Queue );

 if( Marker != MARKER_OF_INTEGER )
  {
   CHAR English_message[] = "Java2C: A value from queue is not an integer.";
   CHAR Russian_message[] = "Java2C: 祭  । -  楫 ᫮.";
   SystemOutPrintln( English_message, Russian_message );

   return 0;
  }

 return J2CRead( Queue );
}

JAVAINT EXPENTRY Java_JavaDive_Java2C_readInteger( PVOID This, JAVALONG Queue_handle )
{
 return J2CReadInteger( J2CConvertToHandle( &Queue_handle ) );
}

FLOAT EXPENTRY J2CReadFloat( HQUEUE Queue )
{
 ULONG Marker = J2CRead( Queue );

 if( Marker != MARKER_OF_FLOAT )
  {
   CHAR English_message[] = "Java2C: A value from queue is not a float.";
   CHAR Russian_message[] = "Java2C: 祭  । -  ᫮  窮.";
   SystemOutPrintln( English_message, Russian_message );

   return 0;
  }

 FLOAT Value = (FLOAT) J2CRead( Queue );
 FLOAT Divider = (FLOAT) J2CRead( Queue );

 return Value / Divider;
}

JAVAINT EXPENTRY Java_JavaDive_Java2C_readFValue( PVOID This, JAVALONG Queue_handle )
{
 HQUEUE Queue = J2CConvertToHandle( &Queue_handle );

 ULONG Marker = J2CRead( Queue );

 if( Marker != MARKER_OF_FLOAT )
  {
   CHAR English_message[] = "Java2C: A value from queue is not a float.";
   CHAR Russian_message[] = "Java2C: 祭  । -  ᫮  窮.";
   SystemOutPrintln( English_message, Russian_message );

   return 0;
  }

 return J2CRead( Queue );
}

JAVAINT EXPENTRY Java_JavaDive_Java2C_readFDivider( PVOID This, JAVALONG Queue_handle )
{
 return J2CRead( J2CConvertToHandle( &Queue_handle ) );
}

VOID EXPENTRY J2CReadString( HQUEUE Queue, PCHAR String )
{
 String[ 0 ] = 0;

 ULONG Marker = J2CRead( Queue );

 if( Marker != MARKER_OF_STRING )
  {
   CHAR English_message[] = "Java2C: A value from queue is not a string.";
   CHAR Russian_message[] = "Java2C: 祭  । -  ப.";
   SystemOutPrintln( English_message, Russian_message );

   return;
  }

 INT Count = 0;
 while( 1 )
  {
   CHAR Value = (CHAR) J2CRead( Queue );
   String[ Count ] = Value; if( Value == 0 ) return;

   Count ++;
  }
}

JAVABOOLEAN EXPENTRY Java_JavaDive_Java2C_readSMarker( PVOID This, JAVALONG Queue_handle )
{
 ULONG Marker = J2CRead( J2CConvertToHandle( &Queue_handle ) );

 if( Marker != MARKER_OF_STRING )
  {
   CHAR English_message[] = "Java2C: A value from queue is not a string.";
   CHAR Russian_message[] = "Java2C: 祭  । -  ப.";
   SystemOutPrintln( English_message, Russian_message );

   return 0;
  }

 return 1;
}

JAVAINT EXPENTRY Java_JavaDive_Java2C_readSCharacter( PVOID This, JAVALONG Queue_handle )
{
 return J2CRead( J2CConvertToHandle( &Queue_handle ) );
}

                                         /*  */

#ifdef APPLET_HAB_IS_REQUIRED
HAB J2CQueryAppletAnchorBlock( VOID )
{
 HENUM Enumeration = WinBeginEnumWindows( HWND_DESKTOP ); HWND Window = NULLHANDLE;
 while( ( Window = WinGetNextWindow( Enumeration ) ) != NULLHANDLE )
  {
   HWND Client_window = WinWindowFromID( Window, FID_CLIENT );
   if( Client_window != NULLHANDLE )
    {
     CHAR Client_name[ 15 ] = ""; WinQueryClassName( Client_window, 15, Client_name );

     if( Client_name[ 0 ] == 'a' && Client_name[ 1 ] == 'w' && Client_name[ 2 ] == 't' )
      {
       WinEndEnumWindows( Enumeration );

       return( WinQueryAnchorBlock( Window ) );
      }
    }
  }
 WinEndEnumWindows( Enumeration );

 return NULLHANDLE;
}
#endif
