// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: ObjectPasserUI.java,v 1.1 2003/10/31 05:03:53 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/**
 * This class represents the Object Passing Demo.
 * This class will pass a DataObject back and forth between two hosts
 * running this demo.  As each host receives the serialized object, it will 
 * deserialize it, run the counter increment method, append it's execution 
 * to the log, and pass it back to the previous host.
 * @author Brad Barclay
 * @version 1.0
 * 
 */
public class ObjectPasserUI extends java.awt.Frame implements java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.WindowListener {
	private AboutBox ivjAboutBox = null;
	private java.awt.Panel ivjbuttonPanel = null;
	private java.awt.GridLayout ivjbuttonPanelGridLayout = null;
	private java.awt.Checkbox ivjCheckbox1 = null;
	private java.awt.Checkbox ivjCheckbox2 = null;
	private CommSettingsPanel ivjCommSettingsPanel1 = null;
	private java.awt.Panel ivjConfigPanel = null;
	private java.awt.Label ivjcountLabel = null;
	private java.awt.CheckboxGroup ivjcsGroup = null;
	private java.awt.Panel ivjdataArea = null;
	private java.awt.TextField ivjhostNameField = null;
	private java.awt.Panel ivjInfoPanel = null;
	private java.awt.Label ivjLabel1 = null;
	private java.awt.Label ivjLabel2 = null;
	private java.awt.Label ivjLabel3 = null;
	private java.awt.TextArea ivjlogArea = null;
	private java.awt.MenuItem ivjmainRetItem = null;
	private java.awt.MenuItem ivjMenuItem1 = null;
	private java.awt.MenuItem ivjMenuItem2 = null;
	private java.awt.MenuItem ivjMenuItem3 = null;
	private java.awt.MenuBar ivjObjectPasserUIMenuBar = null;
	private java.awt.Menu ivjopMenu = null;
	private java.awt.Panel ivjPanel1 = null;
	private java.awt.Panel ivjPanel2 = null;
	private java.awt.Panel ivjPanel3 = null;
	private java.awt.Choice ivjpassChoice = null;
	private java.awt.Button ivjStartButton = null;
	private java.awt.Button ivjStopButton = null;

/**
 * Creates a new default ObjectPasserUI Object.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public ObjectPasserUI() {
	super();
	initialize();
}

/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getStartButton()) ) {
		conn7(e);
	}
	if ((e.getSource() == getMenuItem3()) ) {
		conn19(e);
	}
	if ((e.getSource() == getmainRetItem()) ) {
		conn20(e);
	}
	if ((e.getSource() == getStartButton()) ) {
		conn25(e);
	}
	if ((e.getSource() == getMenuItem2()) ) {
		conn32(e);
	}
	if ((e.getSource() == getStartButton()) ) {
		conn31(e);
	}
	if ((e.getSource() == getStopButton()) ) {
		conn42(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * conn0:  (ObjectPasserUI.window.windowClosing(java.awt.event.WindowEvent) --> ObjectPasserUI.dispose())
 * @param arg1 java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn0(java.awt.event.WindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn11SetTarget:  (csGroup.this <--> Checkbox1.checkboxGroup)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn11SetTarget() {
	/* Set the target from the source */
	try {
		getCheckbox1().setCheckboxGroup(getcsGroup());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn12SetTarget:  (csGroup.this <--> Checkbox2.checkboxGroup)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn12SetTarget() {
	/* Set the target from the source */
	try {
		getCheckbox2().setCheckboxGroup(getcsGroup());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn19:  (MenuItem3.action.actionPerformed(java.awt.event.ActionEvent) --> logArea.text)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn19(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getlogArea().setText(new java.lang.String());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn20:  (mainRetItem.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectPasserUI.dispose())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn20(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.dispose();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn21:  (Checkbox2.item.itemStateChanged(java.awt.event.ItemEvent) --> passChoice.enabled)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn21(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getpassChoice().setEnabled(getCheckbox2().getState());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn25:  (StartButton.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectPasserUI.startPasser(Z)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn25(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.startPasser(getCheckbox2().getState());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn31:  (StartButton.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectPasserUI.startPasser()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn31(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.startPasser();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn32:  (MenuItem2.action.actionPerformed(java.awt.event.ActionEvent) --> AboutBox.show())
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn32(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getAboutBox().show();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn42:  (StopButton.action.actionPerformed(java.awt.event.ActionEvent) --> ObjectPasserUI.stopPasser()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn42(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.stopPasser();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn7:  (StartButton.action.actionPerformed(java.awt.event.ActionEvent) --> countLabel.text)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn7(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getcountLabel().setText("0");
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * Return the AboutBox property value.
 * @return org.jSyncManager.JSerial.TestSuite.AboutBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private AboutBox getAboutBox() {
	if (ivjAboutBox == null) {
		try {
			ivjAboutBox = new org.jSyncManager.JSerial.TestSuite.AboutBox(this);
			ivjAboutBox.setName("AboutBox");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjAboutBox;
}

/**
 * Return the buttonPanel property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getbuttonPanel() {
	if (ivjbuttonPanel == null) {
		try {
			ivjbuttonPanel = new java.awt.Panel();
			ivjbuttonPanel.setName("buttonPanel");
			ivjbuttonPanel.setLayout(getbuttonPanelGridLayout());
			ivjbuttonPanel.add(getStartButton(), getStartButton().getName());
			ivjbuttonPanel.add(getStopButton(), getStopButton().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjbuttonPanel;
}

/**
 * Return the buttonPanelGridLayout property value.
 * @return java.awt.GridLayout
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.GridLayout getbuttonPanelGridLayout() {
	java.awt.GridLayout ivjbuttonPanelGridLayout = null;
	try {
		/* Create part */
		ivjbuttonPanelGridLayout = new java.awt.GridLayout(2, 1);
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	};
	return ivjbuttonPanelGridLayout;
}

/**
 * Return the Checkbox1 property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getCheckbox1() {
	if (ivjCheckbox1 == null) {
		try {
			ivjCheckbox1 = new java.awt.Checkbox();
			ivjCheckbox1.setName("Checkbox1");
			ivjCheckbox1.setLabel("Respond");
			ivjCheckbox1.setState(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCheckbox1;
}

/**
 * Return the Checkbox2 property value.
 * @return java.awt.Checkbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Checkbox getCheckbox2() {
	if (ivjCheckbox2 == null) {
		try {
			ivjCheckbox2 = new java.awt.Checkbox();
			ivjCheckbox2.setName("Checkbox2");
			ivjCheckbox2.setLabel("Originate");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCheckbox2;
}

/**
 * Return the CommSettingsPanel1 property value.
 * @return org.jSyncManager.JSerial.TestSuite.CommSettingsPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private CommSettingsPanel getCommSettingsPanel1() {
	if (ivjCommSettingsPanel1 == null) {
		try {
			ivjCommSettingsPanel1 = new org.jSyncManager.JSerial.TestSuite.CommSettingsPanel();
			ivjCommSettingsPanel1.setName("CommSettingsPanel1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjCommSettingsPanel1;
}

/**
 * Return the ConfigPanel property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getConfigPanel() {
	java.awt.GridBagConstraints constraintsbuttonPanel = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsPanel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsPanel2 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsPanel3 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintsCommSettingsPanel1 = new java.awt.GridBagConstraints();
	if (ivjConfigPanel == null) {
		try {
			ivjConfigPanel = new java.awt.Panel();
			ivjConfigPanel.setName("ConfigPanel");
			ivjConfigPanel.setLayout(new java.awt.GridBagLayout());
			ivjConfigPanel.setBackground(java.awt.Color.lightGray);

			constraintsbuttonPanel.gridx = 3; constraintsbuttonPanel.gridy = 0;
			constraintsbuttonPanel.gridwidth = 1; constraintsbuttonPanel.gridheight = 2;
			constraintsbuttonPanel.fill = java.awt.GridBagConstraints.BOTH;
			constraintsbuttonPanel.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsbuttonPanel.weightx = 0.25;
			constraintsbuttonPanel.weighty = 0.0;
			((java.awt.GridBagLayout) getConfigPanel().getLayout()).setConstraints(getbuttonPanel(), constraintsbuttonPanel);
			getConfigPanel().add(getbuttonPanel());

			constraintsPanel1.gridx = 1; constraintsPanel1.gridy = 0;
			constraintsPanel1.gridwidth = 1; constraintsPanel1.gridheight = 1;
			constraintsPanel1.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsPanel1.weightx = 0.0;
			constraintsPanel1.weighty = 0.0;
			((java.awt.GridBagLayout) getConfigPanel().getLayout()).setConstraints(getPanel1(), constraintsPanel1);
			getConfigPanel().add(getPanel1());

			constraintsPanel2.gridx = 0; constraintsPanel2.gridy = 1;
			constraintsPanel2.gridwidth = 1; constraintsPanel2.gridheight = 1;
			constraintsPanel2.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsPanel2.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsPanel2.weightx = 0.0;
			constraintsPanel2.weighty = 0.0;
			((java.awt.GridBagLayout) getConfigPanel().getLayout()).setConstraints(getPanel2(), constraintsPanel2);
			getConfigPanel().add(getPanel2());

			constraintsPanel3.gridx = 1; constraintsPanel3.gridy = 1;
			constraintsPanel3.gridwidth = 1; constraintsPanel3.gridheight = 1;
			constraintsPanel3.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsPanel3.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsPanel3.weightx = 0.0;
			constraintsPanel3.weighty = 0.0;
			((java.awt.GridBagLayout) getConfigPanel().getLayout()).setConstraints(getPanel3(), constraintsPanel3);
			getConfigPanel().add(getPanel3());

			constraintsCommSettingsPanel1.gridx = 0; constraintsCommSettingsPanel1.gridy = 0;
			constraintsCommSettingsPanel1.gridwidth = 1; constraintsCommSettingsPanel1.gridheight = 1;
			constraintsCommSettingsPanel1.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsCommSettingsPanel1.weightx = 0.0;
			constraintsCommSettingsPanel1.weighty = 0.0;
			((java.awt.GridBagLayout) getConfigPanel().getLayout()).setConstraints(getCommSettingsPanel1(), constraintsCommSettingsPanel1);
			getConfigPanel().add(getCommSettingsPanel1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjConfigPanel;
}

/**
 * Return the countLabel property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getcountLabel() {
	if (ivjcountLabel == null) {
		try {
			ivjcountLabel = new java.awt.Label();
			ivjcountLabel.setName("countLabel");
			ivjcountLabel.setFont(new java.awt.Font("Dialog", 0, 24));
			ivjcountLabel.setAlignment(java.awt.Label.CENTER);
			ivjcountLabel.setText("0");
			ivjcountLabel.setForeground(java.awt.Color.red);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjcountLabel;
}

/**
 * Return the csGroup property value.
 * @return java.awt.CheckboxGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.CheckboxGroup getcsGroup() {
	if (ivjcsGroup == null) {
		try {
			ivjcsGroup = new java.awt.CheckboxGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjcsGroup;
}

/**
 * Return the dataArea property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getdataArea() {
	java.awt.GridBagConstraints constraintsLabel1 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintscountLabel = new java.awt.GridBagConstraints();
	if (ivjdataArea == null) {
		try {
			ivjdataArea = new java.awt.Panel();
			ivjdataArea.setName("dataArea");
			ivjdataArea.setLayout(new java.awt.GridBagLayout());
			ivjdataArea.setBackground(java.awt.Color.lightGray);

			constraintsLabel1.gridx = 0; constraintsLabel1.gridy = 0;
			constraintsLabel1.gridwidth = 1; constraintsLabel1.gridheight = 1;
			constraintsLabel1.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsLabel1.anchor = java.awt.GridBagConstraints.NORTH;
			constraintsLabel1.weightx = 0.0;
			constraintsLabel1.weighty = 0.0;
			((java.awt.GridBagLayout) getdataArea().getLayout()).setConstraints(getLabel1(), constraintsLabel1);
			getdataArea().add(getLabel1());

			constraintscountLabel.gridx = 0; constraintscountLabel.gridy = 1;
			constraintscountLabel.gridwidth = 1; constraintscountLabel.gridheight = 1;
			constraintscountLabel.anchor = java.awt.GridBagConstraints.CENTER;
			constraintscountLabel.weightx = 0.0;
			constraintscountLabel.weighty = 0.0;
			((java.awt.GridBagLayout) getdataArea().getLayout()).setConstraints(getcountLabel(), constraintscountLabel);
			getdataArea().add(getcountLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjdataArea;
}

/**
 * Return the hostNameField property value.
 * @return java.awt.TextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextField gethostNameField() {
	if (ivjhostNameField == null) {
		try {
			ivjhostNameField = new java.awt.TextField();
			ivjhostNameField.setName("hostNameField");
			ivjhostNameField.setBackground(java.awt.Color.white);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjhostNameField;
}

/**
 * Return the InfoPanel property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getInfoPanel() {
	if (ivjInfoPanel == null) {
		try {
			ivjInfoPanel = new java.awt.Panel();
			ivjInfoPanel.setName("InfoPanel");
			ivjInfoPanel.setLayout(new java.awt.BorderLayout());
			getInfoPanel().add("East", getdataArea());
			getInfoPanel().add("Center", getlogArea());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjInfoPanel;
}

/**
 * Return the Label1 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel1() {
	if (ivjLabel1 == null) {
		try {
			ivjLabel1 = new java.awt.Label();
			ivjLabel1.setName("Label1");
			ivjLabel1.setAlignment(java.awt.Label.CENTER);
			ivjLabel1.setText("Count");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel1;
}

/**
 * Return the Label2 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel2() {
	if (ivjLabel2 == null) {
		try {
			ivjLabel2 = new java.awt.Label();
			ivjLabel2.setName("Label2");
			ivjLabel2.setAlignment(java.awt.Label.CENTER);
			ivjLabel2.setText("Hostname:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel2;
}

/**
 * Return the Label3 property value.
 * @return java.awt.Label
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Label getLabel3() {
	if (ivjLabel3 == null) {
		try {
			ivjLabel3 = new java.awt.Label();
			ivjLabel3.setName("Label3");
			ivjLabel3.setAlignment(java.awt.Label.CENTER);
			ivjLabel3.setText("Passes:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjLabel3;
}

/**
 * Return the logArea property value.
 * @return java.awt.TextArea
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.TextArea getlogArea() {
	if (ivjlogArea == null) {
		try {
			ivjlogArea = new java.awt.TextArea();
			ivjlogArea.setName("logArea");
			ivjlogArea.setBackground(java.awt.Color.white);
			ivjlogArea.setEditable(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjlogArea;
}

/**
 * Return the mainRetItem property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getmainRetItem() {
	if (ivjmainRetItem == null) {
		try {
			ivjmainRetItem = new java.awt.MenuItem();
			ivjmainRetItem.setShortcut(new java.awt.MenuShortcut(java.awt.event.KeyEvent.VK_X, false));
			ivjmainRetItem.setLabel("Return to Main Menu");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjmainRetItem;
}

/**
 * Return the MenuItem1 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem1() {
	if (ivjMenuItem1 == null) {
		try {
			ivjMenuItem1 = new java.awt.MenuItem();
			ivjMenuItem1.setLabel("-");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem1;
}

/**
 * Return the MenuItem2 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem2() {
	if (ivjMenuItem2 == null) {
		try {
			ivjMenuItem2 = new java.awt.MenuItem();
			ivjMenuItem2.setLabel("About...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem2;
}

/**
 * Return the MenuItem3 property value.
 * @return java.awt.MenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuItem getMenuItem3() {
	if (ivjMenuItem3 == null) {
		try {
			ivjMenuItem3 = new java.awt.MenuItem();
			ivjMenuItem3.setLabel("Clear Traffic Box");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMenuItem3;
}

/**
 * Return the ObjectPasserUIMenuBar property value.
 * @return java.awt.MenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.MenuBar getObjectPasserUIMenuBar() {
	if (ivjObjectPasserUIMenuBar == null) {
		try {
			ivjObjectPasserUIMenuBar = new java.awt.MenuBar();
			ivjObjectPasserUIMenuBar.add(getopMenu());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjObjectPasserUIMenuBar;
}

/**
 * Return the opMenu property value.
 * @return java.awt.Menu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Menu getopMenu() {
	if (ivjopMenu == null) {
		try {
			ivjopMenu = new java.awt.Menu();
			ivjopMenu.setShortcut(new java.awt.MenuShortcut(java.awt.event.KeyEvent.VK_O, false));
			ivjopMenu.setLabel("Options");
			ivjopMenu.add(getMenuItem3());
			ivjopMenu.add(getmainRetItem());
			ivjopMenu.add(getMenuItem1());
			ivjopMenu.add(getMenuItem2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjopMenu;
}

/**
 * Return the Panel1 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel1() {
	if (ivjPanel1 == null) {
		try {
			ivjPanel1 = new java.awt.Panel();
			ivjPanel1.setName("Panel1");
			ivjPanel1.setLayout(new java.awt.FlowLayout());
			ivjPanel1.add(getCheckbox1(), getCheckbox1().getName());
			ivjPanel1.add(getCheckbox2(), getCheckbox2().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel1;
}

/**
 * Return the Panel2 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel2() {
	java.awt.GridBagConstraints constraintsLabel2 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintshostNameField = new java.awt.GridBagConstraints();
	if (ivjPanel2 == null) {
		try {
			ivjPanel2 = new java.awt.Panel();
			ivjPanel2.setName("Panel2");
			ivjPanel2.setLayout(new java.awt.GridBagLayout());

			constraintsLabel2.gridx = 0; constraintsLabel2.gridy = 0;
			constraintsLabel2.gridwidth = 1; constraintsLabel2.gridheight = 1;
			constraintsLabel2.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsLabel2.weightx = 0.3;
			constraintsLabel2.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(getLabel2(), constraintsLabel2);
			getPanel2().add(getLabel2());

			constraintshostNameField.gridx = 1; constraintshostNameField.gridy = 0;
			constraintshostNameField.gridwidth = 1; constraintshostNameField.gridheight = 1;
			constraintshostNameField.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintshostNameField.anchor = java.awt.GridBagConstraints.CENTER;
			constraintshostNameField.weightx = 0.7;
			constraintshostNameField.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel2().getLayout()).setConstraints(gethostNameField(), constraintshostNameField);
			getPanel2().add(gethostNameField());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel2;
}

/**
 * Return the Panel3 property value.
 * @return java.awt.Panel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Panel getPanel3() {
	java.awt.GridBagConstraints constraintsLabel3 = new java.awt.GridBagConstraints();
	java.awt.GridBagConstraints constraintspassChoice = new java.awt.GridBagConstraints();
	if (ivjPanel3 == null) {
		try {
			ivjPanel3 = new java.awt.Panel();
			ivjPanel3.setName("Panel3");
			ivjPanel3.setLayout(new java.awt.GridBagLayout());

			constraintsLabel3.gridx = 0; constraintsLabel3.gridy = 0;
			constraintsLabel3.gridwidth = 1; constraintsLabel3.gridheight = 1;
			constraintsLabel3.anchor = java.awt.GridBagConstraints.CENTER;
			constraintsLabel3.weightx = 0.3;
			constraintsLabel3.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel3().getLayout()).setConstraints(getLabel3(), constraintsLabel3);
			getPanel3().add(getLabel3());

			constraintspassChoice.gridx = 1; constraintspassChoice.gridy = 0;
			constraintspassChoice.gridwidth = 1; constraintspassChoice.gridheight = 1;
			constraintspassChoice.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintspassChoice.anchor = java.awt.GridBagConstraints.CENTER;
			constraintspassChoice.weightx = 0.7;
			constraintspassChoice.weighty = 0.0;
			((java.awt.GridBagLayout) getPanel3().getLayout()).setConstraints(getpassChoice(), constraintspassChoice);
			getPanel3().add(getpassChoice());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjPanel3;
}

/**
 * Return the passChoice property value.
 * @return java.awt.Choice
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Choice getpassChoice() {
	if (ivjpassChoice == null) {
		try {
			ivjpassChoice = new java.awt.Choice();
			ivjpassChoice.setName("passChoice");
			ivjpassChoice.setBackground(java.awt.Color.white);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjpassChoice;
}

/**
 * Return the StartButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getStartButton() {
	if (ivjStartButton == null) {
		try {
			ivjStartButton = new java.awt.Button();
			ivjStartButton.setName("StartButton");
			ivjStartButton.setLabel("Start");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStartButton;
}

/**
 * Return the StopButton property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.Button getStopButton() {
	if (ivjStopButton == null) {
		try {
			ivjStopButton = new java.awt.Button();
			ivjStopButton.setName("StopButton");
			ivjStopButton.setEnabled(false);
			ivjStopButton.setLabel("Stop");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStopButton;
}

/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	this.addWindowListener(this);
	getStartButton().addActionListener(this);
	getMenuItem3().addActionListener(this);
	getmainRetItem().addActionListener(this);
	getCheckbox2().addItemListener(this);
	getMenuItem2().addActionListener(this);
	getStopButton().addActionListener(this);
	conn11SetTarget();
	conn12SetTarget();
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	setName("ObjectPasserUI");
	setName("ObjectPasserUI");
	setMenuBar(getObjectPasserUIMenuBar());
	setLayout(new java.awt.BorderLayout());
	setBackground(java.awt.Color.lightGray);
	setSize(596, 388);
	setTitle("Java Serial handler Demo v1.0 - By Brad Barclay");
	this.add("Center", getInfoPanel());
	this.add("South", getConfigPanel());
	initConnections();
	// user code begin {2}
	for(int i=1;i<129;i++) {
		getpassChoice().addItem(""+i);
	}
	// user code end
}

/**
 * Method to handle events for the ItemListener interface.
 * @param e java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void itemStateChanged(java.awt.event.ItemEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getCheckbox2()) ) {
		conn21(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Main Entrypoint - starts the ObjectPasserUI when it is run as an application.
 * @param args This application requires no arguments.
 */
public static void main(java.lang.String[] args) {
	try {
		org.jSyncManager.JSerial.TestSuite.ObjectPasserUI aObjectPasserUI = new org.jSyncManager.JSerial.TestSuite.ObjectPasserUI();
		try {
			Class aCloserClass = Class.forName("uvm.abt.edit.WindowCloser");
			Class parmTypes[] = { java.awt.Window.class };
			Object parms[] = { aObjectPasserUI };
			java.lang.reflect.Constructor aCtor = aCloserClass.getConstructor(parmTypes);
			aCtor.newInstance(parms);
		} catch (java.lang.Throwable exc) {};
		aObjectPasserUI.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of java.awt.Frame");
	}
}

/**
 * This method was created by a SmartGuide.
 */
private void startPasser() {
	getCheckbox1().setEnabled(false);
	getCheckbox2().setEnabled(false);
	getCommSettingsPanel1().setEnabled(false);
	gethostNameField().setEnabled(false);
	getLabel2().setEnabled(false);
	getLabel3().setEnabled(false);
	getpassChoice().setEnabled(false);
	getStartButton().setEnabled(false);
	getStopButton().setEnabled(true);
}
/**
 * This method was created by a SmartGuide.
 * @param server boolean
 */
private void startPasser(boolean originate) {
	DataObject data;					// The object to be passed
	StampObject stamp;				// The info to imbed in the data object.
	java.io.ObjectInputStream ois;	// Our Object Input Stream handler
	java.io.ObjectOutputStream oos;	// Our Object Output Stream handler
	int port=0, speed=0;				// Default settings for port and speed
	org.jSyncManager.JSerial.SerialInterface serial;
										// Our Serial Interface
	String hostName=gethostNameField().getText();
	int passes=1000;
	
	// First we'll setup our serial connection
	port=getCommSettingsPanel1().getPortSelect().getSelectedIndex();
	
	try {
		speed=Integer.parseInt(getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
	} catch (Exception e) {
		// Set the speed to a default of 9600 bps
		speed=9600;
	}		

	try {
		serial=new org.jSyncManager.JSerial.SerialInterface((byte)port, speed);
		serial.setRTSCTS(true);
	} catch (Exception e) {
		// Any serial exception is thrown and we exit immediately
		getlogArea().append("*** Unable to connect to port: "+e.toString()+"\n");
		stopPasser();
		return;
	}	

	try {
		oos=new java.io.ObjectOutputStream(serial.getOutputStream());
		ois=new java.io.ObjectInputStream(serial.getInputStream());
	} catch (Exception e) {
		getlogArea().append("*** Unable to initialize IO stream.\n"+e.toString()+"\n");
		stopPasser();
		return;
	}			
	
	data=new DataObject(passes);
	
	if (originate) {
		// Client was started in originate mode
		passes=getpassChoice().getSelectedIndex()+2;
		while(data.getCounter()<passes) {
			// First we'll write the object to the stream
			data.updateObject(hostName);
			getlogArea().append(data.getLastTimeStamp().getDateString()+" - "+data.getLastTimeStamp().getMessage()+"\n");			
			try {
				oos.writeObject(data);
			} catch (Exception e) {
				getlogArea().append("*** Unable to write object to stream.  Exiting...\n");
				stopPasser();
				return;
			}	
			
			// Now we'll wait for the next object to arrive
			// Unless this was pass #passes-1
			if(data.getCounter()==(passes-1)) {
				stopPasser();
				return;
			}	
			
			// Otherwise read the next object in the stream
			try {
				data=(DataObject)ois.readObject();
			} catch (Exception e) {
				getlogArea().append("*** Unable to read object from stream.  Exiting...\n");
			}
			
			// If the object arrived, update the counter and the output display
			getlogArea().append(data.getLastTimeStamp().getDateString()+" - "+data.getLastTimeStamp().getMessage()+"\n");
			getcountLabel().setText(""+data.getCounter());
		} // and do it all over again...	
		stopPasser();
		return;
	} else {
		// This occurs when set to receiver mode
		
		while(data.getCounter()<passes) {
			// First we'll try to read an object from the stream
			try {
				data=(DataObject)ois.readObject();
			} catch (Exception e) {
				getlogArea().append("*** Unable to read object from stream.  Exiting...\n");
			}
			
			// If the object arrived, update the counter and the output display
			passes=data.getPassLimit();
			getlogArea().append(data.getLastTimeStamp().getDateString()+" - "+data.getLastTimeStamp().getMessage()+"\n");
			getcountLabel().setText(""+data.getCounter());

			// Now we'll update the object and send it back...
			
			data.updateObject(hostName);
			getlogArea().append(data.getLastTimeStamp().getDateString()+" - "+data.getLastTimeStamp().getMessage()+"\n");
			try {
				oos.writeObject(data);
			} catch (Exception e) {
				getlogArea().append("*** Unable to write object to stream.  Exiting...\n");
				stopPasser();
				return;
			}	
	
			// We'll check to see if this is the last pass - if so, just return
			if(data.getCounter()==passes) {
				stopPasser();
				return;
			}	
		}
	}		
	stopPasser();
	return;
}
/**
 * This method was created by a SmartGuide.
 */
private void stopPasser() {
	getCheckbox1().setEnabled(true);
	getCheckbox2().setEnabled(true);
	getCommSettingsPanel1().setEnabled(true);
	gethostNameField().setEnabled(true);
	getLabel2().setEnabled(true);
	getLabel3().setEnabled(true);
	getpassChoice().setEnabled(true);
	getStartButton().setEnabled(true);
	getStopButton().setEnabled(false);
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == this) ) {
		conn0(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeiconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowIconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowOpened(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

}