/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Transport;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jSyncManager.API.Transport.SerialTransportInterface;
import org.jSyncManager.API.Transport.TransportException;
import org.jSyncManager.JSerial.SerialInterface;

public class JSerialTransport
extends SerialTransportInterface
implements ActionListener {
    private transient SerialInterface serial = null;
    private transient DataInputStream dis = null;
    private transient DataOutputStream dos = null;
    private transient boolean openState = false;
    protected transient JComboBox comSelectBox = null;
    protected transient JComboBox speedSelectBox = null;
    protected String portName = null;

    public JSerialTransport() throws TransportException {
        try {
            Class.forName("org.jSyncManager.JSerial.SerialInterface");
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void close() throws TransportException {
        try {
            this.openState = false;
            this.dos.close();
            this.dis.skip(this.dis.available());
            this.dis.close();
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void flush() throws TransportException {
        try {
            this.dis.skip(this.dis.available());
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    public String getTransportName() {
        return this.getResourceBundle().getString("jserial.transport.name");
    }

    public void open() throws TransportException {
        if (this.serial == null) {
            this.initialize();
        }
        try {
            if (!this.openState) {
                this.serial.grabPort();
            }
            this.openState = true;
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    public byte readByte() {
        if (!this.openState) {
            return 0;
        }
        try {
            return this.dis.readByte();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    protected void setSpeed(int speed) throws TransportException {
        try {
            this.flush();
            this.serial.setCurrentSpeed(speed);
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void writeBytes(byte[] data) {
        if (!this.openState) {
            return;
        }
        try {
            this.dos.write(data, 0, data.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected JPanel constructConfigPanel() {
        int i;
        JPanel ret = new JPanel();
        JLabel comPortLabel = new JLabel(this.getResourceBundle().getString("transport.jserial.portlabel"));
        JLabel comSpeedLabel = new JLabel(this.getResourceBundle().getString("transport.jserial.speedlabel"));
        Vector<String> v = new Vector<String>();
        v.addElement("9600");
        v.addElement("19200");
        v.addElement("57600");
        v.addElement("115200");
        v.addElement("230400");
        Vector<String> pnV = new Vector<String>();
        pnV.addElement("Serial 0");
        pnV.addElement("Serial 1");
        pnV.addElement("Serial 2");
        pnV.addElement("Serial 3");
        pnV.addElement("Serial 4");
        pnV.addElement("Serial 5");
        pnV.addElement("Serial 6");
        pnV.addElement("Serial 7");
        this.comSelectBox = new JComboBox(pnV);
        this.speedSelectBox = new JComboBox(v);
        this.comSelectBox.addActionListener(this);
        this.speedSelectBox.addActionListener(this);
        ret.setLayout(new GridLayout(5, 1));
        ret.add(comPortLabel);
        ret.add(this.comSelectBox);
        ret.add(comSpeedLabel);
        ret.add(this.speedSelectBox);
        if (this.portName == null) {
            this.portName = (String)pnV.elementAt(0);
        }
        for (i = 0; i < this.speedSelectBox.getItemCount(); ++i) {
            try {
                if (Integer.parseInt((String)this.speedSelectBox.getItemAt(i)) != this.serialSpeed) continue;
                this.speedSelectBox.setSelectedIndex(i);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (i = 0; i < this.comSelectBox.getItemCount(); ++i) {
            try {
                if (!((String)this.comSelectBox.getItemAt(i)).equals(this.portName)) continue;
                this.comSelectBox.setSelectedIndex(i);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JComboBox)) {
            return;
        }
        JComboBox cb = (JComboBox)e.getSource();
        if (cb == this.comSelectBox) {
            this.portName = (String)this.comSelectBox.getSelectedItem();
            return;
        }
        if (cb == this.speedSelectBox) {
            try {
                this.serialSpeed = Integer.parseInt((String)this.speedSelectBox.getSelectedItem());
            }
            catch (NumberFormatException ex) {
                System.err.println("*** A JSerialTransport parse error has occurred. Forcing 9600bps...");
                this.serialSpeed = 9600;
            }
        }
    }

    public void initialize() throws TransportException {
        if (this.portName == null) {
            throw new TransportException(2);
        }
        try {
            byte temp = Byte.valueOf(this.portName.substring(7));
            this.serial = new SerialInterface(temp);
            this.serial.setRTSCTS(true);
            this.dis = new DataInputStream(this.serial.getInputStream());
            this.dos = new DataOutputStream(this.serial.getOutputStream());
        }
        catch (Throwable t) {
            throw new TransportException(t);
        }
    }

    public void initialize(Properties properties, int id) throws TransportException {
        this.portName = properties.getProperty("jsyncman.server.port." + id);
        try {
            this.serialSpeed = Integer.parseInt(properties.getProperty("jsyncman.server.speed." + id));
        }
        catch (NumberFormatException e) {
            throw new TransportException((Throwable)new Exception(this.getResourceBundle().getString("transport.jserial.server.portspeed_error") + "jsyncman.server.speed." + id));
        }
        this.initialize();
    }

    public String getTransportExceptionText(TransportException ex) {
        if (ex == null) {
            return null;
        }
        if (ex.getReasonCode() == 2) {
            return this.getResourceBundle().getString("transport.jserial.insufficientinfo");
        }
        if (ex.getReasonCode() == 1) {
            if (ex.getException() instanceof IOException) {
                return this.getResourceBundle().getString("transport.jserial.ioexceptiontext");
            }
            if (ex.getException() instanceof NoClassDefFoundError) {
                return this.getResourceBundle().getString("transport.jserial.noapiexceptiontext");
            }
            return this.getResourceBundle().getString("transport.jserial.unknownexception");
        }
        return this.getResourceBundle().getString("transport.jserial.undefinederror");
    }

    public String getResourceBundleName() {
        return "org.jSyncManager.Transport.Resources.Text.JSerialTransportResources";
    }

    public String getTransportDescription() {
        return this.getResourceBundle().getString("transport.jserial.description");
    }

    public int getPreferredSyncSpeed() {
        return this.serialSpeed;
    }
}

