/* $Id: RowSetModel.java,v 1.1 1999/03/03 06:00:22 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql;

import com.sun.java.swing.tabel.AbstractTableModel;
import java.sql.SQLException;
import java.sql.Types;
import javax.sql.RowSet;
import javax.sql.RowSetListener;

public class RowSetModel extends AbstractTableModel implements RowSetListener {
    private int    rowCount = -1;
    private RowSet rowSet   = null;

    public RowSetModel(RowSet set) {
	super();
	rowSet = set;
	rowSet.addRowSetListener(this);
    }

    public void cursorMoved(RowSetEvent event) {
    }

    public Class getColumnClass(int column) {
	String cname;
	int type;
	
	try {
	    RowSetMetaData meta = rowSet.getMetaData();

	    type = meta.getColumnType(column);
	}
	catch( SQLException e ) {
	    e.printStackTrace();
	    return super.getColumnClass(column);
	}
	switch( type ) {
	case Types.BIT:
	    {
		cname = "java.lang.Boolean";
		break;
	    }
	case Types.TINYINT:
	    {
		cname = "java.lang.Byte";
		break;
	    }
	case Types.SMALLINT:
	    {
		cname = "java.lang.Short";
		break;
	    }
	case Types.INTEGER:
	    {
		cname = "java.lang.Integer";
		break;
	    }
	case Types.BIGINT:
	    {
		cname = "java.lang.Long";
		break;
	    }
	case Types.FLOAT: case Types.REAL:
	    {
		cname = "java.lang.Float";
		break;
	    }
	case Types.DOUBLE:
	    {
		cname = "java.lang.Double";
		break;
	    }
	case Types.NUMERIC:
	    {
		cname = "java.lang.Number";
		break;
	    }
	case Types.DECIMAL:
	    {
		cname = "java.math.BigDecimal";
		break;
	    }
	case Types.CHAR: case Types.VARCHAR: case Types.LONGVARCHAR:
	    {
		cname = "java.lang.String";
		break;
	    }
	case Types.DATE:
	    {
		cname = "java.sql.Date";
		break;
	    }
	case Types.TIME:
	    {
		cname = "java.sql.Time";
		break;
	    }
	case Types.TIMESTAMP:
	    {
		cname = "java.sql.Timestamp";
		break;
	    }
	case Types.BINARY: case Types.VARBINARY: case Types.LONGVARBINARY:
	    {
		cname = "byte[]";
		break;
	    }
	case Types.OTHER: case Types.JAVA_OBJECT:
	    {
		cname = "java.lang.Object";
		break;
	    }
	case Types.CLOB:
	    {
		cname = "java.sql.Clob";
		break;
	    }
	case Types.BLOB:
	    {
		cname = "java.ssql.Blob";
		break;
	    }
	case Types.REF:
	    {
		cname = "java.sql.Ref";
		break;
	    }
	case Types.STRUCT:
	    {
		cname = "java.sql.Struct";
		break;
	    }
	default:
	    {
		return super.getColumnClass(column);
	    }
	}
	try {
	    return Class.forName(cname);
	}
	catch( Exception e ) {
	    e.printStackTrace();
	    return super.getColumnClass(column);
	}
    }
	    
    public int getColumnCount() {
	RowSetMetaData meta = rowSet.getMetaData();

	return meta.getColumnCount();
    }

    public String getColumnName(int col) {
	RowSetMetaData meta = rowSet.getMetaData();

	return meta.getColumnName(col);
    }

    public int getRowCount() {
	if( rowCount == -1 ) {
	    if( rowSet.last() ) {
		rowCount = rowSet.getRow();
	    }
	    else {
		rowCount = 0;
	    }
	}
	return rowCount;
    }

    public Object getValueAt(int row, int col) {
	if( !rowSet.absolute(row) ) {
	    return null;
	}
	return rowSet.getObject(col);
    }

    public void rowChanged(RowSetEvent event) {
	int row = rowSet.getRow();
	
	if( rowSet.rowDeleted() ) {
	    fireTableRowsDeleted(row, row);
	}
	else if( row.rowInserted() ) {
	    fireTableRowsInserted(row, row);
	}
	else if( row.rowUpdated() ) {
	    fireTableRowsUpdated(row, row);
	}
    }

    public void rowSetChanged(RowSetEvent event) {
	fireTableChanged(null);
    }

    public void setValueAt(Object value, int row, int column) {
	if( !rowSet.absolute(row) ) {
	    return;
	}
	rowSet.updateObject(column, value);
    }
}
