/* $Id: PrimaryKeyResults.java,v 2.2 1999/07/22 20:57:57 borg Exp $ */
/* Copyright  1998-1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * This class represents a ResultSet containing information about
 * the primary key columns in an mSQL table.
 * <BR>
 * Last modified $Date: 1999/07/22 20:57:57 $ 
 * @version $Revision: 2.2 $
 * @author Brian Jepson (bjepson@ids.net)
 * @author George Reese (borg@imaginary.com)
 */
public class PrimaryKeyResults extends MsqlQueryData {
    // The mSQL database that owns the table in question
    private   String            catalog          = null;
    // The columns in the desired table
    private   ArrayList         columns          = null;
    // The name pattern to search on
    private   String            namePattern      = null;

    /**
     * Constructs a new <CODE>PrimaryKeyResults</CODE> object based on
     * the specified criteria.
     * @param conn the associated connection
     * @param np not currently in use
     * @param ll the logging level
     * @throws java.sql.SQLException an error occurred
     */
    PrimaryKeyResults(MsqlConnection conn, ArrayList cols, int ll)
        throws SQLException {
        super(conn, 6, ll, true);
        catalog = conn.getCatalog();
        columns = cols;
        try {
            loadResults();
            complete();
        }
        catch( SQLException e ) {
            log.log("PrimaryKeyResults()", MsqlLog.ERROR,
                    "Results load failed: " + e.getMessage());
            complete();
            throw e;
        }
    }

    /**
     * Provides a hard-coded implementation of the superclass'
     * version so that the right columns are loaded.
     * @param name the name of the desired column
     * @return the column number for the specified column name
     * @exception java.sql.SQLException thrown on a read error
     */
    public int findColumn(String name) throws SQLException {
        if( name.equals("TABLE_CAT") ) {
            return 1;
        }
        else if( name.equals("TABLE_SCHEM") ) {
            return 2;
        }
        else if( name.equals("TABLE_NAME") ) {
            return 3;
        }
        else if( name.equals("COLUMN_NAME") ) {
            return 4;
        }
        else if( name.equals("KEY_SEQ") ) {
            return 5;
        }
        else if( name.equals("PK_NAME") ) {
            return 6;
        }
        else {
            throw new MsqlException("Illegal column name.");
        }
    }

    protected void loadResults() throws SQLException {
        Iterator it = columns.iterator();

        while(it.hasNext() ) {
            ParsedRow row = (ParsedRow)it.next();
            String val;

            val = row.get(5);
            if( val.equalsIgnoreCase("Y") ) {
                int type = Integer.parseInt(row.get(2));
                boolean idxtype = false;

                if( type == MsqlTypes.IDX ) {
                    MsqlOutputStream output =getConnection().getOutputStream();

                    try {
                        output.writeString("11:" + row.get(0) + ":" +
                                           row.get(1) + "\n",
                                           getConnection().getEncoding());
                    }
                    catch( IOException e ) {
                        throw new MsqlException(e);
                    }
                    while( true ) {
                        StringBuffer rd = new StringBuffer();
                        byte[] data;
			
                        rd.append(catalog.length() + ":" + catalog);
                        rd.append("-2:");
                        val = row.get(0);
                        rd.append(val.length() + ":" + val);
                        try {
                            data = getConnection().getInputStream().read();
                        }
                        catch( Exception e ) {
                            throw new MsqlException(e);
                        }
                        if( data.length > 2 && data[0] == '-' &&
                            data[1] == '1' && data[2] == ':' ) {
                            String tmp;
			    
                            try {
                                tmp = new String(data, getEncoding());
                            }
                            catch( UnsupportedEncodingException e ) {
                                throw new MsqlException(e);
                            }
                            throw new MsqlException(tmp);
                        }
                        else if( data.length > 4 && data[0] == '-' &&
                                 data[1] == '1' && data[2] == '0' &&
                                 data[3] == '0' && data[4] == ':' ) {
                            return;
                        }
                        else {
                            RowTokenizer raw = new RowTokenizer(data,
                                                                getEncoding(),
                                                                log.getLevel());
                            RowTokenizer nr;
                            String pk;
                            byte[] b;


                            if( !idxtype ) {
                                idxtype = true;
                                continue;
                            }
                            pk = raw.get(0);
                            rd.append(pk.length() + ":" + pk);
                            rd.append("-2:");
                            val = row.get(1);
                            rd.append(val.length() + ":" + val);
                            val = row.get(1);
                            try {
                                b = rd.toString().getBytes("8859_1");
                            }
                            catch( UnsupportedEncodingException e ) {
                                throw new MsqlException(e);
                            }
                            nr = new RowTokenizer(b,
                                                  getEncoding(),
                                                  log.getLevel());
                            addRow(new MsqlRow(nr,
                                               getConnection().getEncoding()));
                        }
                    }
                }
                else {
                    StringBuffer rd = new StringBuffer();
                    byte[] b;
		    
                    rd.append(catalog.length() + ":" + catalog);
                    rd.append("-2:");
                    val = row.get(0);
                    rd.append(val.length() + ":" + val);
                    val = row.get(1);
                    rd.append(val.length() + ":" + val);
                    rd.append("-2:");
                    rd.append(val.length() + ":" + val);
                    try {
                        b = rd.toString().getBytes("8859_1");
                    }
                    catch( UnsupportedEncodingException e ) {
                        throw new MsqlException(e);
                    }
                    addRow(new MsqlRow(new RowTokenizer(b, getEncoding(),
                                                        log.getLevel()),
                                       getConnection().getEncoding()));
                }
            }
        }
    }
    
    /**
     * Creates a specialized set of result set meta data for this
     * special result set.
     */
    protected ResultSetMetaData loadMetaData() throws SQLException {
        ArrayList cols = new ArrayList();
        ResultSetMetaData rsmd;

        rsmd = new MsqlResultSetMetaData(getConnection().getCatalog(), cols);
        getConnection().release();
        return rsmd;
    }
    
    /**
     * Provides a row that represents the full range of required
     * JDBC meta data for a table's columns.
     * @param the row for the specified data
     * @return an <CODE>MsqlRow</CODE> instance for that row
     * @param java.sql.SQLException an error occurred parsing the mSQL data
     */
    protected MsqlRow readRow(byte[] data) throws SQLException {
        return null;
    }
}
