/* $Id: MsqlDataSourceFactory.java,v 2.3 1999/01/21 01:48:16 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/**
 * JNDI factory class for <CODE>MsqlDataSource</CODE> and
 * <CODE>MsqlPooledDataSource</CODE> objects.
 * <BR>
 * Last modified $Date: 1999/01/21 01:48:16 $
 * @version $Revision: 2.3 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlDataSourceFactory implements ObjectFactory {
    /**
     * Constructs a new mSQL data source for the referenced data
     * source.
     * @param ob the reference object
     * @param name the JNDI name
     * @param ctx the JNDI context
     * @param env meaningless environment shit
     * @return the proper mSQL data source
     */
    public Object getObjectInstance(Object ob, Name name, Context ctx,
				    Hashtable env) throws Exception {
	String mds = "com.imaginary.sql.msql.MsqlDataSource";
	String mpds = "com.imaginary.sql.msql.MsqlPooledDataSource";
	Reference ref = (Reference)ob;
	
	if( ref.getClassName().equals(mds) ) {
	    MsqlDataSource ds = new MsqlDataSource();
	    int port;

	    port = Integer.parseInt((String)ref.get("port").getContent());
	    ds.setServerName((String)ref.get("serverName").getContent());
	    ds.setDatabaseName((String)ref.get("databaseName").getContent());
	    ds.setEncoding((String)ref.get("encoding").getContent());
	    ds.setUser((String)ref.get("user").getContent());
	    ds.setPassword((String)ref.get("password").getContent());
	    ds.setPort(port);
	    return ds;
	}
	else if( ref.getClassName().equals(mpds) ) {
	    MsqlPooledDataSource ds = new MsqlPooledDataSource();
	    String tmp;

	    tmp = (String)ref.get("port").getContent();
	    ds.setPort(Integer.parseInt(tmp));
	    ds.setServerName((String)ref.get("serverName").getContent());
	    ds.setDatabaseName((String)ref.get("databaseName").getContent());
	    tmp = (String)ref.get("maxPoolSize").getContent();
	    ds.setMaxPoolSize(Integer.parseInt(tmp));
	    ds.setEncoding((String)ref.get("encoding").getContent());
	    ds.setUser((String)ref.get("user").getContent());
	    ds.setPassword((String)ref.get("password").getContent());
	    return ds;
	}
	else {
	    return null;
	}
    }
}
