/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlLog;
import com.imaginary.sql.msql.MsqlPreparedStatement;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.util.Encoder;
import com.imaginary.util.NoSuchEncoderException;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public abstract class MsqlResultSet
implements ResultSet {
    private HashMap columnTypes = new HashMap();
    private int concurrency = 1007;
    private int fetchDirection = 1000;
    protected MsqlLog log = null;
    private HashMap pkInfo = null;
    private MsqlStatement statement = null;
    private HashMap tableInfo = null;
    private int type = 1003;

    MsqlResultSet(MsqlStatement msqlStatement, int n) throws SQLException {
        this.statement = msqlStatement;
        this.log = new MsqlLog(n, this);
        if (msqlStatement != null) {
            this.fetchDirection = msqlStatement.getFetchDirection();
            this.concurrency = msqlStatement.getResultSetConcurrency();
            this.type = msqlStatement.getResultSetType();
        }
    }

    public abstract boolean absolute(int var1) throws SQLException;

    public void afterLast() throws SQLException {
        this.absolute(-1);
        this.next();
    }

    public void beforeFirst() throws SQLException {
        this.absolute(1);
        this.previous();
    }

    public void cancelRowUpdates() throws SQLException {
        this.log.log("cancelRowUpdates()", 2, "Row updates cancelled.");
        if (this.getConcurrency() != 1008) {
            this.log.log("cancelRowUpdates()", 8, "Result set is not updatable.");
            throw new MsqlException("Result set is not updatable.");
        }
    }

    public void clearWarnings() throws SQLException {
        this.log.log("clearWarnings()", 2, "Clear warnings.");
    }

    public void close() throws SQLException {
        this.log.log("close()", 2, "Closing result set.");
        this.log.close();
    }

    public void complete() {
        this.log.log("complete()", 16, "Result set complete.");
        if (this.statement != null) {
            this.statement.completeLoad();
        }
    }

    public void deleteRow() throws SQLException {
        this.log.log("deleteRow()", 2, "Delete current row.");
        if (this.getConcurrency() != 1008) {
            this.log.log("deleteRow()", 8, "Result set is not updatable.");
            throw new MsqlException("Result set is not updatable.");
        }
    }

    public abstract int findColumn(String var1) throws SQLException;

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        this.log.log("getArray()", 8, "Arrays not supported.");
        throw new MsqlException("This operation is not supported.");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public abstract InputStream getAsciiStream(int var1) throws SQLException;

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"));
        }
        return new BigDecimal(new BigInteger(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string), n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public abstract InputStream getBinaryStream(int var1) throws SQLException;

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.log.log("getBlob()", 8, "Blob objects are not supported.");
        throw new MsqlException("This operation is not supported.");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public abstract boolean getBoolean(int var1) throws SQLException;

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public abstract byte getByte(int var1) throws SQLException;

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public abstract byte[] getBytes(int var1) throws SQLException;

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.log.log("getClob()", 8, "Clobs not supported.");
        throw new MsqlException("This operation is not supported.");
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getCursorName() throws SQLException {
        this.log.log("getCursorName()", 8, "Cursors not supported.");
        throw new SQLException("mSQL does not support cursors.");
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getDate()", 8, "Invalid date format: " + string);
                throw new SQLException("Invalid date format.");
            }
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getDate()", 8, "Invalid date format: " + string);
                throw new MsqlException("Invalid date format.");
            }
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getDouble()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public String getEncoding() {
        if (this.statement != null) {
            return this.statement.getEncoding();
        }
        return "8859_1";
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getFloat()", 8, "Invalid number format: " + string);
            throw new MsqlException(numberFormatException);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getInt()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getLong()", 8, "Invalid numver format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 3: {
                return this.getBigDecimal(n, 0);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return this.getObject(n, (Map)this.statement.getConnection().getTypeMap());
            }
        }
        this.log.log("getObject()", 8, "Unknown SQL type " + n2 + ".");
        throw new MsqlException("Unknown SQL type: " + n2);
    }

    public Object getObject(int n, Map map) throws SQLException {
        SQLData sQLData;
        Class clazz;
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        String string = resultSetMetaData.getColumnTypeName(n);
        SQLInput sQLInput = null;
        if (!map.containsKey(string)) {
            switch (resultSetMetaData.getColumnType(n)) {
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: {
                    this.log.log("getObject()", 8, "No type mapping defined for " + string + ".");
                    throw new MsqlException("No type mapping defined for" + string + ".");
                }
            }
            return this.getObject(n);
        }
        try {
            clazz = (Class)map.get(string);
        }
        catch (ClassCastException classCastException) {
            this.log.log("getObject()", 8, "Class not found: " + classCastException.getMessage());
            throw new MsqlException(classCastException);
        }
        try {
            sQLData = (SQLData)clazz.newInstance();
        }
        catch (Exception exception) {
            this.log.log("getObject()", 8, "Could not create object: " + exception.getMessage());
            throw new MsqlException(exception);
        }
        sQLData.readSQL(sQLInput, string);
        return sQLData;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        this.log.log("getRef()", 8, "Ref objects not supported.");
        throw new MsqlException("This operation is not supported.");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public abstract int getRow() throws SQLException;

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getShort()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public abstract String getString(int var1) throws SQLException;

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getTime()", 8, "Invalid time format: " + string + ".");
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getTime()", 8, "Invalid time format: " + string + ".");
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public abstract InputStream getUnicodeStream(int var1) throws SQLException;

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    protected String getUpdate(int n) throws SQLException {
        this.log.log("getUpdate()", 16, "Getting update value for column " + n + ".");
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        this.log.log("insertRow()", 2, "Inserting row.");
        if (this.getConcurrency() != 1008) {
            this.log.log("insertRow()", 8, "Result set not updatable.");
            throw new MsqlException("Result set not updatable.");
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.getRow() == -2;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public abstract boolean isLast() throws SQLException;

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        this.log.log("moveToCurrentRow()", 2, "Moving to the current row.");
    }

    public void moveToInsertRow() throws SQLException {
        this.log.log("moveToInsertRow()", 2, "Moving to the insert row.");
        if (this.getConcurrency() != 1008) {
            this.log.log("moveToInsertRow()", 8, "Result set not updatable.");
            throw new MsqlException("Result set not updatable.");
        }
    }

    public abstract boolean next() throws SQLException;

    private synchronized void prepareModification() throws SQLException {
        ArrayList<String> arrayList;
        Object object;
        String string;
        this.log.log("prepareModification()", 16, "Preparing result set modifications.");
        if (this.pkInfo != null) {
            return;
        }
        DatabaseMetaData databaseMetaData = this.statement.getConnection().getMetaData();
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        this.tableInfo = new HashMap();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 < n + 1) {
            string = resultSetMetaData.getColumnName(n2);
            object = resultSetMetaData.getTableName(n2);
            arrayList = this.tableInfo.containsKey(object) ? (ArrayList<String>)this.tableInfo.get(object) : new ArrayList<String>();
            arrayList.add(string);
            this.tableInfo.put(object, arrayList);
            ++n2;
        }
        Iterator iterator = this.tableInfo.keySet().iterator();
        this.pkInfo = new HashMap();
        while (iterator.hasNext()) {
            String string2;
            string = (String)iterator.next();
            object = (ArrayList)this.tableInfo.get(string);
            arrayList = new ArrayList<String>();
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string);
            resultSet.next();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                if (!((ArrayList)object).contains(string2)) {
                    this.log.log("prepareModifications()", 8, "JDBC requires keys to be part of an updatable result set.");
                    throw new MsqlException("The keys must be included in any result set you wish to modify in place.");
                }
                arrayList.add(string2);
            }
            this.pkInfo.put(string, arrayList);
            resultSet.close();
            resultSet = databaseMetaData.getColumns("", "", string, "");
            while (resultSet.next()) {
                string2 = resultSet.getString("NAME");
                String string3 = resultSet.getString("TYPE");
                this.columnTypes.put(String.valueOf(string) + "." + string2, string3);
            }
        }
    }

    public abstract boolean previous() throws SQLException;

    public void refreshRow() throws SQLException {
        this.log.log("refreshRow()", 2, "Refreshing row.");
        if (this.getConcurrency() != 1008) {
            this.log.log("refreshRow()", 8, "Result set is not updatable.");
            throw new MsqlException("Result set is not updatable.");
        }
    }

    public abstract boolean relative(int var1) throws SQLException;

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    protected void setColumn(int n, String string) throws SQLException {
        this.log.log("setColumn()", 16, "Setting column " + n + " to \"" + string + "\".");
        this.log.log("setColumn()", 8, "Result set not updatable.");
        throw new MsqlException("Result set is not updatable.");
    }

    void setConcurrency(int n) {
        this.log.log("setConcurrency()", 2, "Setting concurrency to " + n + ".");
        this.concurrency = n;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.log.log("setFetchDirection()", 2, "Setting fetch direction to " + n + ".");
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.log.log("setFetchSize()", 2, "Setting fetch size to " + n + ".");
    }

    public void setType(int n) {
        this.log.log("setType()", 2, "Result set type set to " + n + ".");
        this.type = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            this.setColumn(n, new String(byArray, "8859_1"));
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setColumn(n, bigDecimal.toString());
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
        this.updateBytes(n, byArray);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            throw new MsqlException("Binary length too long for mSQL.");
        }
        this.updateBinaryStream(n, blob.getBinaryStream(), (int)l);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.setColumn(n, bl ? "1" : "0");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.setColumn(n, String.valueOf(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        String string;
        try {
            Encoder encoder = Encoder.getInstance(1);
            byArray = encoder.encode(byArray);
            string = new String(encoder.encode(byArray), "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
        catch (NoSuchEncoderException noSuchEncoderException) {
            throw new MsqlException(noSuchEncoderException);
        }
        this.setColumn(n, string);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        char[] cArray = new char[n2];
        try {
            reader.read(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new MsqlException(iOException);
        }
        this.setColumn(n, new String(cArray));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        this.setColumn(n, simpleDateFormat.format(date));
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.setColumn(n, String.valueOf(d));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.setColumn(n, String.valueOf(f));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.setColumn(n, String.valueOf(n2));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.setColumn(n, String.valueOf(l));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.setColumn(n, "NULL");
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (object instanceof Date) {
            this.updateDate(n, (Date)object);
        } else if (object instanceof String) {
            this.updateString(n, object.toString());
        } else if (object instanceof StringBuffer) {
            this.updateString(n, object.toString());
        } else if (object instanceof Blob) {
            this.updateBlob(n, (Blob)object);
        } else if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
        } else if (object instanceof Serializable) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                this.updateBytes(n, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw new MsqlException(iOException);
            }
        } else {
            throw new MsqlException("Invalid binary object type.");
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw new MsqlException("Result set is not updatable.");
        }
        this.prepareModification();
        Iterator iterator = this.tableInfo.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = ((AbstractList)((ArrayList)this.tableInfo.get(string))).iterator();
            ArrayList arrayList = (ArrayList)this.pkInfo.get(string);
            StringBuffer stringBuffer = null;
            StringBuffer stringBuffer2 = null;
            while (iterator2.hasNext()) {
                String string2;
                String string3 = (String)iterator2.next();
                String string4 = (String)this.columnTypes.get(String.valueOf(string) + "." + string3);
                if (string4.equals("CHAR") || string4.equals("TEXT")) {
                    String string5 = this.getUpdate(this.findColumn(string3));
                    string2 = "'" + MsqlPreparedStatement.fixString(string5) + "'";
                } else {
                    string2 = this.getUpdate(this.findColumn(string3));
                }
                if (arrayList.contains(string3)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(" WHERE ");
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(String.valueOf(string3) + "=" + string2);
                    continue;
                }
                if (stringBuffer2 == null) {
                    stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(" SET ");
                } else {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(String.valueOf(string3) + "=" + string2);
            }
            this.statement.executeUpdate("UPDATE " + string + " " + stringBuffer2 + " " + stringBuffer);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        this.setColumn(n, String.valueOf(s));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.setColumn(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        this.setColumn(n, simpleDateFormat.format(time));
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateLong(n, ((java.util.Date)timestamp).getTime());
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public abstract boolean wasNull() throws SQLException;
}

