/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;

public class MenuWindow extends Frame {
    boolean inAnApplet = true;
    TextArea output;

    public MenuWindow() {
        MenuBar mb;
        Menu m1, m2, m3, m4, m4_1, m5;
        MenuItem mi1_1, mi1_2, mi3_1, mi3_2, mi3_3, mi3_4,
                 mi4_1_1, mi5_1, mi5_2;
        CheckboxMenuItem mi2_1;

        output = new TextArea(5, 30);
        output.setEditable(false);
        setLayout(new BorderLayout()); //give max space to the output
        add("Center", output);

        //Build the menu bar.
        mb = new MenuBar();
        setMenuBar(mb);

        //Build first menu in the menu bar.
	//Specifying the second argument as true
	//makes this a tear-off menu.
        m1 = new Menu("Menu 1", true);
        mb.add(m1);
        mi1_1 = new MenuItem("Menu Item 1_1");
        m1.add(mi1_1);
        mi1_2 = new MenuItem("Menu Item 1_2");
        m1.add(mi1_2);

        //Build help menu.
        m5 = new Menu("Menu 5");
        mb.add(m5); //just setting the help menu doesn't work; must add it
        mb.setHelpMenu(m5);
        mi5_1 = new MenuItem("Menu Item 5_1");
        m5.add(mi5_1);
        mi5_2 = new MenuItem("Menu Item 5_2");
        m5.add(mi5_2);

        //Build second menu in the menu bar.
        m2 = new Menu("Menu 2");
        mb.add(m2);
        mi2_1 = new CheckboxMenuItem("Menu Item 2_1");
        m2.add(mi2_1);

        //Build third menu in the menu bar.
        m3 = new Menu("Menu 3");
        mb.add(m3);
        mi3_1 = new MenuItem("Menu Item 3_1");
        m3.add(mi3_1);
        mi3_2 = new MenuItem("Menu Item 3_2");
        m3.add(mi3_2);
        m3.addSeparator();
        mi3_3 = new MenuItem("Menu Item 3_3");
        m3.add(mi3_3);
        mi3_4 = new MenuItem("Menu Item 3_4");
        mi3_4.disable();
        m3.add(mi3_4);

        //Build fourth menu in the menu bar.
        m4 = new Menu("Menu 4");
        mb.add(m4);
        m4_1 = new Menu("Submenu 4_1");
        m4.add(m4_1);
        mi4_1_1 = new MenuItem("Menu Item 4_1_1");
        m4_1.add(mi4_1_1);
    }

    public boolean handleEvent(Event event) {
        if (event.id == Event.WINDOW_DESTROY) {
            if (inAnApplet) {
                dispose();
            } else {
                System.exit(0);
            }
        }   
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object arg) {
        String str = "Action detected";

        if (event.target instanceof MenuItem) {
            MenuItem mi=(MenuItem)(event.target);
            str += " on " + arg;
            if (mi instanceof CheckboxMenuItem) {
                str += " (state is " 
                           + ((CheckboxMenuItem)mi).getState()
                       + ")";
            }
            MenuContainer parent = mi.getParent();
            if (parent instanceof Menu) {
                str += " in " + ((Menu)parent).getLabel();
            } else {
                str += " in a container that isn't a Menu";
            }
        }
        str += ".\n";
        output.appendText(str);
        return true;
    }

    public static void main(String[] args) {
        MenuWindow window = new MenuWindow();
        window.inAnApplet = false;

        window.setTitle("MenuWindow Application");
	window.pack();
        window.show();
    }
}
