/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

public class CheckboxDemo extends Applet {

    public void init() {
        Panel p1, p2;
        Checkbox cb1, cb2, cb3; //independent checkboxes
        Checkbox cb4, cb5, cb6; //only one of these three can be selected
        CheckboxGroup cbg;

        //Build first panel, which contains independent checkboxes
        cb1 = new Checkbox();
        cb1.setLabel("Checkbox 1");
        cb2 = new Checkbox("Checkbox 2");
        cb3 = new Checkbox("Checkbox 3");
        cb3.setState(true);
        p1 = new Panel();
        p1.setLayout(new FlowLayout());
        //Using a GridLayout didn't work--kept box and text too far apart.
        p1.add(cb1);
        p1.add(cb2);
        p1.add(cb3);

        //Build second panel, which contains a checkbox group
        cbg = new CheckboxGroup();
        cb4 = new Checkbox("Checkbox 4", cbg, false);
        cb5 = new Checkbox("Checkbox 5", cbg, false);
        cb6 = new Checkbox("Checkbox 6", cbg, false);
        p2 = new Panel();
        p2.setLayout(new FlowLayout());
        p2.add(cb4);
        p2.add(cb5);
        p2.add(cb6);

        //Add panels to the Applet. 
        setLayout(new GridLayout(0, 2));
        add(p1);
        add(p2);

        validate();
    }
}
