/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class CheckedIOTest {
    public static void main(String[] args) {

       Adler32 inChecker = new Adler32();
       Adler32 outChecker = new Adler32();
       CheckedInputStream cis = null;
       CheckedOutputStream cos = null;

       try {
           cis = new CheckedInputStream(new FileInputStream("farrago.txt"), inChecker);
           cos = new CheckedOutputStream(new FileOutputStream("outagain.txt"), outChecker);
       } catch (FileNotFoundException e) {
           System.err.println("CheckedIOTest: " + e);
           System.exit(-1);
       } catch (IOException e) {
           System.err.println("CheckedIOTest: " + e);
           System.exit(-1);
       }

       try {
           int c;

           while ((c = cis.read()) != -1) {
              cos.write(c);
           }

           System.out.println("Input stream check sum: " + inChecker.getValue());
           System.out.println("Output stream check sum: " + outChecker.getValue());

           cis.close();
           cos.close();
       } catch (IOException e) {
           System.err.println("CheckedIOTest: " + e);
       }
    }
}
