/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.awt.*;
import java.applet.Applet;

import java.net.URL;
import java.net.MalformedURLException;

class SoundCanvas extends PictureCanvas {

    private String audioClipName = null;
    private Applet parentApplet = null;

    public SoundCanvas(Image image, LinguaPanel parent, 
		              int initialWidth, int initialHeight,
			      String audioClipName) {
	super(image, parent, initialWidth, initialHeight);
	this.audioClipName = audioClipName;
    }

    public boolean mouseDown(Event evt, int x, int y) {
	if (audioClipName != null) {
	        // grandparent is IntlWindow,
	        // whose parent is either null or AppletButton
		// if it's AppletButton we want to play sound
	    Container greatGrandParent = getParent().getParent().getParent();
	    if (greatGrandParent instanceof Applet) {
	        parentApplet = (Applet)(greatGrandParent);
	        try {
	            URL auURL = new URL(parentApplet.getCodeBase(), audioClipName);
	            parentApplet.play(auURL);
	            return true;
	        } catch (java.net.MalformedURLException e) {
		    return false;
	        }
	    }
	}
        return false;
    }
}
