/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.util.ListResourceBundle;
import java.util.Locale;

import java.awt.Toolkit;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.net.URL;

public abstract class MediaBundle extends ListResourceBundle {

    Image flag;
    Object[][] contents;
    String soundNames[] = { "book", "car", "dog", "apple" };

    public MediaBundle(Locale myLocale) {

	String localeName = myLocale.toString();

        contents = new Object[5][2];

	String s = getClass().getResourceAsName("flag_"+
						localeName + ".gif");
	try {
	    URL url = new URL(s);
	    flag = (Image)url.getContent();
	} catch (Exception e) {
	    System.err.println("Couldn't load sound image: " + s);
	    e.printStackTrace();
	}

        contents[0][0] = "Flag";
        contents[0][1] = flag;

	for (int i = 1; i <= soundNames.length; i++) {
	    contents[i][0] = soundNames[i-1];
	    contents[i][1] = soundNames[i-1] + "_" + localeName + ".au";
	}
    }

    public Object[][] getContents() {
        return contents;
    }

// this should track the sounds as well...but MediaTracker doesn't
// support audio yet...
    public void trackMedia(Panel panel) {
	MediaTracker tracker = new MediaTracker(panel);

	tracker.addImage(flag, 0);
	try {
	    tracker.waitForAll();
	} catch (InterruptedException e) {}
    }
}
