/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class InputFileDeclared {

    FileInputStream fis;

    InputFileDeclared(String filename) throws FileNotFoundException {
        fis = new FileInputStream(filename);
    }

    String getLine() throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();

        do {
            c = fis.read();
            if (c == '\n')             // UNIX new line
                return buf.toString();
            else if (c == '\r') {      // Windows 95/NT new line
                c = fis.read();
                if (c == '\n')
                    return buf.toString();
                else {
                    buf.append((char)'\r');
                    buf.append((char)c);
                }
            } else
                buf.append((char)c);
        } while (c != -1);

        return null;
    }
}
