/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.options.Option;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AuthenticationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String PORT_ERR_MESS = "Port must be a whole number between 1 and 65535";
    private JTabbedPane tabbedPane;
    private Option option;
    private Component tab;

    public AuthenticationPanel(JTextField userName, JPasswordField password, String url, String title, boolean wrap, JCheckBox proxyType, JTextField proxyServer, JTextField proxyPort, JTabbedPane tabbedPane, Component tab, Option option) {
        GridBagConstraints gridBagConstraints;
        this.tab = tab;
        this.option = option;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.setBorder(new TitledBorder(title));
        if (url != null) {
            JLabel page = new JLabel(url);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.add((Component)page, gridBagConstraints);
        }
        if (proxyType != null) {
            this.tabbedPane = tabbedPane;
            PageVerifier pageVerifier = new PageVerifier();
            JLabel proxyNameLabel = new JLabel();
            proxyNameLabel.setText("Host:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            this.add((Component)proxyNameLabel, gridBagConstraints2);
            proxyServer.setToolTipText("The hostname or IP address of the proxy server");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.add((Component)proxyServer, gridBagConstraints2);
            JLabel proxyPortLabel = new JLabel();
            proxyPortLabel.setText("Port:");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
            this.add((Component)proxyPortLabel, gridBagConstraints2);
            proxyPort.setToolTipText("The port the proxy server runs on");
            proxyPort.setInputVerifier(pageVerifier);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.add((Component)proxyPort, gridBagConstraints2);
            proxyType.setOpaque(false);
            proxyType.setToolTipText("Use SOCKS rather than HTTP for the proxy");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            this.add((Component)proxyType, gridBagConstraints2);
        }
        JLabel userNameLabel = new JLabel();
        userNameLabel.setText("User name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)userNameLabel, gridBagConstraints);
        userName.setEditable(true);
        userName.setToolTipText("Domain\\Username for authentication");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        if (wrap) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)userName, gridBagConstraints);
        JLabel passwordLabel = new JLabel();
        passwordLabel.setText("Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)passwordLabel, gridBagConstraints);
        password.setEditable(true);
        password.setEchoChar('*');
        password.setToolTipText("Password for authentication");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)password, gridBagConstraints);
    }

    public static String checkPort(String portStr) {
        if (portStr.length() > 0) {
            int port = 0;
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                return PORT_ERR_MESS;
            }
            if (port < 1 || port > 65535) {
                return PORT_ERR_MESS;
            }
        }
        return null;
    }

    private void highlightError(JTextField field) {
        if (this.tab != null) {
            this.tabbedPane.setSelectedComponent(this.tab);
        }
        field.requestFocusInWindow();
        field.selectAll();
        Toolkit.getDefaultToolkit().beep();
    }

    class PageVerifier
    extends InputVerifier {
        PageVerifier() {
        }

        public boolean shouldYieldFocus(JComponent source) {
            if (AuthenticationPanel.this.option.isDisableVerifier()) {
                return true;
            }
            JTextField input = (JTextField)source;
            if (this.verify(source)) {
                input.setCaretPosition(0);
                return true;
            }
            AuthenticationPanel.this.highlightError(input);
            JOptionPane.showMessageDialog(AuthenticationPanel.this.tabbedPane.getParent(), AuthenticationPanel.checkPort(input.getText().trim()), "Invalid Entry", 2);
            input.setInputVerifier(this);
            input.requestFocusInWindow();
            return false;
        }

        public boolean verify(JComponent source) {
            String port = ((JTextField)source).getText().trim();
            return AuthenticationPanel.checkPort(port) == null;
        }
    }
}

