/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.css.CSSCheck;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.sgml.CSSPiece;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.validations.Validation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSValidation
implements Validation {
    public static final String ONE = "1";
    public static final String TWO = "2";
    public static final String TWO_ONE = "2.1";
    public static final String THREE = "3";
    public static final String ONE_TEXT = "Level 1";
    public static final String TWO_TEXT = "Level 2";
    public static final String TWO_ONE_TEXT = "Level 2.1";
    public static final String THREE_TEXT = "Level 3";
    private static final String STYLE_ATTR = "style";
    public static List<String> cssOptions = new ArrayList<String>();
    private String cssLevel;
    private DTDParser parser;

    public CSSValidation(String cssLevel, DTDParser parser) {
        this.cssLevel = cssLevel;
        this.parser = parser;
    }

    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        for (Piece piece : pieces) {
            cancellor.isCancelled();
            if (piece instanceof CSSPiece || !(piece instanceof Tag)) continue;
            String element = piece.getStrippedElement();
            if (piece.isMalformed() || piece.isEndTag() || piece.isVirtual() || element == null) continue;
            this.checkStyleAttribute(piece, element);
        }
    }

    private void checkStyleAttribute(Piece piece, String element) {
        String style = piece.getAttr(STYLE_ATTR);
        if (style != null && style.trim().length() > 0) {
            CSSCheck cssCheck = new CSSCheck(this.cssLevel);
            cssCheck.checkStyleAttribute(style);
        }
    }

    static {
        cssOptions.add("");
        cssOptions.add(ONE);
        cssOptions.add(TWO);
        cssOptions.add(TWO_ONE);
        cssOptions.add(THREE);
    }
}

