/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CSSProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<String> values = new ArrayList<String>();
    private String initialVal;
    private String appliesTo;
    private String inherited;
    private String percentages;
    private String mediaGroup;
    private static final List<String> specials = new ArrayList<String>();
    private static final String ANGLE = "<angle>";

    public CSSProperty(String name, String values, String initialVal, String appliesTo, String inherited, String percentages, String mediaGroup) {
        this.name = name;
        this.parseValues(values);
        this.initialVal = initialVal;
        this.appliesTo = appliesTo;
        this.inherited = inherited;
        this.percentages = percentages;
        this.mediaGroup = mediaGroup;
    }

    private void parseValues(String valuesString) {
        StringTokenizer st = new StringTokenizer(valuesString, " ");
        while (st.hasMoreTokens()) {
            String value = st.nextToken();
            if (value.charAt(0) == '<') {
                this.values.add(value);
                continue;
            }
            if (!value.equals("|")) continue;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Name: ").append(this.name);
        sb.append("\nValues: ").append(this.values);
        sb.append("\nInitialVal: ").append(this.initialVal);
        sb.append("\tAppliesTo: ").append(this.appliesTo);
        sb.append("\tInherited: ").append(this.inherited);
        sb.append("\tPercentages: ").append(this.percentages);
        sb.append("\tMediaGroup: ").append(this.mediaGroup);
        return sb.toString();
    }

    static {
        specials.add(ANGLE);
    }
}

