/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.spelling;

import com.totalvalidator.spelling.SpellingDictionary;
import com.totalvalidator.spelling.WordIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheck {
    public static final String IGNORE_LANG = "skiplangcheck";
    public static final String IGNORE_UPPER = "uppercase";
    public static final String IGNORE_MIXED = "mixedcase";
    public static final String IGNORE_NUMBERS = "wordswithdigits";
    public static final String IGNORE_HYPENS = "includehyphens";
    public static final String SPLIT_APOSTROPHE = "apostrophesplit";
    public static final String IGNORE_POSSESSIVE = "ignorepossessive";
    public static final String IGNORE_ES_PLURALS = "ignoreesplurals";
    public static final String IGNORE_PLURALS = "ignoreplurals";
    public static final String IGNORE_SUGGESTIONS = "ignoresuggestions";
    public static final String TRY_SWAPSZ = "swapszligs";
    public static final String CHECK_ATTRS = "checkattrs";
    private static final String SS = "ss";
    private static final String SZLIG = "\u00df";
    private static final Pattern SZLIG_PATTERN = Pattern.compile("\u00df");
    private static final Pattern SS_PATTERN = Pattern.compile("ss");
    private static final String VALIDA_START = "<VALIDA>";
    private static final String VALIDB_START = "<VALIDB>[";
    private static final String VALIDB_END = "]</VALIDB>";
    private static final String VALIDA_END = "</VALIDA>";
    private static final String APOS_S = "'s";
    private static final String S_APOS = "s'";
    private static final String S = "s";
    private static final String A = "a";
    private static final String E = "e";
    private static final String I = "i";
    private static final String O = "o";
    private static final String U = "u";
    private static final String SEP = ", ";
    private static final char APOS = '\'';
    private static final char HYPHEN = '-';
    private String text = "";
    boolean ignoreUpper = true;
    boolean ignoreMixed = true;
    boolean ignoreNumbers = true;
    private boolean ignoreHyphens = true;
    private boolean ignoreApostrophe = false;
    private boolean ignorePossessive = false;
    private boolean ignoreESPlurals = false;
    private boolean ignorePlurals = false;
    private boolean trySwapsz = false;
    private boolean ignoreSuggestions = false;
    private SpellingDictionary dictionary;
    private int extrasAdded = 0;
    private Set<String> badWords = new TreeSet<String>();

    public SpellCheck(SpellingDictionary dictionary, Map<String, Boolean> spellOptions) {
        this.dictionary = dictionary;
        if (spellOptions != null) {
            for (String setting : spellOptions.keySet()) {
                boolean value = spellOptions.get(setting);
                if (setting.equals(IGNORE_UPPER)) {
                    this.ignoreUpper = value;
                    continue;
                }
                if (setting.equals(IGNORE_MIXED)) {
                    this.ignoreMixed = value;
                    continue;
                }
                if (setting.equals(IGNORE_NUMBERS)) {
                    this.ignoreNumbers = value;
                    continue;
                }
                if (setting.equals(IGNORE_HYPENS)) {
                    this.ignoreHyphens = value;
                    continue;
                }
                if (setting.equals(SPLIT_APOSTROPHE)) {
                    this.ignoreApostrophe = value;
                    continue;
                }
                if (setting.equals(IGNORE_POSSESSIVE)) {
                    this.ignorePossessive = value;
                    continue;
                }
                if (setting.equals(IGNORE_PLURALS)) {
                    this.ignorePlurals = value;
                    continue;
                }
                if (setting.equals(IGNORE_ES_PLURALS)) {
                    this.ignoreESPlurals = value;
                    continue;
                }
                if (setting.equals(TRY_SWAPSZ)) {
                    this.trySwapsz = value;
                    continue;
                }
                if (!setting.equals(IGNORE_SUGGESTIONS)) continue;
                this.ignoreSuggestions = value;
            }
        }
    }

    public boolean checkSpelling(String text, boolean saveBadWords) {
        this.text = text;
        this.extrasAdded = 0;
        boolean okay = true;
        WordIterator wordIter = new WordIterator(text, this);
        boolean terminated = false;
        ArrayList<String> words = new ArrayList<String>();
        while (wordIter.hasNext() && !terminated) {
            String originalWord = wordIter.next();
            if (originalWord.length() == 0) continue;
            words.clear();
            words.add(originalWord.toLowerCase());
            boolean ignoredES = false;
            boolean triedSwapSS = false;
            boolean triedSwapSZ = false;
            for (int i = 0; i < words.size() && !terminated; ++i) {
                List<String> extras;
                String word = (String)words.get(i);
                if (word.length() <= 1 || this.dictionary.checkWord(word)) continue;
                if (this.ignoreHyphens && !(extras = this.deHyphenate(word)).isEmpty()) {
                    words.addAll(extras);
                    continue;
                }
                if (this.ignorePossessive && (word.endsWith(APOS_S) || word.endsWith(S_APOS)) && word.length() > 2) {
                    words.add(word.substring(0, word.length() - 2));
                    continue;
                }
                if (this.ignoreApostrophe && word.indexOf(39) != -1) {
                    words.addAll(this.apostropheSplit(word));
                    continue;
                }
                if (this.ignoreESPlurals) {
                    String newWord;
                    if (ignoredES && word.length() > 2) {
                        words.add(word.substring(0, word.length() - 1));
                        continue;
                    }
                    if (word.length() > 3 && word.endsWith(S) && (newWord = this.deleteS(word)) != null) {
                        words.add(newWord);
                        ignoredES = true;
                        continue;
                    }
                }
                if (this.ignorePlurals && word.endsWith(S) && !word.endsWith(SS) && word.length() > 2) {
                    words.add(word.substring(0, word.length() - 1));
                    continue;
                }
                if (this.trySwapsz && !triedSwapSS && word.indexOf(SZLIG) != -1) {
                    words.add(SZLIG_PATTERN.matcher(word).replaceAll(SS));
                    triedSwapSZ = true;
                    continue;
                }
                if (this.trySwapsz && !triedSwapSZ && word.indexOf(SS) != -1) {
                    words.add(SS_PATTERN.matcher(word).replaceAll(SZLIG));
                    triedSwapSS = true;
                    continue;
                }
                okay = false;
                if (words.size() > 1) {
                    words.clear();
                }
                this.updateText(originalWord, wordIter, this.ignoreSuggestions ? null : this.dictionary.getAlternatives(originalWord, false));
                if (!saveBadWords) continue;
                this.badWords.add(originalWord);
            }
        }
        return okay;
    }

    private void updateText(String word, WordIterator wordIter, Set<String> alternatives) {
        StringBuilder sb = new StringBuilder();
        sb.append(VALIDA_START).append(word).append(VALIDB_START);
        if (alternatives != null && !alternatives.isEmpty()) {
            boolean firstOne = true;
            int count = 0;
            Iterator<String> iter = alternatives.iterator();
            while (iter.hasNext()) {
                if (!firstOne) {
                    sb.append(SEP);
                }
                sb.append(iter.next().substring(3));
                firstOne = false;
                if (++count != 8) continue;
            }
        }
        sb.append(VALIDB_END).append(VALIDA_END);
        int extraLength = sb.length() - word.length();
        int endOfWord = wordIter.getEndOfWord() + this.extrasAdded;
        if (endOfWord < this.text.length()) {
            sb.append(this.text.substring(endOfWord));
        }
        int startOfWord = wordIter.getStartOfWord() + this.extrasAdded;
        sb.insert(0, this.text.substring(0, startOfWord));
        this.text = sb.toString();
        this.extrasAdded += extraLength;
    }

    private String deleteS(String word) {
        String newWord = null;
        if ((word = word.substring(0, word.length() - 1)).endsWith(A) || word.endsWith(E) || word.endsWith(I) || word.endsWith(O) || word.endsWith(U)) {
            newWord = word;
        }
        return newWord;
    }

    private List<String> apostropheSplit(String word) {
        ArrayList<String> words = new ArrayList<String>();
        int index = word.indexOf(39);
        if (index != word.length() - 1) {
            words.add(word.substring(0, index + 1));
            words.add(word.substring(index + 1));
        }
        return words;
    }

    private List<String> deHyphenate(String word) {
        ArrayList<String> words = new ArrayList<String>();
        int index = word.indexOf(45);
        if (index > 0 && index != word.length() - 1) {
            do {
                String nextWord = word.substring(0, index);
                word = word.substring(index + 1);
                words.add(nextWord);
            } while ((index = word.indexOf(45)) != -1 && index != word.length() - 1);
            words.add(word);
        }
        return words;
    }

    public String getText() {
        return this.text;
    }

    public Set<String> getBadWords() {
        return this.badWords;
    }
}

