/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SupportedDTDs {
    private static final String NONE = "";
    public static final String NO_DTD = "NO DTD";
    private static final String AUTO = "Auto-detect";
    private static final String AUTO_DTD = "dtds/doctype/doctype.dtd";
    private static final String BEST_FIT = "Best-fit";
    private static final String BEST_FIT_DTD = "dtds/doctype/bestfit.dtd";
    private static final String HTML_50 = "HTML5";
    public static final String HTML_50_DTD = "dtds/5.0/html5.dtd";
    private static final String XHTML_50 = "XHTML5";
    public static final String XHTML_50_DTD = "dtds/5.0/xhtml5.dtd";
    private static final String XHTML_11 = "XHTML 1.1";
    private static final String XHTML_11_DTD = "dtds/1.1/xhtml11.dtd";
    private static final String XHTML_B11 = "XHTML Basic 1.1";
    private static final String XHTML_B11_DTD = "dtds/b1.1/xhtml-basic11.dtd";
    private static final String XHTML_RDF_11 = "XHTML+RDFa 1.1";
    private static final String XHTML_RDF_11_DTD = "dtds/r1.1/xhtml-rdfa-2.dtd";
    private static final String XHTML_RDF_10 = "XHTML+RDFa 1.0";
    private static final String XHTML_RDF_10_DTD = "dtds/r1.0/xhtml-rdfa-1.dtd";
    private static final String HTML4_RDF_11 = "HTML4+RDFa 1.1";
    private static final String HTML4_RDF_11_DTD = "dtds/r11h4/html401-rdfa11-1.dtd";
    private static final String HTML4_RDF_10 = "HTML4+RDFa 1.0";
    private static final String HTML4_RDF_10_DTD = "dtds/r1h4/html4-rdfa-1.dtd";
    private static final String XHTML_10_STRICT = "XHTML 1.0 Strict";
    private static final String XHTML_10_STRICT_DTD = "dtds/1.0/xhtml1-strict.dtd";
    private static final String XHTML_10_LOOSE = "XHTML 1.0 Transitional";
    private static final String XHTML_10_LOOSE_DTD = "dtds/1.0/xhtml1-transitional.dtd";
    private static final String XHTML_10_FRAMESET = "XHTML 1.0 Frameset";
    private static final String XHTML_10_FRAMESET_DTD = "dtds/1.0/xhtml1-frameset.dtd";
    private static final String XHTML_P10 = "XHTML-Print 1.0";
    private static final String XHTML_P10_DTD = "dtds/p1.0/xhtml-print10.dtd";
    private static final String XHTML_B10 = "XHTML Basic 1.0";
    private static final String XHTML_B10_DTD = "dtds/b1.0/xhtml-basic10.dtd";
    private static final String ISO = "ISO/IEC 15445:2000";
    private static final String ISO_DTD = "dtds/ISO/15445.dtd";
    private static final String HTML_401_STRICT = "HTML 4.01 Strict";
    private static final String HTML_401_STRICT_DTD = "dtds/4.01/strict.dtd";
    private static final String HTML_401_LOOSE = "HTML 4.01 Transitional";
    private static final String HTML_401_LOOSE_DTD = "dtds/4.01/loose.dtd";
    private static final String HTML_401_FRAMESET = "HTML 4.01 Frameset";
    private static final String HTML_401_FRAMESET_DTD = "dtds/4.01/frameset.dtd";
    private static final String HTML_40_STRICT = "HTML 4.0 Strict";
    private static final String HTML_40_STRICT_DTD = "dtds/4.0/strict.dtd";
    private static final String HTML_40_LOOSE = "HTML 4.0 Transitional";
    private static final String HTML_40_LOOSE_DTD = "dtds/4.0/loose.dtd";
    private static final String HTML_40_FRAMESET = "HTML 4.0 Frameset";
    private static final String HTML_40_FRAMESET_DTD = "dtds/4.0/frameset.dtd";
    private static final String HTML_32 = "HTML 3.2";
    private static final String HTML_32_DTD = "dtds/3.2/HTML32.dtd";
    private static final String HTML_20 = "HTML 2.0";
    private static final String HTML_20_DTD = "dtds/2.0/html.dtd";
    public static final String HTML_50_DOCTYPE = "about:legacy-compat";
    private static final String XHTML_11_DOCTYPE = "-//W3C//DTD XHTML 1.1//EN";
    private static final String XHTML_B11_DOCTYPE = "-//W3C//DTD XHTML Basic 1.1//EN";
    private static final String XHTML_RDF_11_DOCTYPE = "-//W3C//DTD XHTML+RDFa 1.1//EN";
    private static final String XHTML_RDF_10_DOCTYPE = "-//W3C//DTD XHTML+RDFa 1.0//EN";
    private static final String HTML4_RDF_11_DOCTYPE = "-//W3C//DTD HTML 4.01+RDFa 1.1//EN";
    private static final String HTML4_RDF_10_DOCTYPE = "-//W3C//DTD HTML4+RDFa 1.0//EN";
    private static final String XHTML_10_STRICT_DOCTYPE = "-//W3C//DTD XHTML 1.0 Strict//EN";
    private static final String XHTML_10_LOOSE_DOCTYPE = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private static final String XHTML_10_FRAMESET_DOCTYPE = "-//W3C//DTD XHTML 1.0 Frameset//EN";
    private static final String XHTML_P10_DOCTYPE = "-//W3C//DTD XHTML-Print 1.0//EN";
    private static final String XHTML_B10_DOCTYPE = "-//W3C//DTD XHTML Basic 1.0//EN";
    private static final String HTML_ISO_DOCTYPE = "ISO/IEC 15445:2000//DTD HTML//EN";
    private static final String HTML_ISO_1_DOCTYPE = "ISO/IEC 15445:2000//DTD HyperText Markup Language//EN";
    private static final String HTML_401_STRICT_DOCTYPE = "-//W3C//DTD HTML 4.01//EN";
    private static final String HTML_401_LOOSE_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String HTML_401_FRAMESET_DOCTYPE = "-//W3C//DTD HTML 4.01 Frameset//EN";
    private static final String HTML_40_STRICT_DOCTYPE = "-//W3C//DTD HTML 4.0//EN";
    private static final String HTML_40_LOOSE_DOCTYPE = "-//W3C//DTD HTML 4.0 Transitional//EN";
    private static final String HTML_40_FRAMESET_DOCTYPE = "-//W3C//DTD HTML 4.0 Frameset//EN";
    private static final String HTML_32_DOCTYPE = "-//W3C//DTD HTML 3.2 Final//EN";
    private static final String HTML_32_1_DOCTYPE = "-//W3C//DTD HTML 3.2 Draft//EN";
    private static final String HTML_32_2_DOCTYPE = "-//W3C//DTD HTML 3.2//EN";
    private static final String HTML_20_DOCTYPE = "-//IETF//DTD HTML 2.0//EN";
    private static final String HTML_20_1_DOCTYPE = "-//IETF//DTD HTML//EN";
    private static final String HTML_20_2_DOCTYPE = "-//IETF//DTD HTML LEVEL 2//EN";
    private static final String HTML_20_3_DOCTYPE = "-//IETF//DTD HTML 2.0 LEVEL 2//EN";
    private static final String END_OPTION = "</option>\n";
    private static final String VALUE = " value=\"";
    private static final String END_TAG = "\">";
    public static final String[] DTD_OPTIONS = new String[]{"></option>\n", " value=\"dtds/doctype/doctype.dtd\">Auto-detect</option>\n", " value=\"dtds/doctype/bestfit.dtd\">Best-fit</option>\n", " value=\"dtds/5.0/html5.dtd\">HTML5</option>\n", " value=\"dtds/5.0/xhtml5.dtd\">XHTML5</option>\n", " value=\"dtds/1.1/xhtml11.dtd\">XHTML 1.1</option>\n", " value=\"dtds/b1.1/xhtml-basic11.dtd\">XHTML Basic 1.1</option>\n", " value=\"dtds/r1.1/xhtml-rdfa-2.dtd\">XHTML+RDFa 1.1</option>\n", " value=\"dtds/r1.0/xhtml-rdfa-1.dtd\">XHTML+RDFa 1.0</option>\n", " value=\"dtds/1.0/xhtml1-strict.dtd\">XHTML 1.0 Strict</option>\n", " value=\"dtds/1.0/xhtml1-transitional.dtd\">XHTML 1.0 Transitional</option>\n", " value=\"dtds/1.0/xhtml1-frameset.dtd\">XHTML 1.0 Frameset</option>\n", " value=\"dtds/p1.0/xhtml-print10.dtd\">XHTML-Print 1.0</option>\n", " value=\"dtds/b1.0/xhtml-basic10.dtd\">XHTML Basic 1.0</option>\n", " value=\"dtds/r11h4/html401-rdfa11-1.dtd\">HTML4+RDFa 1.1</option>\n", " value=\"dtds/r1h4/html4-rdfa-1.dtd\">HTML4+RDFa 1.0</option>\n", " value=\"dtds/4.01/strict.dtd\">HTML 4.01 Strict</option>\n", " value=\"dtds/4.01/loose.dtd\">HTML 4.01 Transitional</option>\n", " value=\"dtds/4.01/frameset.dtd\">HTML 4.01 Frameset</option>\n", " value=\"dtds/4.0/strict.dtd\">HTML 4.0 Strict</option>\n", " value=\"dtds/4.0/loose.dtd\">HTML 4.0 Transitional</option>\n", " value=\"dtds/4.0/frameset.dtd\">HTML 4.0 Frameset</option>\n", " value=\"dtds/ISO/15445.dtd\">ISO/IEC 15445:2000</option>\n", " value=\"dtds/3.2/HTML32.dtd\">HTML 3.2</option>\n", " value=\"dtds/2.0/html.dtd\">HTML 2.0</option>\n"};
    public static List<String> dtdNames = new ArrayList<String>();
    public static List<String> dtdOptions = new ArrayList<String>();
    public static List<String> framesetDTDs = new ArrayList<String>();
    public static List<String> nonFramesetDTDs = new ArrayList<String>();
    private static Map<String, String> dtds = new HashMap<String, String>();
    private static Map<String, String> doctypes = new HashMap<String, String>();
    private static Map<String, String> docTypeNames = new HashMap<String, String>();
    private static Map<String, String> xmlDocTypeNames = new HashMap<String, String>();

    private SupportedDTDs() {
    }

    public static String getDTD(String dtdName) {
        return dtds.get(dtdName);
    }

    public static String getDTDFromDocType(String docType) {
        return doctypes.get(docType.toUpperCase(Locale.ENGLISH));
    }

    public static String getDTDNameFromDocType(String docType, boolean isXml) {
        return isXml ? xmlDocTypeNames.get(docType.toUpperCase(Locale.ENGLISH)) : docTypeNames.get(docType.toUpperCase(Locale.ENGLISH));
    }

    public static String getDisplayName(String dtdName) {
        String displayName = null;
        for (String name : dtds.keySet()) {
            if (!dtdName.equals(dtds.get(name))) continue;
            displayName = name;
            break;
        }
        return displayName;
    }

    public static boolean isHTML5(String docType) {
        return HTML_50_DOCTYPE.equals(docType);
    }

    static {
        dtdNames.add(NONE);
        dtdNames.add(AUTO);
        dtdNames.add(BEST_FIT);
        dtdNames.add(HTML_50);
        dtdNames.add(XHTML_50);
        dtdNames.add(XHTML_11);
        dtdNames.add(XHTML_B11);
        dtdNames.add(XHTML_RDF_11);
        dtdNames.add(XHTML_RDF_10);
        dtdNames.add(XHTML_10_STRICT);
        dtdNames.add(XHTML_10_LOOSE);
        dtdNames.add(XHTML_10_FRAMESET);
        dtdNames.add(XHTML_P10);
        dtdNames.add(XHTML_B10);
        dtdNames.add(HTML4_RDF_11);
        dtdNames.add(HTML4_RDF_10);
        dtdNames.add(HTML_401_STRICT);
        dtdNames.add(HTML_401_LOOSE);
        dtdNames.add(HTML_401_FRAMESET);
        dtdNames.add(HTML_40_STRICT);
        dtdNames.add(HTML_40_LOOSE);
        dtdNames.add(HTML_40_FRAMESET);
        dtdNames.add(ISO);
        dtdNames.add(HTML_32);
        dtdNames.add(HTML_20);
        dtdOptions.add(NONE);
        dtdOptions.add(AUTO_DTD);
        dtdOptions.add(BEST_FIT_DTD);
        dtdOptions.add(HTML_50_DTD);
        dtdOptions.add(XHTML_50_DTD);
        dtdOptions.add(XHTML_11_DTD);
        dtdOptions.add(XHTML_B11_DTD);
        dtdOptions.add(XHTML_RDF_11_DTD);
        dtdOptions.add(XHTML_RDF_10_DTD);
        dtdOptions.add(HTML4_RDF_11_DTD);
        dtdOptions.add(HTML4_RDF_10_DTD);
        dtdOptions.add(XHTML_10_STRICT_DTD);
        dtdOptions.add(XHTML_10_LOOSE_DTD);
        dtdOptions.add(XHTML_10_FRAMESET_DTD);
        dtdOptions.add(XHTML_P10_DTD);
        dtdOptions.add(XHTML_B10_DTD);
        dtdOptions.add(HTML_401_STRICT_DTD);
        dtdOptions.add(HTML_401_LOOSE_DTD);
        dtdOptions.add(HTML_401_FRAMESET_DTD);
        dtdOptions.add(HTML_40_STRICT_DTD);
        dtdOptions.add(HTML_40_LOOSE_DTD);
        dtdOptions.add(HTML_40_FRAMESET_DTD);
        dtdOptions.add(ISO_DTD);
        dtdOptions.add(HTML_32_DTD);
        dtdOptions.add(HTML_20_DTD);
        dtds.put(NONE, NO_DTD);
        dtds.put(AUTO, AUTO_DTD);
        dtds.put(BEST_FIT, BEST_FIT_DTD);
        dtds.put(HTML_50, HTML_50_DTD);
        dtds.put(XHTML_50, XHTML_50_DTD);
        dtds.put(XHTML_11, XHTML_11_DTD);
        dtds.put(XHTML_B11, XHTML_B11_DTD);
        dtds.put(XHTML_RDF_11, XHTML_RDF_11_DTD);
        dtds.put(XHTML_RDF_10, XHTML_RDF_10_DTD);
        dtds.put(HTML4_RDF_11, HTML4_RDF_11_DTD);
        dtds.put(HTML4_RDF_10, HTML4_RDF_10_DTD);
        dtds.put(XHTML_10_STRICT, XHTML_10_STRICT_DTD);
        dtds.put(XHTML_10_LOOSE, XHTML_10_LOOSE_DTD);
        dtds.put(XHTML_10_FRAMESET, XHTML_10_FRAMESET_DTD);
        dtds.put(XHTML_P10, XHTML_P10_DTD);
        dtds.put(XHTML_B10, XHTML_B10_DTD);
        dtds.put(HTML_401_STRICT, HTML_401_STRICT_DTD);
        dtds.put(HTML_401_LOOSE, HTML_401_LOOSE_DTD);
        dtds.put(HTML_401_FRAMESET, HTML_401_FRAMESET_DTD);
        dtds.put(HTML_40_STRICT, HTML_40_STRICT_DTD);
        dtds.put(HTML_40_LOOSE, HTML_40_LOOSE_DTD);
        dtds.put(HTML_40_FRAMESET, HTML_40_FRAMESET_DTD);
        dtds.put(ISO, ISO_DTD);
        dtds.put(HTML_32, HTML_32_DTD);
        dtds.put(HTML_20, HTML_20_DTD);
        doctypes.put(HTML_50_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_50_DTD);
        doctypes.put(XHTML_11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_11_DTD);
        doctypes.put(XHTML_B11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_B11_DTD);
        doctypes.put(XHTML_RDF_11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_RDF_11_DTD);
        doctypes.put(XHTML_RDF_10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_RDF_10_DTD);
        doctypes.put(HTML4_RDF_11_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML4_RDF_11_DTD);
        doctypes.put(HTML4_RDF_10_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML4_RDF_10_DTD);
        doctypes.put(XHTML_10_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_STRICT_DTD);
        doctypes.put(XHTML_10_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_LOOSE_DTD);
        doctypes.put(XHTML_10_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_FRAMESET_DTD);
        doctypes.put(XHTML_P10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_P10_DTD);
        doctypes.put(XHTML_B10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_B10_DTD);
        doctypes.put(HTML_401_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_STRICT_DTD);
        doctypes.put(HTML_401_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_LOOSE_DTD);
        doctypes.put(HTML_401_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_FRAMESET_DTD);
        doctypes.put(HTML_40_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_STRICT_DTD);
        doctypes.put(HTML_40_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_LOOSE_DTD);
        doctypes.put(HTML_40_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_FRAMESET_DTD);
        doctypes.put(HTML_32_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32_DTD);
        doctypes.put(HTML_32_1_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32_DTD);
        doctypes.put(HTML_32_2_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32_DTD);
        doctypes.put(HTML_20_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20_DTD);
        doctypes.put(HTML_20_1_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20_DTD);
        doctypes.put(HTML_20_2_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20_DTD);
        doctypes.put(HTML_20_3_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20_DTD);
        doctypes.put(HTML_ISO_DOCTYPE.toUpperCase(Locale.ENGLISH), ISO_DTD);
        doctypes.put(HTML_ISO_1_DOCTYPE.toUpperCase(Locale.ENGLISH), ISO_DTD);
        xmlDocTypeNames.put(HTML_50_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_50);
        xmlDocTypeNames.put(XHTML_11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_11);
        xmlDocTypeNames.put(XHTML_B11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_B11);
        xmlDocTypeNames.put(XHTML_RDF_11_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_RDF_11);
        xmlDocTypeNames.put(XHTML_RDF_10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_RDF_10);
        xmlDocTypeNames.put(XHTML_10_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_STRICT);
        xmlDocTypeNames.put(XHTML_10_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_LOOSE);
        xmlDocTypeNames.put(XHTML_10_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_10_FRAMESET);
        xmlDocTypeNames.put(XHTML_P10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_P10);
        xmlDocTypeNames.put(XHTML_B10_DOCTYPE.toUpperCase(Locale.ENGLISH), XHTML_B10);
        docTypeNames.put(HTML_50_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_50);
        docTypeNames.put(HTML_401_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_STRICT);
        docTypeNames.put(HTML4_RDF_11_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML4_RDF_11);
        docTypeNames.put(HTML4_RDF_10_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML4_RDF_10);
        docTypeNames.put(HTML_401_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_LOOSE);
        docTypeNames.put(HTML_401_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_401_FRAMESET);
        docTypeNames.put(HTML_40_STRICT_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_STRICT);
        docTypeNames.put(HTML_40_LOOSE_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_LOOSE);
        docTypeNames.put(HTML_40_FRAMESET_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_40_FRAMESET);
        docTypeNames.put(HTML_32_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32);
        docTypeNames.put(HTML_32_1_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32);
        docTypeNames.put(HTML_32_2_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_32);
        docTypeNames.put(HTML_20_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20);
        docTypeNames.put(HTML_20_1_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20);
        docTypeNames.put(HTML_20_2_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20);
        docTypeNames.put(HTML_20_3_DOCTYPE.toUpperCase(Locale.ENGLISH), HTML_20);
        docTypeNames.put(HTML_ISO_DOCTYPE.toUpperCase(Locale.ENGLISH), ISO);
        docTypeNames.put(HTML_ISO_1_DOCTYPE.toUpperCase(Locale.ENGLISH), ISO);
        nonFramesetDTDs.add(HTML_50_DTD);
        nonFramesetDTDs.add(XHTML_50_DTD);
        nonFramesetDTDs.add(XHTML_11_DTD);
        nonFramesetDTDs.add(XHTML_RDF_11_DTD);
        nonFramesetDTDs.add(XHTML_RDF_10_DTD);
        nonFramesetDTDs.add(HTML4_RDF_11_DTD);
        nonFramesetDTDs.add(HTML4_RDF_10_DTD);
        nonFramesetDTDs.add(XHTML_B11_DTD);
        nonFramesetDTDs.add(XHTML_10_STRICT_DTD);
        nonFramesetDTDs.add(XHTML_10_LOOSE_DTD);
        nonFramesetDTDs.add(XHTML_P10_DTD);
        nonFramesetDTDs.add(XHTML_B10_DTD);
        nonFramesetDTDs.add(HTML_401_STRICT_DTD);
        nonFramesetDTDs.add(HTML_401_LOOSE_DTD);
        nonFramesetDTDs.add(HTML_40_STRICT_DTD);
        nonFramesetDTDs.add(HTML_40_LOOSE_DTD);
        nonFramesetDTDs.add(HTML_32_DTD);
        nonFramesetDTDs.add(HTML_20_DTD);
        framesetDTDs.add(XHTML_10_FRAMESET_DTD);
        framesetDTDs.add(HTML_401_FRAMESET_DTD);
        framesetDTDs.add(HTML_40_FRAMESET_DTD);
    }
}

