/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.parser;

import com.totalvalidator.exceptions.CommandLineException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.jsp.ValidatorFormOptions;
import com.totalvalidator.online.MailHelper;
import com.totalvalidator.options.Option;
import com.totalvalidator.options.OptionFactory;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.snapshot.Snapshot;
import com.totalvalidator.struts.ValidatorForm;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.MyCookieHandler;
import com.totalvalidator.utils.ProxyDetails;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private List<String> ignoreMessages = new ArrayList<String>();
    public static final String USER_AGENT_FILE = "identities.props";
    public static final String DEFAULT_UA_IDENTITY = "Total Validator";
    public static final String DEFAULT_UA_DETAILS = "TotalValidator/6.0";
    public static final long TIME_OUT = 20000L;
    public static final long WAIT_TIME = 15L;
    public static final String SCREENSHOTS_TAKEN = "<span class='error'>NOTE: Screenshots will appear in another tab/window, or be sent as an email attachment</span>";
    private static final String DEFAULT_PROPS_FILE = "commandline.props";
    private static final String EXTENSION_PROPS_FILE = "extension.props";
    private static final String BROKEN_LINK_CHECK = "Check for broken links: true";
    private static final Pattern SPACE_PATTERN = Pattern.compile("%20");
    private static final char COMMENT = '#';
    private static final String EQUALS = "=";
    private static final char DASH = '-';
    private static final String USAGE = "Commandline Options:\n    -help : displays the list of command line options.\n    -properties Path_To_File : Where Path_To_File is properties file containing\n\t the command line options. If this option is used then it must be\n\t the only one used on the command line.\n    -interact : Will automatically display launch a browser to\n\t display the results, and use interactive dialogs where there are\n\t problems with the options supplied. Don't use this option if you\n\t wish to run without any user interaction (any errors will be\n\t displayed on the command line).\n    -interactiveauth : If set (and -interact is set before this option) then\n +\t display prompts when web/proxy authentication fails.\n    -hideresults : Don't display the validation results in a browser.\n\t If used with -interact then other dialogs may still appear.\n    -file Path_To_File : Where Path_To_File is the starting web page located on\n\t local disk e.g. c:\\mysite\\index.html. If both this and -url are\n\t not supplied but -interact is used, then you will be prompted to\n\t choose a starting page on disk.\n    -url URL : Where URL is the starting web page\n\t e.g. http://mywebpage.com/index.html\n    -userobots : Skip paths specified in robots.txt\n    -skippath Path_To_Skip : where Path_To_Skip is a path within the starting\n\t URL to skip when testing more than one page (must start with a '/').\n\t Regular expressions may be used, and you can use this option more\n\t than once.\n    -includepath Path_To_Include : where Path_To_Include is a path within the\n\t starting URL to include when testing more than one page.\n\t This path must start with a '/'.\n\t Regular expressions may be used, and you can use this option more\n\t than once.\n    -pages Pages : Where Pages is the number of pages to check. By default it\n\t will only check one page. Set this to zero to check all pages.\n    -depth Depth : Where Depth is the the depth of recursion through the site.\n    -followlinks : Will follow all links regardless of the starting page\n\t (Use with care).\n    -noquery : Will strip off query parameters from links before testing or\n\t following them.\n    -nosession : Will strip off session ids from links before testing or\n\t following them. e.g. 'http://yourdomain/page.html;session_id' \n    -validateerrors : Validate error pages when HTTP error code is returned.\n    -showsuccess : Use this option to list pages that had no reported problems.\n    -dtd DTD : Where DTD represents the (X)HTML validation you wish to apply.\n\t See documentation for valid values.\n    -accessibility 508|A|AA|AAA|A2|AA2|AAA2 : Supply one of the values \n\t 508|A|AA|AAA|A2|AA2|AAA2 to represent the WAI or Section 508 \n\t validation you wish to apply.\n    -spellcheck GB|US|IT|FR|ES|DE : Supply one of the values GB|US|IT|FR|ES|DE\n\t to represent the language you wish to spell check with.\n    -altdic Path_To_File : Where Path_To_File is the path to a supplementary\n\t or alternative dictionary to use.\n    -uppercase : Spell check words that are all in upper case.\n\t Must appear after -spellcheck or -altdic\n    -mixedcase : Spell check words that are in mixed case.\n\t Must appear after -spellcheck or -altdic\n    -wordswithdigits : Spell check words with digits in.\n\t Must appear after -spellcheck or -altdic\n    -ignoresuggestions : When spell checking don't supply any alternative words\n\t when a word cannot be found in the dictionary.\n\t Must appear after -spellcheck or -altdic\n    -checkattrs : Spell check text in these attributes: alt, title, summary,\n\t label, prompt, standby.\n\t Must appear after -spellcheck or -altdic\n    -skiplangcheck : When spell checking don't check that the web page language\n\t is compatible with the spell check language.\n    -savebadwords : When spell checking save all the misspelt words to a\n\t dictionary.\n    -brokenlinks : Check for and report any broken links.\n    -timeout Seconds : If set after -brokenlinks, then Seconds\n +\t is the time to wait before declaring a link broken.\n\t This must be a value between 10 and 120. It defaults to 20.\n    -concurrency Maximum : If set after -brokenlinks, then Maximum is the\n\t maximum number of links to check simultaneously. This must be a\n\t positive integer. Set to 0 to check all links simultaneously.\n\t It defaults to 10.\n    -reportredirects : If set after -brokenlinks, then all 301/302/303\n\t redirection warnings will be reported.\n    -user UserName : Where UserName is required to access protected web pages.\n    -password Password : Where Password is required to access protected web\n\t pages.\n    -ignoreproxy : Ignore any proxy settings set in 'internet options' control\n\t panel applet.\n    -proxyhost Host : Where Host is the name of the proxy server you need to go\n\t through to access the starting web page.\n    -proxyport Port : Where Port is the port the proxy server listens on.\n\t This must be an integer in the range (1-65535).\n    -puser UserName : Where UserName is required to traverse an authenticating\n\t proxy server.\n    -ppassword Password : Where Password is required to traverse an\n\t authenticating proxy server.\n    -showwarnings : Show warnings as well as errors in the results.\n    -hidecontent : Hides the content on the report.\n    -ENNN : Where NNN is the number of an error to suppress on the report.\n\t You can use the -E option as many times as you wish on the\n\t command line for each error you wish to suppress.\n    -WNNN : Where NNN is the number of a warning to suppress on the report.\n\t You can use the -W option as many times as you wish on the\n\t command line for each warning you wish to suppress.\n    -identity identity : Where identity is the name of a user agent in the\n\t identity.props file.\n    -cookiepolicy ACCEPT_ALL|ACCEPT_NONE|ACCEPT_SESSION|ACCEPT_SERVER : Use\n\t this option to specify how you wish to deal with cookies received\n\t whilst validating. Defaults to ACCEPT_SERVER.\n    -cachepolicy CACHE_ALL|CACHE_PERMANENT|CACHE_NONE : Use this option to\n\t specify which cookies received during validation you wish to\n\t cache to disk. Defaults to CACHE_PERMANENT.\n    -sendpolicy SEND_ALL|SEND_PERMANENT|SEND_NONE : Use this option to specify\n\t which cookies to send from the disk cache. Defaults to\n\t SEND_PERMANENT.\n    -cookieX Cookie : Where Cookie is a standard set-cookie HTTP header. This\n\t cookie will be treated like a normal cookie received from the\n\t server for the starting page and subject to the policies defined\n\t above. X is a number greater than zero to allow more than one \t cookie to be passed.\n    -shortreport : Display a short form of the report.\n    -uniquereport : Output the results using a unique report name.\n    -displaybrowser Browser : The browser you\n\t wish to display the results with. This defaults to the default \n\t browser. It should be the browser's name for OS X\n\t and the full browser's path for Linux or Windows.\n    -resultsfolder Path_To_Folder : Where Path_To_Folder is the folder you\n\t wish to store the results in. This defaults to the folder you\n\t installed the tool into.\n    -showresultspath : Output to stdout the path to the results file.\n    -stdout : Output the results file to stdout. Only works if a single\n\t page is being validated.\n    -extendedstatus : Output an exit status of 4 if any validation errors,\n\t 2 if any warnings, 6 if both, 0 if none, 1 if program errors.\n    -action Action : Where Action is the value of the 'action' attribute value\n\t to match for form submission.\n    -actionregex : Treat the -action option as a regular expression.\n    -submit Name : Where Name is the name of the submit button to use if there\n\t is more than one.\n    -nameX Name : Where Name is the name of a parameter to submit when sending\n\t a form, and X is a number greater than zero, e.g. '-name3 userid' \n    -valueX Value : Where Value is the parameter value to submit when sending\n\t a form, and X is a number greater than zero corresponding to a\n +\t <strong>-nameX</strong> option, e.g. '-value3 julie'.\n";
    private boolean extension = false;
    private boolean shortReport;
    private List<String> options = new ArrayList<String>();
    private String theUrl = null;
    private String dtdName = null;
    private boolean reportRedirects = false;
    private boolean brokenLinks = false;
    private int maxPages = -1;
    private int depth = -1;
    private long timeOut = 20000L;
    private boolean showContent = true;
    private String userName = null;
    private String password = "";
    private boolean useSystemProxy = true;
    private ProxyDetails proxyDetails = null;
    private String proxyHost = null;
    private String proxyPort = "";
    private boolean socksProxy = false;
    private String proxyUserName = null;
    private String proxyPassword = "";
    private Map<String, Boolean> spellOptions;
    private String uploadedFile;
    private String[] browsers;
    private String resolution = "1024x768";
    private long waitTime = 15L;
    private boolean interact = false;
    private boolean interactiveAuth = false;
    private boolean dtdPrompt = false;
    private boolean showWarnings = false;
    private boolean checkLang = true;
    private boolean saveBadWords;
    private Set<String> pathsToInclude = new HashSet<String>();
    private Set<String> pathsToSkip = new HashSet<String>();
    private Set<String> foldersToSkip = new HashSet<String>();
    private Set<Pattern> patternsToSkip;
    private Set<String> foldersToInclude = new HashSet<String>();
    private Set<Pattern> patternsToInclude;
    private boolean showSuccess = false;
    private boolean uploadOnline = false;
    private String userAgent = "TotalValidator/6.0";
    private boolean tool;
    private boolean commandLine = false;
    private boolean css = false;
    private String cssLevel = "2.1";
    private boolean accessibility = false;
    private boolean wcag2 = false;
    private boolean us508 = false;
    private String accessibilityLevel = null;
    private String cookiePolicy = "ACCEPT_SERVER";
    private String cachePolicy = "CACHE_PERMANENT";
    private String sendPolicy = "SEND_PERMANENT";
    private List<String> cookies = new ArrayList<String>();
    private String resultsFolder;
    private boolean uniqueResultsFile = false;
    private boolean followLinks = false;
    private boolean noQuery = false;
    private boolean noSession = false;
    private boolean validateErrors = false;
    private String suffix = ".zip";
    private boolean extendedStatus = false;
    private boolean hideResults = false;
    private boolean showResultsPath = false;
    private String altDic = null;
    private String lang = null;
    private String toAddress = null;
    private String sourceName = null;
    private boolean spellCheck = false;
    private String language = null;
    private String httpCharset;
    private String bomCharset;
    private String otherCharset;
    private boolean screenshotsTaken;
    private String origUrl;
    private int concurrencyLimit;
    private boolean useRobots;
    private boolean resultsToStdout;
    private String actionURL;
    private boolean actionRegex;
    private String submitButton;
    private Vector<String> formNames = new Vector();
    private Vector<String> formValues = new Vector();
    private Map<Integer, String[]> parameters = new HashMap<Integer, String[]>();
    private Map<String, List<String>> nvParameters;
    private Map<String, List<String>> nvPairs;
    private boolean formPost = false;
    private Set<String> formsTested = new HashSet<String>();
    private static EntityEncoder defaultEncoder;

    public CommandLineParser(FileUtils fileUtils) {
        defaultEncoder = new EntityEncoder();
        try {
            defaultEncoder.addBasics(fileUtils);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void processArgs(String[] args) throws CommandLineException {
        Option option = null;
        try {
            option = OptionFactory.newOption();
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Couldn't get Option", e);
            System.exit(1);
        }
        this.setMaxPages(1);
        this.cachePolicy = option.defaultCachePolicy();
        this.sendPolicy = option.defaultSendPolicy();
        if (this.commandLine && option.getType() != 'P') {
            throw new CommandLineException("Command line operation not supported.");
        }
        if (args.length == 0 || args.length == 2 && args[0].equals("-properties")) {
            File propsFile = null;
            if (args.length == 0) {
                File oldPropsFile;
                propsFile = new File(FileUtils.getDataFolder() + DEFAULT_PROPS_FILE);
                if (!propsFile.exists() && (oldPropsFile = new File(FileUtils.getInstallationFolder() + DEFAULT_PROPS_FILE)).exists()) {
                    try {
                        FileUtils.renameTo(oldPropsFile, propsFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        GeneralUtils.LOGGER.fine("Couldn't copy default props file into place");
                    }
                }
            } else {
                propsFile = new File(args[1]);
            }
            try {
                args = this.readProps(propsFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw new CommandLineException("Invalid -properties argument: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName()));
            }
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-path")) continue;
            this.extension = true;
            break;
        }
        if (this.extension) {
            try {
                String[] propsArgs = this.readProps(FileUtils.getDataFolder() + EXTENSION_PROPS_FILE);
                if (propsArgs.length > 0) {
                    String[] newArgs = new String[propsArgs.length + args.length];
                    System.arraycopy(propsArgs, 0, newArgs, 0, propsArgs.length);
                    System.arraycopy(args, 0, newArgs, propsArgs.length, args.length);
                    args = newArgs;
                }
            }
            catch (Exception e) {
                GeneralUtils.LOGGER.fine("extension.props not found");
            }
        }
        this.parseArgs(args, option);
        this.setSpellOption("includehyphens", true);
    }

    private String[] readProps(String propsFile) throws Exception {
        BufferedReader br = new BufferedReader(FileUtils.getLocalReader(propsFile));
        ArrayList<String> argsList = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#' || line.charAt(0) != '-' || (st = new StringTokenizer(line, EQUALS)).countTokens() <= 0) continue;
            argsList.add(st.nextToken().trim());
            if (!st.hasMoreTokens()) continue;
            argsList.add(st.nextToken().trim());
        }
        String[] args = new String[argsList.size()];
        argsList.toArray(args);
        return args;
    }

    private void parseArgs(String[] args, Option option) throws CommandLineException {
        if (GeneralUtils.LOGGER.isLoggable(Level.FINE)) {
            for (int i = 0; i < args.length; ++i) {
                GeneralUtils.LOGGER.fine("arg[" + i + "]=" + args[i]);
            }
        }
        ArrayList<String> browserList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-interact")) {
                this.setInteract(true);
                continue;
            }
            if (args[i].equals("-interactiveauth") && this.isInteract()) {
                this.setInteractiveAuth(true);
                continue;
            }
            if (args[i].equals("-url") && i + 1 < args.length) {
                this.setTheUrl(args[++i]);
                continue;
            }
            if (args[i].equals("-file") && i + 1 < args.length) {
                this.sourceName = args[++i];
                if (!this.sourceName.toLowerCase(Locale.ENGLISH).startsWith("file:///")) continue;
                this.sourceName = this.sourceName.substring(GeneralUtils.isWinNT() ? 8 : 7);
                this.sourceName = SPACE_PATTERN.matcher(this.sourceName).replaceAll(" ");
                int index = -1;
                index = this.sourceName.indexOf(35);
                if (index == -1) continue;
                this.sourceName = this.sourceName.substring(0, index);
                continue;
            }
            if (args[i].equals("-origurl") && i + 1 < args.length) {
                this.setOrigUrl(args[++i]);
                continue;
            }
            if (args[i].equals("-dtd") && i + 1 < args.length) {
                String dtd;
                if ((dtd = SupportedDTDs.getDTD(args[++i])) != null) {
                    this.setDtdName(dtd);
                    continue;
                }
                throw new CommandLineException("Invalid -dtd argument: must be a supported DTD (see documentation)");
            }
            if (args[i].equals("-shortreport")) {
                this.setShortReport(true);
                continue;
            }
            if (args[i].equals("-ignoreproxy")) {
                this.useSystemProxy = false;
                continue;
            }
            if (args[i].equals("-brokenlinks")) {
                this.setBrokenLinks(true);
                continue;
            }
            if (args[i].equals("-showwarnings")) {
                this.setShowWarnings(true);
                continue;
            }
            if (args[i].equals("-spellcheck") && i + 1 < args.length) {
                this.setDictionary(args[++i]);
                if (this.spellCheck) continue;
                throw new CommandLineException("Invalid -spellcheck argument: GB|US|IT|FR|ES|DE");
            }
            if (args[i].equals("-accessibility") && i + 1 < args.length) {
                this.setAccessibility(args[++i]);
                if (this.accessibility) continue;
                throw new CommandLineException("Invalid -accessibility argument: 508|A|AA|AAA|A2|AA2|AAA2");
            }
            if (args[i].equals("-css") && i + 1 < args.length) {
                this.setCSS(args[++i]);
                if (this.css) continue;
                throw new CommandLineException("Invalid -css argument: 1|2|2.1|3");
            }
            if (args[i].equals("-identity") && i + 1 < args.length) {
                String identity = args[++i];
                this.setUserAgent(identity);
                continue;
            }
            if (args[i].equals("-showsuccess")) {
                this.setShowSuccess(true);
                continue;
            }
            if (args[i].equals("-displaybrowser") && i + 1 < args.length) {
                this.setDisplayBrowser(args[++i]);
                continue;
            }
            if (option.getType() == 'B') continue;
            if (option.getType() != 'A') {
                if (args[i].equals("-help")) {
                    System.out.println(USAGE);
                    System.exit(0);
                } else if (args[i].equals("-browser") && i + 1 < args.length) {
                    browserList.add(args[++i]);
                } else if (args[i].equals("-mailhost") && i + 1 < args.length) {
                    MailHelper.server = args[++i];
                } else if (args[i].equals("-to") && i + 1 < args.length) {
                    this.toAddress = args[++i];
                } else if (args[i].equals("-suffix") && i + 1 < args.length) {
                    this.setSuffix(args[++i]);
                } else if (args[i].equals("-from") && i + 1 < args.length) {
                    MailHelper.defaultFromAddress = args[++i];
                } else if (args[i].equals("-mailuser") && i + 1 < args.length) {
                    MailHelper.userName = args[++i];
                } else if (args[i].equals("-mailpassword") && i + 1 < args.length) {
                    MailHelper.password = args[++i];
                } else if (args[i].equals("-resolution") && i + 1 < args.length) {
                    String res;
                    if (Snapshot.testResolution(res = args[++i])) {
                        this.setResolution(res);
                    }
                } else if (args[i].equals("-delay") && i + 1 < args.length) {
                    int waitTimeLocal = -1;
                    try {
                        waitTimeLocal = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException e) {
                        throw new CommandLineException("Invalid -delay argument: must an integer between 3 and 60");
                    }
                    this.setWaitTime(waitTimeLocal < 1 ? 15L : (long)waitTimeLocal);
                } else if (args[i].equals("-user") && i + 1 < args.length) {
                    this.setUserName(args[++i]);
                } else if (args[i].equals("-password") && i + 1 < args.length) {
                    this.setPassword(args[++i]);
                } else if (args[i].equals("-puser") && i + 1 < args.length) {
                    this.setProxyUserName(args[++i]);
                } else if (args[i].equals("-ppassword") && i + 1 < args.length) {
                    this.setProxyPassword(args[++i]);
                } else if (args[i].equals("-proxyhost") && i + 1 < args.length) {
                    this.setProxyHost(args[++i]);
                } else if (args[i].equals("-proxyport") && i + 1 < args.length) {
                    String portStr = args[++i];
                    int port = 0;
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        port = 0;
                    }
                    if (port < 1 || port > 65535) {
                        throw new CommandLineException("Invalid -proxyport argument: must an integer between 1 and 65535");
                    }
                    this.setProxyPort(portStr);
                } else if (args[i].equals("-proxysocks")) {
                    this.setSocksProxy(true);
                } else if (args[i].equals("-cookiepolicy") && i + 1 < args.length) {
                    if (!this.setCookiePolicy(args[++i])) {
                        throw new CommandLineException("Invalid -cookiepolicy argument: ACCEPT_ALL|ACCEPT_NONE|ACCEPT_SESSION|ACCEPT_SERVER");
                    }
                } else if (args[i].equals("-cachepolicy") && i + 1 < args.length) {
                    if (!this.setCachePolicy(args[++i])) {
                        throw new CommandLineException("Invalid -cachepolicy argument: CACHE_ALL|CACHE_PERMANENT|CACHE_NONE");
                    }
                } else if (args[i].equals("-sendpolicy") && i + 1 < args.length) {
                    if (!this.setSendPolicy(args[++i])) {
                        throw new CommandLineException("Invalid -cachepolicy argument: SEND_ALL|SEND_PERMANENT|SEND_NONE");
                    }
                } else if (args[i].startsWith("-cookie") && i + 1 < args.length) {
                    this.addCookie(args[++i]);
                }
            }
            if (args[i].equals("-hideresults")) {
                this.setHideResults(true);
                continue;
            }
            if (args[i].equals("-noquery")) {
                this.setNoQuery(true);
                continue;
            }
            if (args[i].equals("-nosession")) {
                this.setNoSession(true);
                continue;
            }
            if (args[i].equals("-validateerrors")) {
                this.setValidateErrors(true);
                continue;
            }
            if (args[i].equals("-followlinks")) {
                this.setFollowLinks(true);
                continue;
            }
            if (args[i].equals("-userobots")) {
                this.setUseRobots(true);
                continue;
            }
            if (args[i].equals("-stdout")) {
                this.setResultsToStdout(true);
                continue;
            }
            if (args[i].equals("-extendedstatus")) {
                this.setExtendedStatus(true);
                continue;
            }
            if (args[i].equals("-dtdprompt")) {
                this.setDtdPrompt(true);
                continue;
            }
            if (args[i].equals("-pages") && i + 1 < args.length) {
                int pagesLocal = -1;
                try {
                    pagesLocal = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    pagesLocal = -1;
                }
                if (pagesLocal > 0) {
                    this.setMaxPages(pagesLocal);
                    continue;
                }
                if (pagesLocal == 0) {
                    this.setMaxPages(-1);
                    continue;
                }
                throw new CommandLineException("Invalid -pages argument: must an integer");
            }
            if (args[i].equals("-depth") && i + 1 < args.length) {
                int depthLocal = -1;
                try {
                    depthLocal = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    depthLocal = -1;
                }
                if (depthLocal > 0) {
                    this.setDepth(depthLocal);
                    continue;
                }
                throw new CommandLineException("Invalid -depth argument: must be an integer greater than zero");
            }
            if (args[i].equals("-hidecontent")) {
                this.setShowContent(false);
                continue;
            }
            if (args[i].equals("-resultsfolder") && i + 1 < args.length) {
                File f;
                if (!(f = new File(args[++i])).exists() || !f.isDirectory() || !f.canWrite()) continue;
                this.resultsFolder = f.getAbsolutePath() + System.getProperty("file.separator");
                continue;
            }
            if (args[i].equals("-uniquereport")) {
                this.setUniqueResultsFile(true);
                continue;
            }
            if (args[i].equals("-showresultspath")) {
                this.setShowResultsPath(true);
                continue;
            }
            if (args[i].equals("-altdic") && i + 1 < args.length) {
                this.setAltDic(args[++i]);
                continue;
            }
            if (args[i].equals("-uppercase")) {
                this.setSpellOption("uppercase", false);
                continue;
            }
            if (args[i].equals("-mixedcase")) {
                this.setSpellOption("mixedcase", false);
                continue;
            }
            if (args[i].equals("-wordswithdigits")) {
                this.setSpellOption("wordswithdigits", false);
                continue;
            }
            if (args[i].equals("-ignoresuggestions")) {
                this.setSpellOption("ignoresuggestions", true);
                continue;
            }
            if (args[i].equals("-checkattrs")) {
                this.setSpellOption("checkattrs", true);
                continue;
            }
            if (args[i].equals("-skiplangcheck")) {
                this.setSkipLangCheck(true);
                continue;
            }
            if (args[i].equals("-savebadwords")) {
                this.setSaveBadWords(true);
                continue;
            }
            if (this.brokenLinks && args[i].equals("-timeout") && i + 1 < args.length) {
                int timeOutLocal = -1;
                try {
                    timeOutLocal = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    timeOutLocal = -1;
                }
                if (timeOutLocal < 10 || timeOutLocal > 120) {
                    throw new CommandLineException("Invalid -timeout argument: must an integer between 10 and 120");
                }
                this.setTimeOut(timeOutLocal * 1000);
                continue;
            }
            if (this.brokenLinks && args[i].equals("-concurrency") && i + 1 < args.length) {
                int concurrencyLocal = -1;
                try {
                    concurrencyLocal = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    concurrencyLocal = -1;
                }
                if (concurrencyLocal < 0) {
                    throw new CommandLineException("Invalid -concurrency argument: must a positive integer");
                }
                this.setConcurrencyLimit(concurrencyLocal);
                continue;
            }
            if (this.brokenLinks && args[i].equals("-reportredirects")) {
                this.setReportRedirects(true);
                continue;
            }
            if (args[i].startsWith("-E")) {
                if (args[i].length() <= 2) continue;
                int errorNumber = -1;
                String errNum = args[i].substring(2);
                try {
                    errorNumber = Integer.parseInt(errNum);
                }
                catch (NumberFormatException e) {
                    throw new CommandLineException("Invalid -E argument: must be a valid integer");
                }
                if (errorNumber < 1 || errorNumber > 999) {
                    throw new CommandLineException("Invalid -E argument: must be >0, <1000");
                }
                this.ignoreMessages.add("E" + this.pad(errorNumber));
                continue;
            }
            if (args[i].startsWith("-W")) {
                if (args[i].length() <= 2) continue;
                int errorNumber = -1;
                String errNum = args[i].substring(2);
                try {
                    errorNumber = Integer.parseInt(errNum);
                }
                catch (NumberFormatException e) {
                    throw new CommandLineException("Invalid -W argument: must be a valid integer");
                }
                if (errorNumber < 1 || errorNumber > 999) {
                    throw new CommandLineException("Invalid -W argument: must be >0, <1000");
                }
                this.ignoreMessages.add("W" + this.pad(errorNumber));
                continue;
            }
            if (args[i].equals("-skippath") && i + 1 < args.length) {
                this.addPathToSkip(args[++i]);
                continue;
            }
            if (args[i].equals("-includepath") && i + 1 < args.length) {
                this.addPathToInclude(args[++i]);
                continue;
            }
            if (args[i].equals("-action") && i + 1 < args.length) {
                this.setActionURL(args[++i]);
                continue;
            }
            if (args[i].equals("-submit") && i + 1 < args.length) {
                this.setSubmitButton(args[++i]);
                continue;
            }
            if (args[i].equals("-actionregex")) {
                this.setActionRegex(true);
                continue;
            }
            if (args[i].startsWith("-name") && i + 1 < args.length) {
                if (args[i].length() <= 5) continue;
                int paramNumber = -1;
                String paramNum = args[i].substring(5);
                try {
                    paramNumber = Integer.parseInt(paramNum);
                }
                catch (NumberFormatException e) {
                    paramNumber = -1;
                }
                if (paramNumber < 0) {
                    throw new CommandLineException("Invalid -nameX argument: X must be a positive integer");
                }
                this.setFormName(args[++i], paramNumber);
                continue;
            }
            if (!args[i].startsWith("-value") || i + 1 >= args.length || args[i].length() <= 6) continue;
            int paramNumber = -1;
            String paramNum = args[i].substring(6);
            try {
                paramNumber = Integer.parseInt(paramNum);
            }
            catch (NumberFormatException e) {
                paramNumber = -1;
            }
            if (paramNumber < 0) {
                throw new CommandLineException("Invalid -valueX argument: X must be a positive integer");
            }
            this.setFormValue(args[++i], paramNumber);
        }
        if (browserList.size() > 0) {
            this.setBrowsers(browserList.toArray(new String[browserList.size()]));
        }
        this.convertFormParameters();
        this.setProxyDetails();
    }

    private void addCookie(String cookie) {
        this.cookies.add(cookie);
    }

    private boolean setCookiePolicy(String policy) {
        if (!MyCookieHandler.cookiePolicyMap.containsValue(policy)) {
            return false;
        }
        this.cookiePolicy = policy;
        return true;
    }

    private boolean setCachePolicy(String policy) {
        if (!MyCookieHandler.cachePolicyMap.containsValue(policy)) {
            return false;
        }
        this.cachePolicy = policy;
        return true;
    }

    private boolean setSendPolicy(String policy) {
        if (!MyCookieHandler.sendPolicyMap.containsValue(policy)) {
            return false;
        }
        this.sendPolicy = policy;
        return true;
    }

    public CommandLineParser(ValidatorFormOptions opts, FileUtils fileUtils) {
        String password;
        String user;
        String errors;
        String showSuccess;
        String shortReport;
        String showWarnings;
        String skipLangCheck;
        String checkAttrs;
        String suggestions;
        String digits;
        String mixedCase;
        String upperCase;
        String language;
        String pathToSkip;
        String concurrency;
        String timeOut;
        String redirects;
        String checkLinks;
        String level;
        String dtdName;
        String depth;
        String pages;
        String type = opts.getType();
        defaultEncoder = new EntityEncoder();
        try {
            defaultEncoder.addBasics(fileUtils);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        if (type.equals("text") || type.equals("file")) {
            String uploadFile = opts.getUploadedFile();
            if (uploadFile != null && uploadFile.length() > 0) {
                this.setTheUrl(uploadFile);
                String uploadedPath = opts.getUploadedPath();
                if (uploadedPath != null && uploadedPath.length() > 0) {
                    this.setUploadedFile(uploadedPath);
                }
            }
        } else if (type.equals("url")) {
            String param;
            String altDicPath = opts.getAltDicPath();
            if (altDicPath != null && altDicPath.length() > 0) {
                this.setAltDic(altDicPath);
            }
            if ((param = opts.getUrl()) != null) {
                this.setTheUrl(param.trim());
            }
        } else {
            String param = opts.getUrl();
            if (param != null) {
                this.setTheUrl(param.trim());
            }
        }
        this.toAddress = opts.getEmail().trim();
        String suffix = opts.getSuffix().trim();
        if (suffix.trim().length() > 0) {
            this.setSuffix(suffix);
        }
        if ((pages = opts.getPages()) != null && pages.trim().length() > 0) {
            this.setMaxPages(Integer.parseInt(pages.trim()));
        }
        if ((depth = opts.getDepth()) != null && depth.trim().length() > 0) {
            this.setDepth(Integer.parseInt(depth.trim()));
        }
        if ((dtdName = opts.getDtdName()) != null && dtdName.trim().length() > 0) {
            this.setDtdName(dtdName.trim());
        }
        if ((level = opts.getWai()) != null && level.trim().length() > 0) {
            this.setAccessibility(level.trim());
        }
        this.setBrowsers(opts.getBrowsers());
        if (this.isBrowser()) {
            String delay;
            String resolution = opts.getScreenSize();
            if (resolution != null) {
                this.setResolution(resolution.trim());
            }
            if ((delay = opts.getDelay()) != null) {
                this.setWaitTime(Integer.parseInt(delay));
            }
        }
        if ((checkLinks = opts.getChecklinks()) != null && checkLinks.equals("checked=\"checked\"")) {
            this.setBrokenLinks(true);
        }
        if ((redirects = opts.getReportredirects()) != null && redirects.equals("checked=\"checked\"")) {
            this.setReportRedirects(true);
        }
        if ((timeOut = opts.getTimeout()) != null) {
            this.setTimeOut(Integer.parseInt(timeOut) * 1000);
        }
        if ((concurrency = opts.getConcurrency()) != null && concurrency.length() > 0) {
            this.setConcurrencyLimit(Integer.parseInt(concurrency));
        }
        if ((pathToSkip = opts.getPathtoskip()) != null && pathToSkip.trim().length() > 0) {
            this.addPathToSkip(pathToSkip.trim());
        }
        if ((language = opts.getLanguage()) != null && language.trim().length() > 0) {
            this.setDictionary(language.trim());
        }
        if ((upperCase = opts.getUppercase()) != null && upperCase.equals("checked=\"checked\"")) {
            this.setSpellOption("uppercase", false);
        }
        if ((mixedCase = opts.getMixedcase()) != null && mixedCase.equals("checked=\"checked\"")) {
            this.setSpellOption("mixedcase", false);
        }
        if ((digits = opts.getWordswithdigits()) != null && digits.equals("checked=\"checked\"")) {
            this.setSpellOption("wordswithdigits", false);
        }
        if ((suggestions = opts.getIgnoresuggestions()) != null && suggestions.equals("checked=\"checked\"")) {
            this.setSpellOption("ignoresuggestions", true);
        }
        if ((checkAttrs = opts.getCheckattrs()) != null && checkAttrs.equals("checked=\"checked\"")) {
            this.setSpellOption("checkattrs", true);
        }
        if ((skipLangCheck = opts.getSkiplangcheck()) != null && skipLangCheck.equals("checked=\"checked\"")) {
            this.setSkipLangCheck(true);
        }
        this.setSpellOption("includehyphens", true);
        String hideContent = opts.getHidecontent();
        if (hideContent != null && hideContent.equals("checked=\"checked\"")) {
            this.setShowContent(false);
        }
        if ((showWarnings = opts.getShowwarnings()) != null && showWarnings.equals("checked=\"checked\"")) {
            this.setShowWarnings(true);
        }
        if ((shortReport = opts.getShortreport()) != null && shortReport.equals("checked=\"checked\"")) {
            this.setShortReport(true);
        }
        if ((showSuccess = opts.getShowsuccess()) != null && showSuccess.equals("checked=\"checked\"")) {
            this.setShowSuccess(true);
        }
        if ((errors = opts.getErrors()) != null && errors.trim().length() > 0) {
            this.parseErrors(errors);
        }
        if ((user = opts.getUser()) != null && user.trim().length() > 0) {
            this.setUserName(user.trim());
        }
        if ((password = opts.getPassword()) != null && password.trim().length() > 0) {
            this.setPassword(password.trim());
        }
    }

    public CommandLineParser(ValidatorForm vf, FileUtils fileUtils) {
        String password;
        String user;
        String language;
        String pathToSkip;
        String concurrency;
        String[] browsers;
        String level;
        String dtdName;
        String depth;
        defaultEncoder = new EntityEncoder();
        try {
            defaultEncoder.addBasics(fileUtils);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        String param = vf.getUrl();
        if (param != null) {
            this.setTheUrl(param.trim());
        }
        this.toAddress = vf.getEmail() != null ? vf.getEmail().trim() : null;
        String pages = vf.getPages();
        if (pages != null && pages.trim().length() > 0) {
            this.setMaxPages(Integer.parseInt(pages.trim()));
        }
        if ((depth = vf.getDepth()) != null && depth.trim().length() > 0) {
            this.setDepth(Integer.parseInt(depth.trim()));
        }
        if ((dtdName = vf.getDtd()) != null && dtdName.trim().length() > 0) {
            this.setDtdName(dtdName.trim());
        }
        if ((level = vf.getAccessibility()) != null && level.trim().length() > 0) {
            this.setAccessibility(level.trim());
        }
        if ((browsers = vf.getScreenshots()) == null) {
            String browser = vf.getScreenshot();
            if (browser != null) {
                browsers = new String[]{browser};
            }
            this.setBrowsers(browsers);
        } else {
            this.setBrowsers(browsers);
        }
        if (this.isBrowser()) {
            String delay;
            String resolution = vf.getResolution();
            if (resolution != null) {
                this.setResolution(resolution.trim());
            }
            if ((delay = vf.getDelay()) != null) {
                this.setWaitTime(Integer.parseInt(delay));
            }
        }
        this.setBrokenLinks(vf.isChecklinks());
        this.setReportRedirects(vf.isReportredirects());
        String timeOut = vf.getTimeout();
        if (timeOut != null) {
            this.setTimeOut(Integer.parseInt(timeOut) * 1000);
        }
        if ((concurrency = vf.getConcurrency()) != null) {
            this.setConcurrencyLimit(Integer.parseInt(concurrency));
        }
        if ((pathToSkip = vf.getPathtoskip()) != null && pathToSkip.trim().length() > 0) {
            this.addPathToSkip(pathToSkip.trim());
        }
        if ((language = vf.getSpellcheck()) != null && language.trim().length() > 0) {
            this.setDictionary(language.trim());
        }
        this.setSpellOption("uppercase", !vf.isUppercase());
        this.setSpellOption("mixedcase", !vf.isMixedcase());
        this.setSpellOption("wordswithdigits", !vf.isWordswithdigits());
        this.setSpellOption("ignoresuggestions", vf.isIgnoresuggestions());
        this.setSpellOption("checkattrs", vf.isCheckattrs());
        this.setSkipLangCheck(vf.isSkiplangcheck());
        this.setSpellOption("includehyphens", true);
        this.setShowContent(!vf.isHidecontent());
        this.setShowWarnings(vf.isShowwarnings());
        String errors = vf.getErrors();
        if (errors != null && errors.trim().length() > 0) {
            this.parseErrors(errors);
        }
        if ((user = vf.getUser()) != null && user.trim().length() > 0) {
            this.setUserName(user.trim());
        }
        if ((password = vf.getPassword()) != null && password.trim().length() > 0) {
            this.setPassword(password.trim());
        }
    }

    public final void setAccessibility(String level) {
        this.accessibility = false;
        this.us508 = level.equals("508");
        boolean bl = this.wcag2 = level.equals("A2") || level.equals("AA2") || level.equals("AAA2");
        if (this.us508 || this.wcag2 || level.equals("A") || level.equals("AA") || level.equals("AAA")) {
            this.accessibilityLevel = level;
            this.accessibility = true;
            this.options.add("Accessibility: " + level);
        }
    }

    public boolean isUS508() {
        return this.us508;
    }

    public boolean isWCAG2() {
        return this.wcag2;
    }

    public final void setCSS(String level) {
        this.css = false;
        if (level.equals("1") || level.equals("2") || level.equals("2.1") || level.equals("3")) {
            this.cssLevel = level;
            this.css = true;
            this.options.add("CSS: " + level);
        }
    }

    public final void setDictionary(String lang) {
        this.spellCheck = true;
        this.lang = lang;
        if (lang.equals("GB")) {
            this.language = "dicts/ukenglish.dic";
            this.setSpellOption("ignorepossessive", true);
            this.setSpellOption("ignoreplurals", true);
        } else if (lang.equals("US")) {
            this.language = "dicts/usenglish.dic";
            this.setSpellOption("ignorepossessive", true);
            this.setSpellOption("ignoreplurals", true);
        } else if (lang.equals("IT")) {
            this.language = "dicts/italian.dic";
        } else if (lang.equals("FR")) {
            this.language = "dicts/french.dic";
            this.setSpellOption("apostrophesplit", true);
            this.setSpellOption("ignoreplurals", true);
        } else if (lang.equals("ES")) {
            this.language = "dicts/spanish.dic";
            this.setSpellOption("ignoreesplurals", true);
        } else if (lang.equals("DE")) {
            this.language = "dicts/german.dic";
            this.setSpellOption("swapszligs", true);
            this.setSpellOption("mixedcase", true);
        } else {
            this.spellCheck = false;
            lang = null;
            this.language = null;
        }
        if (this.spellCheck) {
            this.options.add("Spell check: " + lang);
        }
    }

    public void setAltDic(String dictionary) {
        this.spellCheck = true;
        this.altDic = dictionary;
        this.options.add("Alternative dictionary: true");
    }

    public String getAltDic() {
        return this.altDic;
    }

    private String pad(int number) {
        String result = "" + number;
        if (number < 10) {
            result = "00" + number;
        } else if (number < 100) {
            result = "0" + number;
        }
        return result;
    }

    public List<String> getOptions() {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.addAll(this.options);
        if (!this.ignoreMessages.isEmpty()) {
            tmp.add("Ignore Errors/Warnings: " + this.ignoreMessages.toString());
        }
        return tmp;
    }

    public final void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
        if (timeOut != 20000L) {
            this.options.add("Time out: " + timeOut / 1000L + " seconds");
        }
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public int getDepth() {
        return this.depth;
    }

    public final void setDepth(int depth) {
        this.depth = depth;
        this.options.add("Depth: " + depth);
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public final void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
        if (maxPages > 1) {
            this.options.add("Pages: " + maxPages);
        }
    }

    public String getDtdName() {
        return this.dtdName;
    }

    private final void setDtdName(String dtdName) {
        this.dtdName = dtdName;
    }

    public String getTheUrl() {
        return this.theUrl;
    }

    public final void setTheUrl(String theUrl) {
        this.theUrl = theUrl;
    }

    public void setParser(DTDParser parser) {
        if (parser != null) {
            String docType = parser.getOrigDocType();
            docType = docType == null ? (parser.isBestFit() ? "Best Fit" : "Auto Detect") : SupportedDTDs.getDTDNameFromDocType(docType, parser.isXml());
            this.options.add("(X)HTML validation: " + docType);
        }
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public final void setShowContent(boolean showContent) {
        this.showContent = showContent;
        this.options.add("Hide content: " + !showContent);
    }

    public final void setPassword(String password) {
        this.password = password;
        this.options.add("Password: " + this.mask(password));
    }

    private String mask(String password) {
        char[] chars = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            chars[i] = 42;
        }
        return new String(chars);
    }

    public final void setUserName(String userName) {
        this.userName = userName;
        this.options.add("User: " + userName);
    }

    public final void setSpellOption(String key, boolean value) {
        if (!this.spellCheck) {
            return;
        }
        if (this.spellOptions == null) {
            this.spellOptions = new HashMap<String, Boolean>();
        }
        if (key.equals("uppercase")) {
            this.spellOptions.put("uppercase", value);
            this.options.add("Check upper case: true");
        } else if (key.equals("mixedcase")) {
            this.spellOptions.put("mixedcase", value);
            this.options.add("Check mixed case: true");
        } else if (key.equals("wordswithdigits")) {
            this.spellOptions.put("wordswithdigits", value);
            this.options.add("Check words with digits: true");
        } else if (key.equals("checkattrs")) {
            this.spellOptions.put("checkattrs", value);
            this.options.add("Check attributes: true");
        } else if (key.equals("ignoresuggestions")) {
            this.spellOptions.put("ignoresuggestions", value);
            this.options.add("Ignore suggestions: true");
        } else if (key.equals("includehyphens")) {
            this.spellOptions.put("includehyphens", value);
        } else if (key.equals("apostrophesplit")) {
            this.spellOptions.put("apostrophesplit", value);
        } else if (key.equals("ignorepossessive")) {
            this.spellOptions.put("ignorepossessive", value);
        } else if (key.equals("ignoreplurals")) {
            this.spellOptions.put("ignoreplurals", value);
        } else if (key.equals("ignoreesplurals")) {
            this.spellOptions.put("ignoreesplurals", value);
        } else if (key.equals("swapszligs")) {
            this.spellOptions.put("swapszligs", value);
        }
    }

    public Map<String, Boolean> getSpellOptions() {
        return this.spellOptions;
    }

    public final void setReportRedirects(boolean reportRedirects) {
        this.reportRedirects = reportRedirects;
        this.options.add("Report redirects: " + reportRedirects);
    }

    public boolean isReportRedirects() {
        return this.reportRedirects;
    }

    public boolean isBrokenLinks() {
        return this.brokenLinks;
    }

    public final void setBrokenLinks(boolean brokenLinks) {
        this.brokenLinks = brokenLinks;
        if (brokenLinks) {
            this.options.add(BROKEN_LINK_CHECK);
        }
    }

    public String getUploadedFile() {
        return this.uploadedFile;
    }

    public final void setUploadedFile(String uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    public String[] getBrowsers() {
        return this.browsers;
    }

    public final void setBrowsers(String[] browsers) {
        if (browsers.length > 6) {
            String[] newBrowsers = new String[6];
            System.arraycopy(browsers, 0, newBrowsers, 0, 6);
            browsers = newBrowsers;
        }
        this.browsers = browsers;
    }

    public String getResolution() {
        return this.resolution;
    }

    public final void setResolution(String resolution) {
        this.resolution = resolution;
        if (this.tool) {
            this.options.add(SCREENSHOTS_TAKEN);
            if (this.maxPages == 1) {
                this.screenshotsTaken = true;
            }
        } else {
            this.options.add("Screenshot(s) taken at: " + resolution);
        }
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public final void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
        if (!this.tool) {
            this.options.add("Screenshot delay: " + waitTime + " seconds");
        }
    }

    public boolean isAddress() {
        return this.toAddress != null && this.toAddress.trim().length() > 0;
    }

    private void parseErrors(String errors) {
        StringTokenizer st = new StringTokenizer(errors, ", ");
        while (st.hasMoreTokens()) {
            String error = st.nextToken().toUpperCase();
            char type = error.charAt(0);
            int errorNumber = -1;
            String errNum = error.substring(1);
            try {
                errorNumber = Integer.parseInt(errNum);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.ignoreMessages.add(type + this.pad(errorNumber));
        }
    }

    public final boolean isBrowser() {
        return false;
    }

    public String getRevalidateOptions() {
        if (this.uploadedFile != null || this.altDic != null) {
            return null;
        }
        StringBuilder action = new StringBuilder(GeneralUtils.getAppServerHome() + "/validator/Revalidate?revalidate=true");
        action.append("&amp;dtd=").append(this.dtdName != null ? this.dtdName : "false");
        if (this.accessibility) {
            action.append("&amp;wai=").append(this.accessibilityLevel);
        }
        if (this.spellCheck) {
            action.append("&amp;spellcheck=").append(this.lang);
            Boolean spellOption = this.spellOptions.get("uppercase");
            boolean optionValue = false;
            if (spellOption != null) {
                optionValue = spellOption == false;
                action.append("&amp;uppercase=").append(optionValue);
            }
            if ((spellOption = this.spellOptions.get("mixedcase")) != null) {
                optionValue = spellOption == false;
                action.append("&amp;mixedcase=").append(optionValue);
            }
            if ((spellOption = this.spellOptions.get("wordswithdigits")) != null) {
                optionValue = spellOption == false;
                action.append("&amp;wordswithdigits=").append(optionValue);
            }
            if ((spellOption = this.spellOptions.get("checkattrs")) != null) {
                optionValue = spellOption == false;
                action.append("&amp;checkattrs=").append(optionValue);
            }
            if ((spellOption = this.spellOptions.get("skiplangcheck")) != null) {
                optionValue = spellOption == false;
                action.append("&amp;skiplangcheck=").append(optionValue);
            }
        }
        if (!this.brokenLinks) {
            action.append("&amp;checklinks=false");
        }
        if (this.timeOut != 20000L) {
            action.append("&amp;timeout=").append(this.timeOut / 1000L);
        }
        if (this.reportRedirects) {
            action.append("&amp;reportredirects=true");
        }
        if (this.concurrencyLimit > 0) {
            action.append("&amp;concurrency=").append(this.concurrencyLimit);
        }
        if (!this.showContent) {
            action.append("&amp;hidecontent=true");
        }
        if (this.showWarnings) {
            action.append("&amp;showwarnings=true");
        }
        if (this.shortReport) {
            action.append("&amp;shortreport=true");
        }
        if (this.userName != null) {
            action.append("&amp;user=").append(this.userName);
            if (this.password != null) {
                action.append("&amp;password=").append(this.password);
            }
        }
        return action.toString();
    }

    public final void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
        if (showWarnings) {
            this.options.add("Show warnings: true");
        }
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public boolean isDtdPrompt() {
        return this.dtdPrompt;
    }

    public void setDtdPrompt(boolean dtdPrompt) {
        this.dtdPrompt = dtdPrompt;
    }

    public boolean isInteract() {
        return this.interact;
    }

    public void setInteract(boolean interact) {
        this.interact = interact;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        this.options.add("Proxy password: " + this.mask(proxyPassword));
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
        this.options.add("Proxy user: " + proxyUserName);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public final void setSkipLangCheck(boolean skipLangCheck) {
        boolean bl = this.checkLang = !skipLangCheck;
        if (skipLangCheck) {
            this.options.add("Skip language check: true");
        }
    }

    public boolean isCheckLang() {
        return this.checkLang;
    }

    private void setSaveBadWords(boolean saveBadWords) {
        this.saveBadWords = saveBadWords;
        if (saveBadWords) {
            this.options.add("Saving misspelt words: true");
        }
    }

    public boolean isSaveBadWords() {
        return this.saveBadWords;
    }

    public boolean isInteractiveAuth() {
        return this.interactiveAuth;
    }

    public void setInteractiveAuth(boolean interactiveAuth) {
        this.interactiveAuth = interactiveAuth;
    }

    public boolean useSystemProxy() {
        return this.useSystemProxy;
    }

    public Set<String> getPathsToSkip() {
        return this.pathsToSkip;
    }

    public Set<Pattern> getPatternsToSkip(String urlOrigin) {
        if (this.patternsToSkip == null) {
            int index = urlOrigin.indexOf("://");
            if (index != -1) {
                urlOrigin = "https?" + urlOrigin.substring(index);
            }
            this.patternsToSkip = new HashSet<Pattern>();
            for (String folder : this.pathsToSkip) {
                this.patternsToSkip.add(Pattern.compile(urlOrigin + folder + ".*"));
            }
            for (String folder : this.foldersToSkip) {
                this.patternsToSkip.add(Pattern.compile(folder + ".*"));
            }
        }
        return this.patternsToSkip;
    }

    public void addPathToSkip(String pathToSkip) {
        if (!this.pathsToSkip.contains(pathToSkip)) {
            this.options.add("Skip path: " + defaultEncoder.encode(pathToSkip));
        }
        this.pathsToSkip.add(pathToSkip);
    }

    public void addFolderToSkip(String siteRoot, String pathToSkip) {
        String folderToSkip;
        int index = siteRoot.indexOf("://");
        if (index != -1) {
            siteRoot = "https?" + siteRoot.substring(index);
        }
        if (!this.foldersToSkip.contains(folderToSkip = siteRoot + this.replaceAllWildCards(pathToSkip))) {
            this.options.add("Skip robots path: " + pathToSkip);
        }
        this.foldersToSkip.add(folderToSkip);
    }

    private String replaceAllWildCards(String path) {
        int index = path.indexOf(42);
        while (index != -1) {
            path = path.substring(0, index) + "." + path.substring(index);
            index = path.indexOf(42, index + 2);
        }
        index = path.indexOf(63);
        while (index != -1) {
            path = path.substring(0, index) + "\\" + path.substring(index);
            index = path.indexOf(63, index + 2);
        }
        index = path.indexOf(46);
        while (index != -1) {
            path = path.substring(0, index) + "\\" + path.substring(index);
            index = path.indexOf(46, index + 2);
        }
        return path;
    }

    public void addPathToInclude(String pathToInclude) {
        if (!this.pathsToInclude.contains(pathToInclude)) {
            this.options.add("Include path: " + defaultEncoder.encode(pathToInclude));
        }
        this.pathsToInclude.add(pathToInclude);
    }

    public void addFolderToInclude(String siteRoot, String pathToInclude) {
        String folderToInclude;
        int index = siteRoot.indexOf("://");
        if (index != -1) {
            siteRoot = "https?" + siteRoot.substring(index);
        }
        if (!this.foldersToInclude.contains(folderToInclude = siteRoot + this.replaceAllWildCards(pathToInclude))) {
            this.options.add("Include robots path: " + pathToInclude);
        }
        this.foldersToInclude.add(folderToInclude);
    }

    public Set<String> getPathsToInclude() {
        return this.pathsToInclude;
    }

    public Set<Pattern> getPatternsToInclude(String urlOrigin) {
        if (this.patternsToInclude == null) {
            int index = urlOrigin.indexOf("://");
            if (index != -1) {
                urlOrigin = "https?" + urlOrigin.substring(index);
            }
            this.patternsToInclude = new HashSet<Pattern>();
            for (String folder : this.pathsToInclude) {
                this.patternsToInclude.add(Pattern.compile(urlOrigin + folder + ".*"));
            }
            for (String folder : this.foldersToInclude) {
                this.patternsToInclude.add(Pattern.compile(folder + ".*"));
            }
        }
        return this.patternsToInclude;
    }

    public boolean isShowSuccess() {
        return this.showSuccess;
    }

    public final void setShowSuccess(boolean showSuccess) {
        this.showSuccess = showSuccess;
        if (showSuccess) {
            this.options.add("Show Success: true");
        }
    }

    public ProxyDetails getProxyDetails() {
        return this.proxyDetails;
    }

    private void setProxyDetails() {
        this.proxyDetails = new ProxyDetails(this.socksProxy, this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword);
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setSocksProxy(boolean socksProxy) {
        this.socksProxy = socksProxy;
    }

    public boolean isSocksProxy() {
        return this.socksProxy;
    }

    public boolean isUploadOnline() {
        return this.uploadOnline;
    }

    public void setUploadOnline(boolean uploadOnline) {
        this.uploadOnline = uploadOnline;
    }

    public void setHttpCharset(String httpCharset) {
        this.httpCharset = httpCharset;
    }

    public String getHttpCharset() {
        return this.httpCharset;
    }

    public void setBomCharset(String bomCharset) {
        this.bomCharset = bomCharset;
    }

    public String getBomCharset() {
        return this.bomCharset;
    }

    public void setOtherCharset(String otherCharset) {
        this.otherCharset = otherCharset;
    }

    public String getOtherCharset() {
        return this.otherCharset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String identity) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = FileUtils.getLocalInputStream(FileUtils.getDataFolder() + USER_AGENT_FILE);
        }
        catch (Exception e) {
            try {
                is = FileUtils.getLocalInputStream(FileUtils.getInstallationFolder() + USER_AGENT_FILE);
            }
            catch (Exception e1) {
                GeneralUtils.LOGGER.log(Level.FINE, "Failed to read User Agent Properties", e1);
            }
        }
        try {
            props.load(is);
            is.close();
            this.userAgent = props.getProperty(identity);
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.FINE, "Failed to read User Agent Properties", e);
        }
        if (this.userAgent == null) {
            identity = DEFAULT_UA_IDENTITY;
            this.userAgent = DEFAULT_UA_DETAILS;
        }
        this.options.add("Identity used: " + identity);
    }

    public void setTool(boolean tool) {
        this.tool = tool;
    }

    public boolean isCss() {
        return this.css;
    }

    public String getCssLevel() {
        return this.cssLevel;
    }

    public boolean isAccessibility() {
        return this.accessibility;
    }

    public String getAccessibilityLevel() {
        return this.accessibilityLevel;
    }

    public String getCookiePolicy() {
        return this.cookiePolicy;
    }

    public String getCachePolicy() {
        return this.cachePolicy;
    }

    public String getSendPolicy() {
        return this.sendPolicy;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public boolean isShortReport() {
        return this.shortReport;
    }

    public void setShortReport(boolean shortReport) {
        this.shortReport = shortReport;
        if (shortReport) {
            this.options.add("Short report: true");
        }
    }

    public void setDisplayBrowser(String displayBrowser) {
        GeneralUtils.setDisplayBrowser(displayBrowser);
    }

    public String getResultsFolder() {
        if (this.resultsFolder == null) {
            this.resultsFolder = FileUtils.getDocumentsFolder();
        }
        return this.resultsFolder;
    }

    public boolean isUniqueResultsFile() {
        return this.uniqueResultsFile;
    }

    public void setUniqueResultsFile(boolean uniqueResultsFile) {
        this.uniqueResultsFile = uniqueResultsFile;
    }

    public boolean isFollowLinks() {
        return this.followLinks;
    }

    public void setFollowLinks(boolean followLinks) {
        this.followLinks = followLinks;
        if (followLinks) {
            this.options.add("Follow links: true");
        }
    }

    public boolean onlySnapshots() {
        return !this.isCss() && !this.isAccessibility() && !this.spellCheck && this.getMaxPages() == 1 && !this.isBrokenLinks() && this.dtdName == null && !this.isDtdPrompt();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        if (!suffix.equals(".zip")) {
            this.options.add("Attachment suffix: " + suffix);
        }
    }

    public boolean isExtendedStatus() {
        return this.extendedStatus;
    }

    public void setExtendedStatus(boolean extendedStatus) {
        this.extendedStatus = extendedStatus;
    }

    public boolean isHideResults() {
        return this.hideResults;
    }

    public void setHideResults(boolean hideResults) {
        this.hideResults = hideResults;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isSpellCheck() {
        return this.spellCheck;
    }

    public List<String> getIgnoreMessages() {
        return this.ignoreMessages;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public boolean isNoQuery() {
        return this.noQuery;
    }

    public void setNoQuery(boolean noQuery) {
        this.noQuery = noQuery;
        if (noQuery) {
            this.options.add("No query parameters: true");
        }
    }

    public boolean isNoSession() {
        return this.noSession;
    }

    public void setNoSession(boolean noSession) {
        this.noSession = noSession;
        if (noSession) {
            this.options.add("No session ids: true");
        }
    }

    public boolean isValidateErrors() {
        return this.validateErrors;
    }

    public void setValidateErrors(boolean validateErrors) {
        this.validateErrors = validateErrors;
        if (validateErrors) {
            this.options.add("Validate error pages: true");
        }
    }

    public boolean isShowResultsPath() {
        return this.showResultsPath;
    }

    public void setShowResultsPath(boolean showResultsPath) {
        this.showResultsPath = showResultsPath;
        if (showResultsPath) {
            this.options.add("Show results path: true");
        }
    }

    public void setCommandLine(boolean commandLine) {
        this.commandLine = commandLine;
    }

    public boolean isScreenshotsTaken() {
        return this.screenshotsTaken;
    }

    public String getOrigUrl() {
        return this.origUrl;
    }

    public void setOrigUrl(String origUrl) {
        this.origUrl = origUrl;
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyLimit = concurrencyLimit;
        if (concurrencyLimit != 10) {
            this.options.add("Concurrency: " + (concurrencyLimit == 0 ? "unlimited" : Integer.valueOf(concurrencyLimit)));
        }
    }

    public int getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    public boolean isUseRobots() {
        return this.useRobots;
    }

    public void setUseRobots(boolean useRobots) {
        this.useRobots = useRobots;
        if (useRobots) {
            this.options.add("Use robots.txt: true");
        }
    }

    public boolean isResultsToStdout() {
        return this.resultsToStdout;
    }

    public void setResultsToStdout(boolean resultsToStdout) {
        this.resultsToStdout = resultsToStdout;
        if (resultsToStdout) {
            this.options.add("Send results to stdout: true");
        }
    }

    public void setActionURL(String actionURL) {
        if (actionURL != null && this.actionURL == null) {
            this.options.add("Action: " + actionURL);
        }
        this.actionURL = actionURL;
    }

    public String getActionURL() {
        return this.actionURL == null ? "" : this.actionURL;
    }

    public void setFormName(String name, int index) {
        String[] parameter = this.parameters.get(index);
        if (parameter == null) {
            parameter = new String[2];
            parameter[0] = name;
            this.parameters.put(index, parameter);
        } else if (parameter[0] == null) {
            parameter[0] = name;
            this.options.add("Form parameter: " + parameter[0] + EQUALS + parameter[1]);
        }
    }

    public void setFormValue(String value, int index) {
        String[] parameter = this.parameters.get(index);
        if (parameter == null) {
            parameter = new String[2];
            parameter[1] = value;
            this.parameters.put(index, parameter);
        } else if (parameter[1] == null) {
            parameter[1] = value;
            this.options.add("Form parameter: " + parameter[0] + EQUALS + parameter[1]);
        }
    }

    private void convertFormParameters() {
        for (String[] parameter : this.parameters.values()) {
            if (parameter[0] == null) continue;
            this.formNames.add(parameter[0]);
            this.formValues.add(parameter[1] == null ? "" : parameter[1]);
        }
        this.nvParameters = new HashMap<String, List<String>>();
        for (int i = 0; i < this.formNames.size(); ++i) {
            String name = this.formNames.elementAt(i);
            if (name.length() <= 0) continue;
            String value = this.formValues.elementAt(i);
            List<Object> values = null;
            if (this.nvParameters.containsKey(name)) {
                values = this.nvParameters.get(name);
                values.add(value);
                this.nvParameters.put(name, values);
                continue;
            }
            values = new ArrayList<String>();
            values.add(value);
            this.nvParameters.put(name, values);
        }
    }

    public Vector<String> getFormNames() {
        return this.formNames;
    }

    public Vector<String> getFormValues() {
        return this.formValues;
    }

    public void resetNVPairs() {
        this.nvPairs = new HashMap<String, List<String>>();
    }

    public void addNVPair(String name, String value, boolean unique) {
        List<Object> values = null;
        if (this.nvPairs.containsKey(name)) {
            if (!unique) {
                values = this.nvPairs.get(name);
                values.add(value);
                this.nvPairs.put(name, values);
            }
        } else {
            values = new ArrayList<String>();
            values.add(value);
            this.nvPairs.put(name, values);
        }
    }

    public void completeNVPairs() {
        for (String parameterName : this.nvParameters.keySet()) {
            this.nvPairs.put(parameterName, this.nvParameters.get(parameterName));
        }
    }

    public Map<String, List<String>> getNVPairs() {
        return this.nvPairs;
    }

    public void setFormPost(boolean formPost) {
        this.formPost = formPost;
    }

    public boolean isFormPost() {
        return this.formPost;
    }

    public String getSubmitButton() {
        return this.submitButton == null ? "" : this.submitButton;
    }

    public void setSubmitButton(String submitButton) {
        this.submitButton = submitButton;
        if (submitButton != null) {
            this.options.add("Submit button: " + submitButton);
        }
    }

    public void setActionRegex(boolean actionRegex) {
        this.actionRegex = actionRegex;
        if (actionRegex) {
            this.options.add("Action is RegEx: true");
        }
    }

    public boolean isActionRegex() {
        return this.actionRegex;
    }

    public boolean isFormTested(String formLink) {
        return this.formsTested.contains(formLink);
    }

    public void addFormTested(String link) {
        this.formsTested.add(link);
    }

    public boolean isExtension() {
        return this.extension;
    }
}

