/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.sgml.Data;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.validations.HTMLValidation;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityValidation
implements Validation {
    public static final String SECTION_508 = "508";
    public static final String SECTION_508_TEXT = "US Section 508";
    public static final String WAI_A = "A";
    public static final String WAI_A_TEXT = "WCAG v1 A";
    public static final String WAI_AA = "AA";
    public static final String WAI_AA_TEXT = "WCAG v1 AA";
    public static final String WAI_AAA = "AAA";
    public static final String WAI_AAA_TEXT = "WCAG v1 AAA";
    public static final String WAI_A2 = "A2";
    public static final String WAI_A2_TEXT = "WCAG v2 A";
    public static final String WAI_AA2 = "AA2";
    public static final String WAI_AA2_TEXT = "WCAG v2 AA";
    public static final String WAI_AAA2 = "AAA2";
    public static final String WAI_AAA2_TEXT = "WCAG v2 AAA";
    private static final String ALT = "alt";
    private static final String SRC = "src";
    private static final String IMG = "img";
    private static final String COLS = "cols";
    private static final String ROWS = "rows";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String SIZE = "size";
    private static final String REFRESH = "refresh";
    private static final String ONDBLCLICK = "ondblclick";
    private static final String ONMOUSEMOVE = "onmousemove";
    private static final String BLANK = "_blank";
    private static final String TITLE = "title";
    private static final String ISMAP = "ismap";
    private static final String DOCTYPE = "!doctype";
    private static final String PICTURE = "picture";
    private static final String IMAGE = "image";
    private static final String SPACER = "spacer";
    private static final String HTTP_EQUIV = "http-equiv";
    private static final String LABEL = "label";
    private static final char H = 'h';
    private static final String HTML = "html";
    private static final String LANG = "lang";
    private static final String XML_LANG = "xml:lang";
    private static final String FOUR_0 = "4.0";
    private static final String ONE_0 = "1.0";
    private static final String XHTML = "XHTML";
    private static final String ONE_ONE = "XHTML 1.1";
    private static final String RDF = "XHTML+RDFa";
    private static final String META = "meta";
    private static final String TT = "tt";
    private static final String B = "b";
    private static final String I = "i";
    private static final String BIG = "big";
    private static final String SMALL = "small";
    private static final String STRIKE = "strike";
    private static final String S = "s";
    private static final String U = "u";
    private static final String HREF = "href";
    private static final String A = "a";
    private static final String CLICK_HERE = "click here";
    private static final String MORE = "more";
    private static final String APPLET = "applet";
    private static final String OBJECT = "object";
    private static final String FRAMESET = "frameset";
    private static final String TABLE = "table";
    private static final String TH = "th";
    private static final String IFRAME = "iframe";
    private static final String TD = "td";
    private static final String FONT = "font";
    private static final String HR = "hr";
    private static final String FRAME = "frame";
    private static final String TARGET = "target";
    private static final String NOFRAMES = "noframes";
    private static final String UL = "ul";
    private static final String OL = "ol";
    private static final String LI = "li";
    private static final String DL = "dl";
    private static final String DD = "dd";
    private static final String DT = "dt";
    private static final String BLINK = "blink";
    private static final String MARQUEE = "marquee";
    private static final String INPUT = "input";
    private static final String TYPE = "type";
    private static final String RESET = "reset";
    private static final String SUBMIT = "submit";
    private static final String HIDDEN = "hidden";
    private static final String BUTTON = "button";
    private static final String ID = "id";
    private static final String FOR = "for";
    private static final String TEXTAREA = "textarea";
    private static final String SELECT = "select";
    private static final String RADIO = "radio";
    private static final String CHECKBOX = "checkbox";
    private static final String AREA = "area";
    private static final String SPACE = " ";
    private static final String LONGDESC = "longdesc";
    private static final String SCRIPT = "script";
    private static final String HEAD = "head";
    private static final String NOSCRIPT = "noscript";
    private static final String PNG = ".png";
    private static final String GIF = ".gif";
    private static final String JPG = ".jpg";
    private static final String PERCENT = "%";
    private static final String PARAM = "param";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String ABBR = "abbr";
    private static final String ACRONYM = "acronym";
    private static final String FORM = "form";
    private static final String CAPTION = "caption";
    private static final String SUMMARY = "summary";
    private static final String BORDER = "border";
    private static final String EMBED = "embed";
    private static final String NOEMBED = "noembed";
    private static final String SCOPE = "scope";
    private static final String ROW = "row";
    private static final String ROWGROUP = "rowgroup";
    private static final String COLGROUP = "colgroup";
    private static final String COL = "col";
    private static final String FIELDSET = "fieldset";
    private static final String LEGEND = "legend";
    private static final String CONTENT = "content";
    private static final String ZERO = "0";
    private static final String NEW_PAGE = "new page";
    private static final String ENTER_TITLE = "enter the title of your html document here";
    private static final String UNTITLED_PAGE = "untitled page";
    private static final String UNTITLED_DOC = "untitled document";
    private static final String NO_TITLE = "no title";
    private static final String ALIGN = "align";
    private static final String P = "p";
    private static final String JUSTIFY = "justify";
    private static final String NAME = "name";
    private static final String ONFOCUS = "onfocus";
    private static final String BLUR = "this.blur()";
    private static final String MENU = "menu";
    private static final String XMP = "xmp";
    private static final String LISTING = "listing";
    private static final String PLAINTEXT = "plaintext";
    private static final String CENTER = "center";
    private static final String BASEFONT = "basefont";
    private static final String DIR = "dir";
    private static final String FRAME_TITLE = "frame title";
    private static final String THE_TITLE = "the title";
    private static final String HEADERS = "headers";
    private static final String USEMAP = "usemap";
    private static final String TEXT = "text";
    private static final String ACCESSKEY = "accesskey";
    private static final String AXIS = "axis";
    private static final String BASE = "base";
    private static final String THEAD = "thead";
    private static final String TFOOT = "tfoot";
    private static final String TBODY = "tbody";
    private static final Object FIGURE = "figure";
    private static final String FIGCAPTION = "figcaption";
    public static List<String> waiOptions = new ArrayList<String>();
    private static Map<String, String> waiNameMap = new HashMap<String, String>();
    private String accessibilityLevel;
    private List<Piece> pieces;
    private boolean DTD40 = true;
    private boolean DTD11 = false;
    private DTDParser parser;
    private boolean us508;
    private boolean wcag2;
    private Map<String, Piece> ids;
    private EntityEncoder ee;
    private String baseUrl;
    private boolean isHtml5;
    private String docType;

    public AccessibilityValidation(String accessibilityLevel, DTDParser parser, String docType, boolean us508, boolean wcag2, String referer, EntityEncoder ee) {
        this.parser = parser;
        this.accessibilityLevel = accessibilityLevel;
        this.us508 = us508;
        this.wcag2 = wcag2;
        this.baseUrl = referer;
        this.ee = ee;
        this.docType = docType;
    }

    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        block29: {
            boolean foundTitle;
            block30: {
                this.pieces = pieces;
                if (this.parser != null) {
                    this.setDTDLevel(this.docType);
                }
                for (Piece piece : pieces) {
                    int index;
                    String base;
                    String element;
                    if (!(piece instanceof Tag) || piece.isMalformed() || piece.isEndTag() || piece.isVirtual() || (element = piece.getStrippedElement()) == null || !BASE.equals(element) || (base = piece.getAttr(HREF)) == null || (index = base.lastIndexOf(47)) == -1) continue;
                    this.baseUrl = base;
                }
                if (this.wcag2) {
                    this.ids = new HashMap<String, Piece>();
                    HTMLValidation.uniqueIdCheck(pieces, this.ids, null, false, "[WCAG v2 4.1.1 (A)] Duplicate 'id' value found:", ValidationProblem.WCAG2_F62);
                    this.accesskeyCheck();
                }
                boolean foundDocType = false;
                foundTitle = false;
                ArrayList<String> headers = new ArrayList<String>();
                HashMap<String, Piece> linkRefs = new HashMap<String, Piece>();
                for (Piece piece : pieces) {
                    String element;
                    cancellor.isCancelled();
                    if (!(piece instanceof Tag) || piece.isMalformed() || piece.isEndTag() || piece.isVirtual() || (element = piece.getStrippedElement()) == null) continue;
                    if (this.parser == null && element.equals(DOCTYPE)) {
                        String docType = piece.getText();
                        this.setDTDLevel(docType);
                    }
                    if (this.wcag2) {
                        if (element.equals(TITLE)) {
                            foundTitle = true;
                        } else if (!HR.equals(element) && element.length() == 2 && element.charAt(0) == 'h') {
                            int level = -1;
                            try {
                                level = Integer.parseInt(element.charAt(1) + "");
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (level > 1 && !headers.contains("h" + (level - 1))) {
                                piece.setProblemElement(ValidationProblem.WCAG2_F43);
                            }
                            headers.add(element);
                        }
                        this.checkLevelA2(piece, element, this.accessibilityLevel.equals(WAI_AAA2), linkRefs);
                        if (!this.accessibilityLevel.equals(WAI_A2)) {
                            this.checkLevelAA2(piece, element);
                        }
                        if (!this.accessibilityLevel.equals(WAI_AAA2)) continue;
                        this.checkLevelAAA2(piece, element);
                        continue;
                    }
                    this.checkPriority1(piece, element);
                    if (this.us508 && this.DTD40) {
                        this.check124(element, piece, false);
                    } else if (!this.accessibilityLevel.equals(WAI_A)) {
                        if (piece.getStrippedElement().equals(DOCTYPE)) {
                            foundDocType = true;
                        } else if (element.equals(TITLE)) {
                            foundTitle = true;
                        } else if (!HR.equals(element) && element.length() == 2 && element.charAt(0) == 'h') {
                            int level = -1;
                            try {
                                level = Integer.parseInt(element.charAt(1) + "");
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (level > 1 && !headers.contains("h" + (level - 1))) {
                                piece.setProblemElement(ValidationProblem.AA35);
                            }
                            headers.add(element);
                        }
                        this.checkPriority2(piece, element, linkRefs);
                    }
                    if (!this.accessibilityLevel.equals(WAI_AAA)) continue;
                    this.checkPriority3(piece, element);
                }
                linkRefs.clear();
                if (!this.accessibilityLevel.equals(WAI_AA) && !this.accessibilityLevel.equals(WAI_AAA)) break block30;
                if (!foundDocType && pieces.size() > 0) {
                    for (Piece testTag : pieces) {
                        if (testTag.isVirtual()) continue;
                        testTag.setProblem(ValidationProblem.AA32);
                        break;
                    }
                }
                if (foundTitle) break block29;
                for (Piece testTag : pieces) {
                    if (testTag.isVirtual()) continue;
                    testTag.setProblem(ValidationProblem.AA132);
                    break block29;
                }
                break block29;
            }
            if (this.wcag2 && !foundTitle) {
                for (Piece testTag : pieces) {
                    if (testTag.isVirtual()) continue;
                    testTag.setProblem(ValidationProblem.WCAG2_F25);
                    break;
                }
            }
        }
    }

    private void accesskeyCheck() {
        HashMap<String, Set<Piece>> accesskeys = new HashMap<String, Set<Piece>>();
        for (Piece piece : this.pieces) {
            String key;
            if (!(piece instanceof Tag) || (key = piece.getAttr(ACCESSKEY)) == null) continue;
            if (accesskeys.keySet().contains(key)) {
                ((Set)accesskeys.get(key)).add(piece);
                continue;
            }
            HashSet<Piece> matchingTags = new HashSet<Piece>();
            matchingTags.add(piece);
            accesskeys.put(key, matchingTags);
        }
        HTMLValidation.addProblemsWithLineNumbers(accesskeys, "[WCAG v2 1.3.1 (A)] Duplicate 'accesskey' value:", ValidationProblem.WCAG2_F17, ACCESSKEY);
    }

    private void setDTDLevel(String docType) {
        this.isHtml5 = SupportedDTDs.isHTML5(docType);
        this.DTD40 = docType.indexOf(FOUR_0) != -1 || docType.indexOf(ONE_0) != -1 || docType.indexOf(XHTML) != -1 || this.isHtml5;
        this.DTD11 = docType.indexOf(ONE_ONE) != -1 || docType.indexOf(RDF) != -1;
    }

    private void checkLevelAAA2(Piece piece, String element) {
        String align;
        if (element.equals(ACRONYM) || element.equals(ABBR)) {
            String title = piece.getAttr(TITLE);
            if (!(this.isHtml5 || title != null && title.length() != 0)) {
                piece.setProblem(ValidationProblem.WCAG2_H28);
            }
        } else if (element.equals(P) && (align = piece.getAttr(ALIGN)) != null && JUSTIFY.equalsIgnoreCase(align)) {
            piece.setProblem(ValidationProblem.WCAG2_F88);
        }
    }

    private void checkPriority3(Piece piece, String element) {
        if (this.DTD40 && element.equals(HTML)) {
            String lang = piece.getAttr(LANG);
            if (!(lang != null && lang.length() != 0 || (lang = piece.getAttr(XML_LANG)) != null && lang.length() != 0)) {
                piece.setProblem(ValidationProblem.AAA43);
            }
        } else if (element.equals(ACRONYM) || element.equals(ABBR)) {
            String title = piece.getAttr(TITLE);
            if (!(this.isHtml5 || title != null && title.length() != 0)) {
                piece.setProblem(ValidationProblem.AAA42);
            }
        } else if (element.equals(TABLE)) {
            String summary = piece.getAttr(SUMMARY);
            String border = piece.getAttr(BORDER);
            Piece caption = this.findInnerTag(piece, CAPTION);
            List<Piece> ths = AccessibilityValidation.findInnerTags(piece, this.pieces, TH);
            List<Piece> tds = AccessibilityValidation.findInnerTags(piece, this.pieces, TD);
            ArrayList<Piece> tdHeaders = new ArrayList<Piece>();
            for (Piece td : tds) {
                if (td.getAttr(SCOPE) == null) continue;
                tdHeaders.add(td);
            }
            if (summary != null && summary.length() != 0 || ths.size() > 0 || tdHeaders.size() > 0 || caption != null || border != null && !border.equals(ZERO)) {
                String abbr;
                StringTokenizer st;
                String title = piece.getAttr(TITLE);
                String captionText = "";
                if (caption != null) {
                    captionText = AccessibilityValidation.findInnerText(caption, this.pieces);
                }
                if (!(caption != null && captionText.length() != 0 || title != null && title.length() != 0 || summary != null && summary.length() >= 10)) {
                    piece.setProblem(ValidationProblem.AAA55);
                }
                for (Piece th : ths) {
                    String thText = AccessibilityValidation.findInnerText(th, this.pieces);
                    st = new StringTokenizer(thText, SPACE);
                    if (st.countTokens() <= 2 || (abbr = th.getAttr(ABBR)) != null && abbr.length() != 0) continue;
                    th.setProblem(ValidationProblem.AAA56);
                }
                for (Piece td : tdHeaders) {
                    String tdText = AccessibilityValidation.findInnerText(td, this.pieces);
                    st = new StringTokenizer(tdText, SPACE);
                    if (st.countTokens() <= 2 || (abbr = td.getAttr(ABBR)) != null && abbr.length() != 0) continue;
                    td.setProblem(ValidationProblem.AAA56);
                }
                boolean markupFound = false;
                if (this.findInnerTag(piece, THEAD) != null || this.findInnerTag(piece, TFOOT) != null || this.findInnerTag(piece, TBODY) != null || this.findInnerTag(piece, COLGROUP) != null) {
                    markupFound = true;
                }
                if (!markupFound) {
                    for (Piece thtag : ths) {
                        if (thtag.getAttr(SCOPE) == null) continue;
                        markupFound = true;
                        break;
                    }
                }
                if (!markupFound) {
                    for (Piece td : tds) {
                        if (td.getAttr(HEADERS) == null && td.getAttr(SCOPE) == null) continue;
                        markupFound = true;
                        break;
                    }
                }
                if (markupFound && !this.isHtml5 && (summary == null || summary.length() < 10)) {
                    piece.setProblem(ValidationProblem.AAA55a);
                }
            }
        }
    }

    private void checkLevelAA2(Piece piece, String element) {
        if (element.equals(FRAMESET)) {
            String rows;
            String cols = piece.getAttr(COLS);
            if (cols != null && !this.isRelative(cols)) {
                piece.setProblemValue(ValidationProblem.WCAG2_144, COLS);
            }
            if ((rows = piece.getAttr(ROWS)) != null && !this.isRelative(rows)) {
                piece.setProblemValue(ValidationProblem.WCAG2_144, ROWS);
            }
        } else if (element.equals(IFRAME) || element.equals(HR) || element.equals(TABLE) || element.equals(TH) || element.equals(TD)) {
            String height;
            String width = piece.getAttr(WIDTH);
            if (width != null && !width.endsWith(PERCENT)) {
                piece.setProblemValue(ValidationProblem.WCAG2_144, WIDTH);
            }
            if ((height = piece.getAttr(HEIGHT)) != null && !height.endsWith(PERCENT)) {
                piece.setProblemValue(ValidationProblem.WCAG2_144, HEIGHT);
            }
        } else if (element.equals(FONT)) {
            String size = piece.getAttr(SIZE);
            if (size != null && !this.isRelativeFont(size)) {
                piece.setProblemValue(ValidationProblem.WCAG2_144, SIZE);
            }
        } else if (element.equals(LEGEND)) {
            String innerText = AccessibilityValidation.findInnerText(piece, this.pieces);
            if (innerText.length() == 0) {
                piece.setProblem(ValidationProblem.WCAG2_G131);
            } else if (LEGEND.equalsIgnoreCase(innerText)) {
                piece.setProblem(ValidationProblem.WCAG2_G131);
            }
        }
    }

    private void checkPriority2(Piece piece, String element, Map<String, Piece> linkText) {
        if (element.equals(META)) {
            String value = piece.getAttr(HTTP_EQUIV);
            if (value != null && value.equalsIgnoreCase(REFRESH)) {
                piece.setProblemValue(ValidationProblem.AA74, HTTP_EQUIV);
            }
        } else if (!this.isHtml5 && (element.equals(B) || element.equals(I) || element.equals(SMALL) || element.equals(MENU))) {
            piece.setProblemElement(ValidationProblem.AA33);
        } else if (element.equals(TT) || element.equals(BIG) || element.equals(STRIKE) || element.equals(LISTING) || element.equals(PLAINTEXT) || element.equals(XMP) || element.equals(S) || element.equals(U)) {
            piece.setProblemElement(ValidationProblem.AA33);
        } else if (element.equals(A)) {
            String href = piece.getAttr(HREF);
            if (href != null) {
                String text = AccessibilityValidation.findInnerText(piece, this.pieces);
                if (text.length() == 0) {
                    if (this.findInnerTag(piece, IMG) == null) {
                        piece.setProblem(ValidationProblem.AA131a);
                    }
                } else {
                    String title;
                    if ((CLICK_HERE.equals(text = text.toLowerCase(Locale.ENGLISH)) || MORE.equals(text)) && ((title = piece.getAttr(TITLE)) == null || title.length() == 0 || CLICK_HERE.equals(title.toLowerCase(Locale.ENGLISH)) || MORE.equals(title.toLowerCase(Locale.ENGLISH)))) {
                        piece.setProblem(ValidationProblem.AA131b);
                    }
                    if (linkText.containsKey(text)) {
                        href = FileUtils.resolveRelativeUrl(href, this.baseUrl, this.ee);
                        Piece tag2 = linkText.get(text);
                        String href2 = tag2.getAttr(HREF);
                        href2 = FileUtils.resolveRelativeUrl(href2, this.baseUrl, this.ee);
                        if (href != null && href2 != null && !href.equals(href2)) {
                            boolean noLineNumber;
                            String title1 = piece.getAttr(TITLE);
                            String title2 = tag2.getAttr(TITLE);
                            boolean bl = noLineNumber = piece.getLineNumber() == tag2.getLineNumber();
                            if (title1 == null || title2 == null) {
                                piece.setProblem(new ValidationProblem("[WCAG v1 13.1 (AA)] Use the 'title' attribute to distinguish between different links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + tag2.getLineNumber()), ValidationProblem.AA131c));
                                tag2.setProblem(new ValidationProblem("[WCAG v1 13.1 (AA)] Use the 'title' attribute to distinguish between different links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + piece.getLineNumber()), ValidationProblem.AA131c));
                            } else if (title1.equalsIgnoreCase(title2)) {
                                piece.setProblemValue(new ValidationProblem("[WCAG v1 13.1 (AA)] Use different values for 'title' attributes with links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + tag2.getLineNumber()), ValidationProblem.AA131d), TITLE);
                                tag2.setProblemValue(new ValidationProblem("[WCAG v1 13.1 (AA)] Use different values for 'title' attributes with links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + piece.getLineNumber()), ValidationProblem.AA131d), TITLE);
                            }
                        }
                    } else {
                        linkText.put(text, piece);
                    }
                }
            }
        } else if (!(this.DTD40 && element.equals(APPLET) || element.equals(OBJECT))) {
            if (element.equals(FRAMESET)) {
                String rows;
                String cols = piece.getAttr(COLS);
                if (cols != null && !this.isRelative(cols)) {
                    piece.setProblemValue(ValidationProblem.AA34, COLS);
                }
                if ((rows = piece.getAttr(ROWS)) != null && !this.isRelative(rows)) {
                    piece.setProblemValue(ValidationProblem.AA34, ROWS);
                }
            } else if (element.equals(IFRAME) || element.equals(HR) || element.equals(TABLE) || element.equals(TH) || element.equals(TD)) {
                String height;
                String width = piece.getAttr(WIDTH);
                if (width != null && !width.endsWith(PERCENT)) {
                    piece.setProblemValue(ValidationProblem.AA34, WIDTH);
                }
                if ((height = piece.getAttr(HEIGHT)) != null && !height.endsWith(PERCENT)) {
                    piece.setProblemValue(ValidationProblem.AA34, HEIGHT);
                }
            } else if (element.equals(FONT)) {
                String size = piece.getAttr(SIZE);
                if (size != null && !this.isRelativeFont(size)) {
                    piece.setProblemValue(ValidationProblem.AA34, SIZE);
                }
            } else if (element.equals(FRAME)) {
                String target = piece.getAttr(TARGET);
                if (target != null && target.equalsIgnoreCase(BLANK)) {
                    piece.setProblemValue(ValidationProblem.AA101, BLANK);
                }
            } else if (element.equals(FRAMESET)) {
                if (this.findInnerTag(piece, NOFRAMES) == null) {
                    piece.setProblem(ValidationProblem.AA65);
                }
            } else if (element.equals(UL) || element.equals(OL)) {
                if (this.findInnerTag(piece, LI) == null) {
                    piece.setProblemElement(ValidationProblem.AA36);
                }
            } else if (element.equals(DL)) {
                if (this.findInnerTag(piece, DT) == null && this.findInnerTag(piece, DD) == null) {
                    piece.setProblemElement(ValidationProblem.AA36);
                }
            } else if (element.equals(BLINK)) {
                piece.setProblemElement(ValidationProblem.AA72);
            } else if (element.equals(MARQUEE)) {
                piece.setProblemElement(ValidationProblem.AA73);
            }
        }
        if (this.DTD40) {
            this.check124(element, piece, false);
            if (piece.getAttr(ONDBLCLICK) != null) {
                piece.setProblemAttribute(ValidationProblem.AA93, ONDBLCLICK);
            }
            if (piece.getAttr(ONMOUSEMOVE) != null) {
                piece.setProblemAttribute(ValidationProblem.AA93, ONMOUSEMOVE);
            }
        }
    }

    private void check124(String element, Piece piece, boolean wcag2) {
        if (element.equals(INPUT)) {
            String title;
            String alt;
            String type = piece.getAttr(TYPE);
            if (type == null) {
                type = TEXT;
            }
            type = type.toLowerCase(Locale.ENGLISH);
            if (wcag2 && type.equals(IMAGE)) {
                alt = piece.getAttr(ALT);
                if (alt == null || alt.length() == 0) {
                    piece.setProblem(ValidationProblem.WCAG2_F65);
                } else if (alt.equalsIgnoreCase(SPACER) || alt.equalsIgnoreCase(IMAGE) || alt.equalsIgnoreCase(PICTURE)) {
                    piece.setProblemValue(ValidationProblem.WCAG2_F30, ALT);
                }
            } else if (wcag2 && (alt = piece.getAttr(ALT)) != null) {
                piece.setProblem(ValidationProblem.WCAG2_H36);
            }
            if (!(type.equals(SUBMIT) || type.equals(RESET) || type.equals(IMAGE) || type.equals(HIDDEN) || type.equals(BUTTON) || (title = piece.getAttr(TITLE)) != null && title.length() != 0)) {
                String parentElement = null;
                Piece parent = piece.getParent();
                if (parent != null) {
                    parentElement = parent.getStrippedElement();
                }
                if (wcag2 || parentElement == null || !parentElement.equals(LABEL)) {
                    String id = piece.getAttr(ID);
                    if (id == null) {
                        piece.setProblem(wcag2 ? ValidationProblem.WCAG2_H65 : ValidationProblem.AA124);
                    } else {
                        Piece match = this.matchAttr(LABEL, FOR, id);
                        if (match == null) {
                            piece.setProblemValue(wcag2 ? ValidationProblem.WCAG2_F68 : ValidationProblem.AA124a, ID);
                        } else if (wcag2) {
                            int index = this.pieces.indexOf(match);
                            if (index < this.pieces.indexOf(piece)) {
                                if (type.equals(CHECKBOX) || type.equals(RADIO)) {
                                    if (match == parent) {
                                        if (!this.labelTextPosition(match, false, this.pieces.indexOf(piece))) {
                                            piece.setProblem(ValidationProblem.WCAG2_H44A);
                                        }
                                    } else {
                                        piece.setProblem(ValidationProblem.WCAG2_H44A);
                                    }
                                } else if (match == parent && !this.labelTextPosition(match, true, this.pieces.indexOf(piece))) {
                                    piece.setProblem(ValidationProblem.WCAG2_H44B);
                                }
                            } else if (index > this.pieces.indexOf(piece) && !type.equals(CHECKBOX) && !type.equals(RADIO)) {
                                piece.setProblem(ValidationProblem.WCAG2_H44B);
                            }
                        }
                    }
                }
            }
        } else if (element.equals(SELECT) || element.equals(TEXTAREA)) {
            String title = piece.getAttr(TITLE);
            if (title == null || title.length() == 0) {
                String parentElement = null;
                Piece parent = piece.getParent();
                if (parent != null) {
                    parentElement = parent.getStrippedElement();
                }
                if (wcag2 || parentElement == null || !parentElement.equals(LABEL)) {
                    String id = piece.getAttr(ID);
                    if (id == null) {
                        piece.setProblem(wcag2 ? ValidationProblem.WCAG2_H65 : ValidationProblem.AA124);
                    } else {
                        Piece match = this.matchAttr(LABEL, FOR, id);
                        if (match == null) {
                            piece.setProblemValue(wcag2 ? ValidationProblem.WCAG2_F68 : ValidationProblem.AA124a, ID);
                        } else if (wcag2) {
                            int index = this.pieces.indexOf(match);
                            if (index < this.pieces.indexOf(piece) && match == parent && !this.labelTextPosition(match, true, this.pieces.indexOf(piece))) {
                                piece.setProblem(ValidationProblem.WCAG2_H44B);
                            } else if (index > this.pieces.indexOf(piece)) {
                                piece.setProblem(ValidationProblem.WCAG2_H44B);
                            }
                        }
                    }
                }
            }
        } else if (element.equals(LABEL)) {
            String id = piece.getAttr(FOR);
            if (wcag2 && id != null) {
                HTMLValidation.findMatchingItem(id, piece, FOR, element, this.ids, ValidationProblem.WCAG2_F62A);
            }
            if (piece.hasMatchingTag()) {
                boolean foundText = false;
                int controlCount = 0;
                int startIndex = this.pieces.indexOf(piece) + 1;
                Piece endTag = piece.getMatchingTag();
                int endIndex = this.pieces.indexOf(endTag);
                for (int i = startIndex; i < endIndex; ++i) {
                    String inner_e;
                    Piece p = this.pieces.get(i);
                    if (p.isEndTag() || (inner_e = p.getStrippedElement()) == null) continue;
                    if (inner_e.equals("#pcdata")) {
                        foundText = true;
                        continue;
                    }
                    if (inner_e.equals(SELECT) || inner_e.equals(TEXTAREA)) {
                        ++controlCount;
                        continue;
                    }
                    if (!inner_e.equals(INPUT)) continue;
                    String type = p.getAttr(TYPE);
                    if (type == null) {
                        type = TEXT;
                    }
                    if ((type = type.toLowerCase(Locale.ENGLISH)).equals(SUBMIT) || type.equals(RESET) || type.equals(IMAGE) || type.equals(HIDDEN) || type.equals(BUTTON)) continue;
                    ++controlCount;
                }
                if (!foundText) {
                    piece.setProblem(wcag2 ? ValidationProblem.WCAG2_F68C : ValidationProblem.AA124c);
                }
                if (controlCount == 0 && piece.getAttr(FOR) == null) {
                    piece.setProblem(wcag2 ? ValidationProblem.WCAG2_F68B : ValidationProblem.AA124b);
                } else if (controlCount > 1) {
                    piece.setProblem(wcag2 ? ValidationProblem.WCAG2_F68D : ValidationProblem.AA124d);
                }
            } else if (id == null) {
                piece.setProblem(wcag2 ? ValidationProblem.WCAG2_F68C : ValidationProblem.AA124c);
            }
        }
    }

    private boolean labelTextPosition(Piece label, boolean before, int childIndex) {
        int startIndex = this.pieces.indexOf(label) + 1;
        Piece endTag = label.getMatchingTag();
        int endIndex = this.pieces.indexOf(endTag);
        for (int i = startIndex; i < endIndex; ++i) {
            Piece p = this.pieces.get(i);
            if (!(p instanceof Data) || (!before || i >= childIndex) && (before || i <= childIndex)) continue;
            return true;
        }
        return false;
    }

    private Piece matchAttr(String element, String attribute, String value) {
        Piece match = null;
        for (Piece tag : this.pieces) {
            String val;
            String e = tag.getStrippedElement();
            if (!(tag instanceof Tag) || tag.isMalformed() || tag.isEndTag() || tag.isVirtual() || tag.isSingleton() || e == null || !e.equals(element) || (val = tag.getAttr(attribute)) == null || !val.equals(value) || !this.isInnerPiece(tag)) continue;
            match = tag;
            break;
        }
        return match;
    }

    private void checkLevelA2(Piece piece, String element, boolean levelAAA, Map<String, Piece> linkText) {
        block131: {
            String type;
            String parentElement;
            String src;
            block133: {
                String summary;
                block134: {
                    Piece figcaption;
                    String parentElement2;
                    Piece parent;
                    block132: {
                        String focusText;
                        String usemap;
                        String text = piece.getAttr(TITLE);
                        if (text != null && text.length() == 0) {
                            piece.setProblemValue(ValidationProblem.WCAG2_H33W, TITLE);
                        }
                        if (this.DTD11 && (usemap = piece.getAttr(USEMAP)) != null) {
                            HTMLValidation.findMatchingItem(usemap, piece, USEMAP, element, this.ids, ValidationProblem.WCAG2_F62A);
                        }
                        if ((focusText = piece.getAttr(ONFOCUS)) != null && focusText.toLowerCase(Locale.ENGLISH).indexOf(BLUR) != -1) {
                            piece.setProblemValue(ValidationProblem.WCAG2_F55, ONFOCUS);
                        }
                        if (element.equals(IMG)) {
                            String longDesc;
                            String alt = piece.getAttr(ALT);
                            src = piece.getAttr(SRC);
                            if (alt == null) {
                                piece.setProblem(ValidationProblem.WCAG2_F65);
                            } else if (alt.equalsIgnoreCase(SPACER) || alt.equalsIgnoreCase(IMAGE) || alt.equalsIgnoreCase(PICTURE) || src != null && alt.equalsIgnoreCase(src)) {
                                piece.setProblemValue(ValidationProblem.WCAG2_F30, ALT);
                            } else if (alt.length() == 0) {
                                parentElement = null;
                                Piece parent2 = piece.getParent();
                                if (parent2 != null) {
                                    parentElement = parent2.getStrippedElement();
                                }
                                if (parentElement != null && parentElement.equals(A)) {
                                    String pcdata = AccessibilityValidation.findInnerText(parent2, this.pieces);
                                    if (pcdata.length() == 0) {
                                        piece.setProblemAttribute(ValidationProblem.WCAG2_H67W, ALT);
                                    }
                                } else {
                                    piece.setProblemAttribute(ValidationProblem.WCAG2_H67W, ALT);
                                }
                                String title = piece.getAttr(TITLE);
                                if (title != null && title.length() != 0) {
                                    piece.setProblemValue(ValidationProblem.WCAG2_H67, TITLE);
                                }
                            } else if (alt.length() > 100) {
                                if (this.DTD40) {
                                    longDesc = piece.getAttr(LONGDESC);
                                    if (longDesc == null || longDesc.length() == 0) {
                                        piece.setProblemValue(ValidationProblem.WCAG2_H45, ALT);
                                    }
                                } else {
                                    piece.setProblemValue(ValidationProblem.WCAG2_H45A, ALT);
                                }
                            } else if (alt.length() > 74) {
                                if (this.DTD40) {
                                    longDesc = piece.getAttr(LONGDESC);
                                    if (longDesc == null || longDesc.length() == 0) {
                                        piece.setProblemValue(ValidationProblem.WCAG2_H45W, ALT);
                                    }
                                } else {
                                    piece.setProblemValue(ValidationProblem.WCAG2_H45WA, ALT);
                                }
                            }
                            Map<String, RealAttribute> attrs = piece.getAttributes();
                            if (attrs != null && attrs.containsKey(ISMAP)) {
                                piece.setProblemAttribute(ValidationProblem.WCAG2_F54, ISMAP);
                            }
                        } else if (element.equals(AREA)) {
                            String alt = piece.getAttr(ALT);
                            if (alt == null || alt.length() == 0) {
                                if (this.DTD40) {
                                    piece.setProblem(ValidationProblem.WCAG2_F65);
                                }
                            } else if (alt.equalsIgnoreCase(SPACER) || alt.equalsIgnoreCase(IMAGE) || alt.equalsIgnoreCase(PICTURE)) {
                                piece.setProblemValue(ValidationProblem.WCAG2_F30, ALT);
                            }
                        } else if (element.equals(APPLET)) {
                            String alt = piece.getAttr(ALT);
                            if (alt == null || alt.length() == 0) {
                                piece.setProblem(ValidationProblem.WCAG2_H35);
                            } else if (alt.equalsIgnoreCase(SPACER) || alt.equalsIgnoreCase(IMAGE) || alt.equalsIgnoreCase(PICTURE)) {
                                piece.setProblemValue(ValidationProblem.WCAG2_F30, ALT);
                            }
                            if (!this.isInnerPiece(piece)) {
                                piece.setProblem(ValidationProblem.WCAG2_H35);
                            }
                        } else if (element.equals(OBJECT)) {
                            if (!this.isInnerPiece(piece)) {
                                piece.setProblem(ValidationProblem.WCAG2_H53);
                            }
                        } else if (element.equals(A)) {
                            String href = piece.getAttr(HREF);
                            if (href != null) {
                                String alt;
                                String desc = AccessibilityValidation.findInnerText(piece, this.pieces);
                                if (desc.length() == 0) {
                                    boolean foundDesc = false;
                                    List<Piece> images = AccessibilityValidation.findInnerTags(piece, this.pieces, IMG);
                                    for (Piece image : images) {
                                        alt = image.getAttr(ALT);
                                        if (alt == null || alt.length() <= 0) continue;
                                        foundDesc = true;
                                        break;
                                    }
                                    if (!foundDesc) {
                                        piece.setProblem(ValidationProblem.WCAG2_H30);
                                    }
                                } else {
                                    String title;
                                    desc = desc.toLowerCase(Locale.ENGLISH);
                                    if (levelAAA && (CLICK_HERE.equals(desc) || MORE.equals(desc)) && ((title = piece.getAttr(TITLE)) == null || title.length() == 0 || CLICK_HERE.equals(title.toLowerCase(Locale.ENGLISH)) || MORE.equals(title.toLowerCase(Locale.ENGLISH)))) {
                                        piece.setProblem(ValidationProblem.WCAG2_F84);
                                    }
                                    if (linkText.containsKey(desc)) {
                                        String resolvedHref = FileUtils.resolveRelativeUrl(href, this.baseUrl, this.ee);
                                        Piece tag2 = linkText.get(desc);
                                        String href2 = tag2.getAttr(HREF);
                                        href2 = FileUtils.resolveRelativeUrl(href2, this.baseUrl, this.ee);
                                        if (resolvedHref != null && href2 != null && !resolvedHref.equals(href2)) {
                                            boolean noLineNumber;
                                            String title1 = piece.getAttr(TITLE);
                                            String title2 = tag2.getAttr(TITLE);
                                            boolean bl = noLineNumber = piece.getLineNumber() == tag2.getLineNumber();
                                            if (title1 == null || title2 == null) {
                                                piece.setProblem(new ValidationProblem("[WCAG v2 2.4.4 (A)] Different links that use the same link text may be confusing:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + tag2.getLineNumber()), ValidationProblem.WCAG2_244A));
                                                tag2.setProblem(new ValidationProblem("[WCAG v2 2.4.4 (A)] Different links that use the same link text may be confusing:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + piece.getLineNumber()), ValidationProblem.WCAG2_244A));
                                            } else if (title1.equalsIgnoreCase(title2)) {
                                                piece.setProblemValue(new ValidationProblem("[WCAG v2 2.4.4 (A)] Use different values for 'title' attributes with links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + tag2.getLineNumber()), ValidationProblem.WCAG2_244B), TITLE);
                                                tag2.setProblemValue(new ValidationProblem("[WCAG v2 2.4.4 (A)] Use different values for 'title' attributes with links that use the same link text:" + (noLineNumber ? "" : " See matching tag(s) on line(s): " + piece.getLineNumber()), ValidationProblem.WCAG2_244B), TITLE);
                                            }
                                        }
                                    } else {
                                        linkText.put(desc, piece);
                                    }
                                }
                                List<Piece> imgTags = AccessibilityValidation.findInnerTags(piece, this.pieces, IMG);
                                if (!imgTags.isEmpty()) {
                                    Piece adjTag;
                                    int currentIndex = this.pieces.indexOf(piece);
                                    if (currentIndex > 0 && (adjTag = this.pieces.get(currentIndex - 1)) instanceof Tag) {
                                        if (adjTag.isEndTag() && adjTag.hasMatchingTag()) {
                                            adjTag = adjTag.getMatchingTag();
                                        }
                                        for (Piece imgTag : imgTags) {
                                            this.checkAdjacent(adjTag, href, piece, imgTag);
                                        }
                                    }
                                    if (piece.hasMatchingTag()) {
                                        currentIndex = this.pieces.indexOf(piece.getMatchingTag());
                                    }
                                    if (currentIndex + 1 != this.pieces.size()) {
                                        adjTag = this.pieces.get(currentIndex + 1);
                                        for (Piece imgTag : imgTags) {
                                            this.checkAdjacent(adjTag, href, piece, imgTag);
                                        }
                                    }
                                    for (Piece imgTag : imgTags) {
                                        alt = imgTag.getAttr(ALT);
                                        if (alt == null || desc.length() <= 0 || !desc.equalsIgnoreCase(alt)) continue;
                                        int imgLineNumber = imgTag.getLineNumber();
                                        piece.setProblem(new ValidationProblem("[WCAG v2 2.4.4 (A)] Unnecessary duplication of link description:" + (imgLineNumber == piece.getLineNumber() ? "" : " See matching tag(s) on line(s): " + imgLineNumber), ValidationProblem.WCAG2_H2A));
                                    }
                                }
                            }
                        } else if (element.equals(FORM)) {
                            boolean foundSubmit = false;
                            List<Piece> buttons = AccessibilityValidation.findInnerTags(piece, this.pieces, BUTTON);
                            for (Piece button : buttons) {
                                String type2 = button.getAttr(TYPE);
                                if (type2 == null || !SUBMIT.equalsIgnoreCase(type2)) continue;
                                foundSubmit = true;
                                break;
                            }
                            List<Piece> inputs = AccessibilityValidation.findInnerTags(piece, this.pieces, INPUT);
                            for (Piece input : inputs) {
                                type = input.getAttr(TYPE);
                                if (type == null || !SUBMIT.equalsIgnoreCase(type) && !IMAGE.equalsIgnoreCase(type)) continue;
                                foundSubmit = true;
                                break;
                            }
                            if (!foundSubmit) {
                                piece.setProblem(ValidationProblem.WCAG2_H32);
                            }
                        } else if (element.equals(EMBED)) {
                            if (this.findInnerTag(piece, NOEMBED) == null) {
                                int currentIndex = this.pieces.indexOf(piece);
                                Piece endTag = piece.getMatchingTag();
                                if (endTag != null) {
                                    currentIndex = this.pieces.indexOf(endTag);
                                }
                                if (currentIndex + 1 != this.pieces.size()) {
                                    String adjElement;
                                    Piece adjTag = this.pieces.get(currentIndex + 1);
                                    if (adjTag instanceof Tag && (adjElement = adjTag.getStrippedElement()) != null && !adjElement.equals(NOEMBED)) {
                                        piece.setProblem(ValidationProblem.WCAG2_H46);
                                    }
                                } else {
                                    piece.setProblem(ValidationProblem.WCAG2_H46);
                                }
                            }
                        } else if (element.equals(META)) {
                            String content;
                            String value = piece.getAttr(HTTP_EQUIV);
                            if (value != null && value.equalsIgnoreCase(REFRESH) && (content = piece.getAttr(CONTENT)) != null && content.length() > 0 && !content.startsWith(ZERO)) {
                                piece.setProblemValue(ValidationProblem.WCAG2_F41, CONTENT);
                            }
                        } else if (element.equals(TITLE)) {
                            String pcdata = AccessibilityValidation.findInnerText(piece, this.pieces).toLowerCase(Locale.ENGLISH);
                            if (pcdata.length() == 0 || pcdata.length() > 150) {
                                piece.setProblem(ValidationProblem.WCAG2_F25A);
                            } else if (pcdata.startsWith(NEW_PAGE) || ENTER_TITLE.equals(pcdata) || UNTITLED_DOC.equals(pcdata) || NO_TITLE.equals(pcdata) || UNTITLED_PAGE.equals(pcdata) || THE_TITLE.equals(pcdata)) {
                                piece.setProblem(ValidationProblem.WCAG2_F25A);
                            }
                        } else if (element.equals(BLINK)) {
                            piece.setProblemElement(ValidationProblem.WCAG2_F47);
                        } else if (element.equals(MARQUEE)) {
                            piece.setProblemElement(ValidationProblem.WCAG2_F16);
                        } else if (!this.isHtml5 && (element.equals(B) || element.equals(I) || element.equals(SMALL) || element.equals(MENU))) {
                            piece.setProblemElement(ValidationProblem.WCAG2_G140);
                        } else if (element.equals(BIG) || element.equals(STRIKE) || element.equals(TT) || element.equals(LISTING) || element.equals(PLAINTEXT) || element.equals(XMP) || element.equals(BASEFONT) || element.equals(CENTER) || element.equals(DIR) || element.equals(FONT) || element.equals(S) || element.equals(U)) {
                            piece.setProblemElement(ValidationProblem.WCAG2_G140);
                        } else if (element.equals(UL) || element.equals(OL)) {
                            if (this.findInnerTag(piece, LI) == null) {
                                piece.setProblemElement(ValidationProblem.WCAG2_G140);
                            }
                        } else if (element.equals(DL) && this.findInnerTag(piece, DT) == null && this.findInnerTag(piece, DD) == null) {
                            piece.setProblemElement(ValidationProblem.WCAG2_G140);
                        }
                        if (!this.DTD40) break block131;
                        this.check124(element, piece, true);
                        if (!element.equals(HTML)) break block132;
                        String lang = piece.getAttr(LANG);
                        if (!(lang != null && lang.length() != 0 || (lang = piece.getAttr(XML_LANG)) != null && lang.length() != 0)) {
                            piece.setProblem(ValidationProblem.WCAG2_H57W);
                        }
                        break block131;
                    }
                    if (!element.equals(TABLE)) break block133;
                    summary = piece.getAttr(SUMMARY);
                    String border = piece.getAttr(BORDER);
                    Piece caption = this.findInnerTag(piece, CAPTION);
                    String captionText = "";
                    if (caption != null) {
                        captionText = AccessibilityValidation.findInnerText(caption, this.pieces);
                    }
                    if (this.isHtml5 && (caption == null || captionText.length() == 0) && (parent = piece.getParent()) != null && (parentElement2 = parent.getStrippedElement()) != null && parentElement2.equals(FIGURE) && (figcaption = this.findInnerTag(parent, FIGCAPTION)) != null) {
                        caption = figcaption;
                        captionText = AccessibilityValidation.findInnerText(caption, this.pieces);
                    }
                    if (summary != null && summary.length() != 0 && captionText.equalsIgnoreCase(summary)) {
                        piece.setProblemValue(ValidationProblem.WCAG2_H39, SUMMARY);
                        caption.setProblemElement(ValidationProblem.WCAG2_H39);
                    }
                    List<Piece> ths = AccessibilityValidation.findInnerTags(piece, this.pieces, TH);
                    List<Piece> tds = AccessibilityValidation.findInnerTags(piece, this.pieces, TD);
                    ArrayList<Piece> tdHeaders = new ArrayList<Piece>();
                    for (Piece td : tds) {
                        if (td.getAttr(SCOPE) == null) continue;
                        tdHeaders.add(td);
                    }
                    if (!this.isHtml5 && (summary == null || summary.length() == 0) && ths.size() <= 0 && tdHeaders.size() <= 0 && caption == null && (border == null || border.equals(ZERO))) break block131;
                    String title = piece.getAttr(TITLE);
                    if (!(caption != null && captionText.length() != 0 || title != null && title.length() != 0 || summary != null && summary.length() >= 10)) {
                        piece.setProblem(ValidationProblem.WCAG2_131);
                    }
                    boolean markupFound = false;
                    if (this.findInnerTag(piece, THEAD) != null || this.findInnerTag(piece, TFOOT) != null || this.findInnerTag(piece, TBODY) != null || this.findInnerTag(piece, COLGROUP) != null) {
                        markupFound = true;
                    }
                    if (!markupFound) {
                        for (Piece th : ths) {
                            if (th.getAttr(SCOPE) == null) continue;
                            markupFound = true;
                            break;
                        }
                    }
                    if (!markupFound) {
                        for (Piece td : tds) {
                            if (td.getAttr(HEADERS) == null && td.getAttr(SCOPE) == null) continue;
                            markupFound = true;
                            break;
                        }
                    }
                    if (markupFound) break block134;
                    if (tdHeaders.size() > 1) {
                        piece.setProblem(ValidationProblem.WCAG2_131A);
                    }
                    break block131;
                }
                if (this.isHtml5 || summary != null && summary.length() >= 10) break block131;
                piece.setProblem(ValidationProblem.WCAG2_H73);
                break block131;
            }
            if (element.equals(TH) || element.equals(TD)) {
                String id;
                String axis;
                String headers;
                String scope = piece.getAttr(SCOPE);
                if (!(scope == null || scope.length() == 0 || ROW.equalsIgnoreCase(scope) || ROWGROUP.equalsIgnoreCase(scope) || COL.equalsIgnoreCase(scope) || COLGROUP.equalsIgnoreCase(scope))) {
                    piece.setProblemValue(ValidationProblem.WCAG2_H63, SCOPE);
                }
                if ((headers = piece.getAttr(HEADERS)) != null) {
                    StringTokenizer st = new StringTokenizer(headers);
                    while (st.hasMoreTokens()) {
                        HTMLValidation.findMatchingItem(st.nextToken(), piece, HEADERS, element, this.ids, ValidationProblem.WCAG2_F62A);
                    }
                }
                if ((axis = piece.getAttr(AXIS)) != null && axis.length() > 0 && ((id = piece.getAttr(ID)) == null || id.length() == 0)) {
                    piece.setProblem(ValidationProblem.WCAG2_F17A);
                }
            } else if (element.equals(FRAME) || element.equals(IFRAME)) {
                String title = piece.getAttr(TITLE);
                if (title == null || title.length() == 0) {
                    piece.setProblem(ValidationProblem.WCAG2_H64);
                } else if (TITLE.equalsIgnoreCase(title) || THE_TITLE.equalsIgnoreCase(title) || FRAME_TITLE.equalsIgnoreCase(title)) {
                    piece.setProblem(ValidationProblem.WCAG2_F30);
                }
                src = piece.getAttr(SRC);
                if (src != null && ((src = src.toLowerCase(Locale.ENGLISH)).endsWith(GIF) || src.endsWith(JPG) || src.endsWith(PNG))) {
                    piece.setProblemValue(ValidationProblem.WCAG2_F20, SRC);
                }
            } else if (element.equals(FIELDSET)) {
                if (this.findInnerTag(piece, LEGEND) == null) {
                    piece.setProblem(ValidationProblem.WCAG2_H71AW);
                }
                boolean noParentForm = true;
                for (Piece parentTag = piece.getParent(); parentTag != null; parentTag = parentTag.getParent()) {
                    parentElement = parentTag.getStrippedElement();
                    if (parentElement == null || !parentElement.equals(FORM)) continue;
                    noParentForm = false;
                    break;
                }
                if (noParentForm) {
                    piece.setProblem(ValidationProblem.WCAG2_H71);
                }
            } else if (element.equals(FORM)) {
                List<Piece> inputs = AccessibilityValidation.findInnerTags(piece, this.pieces, INPUT);
                ArrayList<String> radioNames = new ArrayList<String>();
                ArrayList<String> checkboxNames = new ArrayList<String>();
                for (Piece input : inputs) {
                    String parentElement3;
                    boolean foundFieldSet;
                    type = input.getAttr(TYPE);
                    String name = input.getAttr(NAME);
                    if (type == null || name == null || name.length() <= 0) continue;
                    if (RADIO.equalsIgnoreCase(type)) {
                        if (radioNames.contains(name = name.toLowerCase(Locale.ENGLISH))) {
                            foundFieldSet = false;
                            for (Piece parentTag = input.getParent(); parentTag != null && parentTag != piece; parentTag = parentTag.getParent()) {
                                parentElement3 = parentTag.getStrippedElement();
                                if (parentElement3 == null || !parentElement3.equals(FIELDSET)) continue;
                                foundFieldSet = true;
                                break;
                            }
                            if (foundFieldSet) continue;
                            input.setProblem(ValidationProblem.WCAG2_H71W);
                            continue;
                        }
                        radioNames.add(name);
                        continue;
                    }
                    if (!CHECKBOX.equalsIgnoreCase(type)) continue;
                    if (checkboxNames.contains(name = name.toLowerCase(Locale.ENGLISH))) {
                        foundFieldSet = false;
                        for (Piece parentTag = input.getParent(); parentTag != null && parentTag != piece; parentTag = parentTag.getParent()) {
                            parentElement3 = parentTag.getStrippedElement();
                            if (parentElement3 == null || !parentElement3.equals(FIELDSET)) continue;
                            foundFieldSet = true;
                            break;
                        }
                        if (foundFieldSet) continue;
                        input.setProblem(ValidationProblem.WCAG2_H71W);
                        continue;
                    }
                    checkboxNames.add(name);
                }
            }
        }
    }

    private void checkAdjacent(Piece adjTag, String href, Piece piece, Piece imgTag) {
        String adjHref;
        String adjElement = adjTag.getStrippedElement();
        if (!adjTag.isMalformed() && !adjTag.isEndTag() && !adjTag.isVirtual() && adjElement != null && adjElement.equals(A) && (adjHref = adjTag.getAttr(HREF)) != null) {
            String adjDesc;
            href = FileUtils.resolveRelativeUrl(href, this.baseUrl, this.ee);
            adjHref = FileUtils.resolveRelativeUrl(adjHref, this.baseUrl, this.ee);
            if (href != null && adjHref != null && adjHref.equals(href) && (adjDesc = AccessibilityValidation.findInnerText(adjTag, this.pieces)).length() > 0) {
                String desc = AccessibilityValidation.findInnerText(piece, this.pieces);
                if (desc.length() == 0) {
                    desc = imgTag.getAttr(ALT);
                }
                if (desc != null && desc.equalsIgnoreCase(adjDesc)) {
                    int adjLineNumber = adjTag.getLineNumber();
                    piece.setProblem(new ValidationProblem("[WCAG v2 2.4.4 (A)] Unnecessary duplication of link description:" + (adjLineNumber == piece.getLineNumber() ? "" : " See matching tag(s) on line(s): " + adjLineNumber), ValidationProblem.WCAG2_H2));
                }
            }
        }
    }

    private void checkPriority1(Piece piece, String element) {
        if (element.equals(IMG)) {
            String alt = piece.getAttr(ALT);
            if (alt == null) {
                piece.setProblem(ValidationProblem.A11);
            } else if (alt.length() == 0) {
                String parentElement = null;
                Piece link = piece.getParent();
                if (link != null) {
                    parentElement = link.getStrippedElement();
                }
                if (link == null || !SPACE.equals(piece.getAttributes().get(ALT).getValue()) || parentElement == null || !parentElement.equals(A) || AccessibilityValidation.findInnerText(link, this.pieces).length() == 0) {
                    piece.setProblemAttribute(ValidationProblem.A11g, ALT);
                }
            } else if (alt.length() > 150 && !this.us508) {
                if (this.DTD40) {
                    String longDesc = piece.getAttr(LONGDESC);
                    if (longDesc == null || longDesc.length() == 0) {
                        piece.setProblemValue(ValidationProblem.A11b, ALT);
                    }
                } else {
                    piece.setProblemValue(ValidationProblem.A11c, ALT);
                }
            }
            Map<String, RealAttribute> attrs = piece.getAttributes();
            if (attrs != null && attrs.containsKey(ISMAP)) {
                piece.setProblemAttribute(ValidationProblem.A91, ISMAP);
            }
        } else if (element.equals(INPUT)) {
            String alt;
            String type = piece.getAttr(TYPE);
            if (type != null && type.equalsIgnoreCase(IMAGE) && ((alt = piece.getAttr(ALT)) == null || alt.length() == 0)) {
                piece.setProblem(ValidationProblem.A11d);
            }
        } else if (element.equals(AREA)) {
            String alt = piece.getAttr(ALT);
            if (alt == null || alt.length() == 0) {
                piece.setProblem(ValidationProblem.A11f);
            }
        } else if (element.equals(OBJECT)) {
            if (!this.isInnerPiece(piece)) {
                piece.setProblem(ValidationProblem.A63a);
            }
        } else if (element.equals(APPLET)) {
            String alt = piece.getAttr(ALT);
            if (alt == null || alt.length() == 0) {
                piece.setProblem(ValidationProblem.A11e);
            }
            if (!this.isInnerPiece(piece)) {
                piece.setProblem(ValidationProblem.A63a);
            }
        } else if (element.equals(SCRIPT)) {
            String parentElement;
            Piece parent = piece.getParent();
            if (parent != null && (parentElement = parent.getStrippedElement()) != null && !parentElement.equals(HEAD) && piece.hasMatchingTag()) {
                Piece t = piece.getMatchingTag();
                boolean foundIt = false;
                for (int i = this.pieces.indexOf(t) + 1; i < this.pieces.size(); ++i) {
                    Piece p = this.pieces.get(i);
                    String t_e = p.getStrippedElement();
                    if (t_e == null) continue;
                    if (t_e.equals(NOSCRIPT)) {
                        foundIt = true;
                        break;
                    }
                    if (t_e.equals(SCRIPT)) break;
                }
                if (!foundIt) {
                    piece.setProblem(ValidationProblem.A63);
                }
            }
        } else if (element.equals(FRAME) || element.equals(IFRAME)) {
            String src;
            String title = piece.getAttr(TITLE);
            if (title == null || title.length() == 0) {
                piece.setProblem(ValidationProblem.A121);
            }
            if (element.equals(FRAME) && !this.us508 && (src = piece.getAttr(SRC)) != null && ((src = src.toLowerCase(Locale.ENGLISH)).endsWith(GIF) || src.endsWith(JPG) || src.endsWith(PNG))) {
                piece.setProblemValue(ValidationProblem.A62, SRC);
            }
        } else if (element.equals(TABLE)) {
            String summary = piece.getAttr(SUMMARY);
            String border = piece.getAttr(BORDER);
            Piece caption = this.findInnerTag(piece, CAPTION);
            List<Piece> ths = AccessibilityValidation.findInnerTags(piece, this.pieces, TH);
            List<Piece> tds = AccessibilityValidation.findInnerTags(piece, this.pieces, TD);
            ArrayList<Piece> tdHeaders = new ArrayList<Piece>();
            for (Piece td : tds) {
                if (td.getAttr(SCOPE) == null) continue;
                tdHeaders.add(td);
            }
            if (this.isHtml5 || summary != null && summary.length() != 0 || ths.size() > 0 || tdHeaders.size() > 0 || caption != null || border != null && !border.equals(ZERO)) {
                if (ths.size() == 0 && tdHeaders.size() == 0) {
                    piece.setProblem(ValidationProblem.A51);
                } else if (ths.size() > 1 || tdHeaders.size() > 1) {
                    boolean markupFound = false;
                    if (this.findInnerTag(piece, THEAD) != null || this.findInnerTag(piece, TFOOT) != null || this.findInnerTag(piece, TBODY) != null || this.findInnerTag(piece, COLGROUP) != null) {
                        markupFound = true;
                    }
                    if (!markupFound) {
                        for (Piece th : ths) {
                            if (th.getAttr(SCOPE) == null) continue;
                            markupFound = true;
                            break;
                        }
                    }
                    if (!markupFound) {
                        for (Piece td : tds) {
                            if (td.getAttr(HEADERS) == null && td.getAttr(SCOPE) == null) continue;
                            markupFound = true;
                            break;
                        }
                    }
                    if (!markupFound) {
                        piece.setProblem(ValidationProblem.A52);
                    }
                }
            }
        }
    }

    private boolean isRelative(String list) {
        StringTokenizer st = new StringTokenizer(list, ", ");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            if (item.endsWith(PERCENT)) continue;
            return false;
        }
        return true;
    }

    private boolean isRelativeFont(String size) {
        return size.startsWith(PLUS) || size.startsWith(MINUS);
    }

    private Piece findInnerTag(Piece piece, String element) {
        Piece inner = null;
        if (piece.hasMatchingTag()) {
            int startIndex = this.pieces.indexOf(piece) + 1;
            Piece endTag = piece.getMatchingTag();
            int endIndex = this.pieces.indexOf(endTag);
            String thisElement = piece.getStrippedElement();
            for (int i = startIndex; i < endIndex; ++i) {
                String inner_e;
                Piece t = this.pieces.get(i);
                if (!(t instanceof Tag) || t.isEndTag() || (inner_e = t.getStrippedElement()) == null) continue;
                if (inner_e.equals(thisElement)) {
                    if (!t.hasMatchingTag()) continue;
                    i = this.pieces.indexOf(t.getMatchingTag());
                    continue;
                }
                if (!inner_e.equals(element)) continue;
                inner = t;
                break;
            }
        }
        return inner;
    }

    private boolean isInnerPiece(Piece piece) {
        boolean inner = false;
        if (piece.hasMatchingTag()) {
            int startIndex = this.pieces.indexOf(piece) + 1;
            Piece endTag = piece.getMatchingTag();
            int endIndex = this.pieces.indexOf(endTag);
            String thisElement = piece.getStrippedElement();
            for (int i = startIndex; i < endIndex; ++i) {
                Piece t = this.pieces.get(i);
                if (t instanceof Tag) {
                    String inner_e;
                    if (t.isEndTag() || (inner_e = t.getStrippedElement()) == null) continue;
                    if (inner_e.equals(thisElement)) {
                        if (!t.hasMatchingTag()) continue;
                        i = this.pieces.indexOf(t.getMatchingTag());
                        continue;
                    }
                    if (inner_e.equals(PARAM)) continue;
                    inner = true;
                    break;
                }
                if (t.getText().length() == 0) continue;
                inner = true;
                break;
            }
        }
        return inner;
    }

    public static List<Piece> findInnerTags(Piece tag, List<Piece> pieces, String element) {
        ArrayList<Piece> innerTags = new ArrayList<Piece>();
        if (tag.hasMatchingTag()) {
            int startIndex = pieces.indexOf(tag) + 1;
            Piece endTag = tag.getMatchingTag();
            int endIndex = pieces.indexOf(endTag);
            String thisElement = tag.getStrippedElement();
            for (int i = startIndex; i < endIndex; ++i) {
                String inner_e;
                Piece t = pieces.get(i);
                if (!(t instanceof Tag) || t.isEndTag() || (inner_e = t.getStrippedElement()) == null) continue;
                if (inner_e.equals(thisElement)) {
                    if (!t.hasMatchingTag()) continue;
                    i = pieces.indexOf(t.getMatchingTag());
                    continue;
                }
                if (element != null && !inner_e.equals(element)) continue;
                innerTags.add(t);
            }
        }
        return innerTags;
    }

    public static String findInnerText(Piece link, List<Piece> pieces) {
        String text = "";
        if (link.hasMatchingTag()) {
            int startIndex = pieces.indexOf(link) + 1;
            Piece endTag = link.getMatchingTag();
            int endIndex = pieces.indexOf(endTag);
            for (int i = startIndex; i < endIndex; ++i) {
                Piece p = pieces.get(i);
                if (!(p instanceof Data)) continue;
                text = text + p.getText() + SPACE;
            }
        }
        return text.trim();
    }

    public static String getWAI(String displayName) {
        return waiNameMap.get(displayName);
    }

    public static String getDisplayName(String waiName) {
        String displayName = null;
        for (String name : waiNameMap.keySet()) {
            if (!waiName.equals(waiNameMap.get(name))) continue;
            displayName = name;
            break;
        }
        return displayName;
    }

    static {
        waiOptions.add("");
        waiOptions.add(SECTION_508);
        waiOptions.add(WAI_A);
        waiOptions.add(WAI_AA);
        waiOptions.add(WAI_AAA);
        waiOptions.add(WAI_A2);
        waiOptions.add(WAI_AA2);
        waiOptions.add(WAI_AAA2);
        waiNameMap.put(SECTION_508_TEXT, SECTION_508);
        waiNameMap.put(WAI_A_TEXT, WAI_A);
        waiNameMap.put(WAI_AA_TEXT, WAI_AA);
        waiNameMap.put(WAI_AAA_TEXT, WAI_AAA);
        waiNameMap.put(WAI_A2_TEXT, WAI_A2);
        waiNameMap.put(WAI_AA2_TEXT, WAI_AA2);
        waiNameMap.put(WAI_AAA2_TEXT, WAI_AAA2);
    }
}

